
#ifndef _ACFG_H
#define _ACFG_H

#include "config.h"
#include "meta.h"
#include <bitset>

class hostdata;

static const int RESERVED_DEFVAL = -4223;


struct ltstring
{
  bool operator()(const mstring &s1, const mstring &s2) const
  {
    return strcasecmp(s1.c_str(), s2.c_str()) < 0;
  }
};

typedef MYMAP<mstring, mstring, ltstring> NoCaseStringMap;

namespace acfg
{

extern mstring cachedir, logdir, confdir, fifopath, user, group, pidfile, suppdir,
reportpage, vfilepat, pfilepat, wfilepat, agentname, remoteport, adminauth, bindaddr, port, sUmask,
tmpDontcacherq, tmpDontcachetgt, tmpDontcache, mirrorsrcs, requestapx;

extern int debug, numcores, offlinemode, foreground, verbose, stupidfs, forcemanaged, keepnver,
verboselog, extreshhold, exfailabort, tpstandbymax, tpthreadmax, dnscachetime, dlbufsize, usewrap,
exporigin, logxff, oldupdate, recompbz2, nettimeout, updinterval, forwardsoap, dirperms, fileperms,
maxtempdelay, redirmax;

// processed config settings
extern tHttpUrl proxy_info;
extern mstring agentheader;

extern int conprotos[2];

bool SetOption(const mstring &line, bool bQuiet=false);
void ReadConfigDirectory(const char*);

//! Prepare various things resulting from variable combinations, etc.
void PostProcConfig();

// TODO: document me
// throw away the rewritten part of the path, foo/debian/bla.deb -> bla.deb,
// no slash needed with backends...
				
const mstring * GetRepNameAndPathResidual(const tHttpUrl & in, mstring & sRetPathResidual);

struct tRepoData
{
	MYSTD::vector<tHttpUrl> m_backends;

	// dirty little helper to execute custom actions when a jobs associates or forgets this data set
	struct IHookHandler
	{
		virtual void JobRelease()=0;
		virtual void JobConnect()=0;
    virtual ~IHookHandler() {};
	};
	IHookHandler *m_pHooks;
	tStrVec m_keyfiles;
	tHttpUrl m_deltasrc;
	tRepoData() : m_pHooks(NULL) {};
	virtual ~tRepoData();
};

const tRepoData * GetBackendVec(cmstring &vname);

time_t ExecutePostponed();

extern tStrMap localdirs;
extern NoCaseStringMap mimemap;
#define TCP_PORT_MAX 65536
extern MYSTD::bitset<TCP_PORT_MAX> *pUserPorts;

extern mstring cacheDirSlash; // guaranteed to have a trailing path separator

mstring EncodeBase64Auth(const cmstring & s);
} // namespace acfg

namespace rechecks
{
#define FILE_PKG 0
#define FILE_INDEX 1
#define	FILE_INVALID 2
unsigned int GetFiletype(const mstring &);
bool MatchWhitelist(const mstring &);
bool MatchUncacheableRequest(const mstring &);
bool MatchUncacheableTarget(const mstring &);

bool CompileExpressions();
}


#endif
