
#ifndef _DLCON_H
#define _DLCON_H

#include <string>
#include <list>
#include <map>
#include <set>

//#include <netinet/in.h>
//#include <netdb.h>

#include "tcpconnect.h"
#include "lockable.h"
#include "fileitem.h"
#include "acfg.h"
#include "acbuf.h"

struct tDlJob;
typedef SHARED_PTR<tDlJob> tDlJobPtr;
typedef MYSTD::list<tDlJobPtr> tDljQueue;

class dlcon : public lockable
{ 
    public:
        dlcon(bool bManualExecution, mstring *xff=NULL);
        ~dlcon();

        void WorkLoop();
        
        void SignalStop();

	    void AddJob(tFileItemPtr m_pItem, tHttpUrl hi);
        void AddJob(tFileItemPtr m_pItem, const acfg::tRepoData *pBackends,
        		const mstring & sPatSuffix);
    	void EnqJob(tDlJob *);

        mstring m_sXForwardedFor;

    private:

    	//not to be copied
    	dlcon & operator=(const dlcon&);
    	dlcon(const dlcon&);
    	
    	//friend class tDlJob;
    	
    	tDljQueue m_qNewjobs;

    	int m_wakepipe[2];

    	// flags and local copies for input parsing
    	/// remember being attached to an fitem

    	bool m_bStopASAP;

    	UINT m_bManualMode;

    	/// blacklist for permanently failing hosts, with error message
    	MYMAP<MYSTD::pair<cmstring,cmstring>, mstring> m_blacklist;
    	void BlacklistMirror(tDlJobPtr &failJob, cmstring &msg);
    	bool SetupJobConfig(tDlJobPtr &job, mstring *pReasonMsg);

    	tSS m_sendBuf, m_inBuf;

    	UINT ExchangeData(mstring &sErrorMsg, tTcpHandlePtr &con, tDljQueue &qActive);

};

#endif


