// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package kinesis_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/kinesis"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleKinesis_AddTagsToStream() {
	sess := session.Must(session.NewSession())

	svc := kinesis.New(sess)

	params := &kinesis.AddTagsToStreamInput{
		StreamName: aws.String("StreamName"), // Required
		Tags: map[string]*string{ // Required
			"Key": aws.String("TagValue"), // Required
			// More values...
		},
	}
	resp, err := svc.AddTagsToStream(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleKinesis_CreateStream() {
	sess := session.Must(session.NewSession())

	svc := kinesis.New(sess)

	params := &kinesis.CreateStreamInput{
		ShardCount: aws.Int64(1),             // Required
		StreamName: aws.String("StreamName"), // Required
	}
	resp, err := svc.CreateStream(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleKinesis_DecreaseStreamRetentionPeriod() {
	sess := session.Must(session.NewSession())

	svc := kinesis.New(sess)

	params := &kinesis.DecreaseStreamRetentionPeriodInput{
		RetentionPeriodHours: aws.Int64(1),             // Required
		StreamName:           aws.String("StreamName"), // Required
	}
	resp, err := svc.DecreaseStreamRetentionPeriod(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleKinesis_DeleteStream() {
	sess := session.Must(session.NewSession())

	svc := kinesis.New(sess)

	params := &kinesis.DeleteStreamInput{
		StreamName: aws.String("StreamName"), // Required
	}
	resp, err := svc.DeleteStream(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleKinesis_DescribeLimits() {
	sess := session.Must(session.NewSession())

	svc := kinesis.New(sess)

	var params *kinesis.DescribeLimitsInput
	resp, err := svc.DescribeLimits(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleKinesis_DescribeStream() {
	sess := session.Must(session.NewSession())

	svc := kinesis.New(sess)

	params := &kinesis.DescribeStreamInput{
		StreamName:            aws.String("StreamName"), // Required
		ExclusiveStartShardId: aws.String("ShardId"),
		Limit: aws.Int64(1),
	}
	resp, err := svc.DescribeStream(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleKinesis_DisableEnhancedMonitoring() {
	sess := session.Must(session.NewSession())

	svc := kinesis.New(sess)

	params := &kinesis.DisableEnhancedMonitoringInput{
		ShardLevelMetrics: []*string{ // Required
			aws.String("MetricsName"), // Required
			// More values...
		},
		StreamName: aws.String("StreamName"), // Required
	}
	resp, err := svc.DisableEnhancedMonitoring(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleKinesis_EnableEnhancedMonitoring() {
	sess := session.Must(session.NewSession())

	svc := kinesis.New(sess)

	params := &kinesis.EnableEnhancedMonitoringInput{
		ShardLevelMetrics: []*string{ // Required
			aws.String("MetricsName"), // Required
			// More values...
		},
		StreamName: aws.String("StreamName"), // Required
	}
	resp, err := svc.EnableEnhancedMonitoring(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleKinesis_GetRecords() {
	sess := session.Must(session.NewSession())

	svc := kinesis.New(sess)

	params := &kinesis.GetRecordsInput{
		ShardIterator: aws.String("ShardIterator"), // Required
		Limit:         aws.Int64(1),
	}
	resp, err := svc.GetRecords(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleKinesis_GetShardIterator() {
	sess := session.Must(session.NewSession())

	svc := kinesis.New(sess)

	params := &kinesis.GetShardIteratorInput{
		ShardId:                aws.String("ShardId"),           // Required
		ShardIteratorType:      aws.String("ShardIteratorType"), // Required
		StreamName:             aws.String("StreamName"),        // Required
		StartingSequenceNumber: aws.String("SequenceNumber"),
		Timestamp:              aws.Time(time.Now()),
	}
	resp, err := svc.GetShardIterator(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleKinesis_IncreaseStreamRetentionPeriod() {
	sess := session.Must(session.NewSession())

	svc := kinesis.New(sess)

	params := &kinesis.IncreaseStreamRetentionPeriodInput{
		RetentionPeriodHours: aws.Int64(1),             // Required
		StreamName:           aws.String("StreamName"), // Required
	}
	resp, err := svc.IncreaseStreamRetentionPeriod(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleKinesis_ListStreams() {
	sess := session.Must(session.NewSession())

	svc := kinesis.New(sess)

	params := &kinesis.ListStreamsInput{
		ExclusiveStartStreamName: aws.String("StreamName"),
		Limit: aws.Int64(1),
	}
	resp, err := svc.ListStreams(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleKinesis_ListTagsForStream() {
	sess := session.Must(session.NewSession())

	svc := kinesis.New(sess)

	params := &kinesis.ListTagsForStreamInput{
		StreamName:           aws.String("StreamName"), // Required
		ExclusiveStartTagKey: aws.String("TagKey"),
		Limit:                aws.Int64(1),
	}
	resp, err := svc.ListTagsForStream(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleKinesis_MergeShards() {
	sess := session.Must(session.NewSession())

	svc := kinesis.New(sess)

	params := &kinesis.MergeShardsInput{
		AdjacentShardToMerge: aws.String("ShardId"),    // Required
		ShardToMerge:         aws.String("ShardId"),    // Required
		StreamName:           aws.String("StreamName"), // Required
	}
	resp, err := svc.MergeShards(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleKinesis_PutRecord() {
	sess := session.Must(session.NewSession())

	svc := kinesis.New(sess)

	params := &kinesis.PutRecordInput{
		Data:                      []byte("PAYLOAD"),          // Required
		PartitionKey:              aws.String("PartitionKey"), // Required
		StreamName:                aws.String("StreamName"),   // Required
		ExplicitHashKey:           aws.String("HashKey"),
		SequenceNumberForOrdering: aws.String("SequenceNumber"),
	}
	resp, err := svc.PutRecord(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleKinesis_PutRecords() {
	sess := session.Must(session.NewSession())

	svc := kinesis.New(sess)

	params := &kinesis.PutRecordsInput{
		Records: []*kinesis.PutRecordsRequestEntry{ // Required
			{ // Required
				Data:            []byte("PAYLOAD"),          // Required
				PartitionKey:    aws.String("PartitionKey"), // Required
				ExplicitHashKey: aws.String("HashKey"),
			},
			// More values...
		},
		StreamName: aws.String("StreamName"), // Required
	}
	resp, err := svc.PutRecords(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleKinesis_RemoveTagsFromStream() {
	sess := session.Must(session.NewSession())

	svc := kinesis.New(sess)

	params := &kinesis.RemoveTagsFromStreamInput{
		StreamName: aws.String("StreamName"), // Required
		TagKeys: []*string{ // Required
			aws.String("TagKey"), // Required
			// More values...
		},
	}
	resp, err := svc.RemoveTagsFromStream(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleKinesis_SplitShard() {
	sess := session.Must(session.NewSession())

	svc := kinesis.New(sess)

	params := &kinesis.SplitShardInput{
		NewStartingHashKey: aws.String("HashKey"),    // Required
		ShardToSplit:       aws.String("ShardId"),    // Required
		StreamName:         aws.String("StreamName"), // Required
	}
	resp, err := svc.SplitShard(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleKinesis_UpdateShardCount() {
	sess := session.Must(session.NewSession())

	svc := kinesis.New(sess)

	params := &kinesis.UpdateShardCountInput{
		ScalingType:      aws.String("ScalingType"), // Required
		StreamName:       aws.String("StreamName"),  // Required
		TargetShardCount: aws.Int64(1),              // Required
	}
	resp, err := svc.UpdateShardCount(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
