// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package lightsail_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/lightsail"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleLightsail_AllocateStaticIp() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.AllocateStaticIpInput{
		StaticIpName: aws.String("ResourceName"), // Required
	}
	resp, err := svc.AllocateStaticIp(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_AttachStaticIp() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.AttachStaticIpInput{
		InstanceName: aws.String("ResourceName"), // Required
		StaticIpName: aws.String("ResourceName"), // Required
	}
	resp, err := svc.AttachStaticIp(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_CloseInstancePublicPorts() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.CloseInstancePublicPortsInput{
		InstanceName: aws.String("ResourceName"), // Required
		PortInfo: &lightsail.PortInfo{ // Required
			FromPort: aws.Int64(1),
			Protocol: aws.String("NetworkProtocol"),
			ToPort:   aws.Int64(1),
		},
	}
	resp, err := svc.CloseInstancePublicPorts(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_CreateDomain() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.CreateDomainInput{
		DomainName: aws.String("DomainName"), // Required
	}
	resp, err := svc.CreateDomain(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_CreateDomainEntry() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.CreateDomainEntryInput{
		DomainEntry: &lightsail.DomainEntry{ // Required
			Id:   aws.String("NonEmptyString"),
			Name: aws.String("DomainName"),
			Options: map[string]*string{
				"Key": aws.String("string"), // Required
				// More values...
			},
			Target: aws.String("string"),
			Type:   aws.String("DomainEntryType"),
		},
		DomainName: aws.String("DomainName"), // Required
	}
	resp, err := svc.CreateDomainEntry(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_CreateInstanceSnapshot() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.CreateInstanceSnapshotInput{
		InstanceName:         aws.String("ResourceName"), // Required
		InstanceSnapshotName: aws.String("ResourceName"), // Required
	}
	resp, err := svc.CreateInstanceSnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_CreateInstances() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.CreateInstancesInput{
		AvailabilityZone: aws.String("string"),         // Required
		BlueprintId:      aws.String("NonEmptyString"), // Required
		BundleId:         aws.String("NonEmptyString"), // Required
		InstanceNames: []*string{ // Required
			aws.String("string"), // Required
			// More values...
		},
		CustomImageName: aws.String("ResourceName"),
		KeyPairName:     aws.String("ResourceName"),
		UserData:        aws.String("string"),
	}
	resp, err := svc.CreateInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_CreateInstancesFromSnapshot() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.CreateInstancesFromSnapshotInput{
		AvailabilityZone: aws.String("string"),         // Required
		BundleId:         aws.String("NonEmptyString"), // Required
		InstanceNames: []*string{ // Required
			aws.String("string"), // Required
			// More values...
		},
		InstanceSnapshotName: aws.String("ResourceName"), // Required
		KeyPairName:          aws.String("ResourceName"),
		UserData:             aws.String("string"),
	}
	resp, err := svc.CreateInstancesFromSnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_CreateKeyPair() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.CreateKeyPairInput{
		KeyPairName: aws.String("ResourceName"), // Required
	}
	resp, err := svc.CreateKeyPair(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_DeleteDomain() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.DeleteDomainInput{
		DomainName: aws.String("DomainName"), // Required
	}
	resp, err := svc.DeleteDomain(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_DeleteDomainEntry() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.DeleteDomainEntryInput{
		DomainEntry: &lightsail.DomainEntry{ // Required
			Id:   aws.String("NonEmptyString"),
			Name: aws.String("DomainName"),
			Options: map[string]*string{
				"Key": aws.String("string"), // Required
				// More values...
			},
			Target: aws.String("string"),
			Type:   aws.String("DomainEntryType"),
		},
		DomainName: aws.String("DomainName"), // Required
	}
	resp, err := svc.DeleteDomainEntry(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_DeleteInstance() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.DeleteInstanceInput{
		InstanceName: aws.String("ResourceName"), // Required
	}
	resp, err := svc.DeleteInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_DeleteInstanceSnapshot() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.DeleteInstanceSnapshotInput{
		InstanceSnapshotName: aws.String("ResourceName"), // Required
	}
	resp, err := svc.DeleteInstanceSnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_DeleteKeyPair() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.DeleteKeyPairInput{
		KeyPairName: aws.String("ResourceName"), // Required
	}
	resp, err := svc.DeleteKeyPair(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_DetachStaticIp() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.DetachStaticIpInput{
		StaticIpName: aws.String("ResourceName"), // Required
	}
	resp, err := svc.DetachStaticIp(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_DownloadDefaultKeyPair() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	var params *lightsail.DownloadDefaultKeyPairInput
	resp, err := svc.DownloadDefaultKeyPair(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_GetActiveNames() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.GetActiveNamesInput{
		PageToken: aws.String("string"),
	}
	resp, err := svc.GetActiveNames(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_GetBlueprints() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.GetBlueprintsInput{
		IncludeInactive: aws.Bool(true),
		PageToken:       aws.String("string"),
	}
	resp, err := svc.GetBlueprints(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_GetBundles() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.GetBundlesInput{
		IncludeInactive: aws.Bool(true),
		PageToken:       aws.String("string"),
	}
	resp, err := svc.GetBundles(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_GetDomain() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.GetDomainInput{
		DomainName: aws.String("DomainName"), // Required
	}
	resp, err := svc.GetDomain(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_GetDomains() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.GetDomainsInput{
		PageToken: aws.String("string"),
	}
	resp, err := svc.GetDomains(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_GetInstance() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.GetInstanceInput{
		InstanceName: aws.String("ResourceName"), // Required
	}
	resp, err := svc.GetInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_GetInstanceAccessDetails() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.GetInstanceAccessDetailsInput{
		InstanceName: aws.String("ResourceName"), // Required
		Protocol:     aws.String("InstanceAccessProtocol"),
	}
	resp, err := svc.GetInstanceAccessDetails(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_GetInstanceMetricData() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.GetInstanceMetricDataInput{
		EndTime:      aws.Time(time.Now()),             // Required
		InstanceName: aws.String("ResourceName"),       // Required
		MetricName:   aws.String("InstanceMetricName"), // Required
		Period:       aws.Int64(1),                     // Required
		StartTime:    aws.Time(time.Now()),             // Required
		Statistics: []*string{ // Required
			aws.String("MetricStatistic"), // Required
			// More values...
		},
		Unit: aws.String("MetricUnit"), // Required
	}
	resp, err := svc.GetInstanceMetricData(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_GetInstancePortStates() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.GetInstancePortStatesInput{
		InstanceName: aws.String("ResourceName"), // Required
	}
	resp, err := svc.GetInstancePortStates(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_GetInstanceSnapshot() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.GetInstanceSnapshotInput{
		InstanceSnapshotName: aws.String("ResourceName"), // Required
	}
	resp, err := svc.GetInstanceSnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_GetInstanceSnapshots() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.GetInstanceSnapshotsInput{
		PageToken: aws.String("string"),
	}
	resp, err := svc.GetInstanceSnapshots(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_GetInstanceState() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.GetInstanceStateInput{
		InstanceName: aws.String("ResourceName"), // Required
	}
	resp, err := svc.GetInstanceState(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_GetInstances() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.GetInstancesInput{
		PageToken: aws.String("string"),
	}
	resp, err := svc.GetInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_GetKeyPair() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.GetKeyPairInput{
		KeyPairName: aws.String("ResourceName"), // Required
	}
	resp, err := svc.GetKeyPair(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_GetKeyPairs() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.GetKeyPairsInput{
		PageToken: aws.String("string"),
	}
	resp, err := svc.GetKeyPairs(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_GetOperation() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.GetOperationInput{
		OperationId: aws.String("NonEmptyString"), // Required
	}
	resp, err := svc.GetOperation(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_GetOperations() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.GetOperationsInput{
		PageToken: aws.String("string"),
	}
	resp, err := svc.GetOperations(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_GetOperationsForResource() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.GetOperationsForResourceInput{
		ResourceName: aws.String("ResourceName"), // Required
		PageToken:    aws.String("string"),
	}
	resp, err := svc.GetOperationsForResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_GetRegions() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.GetRegionsInput{
		IncludeAvailabilityZones: aws.Bool(true),
	}
	resp, err := svc.GetRegions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_GetStaticIp() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.GetStaticIpInput{
		StaticIpName: aws.String("ResourceName"), // Required
	}
	resp, err := svc.GetStaticIp(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_GetStaticIps() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.GetStaticIpsInput{
		PageToken: aws.String("string"),
	}
	resp, err := svc.GetStaticIps(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_ImportKeyPair() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.ImportKeyPairInput{
		KeyPairName:     aws.String("ResourceName"), // Required
		PublicKeyBase64: aws.String("Base64"),       // Required
	}
	resp, err := svc.ImportKeyPair(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_IsVpcPeered() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	var params *lightsail.IsVpcPeeredInput
	resp, err := svc.IsVpcPeered(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_OpenInstancePublicPorts() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.OpenInstancePublicPortsInput{
		InstanceName: aws.String("ResourceName"), // Required
		PortInfo: &lightsail.PortInfo{ // Required
			FromPort: aws.Int64(1),
			Protocol: aws.String("NetworkProtocol"),
			ToPort:   aws.Int64(1),
		},
	}
	resp, err := svc.OpenInstancePublicPorts(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_PeerVpc() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	var params *lightsail.PeerVpcInput
	resp, err := svc.PeerVpc(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_RebootInstance() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.RebootInstanceInput{
		InstanceName: aws.String("ResourceName"), // Required
	}
	resp, err := svc.RebootInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_ReleaseStaticIp() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.ReleaseStaticIpInput{
		StaticIpName: aws.String("ResourceName"), // Required
	}
	resp, err := svc.ReleaseStaticIp(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_StartInstance() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.StartInstanceInput{
		InstanceName: aws.String("ResourceName"), // Required
	}
	resp, err := svc.StartInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_StopInstance() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.StopInstanceInput{
		InstanceName: aws.String("ResourceName"), // Required
	}
	resp, err := svc.StopInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_UnpeerVpc() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	var params *lightsail.UnpeerVpcInput
	resp, err := svc.UnpeerVpc(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleLightsail_UpdateDomainEntry() {
	sess := session.Must(session.NewSession())

	svc := lightsail.New(sess)

	params := &lightsail.UpdateDomainEntryInput{
		DomainEntry: &lightsail.DomainEntry{ // Required
			Id:   aws.String("NonEmptyString"),
			Name: aws.String("DomainName"),
			Options: map[string]*string{
				"Key": aws.String("string"), // Required
				// More values...
			},
			Target: aws.String("string"),
			Type:   aws.String("DomainEntryType"),
		},
		DomainName: aws.String("DomainName"), // Required
	}
	resp, err := svc.UpdateDomainEntry(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
