// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package redshift_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/redshift"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleRedshift_AuthorizeClusterSecurityGroupIngress() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.AuthorizeClusterSecurityGroupIngressInput{
		ClusterSecurityGroupName: aws.String("String"), // Required
		CIDRIP:                  aws.String("String"),
		EC2SecurityGroupName:    aws.String("String"),
		EC2SecurityGroupOwnerId: aws.String("String"),
	}
	resp, err := svc.AuthorizeClusterSecurityGroupIngress(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_AuthorizeSnapshotAccess() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.AuthorizeSnapshotAccessInput{
		AccountWithRestoreAccess:  aws.String("String"), // Required
		SnapshotIdentifier:        aws.String("String"), // Required
		SnapshotClusterIdentifier: aws.String("String"),
	}
	resp, err := svc.AuthorizeSnapshotAccess(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_CopyClusterSnapshot() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.CopyClusterSnapshotInput{
		SourceSnapshotIdentifier:        aws.String("String"), // Required
		TargetSnapshotIdentifier:        aws.String("String"), // Required
		SourceSnapshotClusterIdentifier: aws.String("String"),
	}
	resp, err := svc.CopyClusterSnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_CreateCluster() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.CreateClusterInput{
		ClusterIdentifier:                aws.String("String"), // Required
		MasterUserPassword:               aws.String("String"), // Required
		MasterUsername:                   aws.String("String"), // Required
		NodeType:                         aws.String("String"), // Required
		AdditionalInfo:                   aws.String("String"),
		AllowVersionUpgrade:              aws.Bool(true),
		AutomatedSnapshotRetentionPeriod: aws.Int64(1),
		AvailabilityZone:                 aws.String("String"),
		ClusterParameterGroupName:        aws.String("String"),
		ClusterSecurityGroups: []*string{
			aws.String("String"), // Required
			// More values...
		},
		ClusterSubnetGroupName:         aws.String("String"),
		ClusterType:                    aws.String("String"),
		ClusterVersion:                 aws.String("String"),
		DBName:                         aws.String("String"),
		ElasticIp:                      aws.String("String"),
		Encrypted:                      aws.Bool(true),
		EnhancedVpcRouting:             aws.Bool(true),
		HsmClientCertificateIdentifier: aws.String("String"),
		HsmConfigurationIdentifier:     aws.String("String"),
		IamRoles: []*string{
			aws.String("String"), // Required
			// More values...
		},
		KmsKeyId:      aws.String("String"),
		NumberOfNodes: aws.Int64(1),
		Port:          aws.Int64(1),
		PreferredMaintenanceWindow: aws.String("String"),
		PubliclyAccessible:         aws.Bool(true),
		Tags: []*redshift.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
		VpcSecurityGroupIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.CreateCluster(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_CreateClusterParameterGroup() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.CreateClusterParameterGroupInput{
		Description:          aws.String("String"), // Required
		ParameterGroupFamily: aws.String("String"), // Required
		ParameterGroupName:   aws.String("String"), // Required
		Tags: []*redshift.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateClusterParameterGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_CreateClusterSecurityGroup() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.CreateClusterSecurityGroupInput{
		ClusterSecurityGroupName: aws.String("String"), // Required
		Description:              aws.String("String"), // Required
		Tags: []*redshift.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateClusterSecurityGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_CreateClusterSnapshot() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.CreateClusterSnapshotInput{
		ClusterIdentifier:  aws.String("String"), // Required
		SnapshotIdentifier: aws.String("String"), // Required
		Tags: []*redshift.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateClusterSnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_CreateClusterSubnetGroup() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.CreateClusterSubnetGroupInput{
		ClusterSubnetGroupName: aws.String("String"), // Required
		Description:            aws.String("String"), // Required
		SubnetIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		Tags: []*redshift.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateClusterSubnetGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_CreateEventSubscription() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.CreateEventSubscriptionInput{
		SnsTopicArn:      aws.String("String"), // Required
		SubscriptionName: aws.String("String"), // Required
		Enabled:          aws.Bool(true),
		EventCategories: []*string{
			aws.String("String"), // Required
			// More values...
		},
		Severity: aws.String("String"),
		SourceIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		SourceType: aws.String("String"),
		Tags: []*redshift.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateEventSubscription(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_CreateHsmClientCertificate() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.CreateHsmClientCertificateInput{
		HsmClientCertificateIdentifier: aws.String("String"), // Required
		Tags: []*redshift.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateHsmClientCertificate(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_CreateHsmConfiguration() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.CreateHsmConfigurationInput{
		Description:                aws.String("String"), // Required
		HsmConfigurationIdentifier: aws.String("String"), // Required
		HsmIpAddress:               aws.String("String"), // Required
		HsmPartitionName:           aws.String("String"), // Required
		HsmPartitionPassword:       aws.String("String"), // Required
		HsmServerPublicCertificate: aws.String("String"), // Required
		Tags: []*redshift.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateHsmConfiguration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_CreateSnapshotCopyGrant() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.CreateSnapshotCopyGrantInput{
		SnapshotCopyGrantName: aws.String("String"), // Required
		KmsKeyId:              aws.String("String"),
		Tags: []*redshift.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateSnapshotCopyGrant(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_CreateTags() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.CreateTagsInput{
		ResourceName: aws.String("String"), // Required
		Tags: []*redshift.Tag{ // Required
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateTags(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DeleteCluster() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DeleteClusterInput{
		ClusterIdentifier:              aws.String("String"), // Required
		FinalClusterSnapshotIdentifier: aws.String("String"),
		SkipFinalClusterSnapshot:       aws.Bool(true),
	}
	resp, err := svc.DeleteCluster(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DeleteClusterParameterGroup() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DeleteClusterParameterGroupInput{
		ParameterGroupName: aws.String("String"), // Required
	}
	resp, err := svc.DeleteClusterParameterGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DeleteClusterSecurityGroup() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DeleteClusterSecurityGroupInput{
		ClusterSecurityGroupName: aws.String("String"), // Required
	}
	resp, err := svc.DeleteClusterSecurityGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DeleteClusterSnapshot() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DeleteClusterSnapshotInput{
		SnapshotIdentifier:        aws.String("String"), // Required
		SnapshotClusterIdentifier: aws.String("String"),
	}
	resp, err := svc.DeleteClusterSnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DeleteClusterSubnetGroup() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DeleteClusterSubnetGroupInput{
		ClusterSubnetGroupName: aws.String("String"), // Required
	}
	resp, err := svc.DeleteClusterSubnetGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DeleteEventSubscription() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DeleteEventSubscriptionInput{
		SubscriptionName: aws.String("String"), // Required
	}
	resp, err := svc.DeleteEventSubscription(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DeleteHsmClientCertificate() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DeleteHsmClientCertificateInput{
		HsmClientCertificateIdentifier: aws.String("String"), // Required
	}
	resp, err := svc.DeleteHsmClientCertificate(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DeleteHsmConfiguration() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DeleteHsmConfigurationInput{
		HsmConfigurationIdentifier: aws.String("String"), // Required
	}
	resp, err := svc.DeleteHsmConfiguration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DeleteSnapshotCopyGrant() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DeleteSnapshotCopyGrantInput{
		SnapshotCopyGrantName: aws.String("String"), // Required
	}
	resp, err := svc.DeleteSnapshotCopyGrant(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DeleteTags() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DeleteTagsInput{
		ResourceName: aws.String("String"), // Required
		TagKeys: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DeleteTags(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DescribeClusterParameterGroups() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DescribeClusterParameterGroupsInput{
		Marker:             aws.String("String"),
		MaxRecords:         aws.Int64(1),
		ParameterGroupName: aws.String("String"),
		TagKeys: []*string{
			aws.String("String"), // Required
			// More values...
		},
		TagValues: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeClusterParameterGroups(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DescribeClusterParameters() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DescribeClusterParametersInput{
		ParameterGroupName: aws.String("String"), // Required
		Marker:             aws.String("String"),
		MaxRecords:         aws.Int64(1),
		Source:             aws.String("String"),
	}
	resp, err := svc.DescribeClusterParameters(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DescribeClusterSecurityGroups() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DescribeClusterSecurityGroupsInput{
		ClusterSecurityGroupName: aws.String("String"),
		Marker:     aws.String("String"),
		MaxRecords: aws.Int64(1),
		TagKeys: []*string{
			aws.String("String"), // Required
			// More values...
		},
		TagValues: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeClusterSecurityGroups(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DescribeClusterSnapshots() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DescribeClusterSnapshotsInput{
		ClusterIdentifier:  aws.String("String"),
		EndTime:            aws.Time(time.Now()),
		Marker:             aws.String("String"),
		MaxRecords:         aws.Int64(1),
		OwnerAccount:       aws.String("String"),
		SnapshotIdentifier: aws.String("String"),
		SnapshotType:       aws.String("String"),
		StartTime:          aws.Time(time.Now()),
		TagKeys: []*string{
			aws.String("String"), // Required
			// More values...
		},
		TagValues: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeClusterSnapshots(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DescribeClusterSubnetGroups() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DescribeClusterSubnetGroupsInput{
		ClusterSubnetGroupName: aws.String("String"),
		Marker:                 aws.String("String"),
		MaxRecords:             aws.Int64(1),
		TagKeys: []*string{
			aws.String("String"), // Required
			// More values...
		},
		TagValues: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeClusterSubnetGroups(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DescribeClusterVersions() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DescribeClusterVersionsInput{
		ClusterParameterGroupFamily: aws.String("String"),
		ClusterVersion:              aws.String("String"),
		Marker:                      aws.String("String"),
		MaxRecords:                  aws.Int64(1),
	}
	resp, err := svc.DescribeClusterVersions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DescribeClusters() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DescribeClustersInput{
		ClusterIdentifier: aws.String("String"),
		Marker:            aws.String("String"),
		MaxRecords:        aws.Int64(1),
		TagKeys: []*string{
			aws.String("String"), // Required
			// More values...
		},
		TagValues: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeClusters(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DescribeDefaultClusterParameters() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DescribeDefaultClusterParametersInput{
		ParameterGroupFamily: aws.String("String"), // Required
		Marker:               aws.String("String"),
		MaxRecords:           aws.Int64(1),
	}
	resp, err := svc.DescribeDefaultClusterParameters(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DescribeEventCategories() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DescribeEventCategoriesInput{
		SourceType: aws.String("String"),
	}
	resp, err := svc.DescribeEventCategories(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DescribeEventSubscriptions() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DescribeEventSubscriptionsInput{
		Marker:           aws.String("String"),
		MaxRecords:       aws.Int64(1),
		SubscriptionName: aws.String("String"),
	}
	resp, err := svc.DescribeEventSubscriptions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DescribeEvents() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DescribeEventsInput{
		Duration:         aws.Int64(1),
		EndTime:          aws.Time(time.Now()),
		Marker:           aws.String("String"),
		MaxRecords:       aws.Int64(1),
		SourceIdentifier: aws.String("String"),
		SourceType:       aws.String("SourceType"),
		StartTime:        aws.Time(time.Now()),
	}
	resp, err := svc.DescribeEvents(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DescribeHsmClientCertificates() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DescribeHsmClientCertificatesInput{
		HsmClientCertificateIdentifier: aws.String("String"),
		Marker:     aws.String("String"),
		MaxRecords: aws.Int64(1),
		TagKeys: []*string{
			aws.String("String"), // Required
			// More values...
		},
		TagValues: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeHsmClientCertificates(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DescribeHsmConfigurations() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DescribeHsmConfigurationsInput{
		HsmConfigurationIdentifier: aws.String("String"),
		Marker:     aws.String("String"),
		MaxRecords: aws.Int64(1),
		TagKeys: []*string{
			aws.String("String"), // Required
			// More values...
		},
		TagValues: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeHsmConfigurations(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DescribeLoggingStatus() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DescribeLoggingStatusInput{
		ClusterIdentifier: aws.String("String"), // Required
	}
	resp, err := svc.DescribeLoggingStatus(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DescribeOrderableClusterOptions() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DescribeOrderableClusterOptionsInput{
		ClusterVersion: aws.String("String"),
		Marker:         aws.String("String"),
		MaxRecords:     aws.Int64(1),
		NodeType:       aws.String("String"),
	}
	resp, err := svc.DescribeOrderableClusterOptions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DescribeReservedNodeOfferings() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DescribeReservedNodeOfferingsInput{
		Marker:                 aws.String("String"),
		MaxRecords:             aws.Int64(1),
		ReservedNodeOfferingId: aws.String("String"),
	}
	resp, err := svc.DescribeReservedNodeOfferings(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DescribeReservedNodes() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DescribeReservedNodesInput{
		Marker:         aws.String("String"),
		MaxRecords:     aws.Int64(1),
		ReservedNodeId: aws.String("String"),
	}
	resp, err := svc.DescribeReservedNodes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DescribeResize() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DescribeResizeInput{
		ClusterIdentifier: aws.String("String"), // Required
	}
	resp, err := svc.DescribeResize(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DescribeSnapshotCopyGrants() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DescribeSnapshotCopyGrantsInput{
		Marker:                aws.String("String"),
		MaxRecords:            aws.Int64(1),
		SnapshotCopyGrantName: aws.String("String"),
		TagKeys: []*string{
			aws.String("String"), // Required
			// More values...
		},
		TagValues: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeSnapshotCopyGrants(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DescribeTableRestoreStatus() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DescribeTableRestoreStatusInput{
		ClusterIdentifier:     aws.String("String"),
		Marker:                aws.String("String"),
		MaxRecords:            aws.Int64(1),
		TableRestoreRequestId: aws.String("String"),
	}
	resp, err := svc.DescribeTableRestoreStatus(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DescribeTags() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DescribeTagsInput{
		Marker:       aws.String("String"),
		MaxRecords:   aws.Int64(1),
		ResourceName: aws.String("String"),
		ResourceType: aws.String("String"),
		TagKeys: []*string{
			aws.String("String"), // Required
			// More values...
		},
		TagValues: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeTags(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DisableLogging() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DisableLoggingInput{
		ClusterIdentifier: aws.String("String"), // Required
	}
	resp, err := svc.DisableLogging(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_DisableSnapshotCopy() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.DisableSnapshotCopyInput{
		ClusterIdentifier: aws.String("String"), // Required
	}
	resp, err := svc.DisableSnapshotCopy(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_EnableLogging() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.EnableLoggingInput{
		BucketName:        aws.String("String"), // Required
		ClusterIdentifier: aws.String("String"), // Required
		S3KeyPrefix:       aws.String("String"),
	}
	resp, err := svc.EnableLogging(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_EnableSnapshotCopy() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.EnableSnapshotCopyInput{
		ClusterIdentifier:     aws.String("String"), // Required
		DestinationRegion:     aws.String("String"), // Required
		RetentionPeriod:       aws.Int64(1),
		SnapshotCopyGrantName: aws.String("String"),
	}
	resp, err := svc.EnableSnapshotCopy(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_ModifyCluster() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.ModifyClusterInput{
		ClusterIdentifier:                aws.String("String"), // Required
		AllowVersionUpgrade:              aws.Bool(true),
		AutomatedSnapshotRetentionPeriod: aws.Int64(1),
		ClusterParameterGroupName:        aws.String("String"),
		ClusterSecurityGroups: []*string{
			aws.String("String"), // Required
			// More values...
		},
		ClusterType:                    aws.String("String"),
		ClusterVersion:                 aws.String("String"),
		ElasticIp:                      aws.String("String"),
		EnhancedVpcRouting:             aws.Bool(true),
		HsmClientCertificateIdentifier: aws.String("String"),
		HsmConfigurationIdentifier:     aws.String("String"),
		MasterUserPassword:             aws.String("String"),
		NewClusterIdentifier:           aws.String("String"),
		NodeType:                       aws.String("String"),
		NumberOfNodes:                  aws.Int64(1),
		PreferredMaintenanceWindow:     aws.String("String"),
		PubliclyAccessible:             aws.Bool(true),
		VpcSecurityGroupIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.ModifyCluster(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_ModifyClusterIamRoles() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.ModifyClusterIamRolesInput{
		ClusterIdentifier: aws.String("String"), // Required
		AddIamRoles: []*string{
			aws.String("String"), // Required
			// More values...
		},
		RemoveIamRoles: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.ModifyClusterIamRoles(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_ModifyClusterParameterGroup() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.ModifyClusterParameterGroupInput{
		ParameterGroupName: aws.String("String"), // Required
		Parameters: []*redshift.Parameter{ // Required
			{ // Required
				AllowedValues:        aws.String("String"),
				ApplyType:            aws.String("ParameterApplyType"),
				DataType:             aws.String("String"),
				Description:          aws.String("String"),
				IsModifiable:         aws.Bool(true),
				MinimumEngineVersion: aws.String("String"),
				ParameterName:        aws.String("String"),
				ParameterValue:       aws.String("String"),
				Source:               aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.ModifyClusterParameterGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_ModifyClusterSubnetGroup() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.ModifyClusterSubnetGroupInput{
		ClusterSubnetGroupName: aws.String("String"), // Required
		SubnetIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		Description: aws.String("String"),
	}
	resp, err := svc.ModifyClusterSubnetGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_ModifyEventSubscription() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.ModifyEventSubscriptionInput{
		SubscriptionName: aws.String("String"), // Required
		Enabled:          aws.Bool(true),
		EventCategories: []*string{
			aws.String("String"), // Required
			// More values...
		},
		Severity:    aws.String("String"),
		SnsTopicArn: aws.String("String"),
		SourceIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		SourceType: aws.String("String"),
	}
	resp, err := svc.ModifyEventSubscription(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_ModifySnapshotCopyRetentionPeriod() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.ModifySnapshotCopyRetentionPeriodInput{
		ClusterIdentifier: aws.String("String"), // Required
		RetentionPeriod:   aws.Int64(1),         // Required
	}
	resp, err := svc.ModifySnapshotCopyRetentionPeriod(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_PurchaseReservedNodeOffering() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.PurchaseReservedNodeOfferingInput{
		ReservedNodeOfferingId: aws.String("String"), // Required
		NodeCount:              aws.Int64(1),
	}
	resp, err := svc.PurchaseReservedNodeOffering(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_RebootCluster() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.RebootClusterInput{
		ClusterIdentifier: aws.String("String"), // Required
	}
	resp, err := svc.RebootCluster(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_ResetClusterParameterGroup() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.ResetClusterParameterGroupInput{
		ParameterGroupName: aws.String("String"), // Required
		Parameters: []*redshift.Parameter{
			{ // Required
				AllowedValues:        aws.String("String"),
				ApplyType:            aws.String("ParameterApplyType"),
				DataType:             aws.String("String"),
				Description:          aws.String("String"),
				IsModifiable:         aws.Bool(true),
				MinimumEngineVersion: aws.String("String"),
				ParameterName:        aws.String("String"),
				ParameterValue:       aws.String("String"),
				Source:               aws.String("String"),
			},
			// More values...
		},
		ResetAllParameters: aws.Bool(true),
	}
	resp, err := svc.ResetClusterParameterGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_RestoreFromClusterSnapshot() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.RestoreFromClusterSnapshotInput{
		ClusterIdentifier:                aws.String("String"), // Required
		SnapshotIdentifier:               aws.String("String"), // Required
		AdditionalInfo:                   aws.String("String"),
		AllowVersionUpgrade:              aws.Bool(true),
		AutomatedSnapshotRetentionPeriod: aws.Int64(1),
		AvailabilityZone:                 aws.String("String"),
		ClusterParameterGroupName:        aws.String("String"),
		ClusterSecurityGroups: []*string{
			aws.String("String"), // Required
			// More values...
		},
		ClusterSubnetGroupName:         aws.String("String"),
		ElasticIp:                      aws.String("String"),
		EnhancedVpcRouting:             aws.Bool(true),
		HsmClientCertificateIdentifier: aws.String("String"),
		HsmConfigurationIdentifier:     aws.String("String"),
		IamRoles: []*string{
			aws.String("String"), // Required
			// More values...
		},
		KmsKeyId:     aws.String("String"),
		NodeType:     aws.String("String"),
		OwnerAccount: aws.String("String"),
		Port:         aws.Int64(1),
		PreferredMaintenanceWindow: aws.String("String"),
		PubliclyAccessible:         aws.Bool(true),
		SnapshotClusterIdentifier:  aws.String("String"),
		VpcSecurityGroupIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.RestoreFromClusterSnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_RestoreTableFromClusterSnapshot() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.RestoreTableFromClusterSnapshotInput{
		ClusterIdentifier:  aws.String("String"), // Required
		NewTableName:       aws.String("String"), // Required
		SnapshotIdentifier: aws.String("String"), // Required
		SourceDatabaseName: aws.String("String"), // Required
		SourceTableName:    aws.String("String"), // Required
		SourceSchemaName:   aws.String("String"),
		TargetDatabaseName: aws.String("String"),
		TargetSchemaName:   aws.String("String"),
	}
	resp, err := svc.RestoreTableFromClusterSnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_RevokeClusterSecurityGroupIngress() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.RevokeClusterSecurityGroupIngressInput{
		ClusterSecurityGroupName: aws.String("String"), // Required
		CIDRIP:                  aws.String("String"),
		EC2SecurityGroupName:    aws.String("String"),
		EC2SecurityGroupOwnerId: aws.String("String"),
	}
	resp, err := svc.RevokeClusterSecurityGroupIngress(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_RevokeSnapshotAccess() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.RevokeSnapshotAccessInput{
		AccountWithRestoreAccess:  aws.String("String"), // Required
		SnapshotIdentifier:        aws.String("String"), // Required
		SnapshotClusterIdentifier: aws.String("String"),
	}
	resp, err := svc.RevokeSnapshotAccess(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRedshift_RotateEncryptionKey() {
	sess := session.Must(session.NewSession())

	svc := redshift.New(sess)

	params := &redshift.RotateEncryptionKeyInput{
		ClusterIdentifier: aws.String("String"), // Required
	}
	resp, err := svc.RotateEncryptionKey(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
