//
// Copyright © 2019 Arm Ltd. All rights reserved.
// SPDX-License-Identifier: MIT
//

#pragma once

#include "IPacketBuffer.hpp"

#include <memory>

#define MAX_METADATA_PACKET_LENGTH 4096

namespace armnn
{

namespace profiling
{

class IBufferManager
{
public:
    virtual ~IBufferManager() {}

    virtual IPacketBufferPtr Reserve(unsigned int requestedSize, unsigned int& reservedSize) = 0;

    virtual void Commit(IPacketBufferPtr& packetBuffer, unsigned int size) = 0;

    virtual void Release(IPacketBufferPtr& packetBuffer) = 0;

    virtual IPacketBufferPtr GetReadableBuffer() = 0;

    virtual void MarkRead(IPacketBufferPtr& packetBuffer) = 0;
};

} // namespace profiling

} // namespace armnn
