/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:21:22 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.biojava.bio.symbol.IntegerAlphabet;
import org.biojava.bio.symbol.SymbolList;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.BioJavaSequence;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.PositionalAsymmetryAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class PositionalAsymmetryAlgorithm_ESTest extends PositionalAsymmetryAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      Integer integer0 = positionalAsymmetryAlgorithm0.getDefaultStepSize(2046);
      assertNotNull(integer0);
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertEquals("Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertEquals(204, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      float[] floatArray0 = new float[2];
      // Undeclared exception!
      try { 
        positionalAsymmetryAlgorithm0.getValues(2, (-334), floatArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      float[] floatArray0 = new float[6];
      // Undeclared exception!
      try { 
        positionalAsymmetryAlgorithm0.getValues(103, 0, floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 103 > end: 0
         //
         verifyException("uk.ac.sanger.artemis.plot.PositionalAsymmetryAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = null;
      try {
        positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.PositionalAsymmetryAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      Integer integer0 = positionalAsymmetryAlgorithm0.getDefaultStepSize(103);
      assertEquals(10, (int)integer0);
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertEquals("Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertNotNull(integer0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      Integer integer0 = positionalAsymmetryAlgorithm0.getDefaultStepSize(0);
      assertNull(integer0);
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertEquals("Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      int[] intArray0 = new int[1];
      SymbolList symbolList0 = IntegerAlphabet.fromArray(intArray0);
      BioJavaSequence bioJavaSequence0 = new BioJavaSequence(symbolList0);
      Bases bases0 = new Bases(bioJavaSequence0);
      Strand strand0 = bases0.getForwardStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      Integer integer0 = positionalAsymmetryAlgorithm0.getDefaultMinWindowSize();
      assertEquals("Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertEquals(10, (int)integer0);
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertNotNull(integer0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      Integer integer0 = positionalAsymmetryAlgorithm0.getDefaultMaxWindowSize();
      assertEquals("Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertNotNull(integer0);
      assertEquals(5000, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("L");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      Integer integer0 = positionalAsymmetryAlgorithm0.getDefaultWindowSize();
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertNotNull(integer0);
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertEquals(500, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Cannot create a FramedFeature on the negative strand of an RNA", "Cannot create a FramedFeature on the negative strand of an RNA");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      float[] floatArray0 = new float[2];
      positionalAsymmetryAlgorithm0.getValues(1, 970, floatArray0);
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertArrayEquals(new float[] {2.65625F, 0.0F}, floatArray0, 0.01F);
      assertEquals("Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      float[] floatArray0 = new float[6];
      positionalAsymmetryAlgorithm0.getValues(0, 0, floatArray0);
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertEquals("Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("L");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      float[] floatArray0 = new float[1];
      positionalAsymmetryAlgorithm0.getValues((-3), 2, floatArray0);
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("L");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      int int0 = positionalAsymmetryAlgorithm0.getValueCount();
      assertEquals(1, int0);
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("X\"8bBd`wIoiq'", "X\"8bBd`wIoiq'");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      Float float0 = positionalAsymmetryAlgorithm0.getMaximumInternal();
      assertEquals(10000.0F, (float)float0, 0.01F);
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      positionalAsymmetryAlgorithm0.getMinimumInternal();
  }
}
