/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public final class ConvertToString
extends ComputedExpression {
    private Expression base;

    public ConvertToString(Expression expression) {
        this.base = expression;
    }

    public ItemType getItemType() {
        return Type.STRING_TYPE;
    }

    public Expression simplify() throws XPathException {
        this.base = this.base.simplify();
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.base = this.base.analyze(staticContext);
        if (this.base.getCardinality() == 512 && Type.isSubType(this.base.getItemType(), Type.STRING_TYPE)) {
            return this.base;
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        this.base = this.base.promote(promotionOffer);
        return this;
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.base};
        return expressionArray;
    }

    public int computeCardinality() {
        return 512;
    }

    public boolean equals(Object object) {
        if (object instanceof ConvertToString) {
            ConvertToString convertToString = (ConvertToString)object;
            return this.base.equals(convertToString.base);
        }
        return false;
    }

    public int hashCode() {
        return "ConvertToString".hashCode() + this.base.hashCode();
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.base.iterate(xPathContext);
        Item item = sequenceIterator.next();
        if (item == null) {
            return StringValue.EMPTY_STRING;
        }
        return new StringValue(item.getStringValue());
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "convert to string: ");
        this.base.display(n + 1, namePool);
    }
}

