/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.build;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class Util {
    public static final boolean JAVA5_VM;

    public static String shortVersion(String version) {
        version = Util.replace(version, "alpha", "a");
        version = Util.replace(version, "beta", "b");
        version = Util.replace(version, "candidate", "rc");
        version = Util.replace(version, "development", "d");
        version = Util.replace(version, "dev", "d");
        return version;
    }

    public static String replace(String input, String replace, String with) {
        int loc = input.indexOf(replace);
        if (-1 != loc) {
            String result = input.substring(0, loc);
            result = result + with;
            int start = loc + replace.length();
            if (start < input.length()) {
                result = result + input.substring(start);
            }
            input = result;
        }
        return input;
    }

    public static boolean visitFiles(File baseDir, FileFilter filter) {
        Util.iaxIfNotCanReadDir(baseDir, "baseDir");
        Util.iaxIfNull(filter, "filter");
        File[] files = baseDir.listFiles();
        boolean passed = true;
        for (int i = 0; passed && i < files.length; ++i) {
            passed = files[i].isDirectory() ? Util.visitFiles(files[i], filter) : filter.accept(files[i]);
        }
        return passed;
    }

    public static void iaxIfNotCanReadDir(File dir, String name) {
        if (!Util.canReadDir(dir)) {
            throw new IllegalArgumentException(name + " dir not readable: " + dir);
        }
    }

    public static void iaxIfNotCanReadFile(File file, String name) {
        if (!Util.canReadFile(file)) {
            throw new IllegalArgumentException(name + " file not readable: " + file);
        }
    }

    public static void iaxIfNotCanWriteDir(File dir, String name) {
        if (!Util.canWriteDir(dir)) {
            throw new IllegalArgumentException(name + " dir not writeable: " + dir);
        }
    }

    public static void iaxIfNull(Object input, String name) {
        if (null == input) {
            throw new IllegalArgumentException("null " + name);
        }
    }

    public static String renderException(Throwable thrown) {
        if (null == thrown) {
            return "(Throwable) null";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        pw.println(thrown.getMessage());
        thrown.printStackTrace(pw);
        pw.flush();
        return sw.getBuffer().toString();
    }

    public static boolean canWriteDir(File dir) {
        return null != dir && dir.canWrite() && dir.isDirectory();
    }

    public static String path(String first, String second) {
        return first + File.separator + second;
    }

    public static String path(String[] segments) {
        StringBuffer sb = new StringBuffer();
        if (null != segments) {
            for (int i = 0; i < segments.length; ++i) {
                if (0 < i) {
                    sb.append(File.separator);
                }
                sb.append(segments[i]);
            }
        }
        return sb.toString();
    }

    public static boolean canReadDir(File dir) {
        return null != dir && dir.canRead() && dir.isDirectory();
    }

    public static boolean canReadFile(File file) {
        return null != file && file.canRead() && file.isFile();
    }

    public static boolean delete(File dir) {
        return Util.deleteContents(dir) && dir.delete();
    }

    public static boolean deleteContents(File dir) {
        if (null == dir || !dir.canWrite()) {
            return false;
        }
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (Util.deleteContents(files[i]) && files[i].delete()) continue;
                return false;
            }
        }
        return true;
    }

    public static File makeTempDir(String prefix) {
        if (null == prefix) {
            prefix = "tempDir";
        }
        File tempFile = null;
        for (int i = 0; i < 10; ++i) {
            try {
                tempFile = File.createTempFile(prefix, "tmp");
                tempFile.delete();
                if (tempFile.mkdirs()) break;
                tempFile = null;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return tempFile;
    }

    public static String close(Writer stream) {
        String result = null;
        if (null != stream) {
            try {
                stream.close();
            }
            catch (IOException e) {
                result = e.getMessage();
            }
        }
        return result;
    }

    public static boolean isEmpty(Object[] list) {
        return null == list || 0 == list.length;
    }

    public static void closeSilently(InputStream in) {
        if (null != in) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(Reader in) {
        if (null != in) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final boolean reportMemberDiffs(String[] expected, String[] actual, StringBuffer sb) {
        expected = Util.copy(expected);
        actual = Util.copy(actual);
        int hits = 0;
        for (int i = 0; i < expected.length; ++i) {
            int curHit = hits;
            for (int j = 0; curHit == hits && j < actual.length; ++j) {
                if (null == expected[i]) {
                    throw new IllegalArgumentException("null at " + i);
                }
                if (!expected[i].equals(actual[j])) continue;
                expected[i] = null;
                actual[j] = null;
                ++hits;
            }
        }
        if (hits != expected.length || hits != actual.length) {
            int i;
            sb.append("unexpected [");
            String prefix = "";
            for (i = 0; i < actual.length; ++i) {
                if (null == actual[i]) continue;
                sb.append(prefix);
                prefix = ", ";
                sb.append("\"");
                sb.append(actual[i]);
                sb.append("\"");
            }
            sb.append("] missing [");
            prefix = "";
            for (i = 0; i < expected.length; ++i) {
                if (null == expected[i]) continue;
                sb.append(prefix);
                prefix = ", ";
                sb.append("\"");
                sb.append(expected[i]);
                sb.append("\"");
            }
            sb.append("]");
            return true;
        }
        return false;
    }

    private static final String[] copy(String[] ra) {
        if (null == ra) {
            return new String[0];
        }
        String[] result = new String[ra.length];
        System.arraycopy(ra, 0, result, 0, ra.length);
        return result;
    }

    static {
        boolean java5VM = false;
        try {
            java5VM = null != Class.forName("java.lang.annotation.Annotation");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JAVA5_VM = java5VM;
    }

    public static class OSGIBundle {
        public static final Attributes.Name BUNDLE_NAME = new Attributes.Name("Bundle-Name");
        public static final Attributes.Name BUNDLE_SYMBOLIC_NAME = new Attributes.Name("Bundle-SymbolicName");
        public static final Attributes.Name BUNDLE_VERSION = new Attributes.Name("Bundle-Version");
        public static final Attributes.Name BUNDLE_ACTIVATOR = new Attributes.Name("Bundle-Activator");
        public static final Attributes.Name BUNDLE_VENDOR = new Attributes.Name("Bundle-Vendor");
        public static final Attributes.Name REQUIRE_BUNDLE = new Attributes.Name("Require-Bundle");
        public static final Attributes.Name IMPORT_PACKAGE = new Attributes.Name("Import-Package");
        public static final Attributes.Name BUNDLE_CLASSPATH = new Attributes.Name("Bundle-ClassPath");
        public static final List NAMES;
        private final Manifest manifest = new Manifest();
        private final Attributes attributes;

        public OSGIBundle(InputStream manifestInputStream) throws IOException {
            this.manifest.read(manifestInputStream);
            manifestInputStream.close();
            this.attributes = this.manifest.getMainAttributes();
        }

        public String getAttribute(Attributes.Name attributeName) {
            return this.attributes.getValue(attributeName);
        }

        public String[] getClasspath() {
            String cp = this.getAttribute(BUNDLE_CLASSPATH);
            if (null == cp) {
                return new String[0];
            }
            StringTokenizer st = new StringTokenizer(cp, " ,");
            String[] result = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                result[i++] = st.nextToken();
            }
            return result;
        }

        public RequiredBundle[] getRequiredBundles() {
            String value = this.getAttribute(REQUIRE_BUNDLE);
            if (null == value) {
                return new RequiredBundle[0];
            }
            StringTokenizer st = new StringTokenizer(value, " ,");
            RequiredBundle[] result = new RequiredBundle[st.countTokens()];
            int i = 0;
            int skips = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int first = token.indexOf("\"");
                if (-1 != first) {
                    if (!st.hasMoreTokens()) {
                        throw new IllegalArgumentException(token);
                    }
                    token = token + "," + st.nextToken();
                    ++skips;
                }
                result[i++] = new RequiredBundle(token);
            }
            if (skips > 0) {
                RequiredBundle[] patch = new RequiredBundle[result.length - skips];
                System.arraycopy(result, 0, patch, 0, patch.length);
                result = patch;
            }
            return result;
        }

        static {
            ArrayList<Attributes.Name> names = new ArrayList<Attributes.Name>();
            names.add(BUNDLE_NAME);
            names.add(BUNDLE_SYMBOLIC_NAME);
            names.add(BUNDLE_VERSION);
            names.add(BUNDLE_ACTIVATOR);
            names.add(BUNDLE_VENDOR);
            names.add(REQUIRE_BUNDLE);
            names.add(IMPORT_PACKAGE);
            names.add(BUNDLE_CLASSPATH);
            NAMES = Collections.unmodifiableList(names);
        }

        public static class RequiredBundle {
            final String text;
            final String name;
            final String versions;
            final boolean optional;

            private RequiredBundle(String entry) {
                this.text = entry;
                StringTokenizer st = new StringTokenizer(entry, ";");
                this.name = st.nextToken();
                String vers = null;
                String opt = null;
                String RESOLUTION = "resolution:=";
                String VERSION = "bundle-version=\"";
                while (st.hasMoreTokens()) {
                    int end;
                    int start;
                    String token = st.nextToken();
                    if (token.startsWith("bundle-version=\"")) {
                        start = "bundle-version=\"".length();
                        end = token.lastIndexOf("\"");
                        vers = token.substring(start, end);
                        continue;
                    }
                    if (!token.startsWith("resolution:=")) continue;
                    start = "resolution:=".length();
                    end = token.length();
                    opt = token.substring(start, end);
                }
                this.versions = vers;
                this.optional = "optional".equals(opt);
            }
        }
    }

    public static class Constants {
        public static final String TESTSRC = "testsrc";
        public static final String JAVA5_SRC = "java5-src";
        public static final String JAVA5_TESTSRC = "java5-testsrc";
    }
}

