/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc.misc;

import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;

public class PatternPaint
implements Paint {
    private Paint forePaint;
    private Paint backPaint;
    private long pattern;

    public PatternPaint(Paint fore, Paint back, long pattern) {
        this.forePaint = fore;
        this.backPaint = back;
        this.pattern = pattern;
    }

    public Paint getForeground() {
        return this.forePaint;
    }

    public Paint getBackground() {
        return this.backPaint;
    }

    public long getPattern() {
        return this.pattern;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        PaintContext fore = this.forePaint.createContext(cm, deviceBounds, userBounds, xform, hints);
        PaintContext back = this.backPaint.createContext(cm, deviceBounds, userBounds, xform, hints);
        return new PatternPaintContext(fore, back, this.pattern);
    }

    @Override
    public int getTransparency() {
        int back;
        int fore = this.forePaint.getTransparency();
        if (fore == (back = this.backPaint.getTransparency())) {
            return fore;
        }
        if (fore == 3 || back == 3) {
            return 3;
        }
        if (fore == 2 || back == 2) {
            return 2;
        }
        if (fore == 1 || back == 1) {
            return 1;
        }
        return 1;
    }

    private static class PatternPaintContext
    implements PaintContext {
        private PaintContext foreContext;
        private PaintContext backContext;
        private long pattern;

        public PatternPaintContext(PaintContext fore, PaintContext back, long pattern) {
            this.foreContext = fore;
            this.backContext = back;
            this.pattern = pattern;
        }

        @Override
        public Raster getRaster(int x, int y, int w, int h) {
            if (this.pattern == -1L) {
                return this.foreContext.getRaster(x, y, w, h);
            }
            if (this.pattern == 0L) {
                return this.backContext.getRaster(x, y, w, h);
            }
            Raster foreRaster = this.foreContext.getRaster(x, y, w, h);
            Raster backRaster = this.backContext.getRaster(x, y, w, h);
            ColorModel foreModel = this.foreContext.getColorModel();
            ColorModel backModel = this.backContext.getColorModel();
            BufferedImage img = new BufferedImage(w, h, 2);
            int ry = y;
            int ny = 0;
            while (ny < h) {
                int rx = x;
                int nx = 0;
                while (nx < w) {
                    int rgb = (this.pattern >> ((ry & 7) << 3 | rx & 7) & 1L) != 0L ? foreModel.getRGB(foreRaster.getDataElements(nx, ny, null)) : backModel.getRGB(backRaster.getDataElements(nx, ny, null));
                    img.setRGB(nx, ny, rgb);
                    ++rx;
                    ++nx;
                }
                ++ry;
                ++ny;
            }
            return img.getData();
        }

        @Override
        public ColorModel getColorModel() {
            if (this.pattern == -1L) {
                return this.foreContext.getColorModel();
            }
            if (this.pattern == 0L) {
                return this.backContext.getColorModel();
            }
            BufferedImage img = new BufferedImage(8, 8, 2);
            return img.getColorModel();
        }

        @Override
        public void dispose() {
            this.foreContext.dispose();
            this.backContext.dispose();
        }
    }
}

