--- boohu-0.9.0.orig/combat.go
+++ boohu-0.9.0/combat.go
@@ -174,7 +174,7 @@ func (g *game) AttackMonster(mons *monst
 		if HPrate < 50 && RandInt(HPrate/4) == 0 && !g.Player.HasStatus(StatusExhausted) && !g.Player.HasStatus(StatusBerserk) {
 			g.Player.Statuses[StatusBerserk] = 1
 			g.PushEvent(&simpleEvent{ERank: ev.Rank() + 65 + RandInt(20), EAction: BerserkEnd})
-			g.Print("Your sword insurges you to kill things.")
+			g.Print("Your sword enrages you to kill things.")
 			g.Player.HP += 10
 		}
 	case g.Player.Weapon == DefenderFlail:
@@ -359,7 +359,7 @@ func (g *game) HitMonster(dt dmgType, dm
 			mons.Pos.Distance(g.Player.Pos) == 1 {
 			g.Player.Statuses[StatusNausea]++
 			g.PushEvent(&simpleEvent{ERank: ev.Rank() + 30 + RandInt(20), EAction: NauseaEnd})
-			g.Print("The brizzia's corpse releases a nauseous gas. You feel sick.")
+			g.Print("The brizzia's corpse releases some nauseous gas. You feel sick.")
 		}
 		g.Stats.Hits++
 	} else {
@@ -421,7 +421,7 @@ func (g *game) BlockEffects(m *monster)
 				g.Stats.Digs++
 				g.MakeNoise(WallNoise+2, pos)
 				g.Fog(pos, 1, g.Ev)
-				g.Printf("%s Blocking sound breaks a wall.", g.CrackSound())
+				g.Printf("%s The sound of blocking breaks a wall.", g.CrackSound())
 			}
 		}
 	case BashingShield:
--- boohu-0.9.0.orig/draw.go
+++ boohu-0.9.0/draw.go
@@ -780,11 +780,11 @@ func (ui *termui) HandleKeyAction(g *gam
 
 func (ui *termui) OptionalDescendConfirmation(g *game, st stair) (err error) {
 	if g.Depth == WinDepth && st == NormalStair {
-		g.Print("Do you really want to dive in optional depths? [y/N]")
+		g.Print("Do you really want to dive into optional depths? [y/N]")
 		ui.DrawDungeonView(g, NormalMode)
 		dive := ui.PromptConfirmation(g)
 		if !dive {
-			err = errors.New("Keep going in current level, then.")
+			err = errors.New("Keep going in the current level, then.")
 		}
 	}
 	return err
--- boohu-0.9.0.orig/events.go
+++ boohu-0.9.0/events.go
@@ -115,7 +115,7 @@ func (sev *simpleEvent) Action(g *game)
 		if !g.Player.HasStatus(StatusLignification) {
 			g.Teleportation(sev)
 		} else {
-			g.Print("Lignification prevented teleportation.")
+			g.Print("Lignification has prevented teleportation.")
 		}
 		g.Player.Statuses[StatusTele] = 0
 	case BerserkEnd:
@@ -130,38 +130,38 @@ func (sev *simpleEvent) Action(g *game)
 	case SlowEnd:
 		g.Player.Statuses[StatusSlow]--
 		if g.Player.Statuses[StatusSlow] <= 0 {
-			g.PrintStyled("You feel no longer slow.", logStatusEnd)
+			g.PrintStyled("You no longer feel slow.", logStatusEnd)
 			g.ui.StatusEndAnimation(g)
 		}
 	case ExhaustionEnd:
-		g.PrintStyled("You feel no longer exhausted.", logStatusEnd)
+		g.PrintStyled("You no longer feel exhausted.", logStatusEnd)
 		g.Player.Statuses[StatusExhausted] = 0
 		g.ui.StatusEndAnimation(g)
 	case HasteEnd:
 		g.Player.Statuses[StatusSwift]--
 		if g.Player.Statuses[StatusSwift] == 0 {
-			g.PrintStyled("You feel no longer speedy.", logStatusEnd)
+			g.PrintStyled("You no longer feel speedy.", logStatusEnd)
 			g.ui.StatusEndAnimation(g)
 		}
 	case EvasionEnd:
 		g.Player.Statuses[StatusAgile]--
 		if g.Player.Statuses[StatusAgile] == 0 {
-			g.PrintStyled("You feel no longer agile.", logStatusEnd)
+			g.PrintStyled("You no longer feel agile.", logStatusEnd)
 			g.ui.StatusEndAnimation(g)
 		}
 	case LignificationEnd:
 		g.Player.Statuses[StatusLignification]--
 		g.Player.HP -= int(10 * g.Player.HP / Max(g.Player.HPMax(), g.Player.HP))
 		if g.Player.Statuses[StatusLignification] == 0 {
-			g.PrintStyled("You feel no longer attached to the ground.", logStatusEnd)
+			g.PrintStyled("You no longer feel attached to the ground.", logStatusEnd)
 			g.ui.StatusEndAnimation(g)
 		}
 	case ConfusionEnd:
-		g.PrintStyled("You feel no longer confused.", logStatusEnd)
+		g.PrintStyled("You no longer feel confused.", logStatusEnd)
 		g.Player.Statuses[StatusConfusion] = 0
 		g.ui.StatusEndAnimation(g)
 	case NauseaEnd:
-		g.PrintStyled("You feel no longer sick.", logStatusEnd)
+		g.PrintStyled("You no longer feel sick.", logStatusEnd)
 		g.Player.Statuses[StatusNausea] = 0
 		g.ui.StatusEndAnimation(g)
 	case DisabledShieldEnd:
@@ -177,19 +177,19 @@ func (sev *simpleEvent) Action(g *game)
 	case DigEnd:
 		g.Player.Statuses[StatusDig] = 0
 		if g.Player.Statuses[StatusDig] == 0 {
-			g.PrintStyled("You feel no longer like an earth dragon.", logStatusEnd)
+			g.PrintStyled("You no longer feel like an earth dragon.", logStatusEnd)
 			g.ui.StatusEndAnimation(g)
 		}
 	case SwapEnd:
 		g.Player.Statuses[StatusSwap] = 0
 		if g.Player.Statuses[StatusSwap] == 0 {
-			g.PrintStyled("You feel no longer dancing.", logStatusEnd)
+			g.PrintStyled("You are no longer dancing.", logStatusEnd)
 			g.ui.StatusEndAnimation(g)
 		}
 	case ShadowsEnd:
 		g.Player.Statuses[StatusShadows] = 0
 		if g.Player.Statuses[StatusShadows] == 0 {
-			g.PrintStyled("Shadows leaved you.", logStatusEnd)
+			g.PrintStyled("Shadows have left you.", logStatusEnd)
 			g.ui.StatusEndAnimation(g)
 			g.ComputeLOS()
 			g.MakeMonstersAware()
@@ -200,7 +200,7 @@ func (sev *simpleEvent) Action(g *game)
 		}
 		g.Player.Statuses[StatusSlay]--
 		if g.Player.Statuses[StatusSlay] == 0 {
-			g.PrintStyled("You feel no longer slaying.", logStatusEnd)
+			g.PrintStyled("You no longer feel extra slaying power.", logStatusEnd)
 			g.ui.StatusEndAnimation(g)
 			g.ComputeLOS()
 			g.MakeMonstersAware()
@@ -325,7 +325,7 @@ func (g *game) MakeCreatureSleep(pos pos
 	if pos == g.Player.Pos {
 		g.Player.Statuses[StatusSlow]++
 		g.PushEvent(&simpleEvent{ERank: ev.Rank() + 30 + RandInt(10), EAction: SlowEnd})
-		g.Print("The night clouds make you feel sleepy.")
+		g.Print("The night clouds make you sleepy.")
 		return
 	}
 	mons := g.MonsterAt(pos)
--- boohu-0.9.0.orig/game.go
+++ boohu-0.9.0/game.go
@@ -829,7 +829,7 @@ func (g *game) ApplyRest() {
 		}
 	}
 	g.Stats.Rest++
-	g.PrintStyled("You feel fresh again. Some monsters might have awaken.", logStatusEnd)
+	g.PrintStyled("You feel fresh again. Some monsters might have awoken.", logStatusEnd)
 }
 
 func (g *game) AutoPlayer(ev event) bool {
--- boohu-0.9.0.orig/items.go
+++ boohu-0.9.0/items.go
@@ -366,7 +366,7 @@ func (g *game) QuaffWallPotion(ev event)
 		}
 		g.PushEvent(&cloudEvent{ERank: ev.Rank() + 200 + RandInt(50), Pos: pos, EAction: ObstructionEnd})
 	}
-	g.Printf("You quaff the %s. You feel surrounded by temporal walls.", WallPotion)
+	g.Printf("You quaff the %s. You feel surrounded by temporary walls.", WallPotion)
 	g.ComputeLOS()
 	return nil
 }
--- boohu-0.9.0.orig/los.go
+++ boohu-0.9.0/los.go
@@ -156,7 +156,7 @@ func (g *game) SeePosition(pos position)
 		g.DijkstraMapRebuild = true
 	} else {
 		if g.WrongWall[pos] {
-			g.Printf("There is no more a wall there.")
+			g.Printf("There is no longer a wall there.")
 			g.StopAuto()
 			g.DijkstraMapRebuild = true
 		}
@@ -251,7 +251,7 @@ func (g *game) ComputeNoise() {
 				// no footsteps
 			default:
 				noise[pos] = true
-				g.Print("You heared some footsteps.")
+				g.Print("You heard some footsteps.")
 				count++
 			}
 		}
--- boohu-0.9.0.orig/monster.go
+++ boohu-0.9.0/monster.go
@@ -1773,7 +1773,7 @@ func (m *monster) HitPlayer(g *game, ev
 		m.HitSideEffects(g, ev)
 		if g.Player.Aptitudes[AptConfusingGas] && g.Player.HP < g.Player.HPMax()/2 && RandInt(3) == 0 {
 			m.EnterConfusion(g, ev)
-			g.Printf("You release a confusing gas on the %s.", m.Kind)
+			g.Printf("You release some confusing gas on the %s.", m.Kind)
 		}
 		if g.Player.Aptitudes[AptSmoke] && g.Player.HP < g.Player.HPMax()/2 && RandInt(2) == 0 {
 			g.Smoke(ev)
@@ -2194,7 +2194,7 @@ func (m *monster) MakeHuntIfHurt(g *game
 	if m.Exists() && m.State != Hunting {
 		m.MakeHunt(g)
 		if m.State == Resting {
-			g.Printf("%s awakes.", m.Kind.Definite(true))
+			g.Printf("%s awakens.", m.Kind.Definite(true))
 		}
 		if m.Kind == MonsHound {
 			g.Printf("%s barks.", m.Kind.Definite(true))
@@ -2271,7 +2271,7 @@ func (m *monster) MakeAware(g *game) {
 		}
 	}
 	if m.State == Resting {
-		g.Printf("%s awakes.", m.Kind.Definite(true))
+		g.Printf("%s awakens.", m.Kind.Definite(true))
 	}
 	if m.State == Wandering {
 		g.Printf("%s notices you.", m.Kind.Definite(true))
--- boohu-0.9.0.orig/player.go
+++ boohu-0.9.0/player.go
@@ -237,7 +237,7 @@ func (g *game) BoredomAction(ev event, g
 	}
 	if g.Boredom >= 120 && obor < 120 {
 		if g.MonsterCount() > 4 {
-			g.PrintStyled("You feel a little bored, your health could decline.", logCritic)
+			g.PrintStyled("You feel a little bored, your health may decline.", logCritic)
 			g.StopAuto()
 		}
 	}
@@ -476,13 +476,13 @@ func (g *game) Smoke(ev event) {
 	g.Player.Statuses[StatusSwift]++
 	g.PushEvent(&simpleEvent{ERank: ev.Rank() + 20 + RandInt(10), EAction: HasteEnd})
 	g.ComputeLOS()
-	g.Print("You feel an energy burst and smoking coming out from you.")
+	g.Print("You feel an energy burst and smoke comes out from you.")
 }
 
 func (g *game) Corrosion(ev event) {
 	g.Player.Statuses[StatusCorrosion]++
 	g.PushEvent(&simpleEvent{ERank: ev.Rank() + 80 + RandInt(40), EAction: CorrosionEnd})
-	g.Print("Your equipment is corroded.")
+	g.Print("Your equipment gets corroded.")
 }
 
 func (g *game) Confusion(ev event) {
--- boohu-0.9.0.orig/rods.go
+++ boohu-0.9.0/rods.go
@@ -489,7 +489,7 @@ func (g *game) EvokeRodObstruction(ev ev
 		return err
 	}
 	g.TemporalWallAt(g.Player.Target, ev)
-	g.Printf("You see a wall appear from nothing.")
+	g.Printf("You see a wall appear from thin air.")
 	return nil
 }
 
