//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Base/Util/VectorUtil.h
//! @brief     Defines namespace VectorUtil.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_BASE_UTIL_VECTORUTIL_H
#define BORNAGAIN_BASE_UTIL_VECTORUTIL_H

#include <heinz/Complex.h>
#include <vector>

namespace VectorUtil {

//! Returns true if vector is equidistant within tol * bin_width.
bool is_equidistant(const std::vector<double>& vec, double tol);

std::vector<double> make_grid(std::size_t n, double first, double last);

//! Returns vector of real parts.
std::vector<double> real(const std::vector<complex_t>& v);

} // namespace VectorUtil

#endif // BORNAGAIN_BASE_UTIL_VECTORUTIL_H
