//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Item/ItemStackWidget.h
//! @brief     Defines class ItemStackWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_ITEM_ITEMSTACKWIDGET_H
#define BORNAGAIN_GUI_VIEW_ITEM_ITEMSTACKWIDGET_H

#include <QWidget>

//! Base for ItemStackPresenter. Contains a stack of widgets.

class ItemStackWidget : public QWidget {
    Q_OBJECT
public:
    ItemStackWidget(QWidget* parent = nullptr);

    QSize sizeHint() const override;
    QSize minimumSizeHint() const override;

    void setSizeHint(const QSize& size_hint);

    void hideWidgets();

protected:
    class QStackedWidget* m_stackedWidget;
    QSize m_size_hint;
};

#endif // BORNAGAIN_GUI_VIEW_ITEM_ITEMSTACKWIDGET_H
