//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Mask/RegionOfInterestView.cpp
//! @brief     Defines RegionOfInterestView class
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/View/Mask/RegionOfInterestView.h"
#include "GUI/Model/Data/MaskItems.h"
#include "GUI/View/Mask/ISceneAdaptor.h"
#include <QPainter>

RegionOfInterestView::RegionOfInterestView(RegionOfInterestItem* item)
    : RectangleView(item)
{
}

QRectF RegionOfInterestView::boundingRect() const
{
    return mapFromScene(m_adaptor->viewportRectangle()).boundingRect();
}

void RegionOfInterestView::update_view()
{
    RectangleView::update_view();
    m_bounding_rect = m_adaptor->viewportRectangle();
    update();
}

void RegionOfInterestView::paint(QPainter* painter, const QStyleOptionGraphicsItem*, QWidget*)
{
    QPainterPath outerRect;
    outerRect.addRect(boundingRect());

    QPainterPath innerRect;
    innerRect.addRect(m_mask_rect);

    painter->setBrush(MaskEditorHelper::getMaskBrush(true));
    painter->drawPath(outerRect.subtracted(innerRect));
}
