# Python dependencies

# find Python platform with/without a given path
include("multipython/FindCustomPython3")
if(BA_PY_PLATFORM)
    message(STATUS "PyDependences: Custom Python platform path = '${BA_PY_PLATFORM}'")
    find_custom_python3(PATHS "${BA_PY_PLATFORM}" VERBOSE)
else()
    message(STATUS "PyDependences: Using default Python platform")
    find_custom_python3(DEFAULT_PATH VERBOSE)
endif()

set(pyversion ${Python3_VERSION_MAJOR}.${Python3_VERSION_MINOR})
set(pydst "${destination_root}python/${pyversion}")
set(destination_python
    "${pydst}/dist-packages/")
set(destination_pypackage ${pydst}/wheel)

message(STATUS "Python destination directory: ${destination_python}")
message(STATUS "Python package destination directory: ${destination_pypackage}")

# check presence of some Python modules
message(STATUS "Searching required Python packages...")
set(py_packages "pip;numpy;matplotlib")
if(LINUX AND BA_PY_PACKAGE)
    # on Linux, `auditwheel` is needed to produce 'manylinux' wheels repair (PEP 599)
    list(APPEND py_packages "auditwheel")
endif()

foreach(pkg ${py_packages})
    message(STATUS "Python package ${pkg}")
    execute_process(
        COMMAND ${Python3_EXECUTABLE} -c "import ${pkg}"
        RESULT_VARIABLE PKG_FOUND)
    if(NOT PKG_FOUND EQUAL 0)
        message(FATAL_ERROR "Python package '${pkg}' not found")
    endif()
endforeach()

# configure SWIG bindings
if(CONFIGURE_BINDINGS)
    find_package(SWIG 4.1 EXACT REQUIRED)
    include(${SWIG_USE_FILE})
    message(STATUS "Found SWIG version ${SWIG_VERSION} at ${SWIG_EXECUTABLE} "
        "with flags '${SWIG_FLAGS}'; CMake definitions in ${SWIG_USE_FILE}")

    # cache SWIG-related variables
    foreach(var_ SWIG_EXECUTABLE SWIG_VERSION SWIG_FLAGS SWIG_USE_FILE)
        set(${var_} ${${var_}} CACHE INTERNAL "")
    endforeach()
endif()

if(BA_PY_PACKAGE)
    # define a target to make a Python wheel
    include("multipython/MakePythonWheel")
    make_python_wheel(
        Py3_VERSION ${Python3_VERSION}
        Py3_EXECUTABLE "${Python3_EXECUTABLE}"
        Py3_INCLUDE_DIRS "${Python3_INCLUDE_DIRS}"
        Py3_LIBRARY_DIRS "${Python3_LIBRARY_DIRS}"
        )
endif()
