+++
title = "Specular"
weight = 10
+++

## Specular reflectometry simulation

To set up and run a specular reflectometry simulation, use
```python
import bornagain as ba
scan = ...
sample = ...
simulation = ba.SpecularSimulation(scan, sample)
# ... set options
result = simulation.simulate()
```

For the constructor arguments, see sections [scan](/ref/instr/scan)
and [sample](/ref/sample).

For optional settings, see [simulation options](/ref/sim/setup/options).

For the return type of function `simulate()`,
see [Datafield](/ref/result/datafield).


##### Examples

* [basic specular simulation](/ex/sim/specular)

##### Further reading

* [specular signal from a rough sample](/ref/sample/roughness/specular/index.md)
* [beam footprint correction](/ref/instr/beam/footprint/index.md)
* [beam divergence in specular simulations](/ref/instr/beam/full-divergence/index.md)
* [fitting reflectometry data](/ex/fit/extended/fit-specular-data/index.md)
