//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Base/Util/Vec.h
//! @brief     Defines namespace Vec.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_BASE_UTIL_VEC_H
#define BORNAGAIN_BASE_UTIL_VEC_H

#include <vector>

namespace Vec {

template <typename T, class S> int indexOfPtr(const T* t, const std::vector<S*>& v)
{
    for (size_t i = 0; i < v.size(); i++)
        if (v[i] == t)
            return int(i);
    return -1;
}

template <typename T, class S> bool containsPtr(const T* t, const std::vector<S*>& v)
{
    for (size_t i = 0; i < v.size(); i++)
        if (v[i] == t)
            return true;
    return false;
}

template <typename C> void concat(std::vector<C>& v, const std::vector<C>& w)
{
    v.insert(v.end(), w.begin(), w.end());
}

template <typename C> std::vector<C> flatten(const std::vector<std::vector<C>>& src)
{
    std::vector<C> result;
    for (const auto& row : src)
        result.insert(result.end(), row.begin(), row.end());
    return result;
}

template <typename C>
std::vector<std::vector<C>> reshapeTo2D(const std::vector<C>& src, size_t n_rows)
{
    size_t n_cols = src.size() / n_rows;
    std::vector<std::vector<C>> result(n_rows);

    for (size_t i = 0; i < n_rows; i++)
        result[i].insert(result[i].end(), src.begin() + i * n_cols, src.begin() + (i + 1) * n_cols);
    return result;
}

} // namespace Vec

#endif // BORNAGAIN_BASE_UTIL_VEC_H
