//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Sample/LayerItem.h
//! @brief     Defines class LayerItem.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_SAMPLE_LAYERITEM_H
#define BORNAGAIN_GUI_MODEL_SAMPLE_LAYERITEM_H

#include "Base/Type/OwningVector.h"
#include "GUI/Model/Descriptor/DoubleProperty.h"
#include "GUI/Model/Descriptor/PolyItem.h"
#include "GUI/Model/Sample/Item3D.h"
#include "GUI/Model/Sample/ItemWithMaterial.h"
#include "GUI/Model/Sample/RoughnessCatalog.h"
#include <QColor>

class ItemWithParticles;
class ParticleLayoutItem;

class LayerItem : public virtual ItemWithMaterial, public virtual Item3D {
public:
    explicit LayerItem(const MaterialsSet* materials);
    ~LayerItem();

    std::vector<ItemWithMaterial*> itemsWithMaterial();
    std::vector<ItemWithParticles*> itemsWithParticles() const;

    DoubleProperty& thickness() { return m_thickness; }
    const DoubleProperty& thickness() const { return m_thickness; }

    PolyItem<RoughnessCatalog>& roughnessSelection() { return m_roughness; }

    uint numSlices() const { return m_num_slices; }
    void setNumSlices(uint v) { m_num_slices = v; }

    const std::vector<ParticleLayoutItem*>& layoutItems() const { return m_layouts.shared(); }
    ParticleLayoutItem* addLayoutItem();
    void removeLayoutItem(ParticleLayoutItem* layout);

    QColor color() const { return m_color; }
    void setColor(const QColor& c) { m_color = c; }

    bool isTopLayer() const { return m_is_top_layer; }
    void setIsTopLayer(bool b) { m_is_top_layer = b; }

    bool isBottomLayer() const { return m_is_bottom_layer; }
    void setIsBottomLayer(bool b) { m_is_bottom_layer = b; }

    void writeTo(QXmlStreamWriter* w) const;
    void readFrom(QXmlStreamReader* r);

    bool expandLayer = false;

private:
    uint m_num_slices = 1;
    DoubleProperty m_thickness;
    QColor m_color;
    bool m_is_top_layer = false;
    bool m_is_bottom_layer = false;
    OwningVector<ParticleLayoutItem> m_layouts;
    PolyItem<RoughnessCatalog> m_roughness;
};

#endif // BORNAGAIN_GUI_MODEL_SAMPLE_LAYERITEM_H
