//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Sample/RoughnessCatalog.cpp
//! @brief     Implements class RoughnessCatalog.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2022
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/Model/Sample/RoughnessCatalog.h"
#include "Base/Util/Assert.h"
#include "GUI/Model/Sample/RoughnessItems.h"

RoughnessItem* RoughnessCatalog::create(Type type)
{
    switch (type) {
    case Type::None:
        return nullptr;
    case Type::Basic:
        return new BasicRoughnessItem(0., .3, 5.);
    }
    ASSERT_NEVER;
}

QVector<RoughnessCatalog::Type> RoughnessCatalog::types()
{
    return {Type::None, Type::Basic};
}

UiInfo RoughnessCatalog::uiInfo(Type type)
{
    switch (type) {
    case Type::None:
        return {"None", "", ""};
    case Type::Basic:
        return {"Basic", "Stretched exponential lateral correlation function", ""};
    }
    ASSERT_NEVER;
}

RoughnessCatalog::Type RoughnessCatalog::type(const RoughnessItem* item)
{
    if (!item)
        return Type::None;

    if (dynamic_cast<const BasicRoughnessItem*>(item))
        return Type::Basic;

    ASSERT_NEVER;
}
