//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Sample/ISelectionForm.cpp
//! @brief     Implements class ISelectionForm, except for templated functions.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/View/Sample/ISelectionForm.h"
#include "GUI/View/Base/LayoutUtil.h"

ISelectionForm::ISelectionForm(QWidget* parent, SampleEditorController* ec)
    : QWidget(parent)
    , m_ec(ec)
{
}

void ISelectionForm::clear()
{
    auto* layoutItemOfComboBox = m_grid_layout->itemAtPosition(1, 0);
    m_grid_layout->takeAt(m_grid_layout->indexOf(layoutItemOfComboBox));
    GUI::Util::Layout::clearLayout(m_grid_layout, true);
    m_grid_layout->addWidget(layoutItemOfComboBox->widget(), 1, 0);
}
