//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Resample/Slice/SliceStack.h
//! @brief     Defines class SliceStack.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifdef SWIG
#error no need to expose this header to Swig
#endif // SWIG
#ifndef BORNAGAIN_RESAMPLE_SLICE_SLICESTACK_H
#define BORNAGAIN_RESAMPLE_SLICE_SLICESTACK_H

#include "Resample/Slice/Slice.h" // TODO move back to cpp file
#include <heinz/Vectors3D.h>
#include <vector>

class LayerRoughness;
class Material;
class Slice;

//! A stack of Slice%s.

class SliceStack : public std::vector<Slice> {
public:
    SliceStack() = default;

    void addTopSlice(double zbottom, const Material& material);
    void addSlice(double thickness, const Material& material,
                  const LayerRoughness* roughness = nullptr);
    void addNSlices(size_t n, double thickness, const Material& material,
                    const LayerRoughness* roughness = nullptr);

    SliceStack setBField(const R3& externalField);

    // the name "bottom roughness" refers to the normal top roughness of a slice, but from the point
    // of view of the inverted stack used in the recurrence relation computation algorithm.
    const LayerRoughness* bottomRoughness(size_t i_slice) const;
};

#endif // BORNAGAIN_RESAMPLE_SLICE_SLICESTACK_H
