//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Sample/Interface/RoughnessModels.h
//! @brief     Define RoughnessModels enumerator and Python wrapper.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_SAMPLE_INTERFACE_ROUGHNESSMODELS_H
#define BORNAGAIN_SAMPLE_INTERFACE_ROUGHNESSMODELS_H

#include "Base/Type/ICloneable.h"

class RoughnessModel : public ICloneable {
public:
    RoughnessModel* clone() const override = 0;
    virtual double transient(double x, double sigma) const = 0;
    virtual double distribution(double x, double sigma) const = 0;
    virtual double sigmaRange() const = 0;
};

class ErfRoughness : public RoughnessModel {
public:
    ErfRoughness();
    double transient(double x, double sigma) const override;
    double distribution(double x, double sigma) const override;
    double sigmaRange() const override;
    ErfRoughness* clone() const override;
};

class TanhRoughness : public RoughnessModel {
public:
    TanhRoughness();
    double transient(double x, double sigma) const override;
    double distribution(double x, double sigma) const override;
    double sigmaRange() const override;
    TanhRoughness* clone() const override;
};

using DefaultRoughness = TanhRoughness;

#endif // BORNAGAIN_SAMPLE_INTERFACE_ROUGHNESSMODELS_H
