#!/usr/bin/env python3

from __future__ import print_function
import sys
sys.path.append('/usr/share/botch')
from util import read_json_file

# string of package


def sop(cudfpkg):
    name, ver = cudfpkg
    pref, name = name.split(':', 2)
    if pref == 'src':
        return "src:" + name
    else:
        return name

# string of list


def sol(l):
    return " ".join([sop(pkg) for pkg in l])

if __name__ == '__main__':
    import argparse
    parser = argparse.ArgumentParser(
        description=("extract feedback arc set from stats.json"))
    parser.add_argument(
        'stats', metavar='stats.json', type=read_json_file, help='input json')
    parser.add_argument(
        '-v', '--verbose', action='store_true', help='be verbose')
    args = parser.parse_args()
    for scc in args.stats['buildgraph']['sccs']:
        for src, deps in scc['fas']:
            print(sop(src), sol(deps))
