#!/usr/bin/env python3

import networkx as nx
import sys
sys.path.append('/usr/share/botch')
from util import read_graphml, write_dot


def graphml2dot(g):
    h = nx.DiGraph()

    for n, d in g.nodes_iter(data=True):
        t = g.node[n].get('type')
        if t in ['src', None]:
            h.add_node(n, {'label': d['name'], 'shape': 'rectangle'})
        else:
            h.add_node(
                n, {'label': d['name'].split(':')[1], 'shape': 'ellipse'})

    for efrom, eto, edata in g.edges_iter(data=True):
        k = edata.get('kind')
        if k in ['builddep', None]:
            h.add_edge(efrom, eto, {'style': 'dashed'})
        else:
            h.add_edge(efrom, eto)

    return h

if __name__ == '__main__':
    import argparse
    parser = argparse.ArgumentParser(
        description=("Convert a graph in GraphML format to dot"))
    parser.add_argument(
        "g", type=read_graphml, help="Input graph in GraphML format")
    parser.add_argument("h", type=write_dot, help="Output graph in dot format")
    parser.add_argument(
        '-v', '--verbose', action='store_true', help='be verbose')
    args = parser.parse_args()
    h = graphml2dot(args.g)
    args.h(h)
