{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetBody1: TRigidBodyNode;
    procedure SetBody1(const Value: TRigidBodyNode);
    function GetBody2: TRigidBodyNode;
    procedure SetBody2(const Value: TRigidBodyNode);
    function GetBounce: Single;
    procedure SetBounce(const Value: Single);
    function GetContactNormal: TVector3;
    procedure SetContactNormal(const Value: TVector3);
    function GetDepth: Single;
    procedure SetDepth(const Value: Single);
    function GetFrictionCoefficients: TVector2;
    procedure SetFrictionCoefficients(const Value: TVector2);
    function GetFrictionDirection: TVector3;
    procedure SetFrictionDirection(const Value: TVector3);
    function GetGeometry1: TAbstractNBodyCollidableNode;
    procedure SetGeometry1(const Value: TAbstractNBodyCollidableNode);
    function GetGeometry2: TAbstractNBodyCollidableNode;
    procedure SetGeometry2(const Value: TAbstractNBodyCollidableNode);
    function GetMinbounceSpeed: Single;
    procedure SetMinbounceSpeed(const Value: Single);
    function GetPosition: TVector3;
    procedure SetPosition(const Value: TVector3);
    function GetSlipCoefficients: TVector2;
    procedure SetSlipCoefficients(const Value: TVector2);
    function GetSoftnessConstantForceMix: Single;
    procedure SetSoftnessConstantForceMix(const Value: Single);
    function GetSoftnessErrorCorrection: Single;
    procedure SetSoftnessErrorCorrection(const Value: Single);
    function GetSurfaceSpeed: TVector2;
    procedure SetSurfaceSpeed(const Value: TVector2);
  public
    procedure SetAppliedParameters(const Value: array of string);
    procedure SetAppliedParameters(const Value: TCastleStringList);
    property Body1: TRigidBodyNode read GetBody1 write SetBody1;
    property Body2: TRigidBodyNode read GetBody2 write SetBody2;
    property Bounce: Single read GetBounce write SetBounce;
    property ContactNormal: TVector3 read GetContactNormal write SetContactNormal;
    property Depth: Single read GetDepth write SetDepth;
    property FrictionCoefficients: TVector2 read GetFrictionCoefficients write SetFrictionCoefficients;
    property FrictionDirection: TVector3 read GetFrictionDirection write SetFrictionDirection;
    property Geometry1: TAbstractNBodyCollidableNode read GetGeometry1 write SetGeometry1;
    property Geometry2: TAbstractNBodyCollidableNode read GetGeometry2 write SetGeometry2;
    property MinbounceSpeed: Single read GetMinbounceSpeed write SetMinbounceSpeed;
    property Position: TVector3 read GetPosition write SetPosition;
    property SlipCoefficients: TVector2 read GetSlipCoefficients write SetSlipCoefficients;
    property SoftnessConstantForceMix: Single read GetSoftnessConstantForceMix write SetSoftnessConstantForceMix;
    property SoftnessErrorCorrection: Single read GetSoftnessErrorCorrection write SetSoftnessErrorCorrection;
    property SurfaceSpeed: TVector2 read GetSurfaceSpeed write SetSurfaceSpeed;

{$endif read_interface}

{$ifdef read_implementation}

{ TContactNode ----------------------------------------------- }

procedure TContactNode.SetAppliedParameters(const Value: array of string);
begin
  FdAppliedParameters.Send(Value);
end;

procedure TContactNode.SetAppliedParameters(const Value: TCastleStringList);
begin
  FdAppliedParameters.Send(Value);
end;

function TContactNode.GetBody1: TRigidBodyNode;
begin
  if FdBody1.Value is TRigidBodyNode then
    Result := TRigidBodyNode(FdBody1.Value)
  else
    Result := nil;
end;

procedure TContactNode.SetBody1(const Value: TRigidBodyNode);
begin
  FdBody1.Send(Value);
end;

function TContactNode.GetBody2: TRigidBodyNode;
begin
  if FdBody2.Value is TRigidBodyNode then
    Result := TRigidBodyNode(FdBody2.Value)
  else
    Result := nil;
end;

procedure TContactNode.SetBody2(const Value: TRigidBodyNode);
begin
  FdBody2.Send(Value);
end;

function TContactNode.GetBounce: Single;
begin
  Result := FdBounce.Value;
end;

procedure TContactNode.SetBounce(const Value: Single);
begin
  FdBounce.Send(Value);
end;

function TContactNode.GetContactNormal: TVector3;
begin
  Result := FdContactNormal.Value;
end;

procedure TContactNode.SetContactNormal(const Value: TVector3);
begin
  FdContactNormal.Send(Value);
end;

function TContactNode.GetDepth: Single;
begin
  Result := FdDepth.Value;
end;

procedure TContactNode.SetDepth(const Value: Single);
begin
  FdDepth.Send(Value);
end;

function TContactNode.GetFrictionCoefficients: TVector2;
begin
  Result := FdFrictionCoefficients.Value;
end;

procedure TContactNode.SetFrictionCoefficients(const Value: TVector2);
begin
  FdFrictionCoefficients.Send(Value);
end;

function TContactNode.GetFrictionDirection: TVector3;
begin
  Result := FdFrictionDirection.Value;
end;

procedure TContactNode.SetFrictionDirection(const Value: TVector3);
begin
  FdFrictionDirection.Send(Value);
end;

function TContactNode.GetGeometry1: TAbstractNBodyCollidableNode;
begin
  if FdGeometry1.Value is TAbstractNBodyCollidableNode then
    Result := TAbstractNBodyCollidableNode(FdGeometry1.Value)
  else
    Result := nil;
end;

procedure TContactNode.SetGeometry1(const Value: TAbstractNBodyCollidableNode);
begin
  FdGeometry1.Send(Value);
end;

function TContactNode.GetGeometry2: TAbstractNBodyCollidableNode;
begin
  if FdGeometry2.Value is TAbstractNBodyCollidableNode then
    Result := TAbstractNBodyCollidableNode(FdGeometry2.Value)
  else
    Result := nil;
end;

procedure TContactNode.SetGeometry2(const Value: TAbstractNBodyCollidableNode);
begin
  FdGeometry2.Send(Value);
end;

function TContactNode.GetMinbounceSpeed: Single;
begin
  Result := FdMinbounceSpeed.Value;
end;

procedure TContactNode.SetMinbounceSpeed(const Value: Single);
begin
  FdMinbounceSpeed.Send(Value);
end;

function TContactNode.GetPosition: TVector3;
begin
  Result := FdPosition.Value;
end;

procedure TContactNode.SetPosition(const Value: TVector3);
begin
  FdPosition.Send(Value);
end;

function TContactNode.GetSlipCoefficients: TVector2;
begin
  Result := FdSlipCoefficients.Value;
end;

procedure TContactNode.SetSlipCoefficients(const Value: TVector2);
begin
  FdSlipCoefficients.Send(Value);
end;

function TContactNode.GetSoftnessConstantForceMix: Single;
begin
  Result := FdSoftnessConstantForceMix.Value;
end;

procedure TContactNode.SetSoftnessConstantForceMix(const Value: Single);
begin
  FdSoftnessConstantForceMix.Send(Value);
end;

function TContactNode.GetSoftnessErrorCorrection: Single;
begin
  Result := FdSoftnessErrorCorrection.Value;
end;

procedure TContactNode.SetSoftnessErrorCorrection(const Value: Single);
begin
  FdSoftnessErrorCorrection.Send(Value);
end;

function TContactNode.GetSurfaceSpeed: TVector2;
begin
  Result := FdSurfaceSpeed.Value;
end;

procedure TContactNode.SetSurfaceSpeed(const Value: TVector2);
begin
  FdSurfaceSpeed.Send(Value);
end;

{$endif read_implementation}
