/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2019 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/
#ifndef CDO_VLIST_H
#define CDO_VLIST_H

#include <vector>
#include <map>

void vlistMap(int vlistID1, int vlistID2, int flag, int mapflag, std::map<int, int> &mapOfVarIDs);
void vlistCompare(int vlistID1, int vlistID2, int flag);
int vlistCompareX(int vlistID1, int vlistID2, int flag);
bool vlistIsSzipped(int vlistID);

int vlistInqNWPV(int vlistID, int varID);
size_t vlist_check_gridsize(int vlistID);
int vlist_get_psvarid(int vlistID, int zaxisID);
double *vlist_read_vct(int vlistID, int *rzaxisIDh, int *rnvct, int *rnhlev, int *rnhlevf, int *rnhlevh);
void vlist_change_hybrid_zaxis(int vlistID1, int vlistID2, int zaxisID1, int zaxisID2);

void cdoCompareGrids(int gridID1, int gridID2);  // TODO: Check if this belongs here or if it should be in griddes.*

struct ListVar
{
  int gridID;
  int zaxisID;
  size_t gridsize;
  int nlevels;
  int datatype;
  double missval;
  int timetype;
};

using VarList = std::vector<ListVar>;
void varListInit(VarList &vl, int vlistID);

#endif
