// Copyright (c) 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SESSIONS_SESSION_TYPES_TEST_HELPER_H_
#define COMPONENTS_SESSIONS_SESSION_TYPES_TEST_HELPER_H_

#include <string>

#include "base/basictypes.h"
#include "base/strings/string16.h"
#include "base/time/time.h"
#include "ui/base/page_transition_types.h"

class GURL;

namespace base {
class Time;
}

namespace sessions {

class SerializedNavigationEntry;

namespace test_data {

extern const int kIndex;
extern const int kUniqueID;
extern const GURL kReferrerURL;
extern const int kReferrerPolicy;
extern const GURL kVirtualURL;
extern const base::string16 kTitle;
extern const std::string kEncodedPageState;
extern const ui::PageTransition kTransitionType;
extern const bool kHasPostData;
extern const int64 kPostID;
extern const GURL kOriginalRequestURL;
extern const bool kIsOverridingUserAgent;
extern const base::Time kTimestamp;
extern const base::string16 kSearchTerms;
extern const GURL kFaviconURL;
extern const int kHttpStatusCode;
extern const GURL kRedirectURL0;
extern const GURL kRedirectURL1;
extern const GURL kOtherURL;
extern const int kPageID;

}  // namespace test_data

// Set of test functions to manipulate a SerializedNavigationEntry.
class SerializedNavigationEntryTestHelper {
 public:
  // Compares the two entries. This uses EXPECT_XXX on each member, if your test
  // needs to stop after this wrap calls to this in EXPECT_NO_FATAL_FAILURE.
  static void ExpectNavigationEquals(const SerializedNavigationEntry& expected,
                                     const SerializedNavigationEntry& actual);

  // Creates a SerializedNavigationEntry with the given URL and title and some
  // common values for the other fields.
  static SerializedNavigationEntry CreateNavigation(
      const std::string& virtual_url,
      const std::string& title);

  // Creates a SerializedNavigationEntry using the |test_data| constants above.
  static SerializedNavigationEntry CreateNavigationForTest();

  static void SetReferrerPolicy(int policy,
                                SerializedNavigationEntry* navigation);

  static void SetVirtualURL(const GURL& virtual_url,
                            SerializedNavigationEntry* navigation);

  static void SetEncodedPageState(const std::string& encoded_page_state,
                                  SerializedNavigationEntry* navigation);

  static void SetTransitionType(ui::PageTransition transition_type,
                                SerializedNavigationEntry* navigation);

  static void SetHasPostData(bool has_post_data,
                             SerializedNavigationEntry* navigation);

  static void SetOriginalRequestURL(const GURL& original_request_url,
                                    SerializedNavigationEntry* navigation);

  static void SetIsOverridingUserAgent(bool is_overriding_user_agent,
                                       SerializedNavigationEntry* navigation);

  static void SetTimestamp(base::Time timestamp,
                           SerializedNavigationEntry* navigation);

 private:
  DISALLOW_IMPLICIT_CONSTRUCTORS(SerializedNavigationEntryTestHelper);
};

}  // sessions

#endif  // COMPONENTS_SESSIONS_SESSION_TYPES_TEST_HELPER_H_
