<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from oauth-client/xml/schema/CRM/OAuth/OAuthSysToken.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:14387fad3c51ab994575b3cd759e6229)
 */
use CRM_OAuth_ExtensionUtil as E;

/**
 * Database access object for the OAuthSysToken entity.
 */
class CRM_OAuth_DAO_OAuthSysToken extends CRM_Core_DAO {
  const EXT = E::LONG_NAME;
  const TABLE_ADDED = '5.32';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_oauth_systoken';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = FALSE;

  /**
   * Token ID
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $id;

  /**
   * The tag specifies how this token will be used.
   *
   * @var string|null
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $tag;

  /**
   * Client ID
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $client_id;

  /**
   * Ex: authorization_code
   *
   * @var string|null
   *   (SQL type: varchar(31))
   *   Note that values will be retrieved from the database as a string.
   */
  public $grant_type;

  /**
   * List of scopes addressed by this token
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $scopes;

  /**
   * Ex: Bearer or MAC
   *
   * @var string|null
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $token_type;

  /**
   * Token to present when accessing resources
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $access_token;

  /**
   * Expiration time for the access_token (seconds since epoch)
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $expires;

  /**
   * Token to present when refreshing the access_token
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $refresh_token;

  /**
   * Identifier for the resource owner. Structure varies by service.
   *
   * @var string|null
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $resource_owner_name;

  /**
   * Cached details describing the resource owner
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $resource_owner;

  /**
   * List of scopes addressed by this token
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $error;

  /**
   * The token response data, per AccessToken::jsonSerialize
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $raw;

  /**
   * When the token was created.
   *
   * @var string
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   */
  public $created_date;

  /**
   * When the token was created or modified.
   *
   * @var string
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   */
  public $modified_date;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_oauth_systoken';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? E::ts('OAuth Sys Tokens') : E::ts('OAuth Sys Token');
  }

  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  public static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'client_id', 'civicrm_oauth_client', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => E::ts('Token ID'),
          'description' => E::ts('Token ID'),
          'required' => TRUE,
          'where' => 'civicrm_oauth_systoken.id',
          'table_name' => 'civicrm_oauth_systoken',
          'entity' => 'OAuthSysToken',
          'bao' => 'CRM_OAuth_DAO_OAuthSysToken',
          'localizable' => 0,
          'readonly' => TRUE,
          'add' => '5.32',
        ],
        'tag' => [
          'name' => 'tag',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => E::ts('Tag'),
          'description' => E::ts('The tag specifies how this token will be used.'),
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'where' => 'civicrm_oauth_systoken.tag',
          'table_name' => 'civicrm_oauth_systoken',
          'entity' => 'OAuthSysToken',
          'bao' => 'CRM_OAuth_DAO_OAuthSysToken',
          'localizable' => 0,
          'add' => '5.32',
        ],
        'client_id' => [
          'name' => 'client_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => E::ts('Client ID'),
          'description' => E::ts('Client ID'),
          'where' => 'civicrm_oauth_systoken.client_id',
          'table_name' => 'civicrm_oauth_systoken',
          'entity' => 'OAuthSysToken',
          'bao' => 'CRM_OAuth_DAO_OAuthSysToken',
          'localizable' => 0,
          'FKClassName' => 'CRM_OAuth_DAO_OAuthClient',
          'add' => '5.32',
        ],
        'grant_type' => [
          'name' => 'grant_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => E::ts('Grant type'),
          'description' => E::ts('Ex: authorization_code'),
          'maxlength' => 31,
          'size' => CRM_Utils_Type::MEDIUM,
          'where' => 'civicrm_oauth_systoken.grant_type',
          'table_name' => 'civicrm_oauth_systoken',
          'entity' => 'OAuthSysToken',
          'bao' => 'CRM_OAuth_DAO_OAuthSysToken',
          'localizable' => 0,
          'add' => '5.32',
        ],
        'scopes' => [
          'name' => 'scopes',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => E::ts('Scopes'),
          'description' => E::ts('List of scopes addressed by this token'),
          'where' => 'civicrm_oauth_systoken.scopes',
          'table_name' => 'civicrm_oauth_systoken',
          'entity' => 'OAuthSysToken',
          'bao' => 'CRM_OAuth_DAO_OAuthSysToken',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_SEPARATOR_BOOKEND,
          'add' => '5.32',
        ],
        'token_type' => [
          'name' => 'token_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => E::ts('Token Type'),
          'description' => E::ts('Ex: Bearer or MAC'),
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'where' => 'civicrm_oauth_systoken.token_type',
          'table_name' => 'civicrm_oauth_systoken',
          'entity' => 'OAuthSysToken',
          'bao' => 'CRM_OAuth_DAO_OAuthSysToken',
          'localizable' => 0,
          'add' => '5.32',
        ],
        'access_token' => [
          'name' => 'access_token',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => E::ts('Access Token'),
          'description' => E::ts('Token to present when accessing resources'),
          'where' => 'civicrm_oauth_systoken.access_token',
          'permission' => [
            [
              'manage OAuth client secrets',
            ],
          ],
          'table_name' => 'civicrm_oauth_systoken',
          'entity' => 'OAuthSysToken',
          'bao' => 'CRM_OAuth_DAO_OAuthSysToken',
          'localizable' => 0,
          'add' => '5.32',
        ],
        'expires' => [
          'name' => 'expires',
          'type' => CRM_Utils_Type::T_INT,
          'title' => E::ts('Expiration time'),
          'description' => E::ts('Expiration time for the access_token (seconds since epoch)'),
          'where' => 'civicrm_oauth_systoken.expires',
          'default' => '0',
          'table_name' => 'civicrm_oauth_systoken',
          'entity' => 'OAuthSysToken',
          'bao' => 'CRM_OAuth_DAO_OAuthSysToken',
          'localizable' => 0,
          'add' => '4.7',
        ],
        'refresh_token' => [
          'name' => 'refresh_token',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => E::ts('Refresh Token'),
          'description' => E::ts('Token to present when refreshing the access_token'),
          'where' => 'civicrm_oauth_systoken.refresh_token',
          'permission' => [
            [
              'manage OAuth client secrets',
            ],
          ],
          'table_name' => 'civicrm_oauth_systoken',
          'entity' => 'OAuthSysToken',
          'bao' => 'CRM_OAuth_DAO_OAuthSysToken',
          'localizable' => 0,
          'add' => '5.32',
        ],
        'resource_owner_name' => [
          'name' => 'resource_owner_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => E::ts('Resource Owner Name'),
          'description' => E::ts('Identifier for the resource owner. Structure varies by service.'),
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'where' => 'civicrm_oauth_systoken.resource_owner_name',
          'table_name' => 'civicrm_oauth_systoken',
          'entity' => 'OAuthSysToken',
          'bao' => 'CRM_OAuth_DAO_OAuthSysToken',
          'localizable' => 0,
          'add' => '5.32',
        ],
        'resource_owner' => [
          'name' => 'resource_owner',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => E::ts('Resource Owner'),
          'description' => E::ts('Cached details describing the resource owner'),
          'where' => 'civicrm_oauth_systoken.resource_owner',
          'table_name' => 'civicrm_oauth_systoken',
          'entity' => 'OAuthSysToken',
          'bao' => 'CRM_OAuth_DAO_OAuthSysToken',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_JSON,
          'add' => '5.32',
        ],
        'error' => [
          'name' => 'error',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => E::ts('Error'),
          'description' => E::ts('List of scopes addressed by this token'),
          'where' => 'civicrm_oauth_systoken.error',
          'table_name' => 'civicrm_oauth_systoken',
          'entity' => 'OAuthSysToken',
          'bao' => 'CRM_OAuth_DAO_OAuthSysToken',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_JSON,
          'add' => '5.32',
        ],
        'raw' => [
          'name' => 'raw',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => E::ts('Raw token'),
          'description' => E::ts('The token response data, per AccessToken::jsonSerialize'),
          'where' => 'civicrm_oauth_systoken.raw',
          'table_name' => 'civicrm_oauth_systoken',
          'entity' => 'OAuthSysToken',
          'bao' => 'CRM_OAuth_DAO_OAuthSysToken',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_JSON,
          'add' => '5.32',
        ],
        'created_date' => [
          'name' => 'created_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => E::ts('Created Date'),
          'description' => E::ts('When the token was created.'),
          'required' => FALSE,
          'where' => 'civicrm_oauth_systoken.created_date',
          'default' => 'CURRENT_TIMESTAMP',
          'table_name' => 'civicrm_oauth_systoken',
          'entity' => 'OAuthSysToken',
          'bao' => 'CRM_OAuth_DAO_OAuthSysToken',
          'localizable' => 0,
          'add' => '5.32',
        ],
        'modified_date' => [
          'name' => 'modified_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => E::ts('Modified Date'),
          'description' => E::ts('When the token was created or modified.'),
          'required' => FALSE,
          'where' => 'civicrm_oauth_systoken.modified_date',
          'default' => 'CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP',
          'table_name' => 'civicrm_oauth_systoken',
          'entity' => 'OAuthSysToken',
          'bao' => 'CRM_OAuth_DAO_OAuthSysToken',
          'localizable' => 0,
          'add' => '5.32',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  public static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }

  /**
   * Returns the names of this table
   *
   * @return string
   */
  public static function getTableName() {
    return self::$_tableName;
  }

  /**
   * Returns if this table needs to be logged
   *
   * @return bool
   */
  public function getLog() {
    return self::$_log;
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'oauth_systoken', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'oauth_systoken', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'UI_tag' => [
        'name' => 'UI_tag',
        'field' => [
          0 => 'tag',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_oauth_systoken::0::tag',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
