#------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2020-02-17 02:02:17 +0200 (Mon, 17 Feb 2020) $ 
#$Revision: 7735 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.0.1/src/lib/perl5/COD/CIF/Tags/DictTags.pm $
#------------------------------------------------------------------------
#* 
#  A list of CIF dictionary tags.
#
#  Contains at least all tags from Core CIF dictionary Version 2.4.5
#**

package COD::CIF::Tags::DictTags;

use strict;
use warnings;

require Exporter;
our @ISA = qw( Exporter );
our @EXPORT_OK = qw(
    @tag_list
);

# The variable is defined here for visibility,
# but is assigned a proper elsewhere
# FIXME: using global package variables is not a good practice
# and should be avoided/refactored in the future
our @tag_list;

my @unclassified_tags_part_1 = qw (
_publ_[]
_publ_author_[]
_publ_author_address
_publ_author.address
_publ_author_email
_publ_author.email
_publ_author_footnote
_publ_author.footnote
_publ_author_id_iucr
_publ_author.id_iucr
_publ_author_id_orcid
_publ_author_name
_publ_author.name
_publ_body_[]
_publ_body_contents
_publ_body.contents
_publ_body_element
_publ_body.element
_publ_body_format
_publ_body.format
_publ_body_label
_publ_body.label
_publ_body_title
_publ_body.title
_publ_contact_author
_publ.contact_author
_publ_contact_author_address
_publ.contact_author_address
_publ_contact_author_email
_publ.contact_author_email
_publ_contact_author_fax
_publ.contact_author_fax
_publ_contact_author_id_iucr
_publ_contact_author_id_orcid
_publ_contact_author_name
_publ.contact_author_name
_publ_contact_author_phone
_publ.contact_author_phone
_publ_contact_letter
_publ.contact_letter
_publ.entry_id
_publ_manuscript_creation
_publ.manuscript_creation
_publ_manuscript_incl_[]
_publ_manuscript_incl.entry_id
_publ_manuscript_incl_extra_defn
_publ_manuscript_incl.extra_defn
_publ_manuscript_incl_extra_info
_publ_manuscript_incl.extra_info
_publ_manuscript_incl_extra_item
_publ_manuscript_incl.extra_item
_publ_manuscript_processed
_publ.manuscript_processed
_publ_manuscript_text
_publ.manuscript_text
_publ_requested_category
_publ.requested_category
_publ_requested_coeditor_name
_publ.requested_coeditor_name
_publ_requested_journal
_publ.requested_journal
_publ_section_abstract
_publ.section_abstract
_publ_section_acknowledgements
_publ.section_acknowledgements
_publ_section_comment
_publ.section_comment
_publ_section_discussion
_publ.section_discussion
_publ_section_experimental
_publ.section_experimental
_publ_section_exptl_prep
_publ.section_exptl_prep
_publ_section_exptl_refinement
_publ.section_exptl_refinement
_publ_section_exptl_solution
_publ.section_exptl_solution
_publ_section_figure_captions
_publ.section_figure_captions
_publ_section_introduction
_publ.section_introduction
_publ_section_references
_publ.section_references
_publ_section_related_literature
_publ_section_synopsis
_publ.section_synopsis
_publ_section_table_legends
_publ.section_table_legends
_publ_section_title
_publ.section_title
_publ_section_title_footnote
_publ.section_title_footnote
_publ_vrn_code
_publ_section_keywords

_journal_[]
_journal_coden_ASTM
_journal.coden_ASTM
_journal_coden_Cambridge
_journal.coden_Cambridge
_journal_coeditor_address
_journal.coeditor_address
_journal_coeditor_code
_journal.coeditor_code
_journal_coeditor_email
_journal.coeditor_email
_journal_coeditor_fax
_journal.coeditor_fax
_journal_coeditor_name
_journal.coeditor_name
_journal_coeditor_notes
_journal.coeditor_notes
_journal_coeditor_phone
_journal.coeditor_phone
_journal_data_validation_number
_journal.data_validation_number
_journal_date_accepted
_journal.date_accepted
_journal_date_from_coeditor
_journal.date_from_coeditor
_journal_date_printers_final
_journal.date_printers_final
_journal_date_printers_first
_journal.date_printers_first
_journal_date_proofs_in
_journal.date_proofs_in
_journal_date_proofs_out
_journal.date_proofs_out
_journal_date_recd_copyright
_journal.date_recd_copyright
_journal_date_recd_electronic
_journal.date_recd_electronic
_journal_date_recd_hard_copy
_journal.date_recd_hard_copy
_journal_date_to_coeditor
_journal.date_to_coeditor
_journal.entry_id
_journal_index_[]
_journal_index_subterm
_journal_index.subterm
_journal_index_term
_journal_index.term
_journal_index_type
_journal_index.type
_journal_issue
_journal.issue
_journal_language
_journal.language
_journal_name_full
_journal.name_full
_journal_page_first
_journal.page_first
_journal_page_last
_journal.page_last
_journal_paper_category
_journal.paper_category
_journal_paper_doi
_journal_suppl_publ_number
_journal.suppl_publ_number
_journal_suppl_publ_pages
_journal.suppl_publ_pages
_journal_techeditor_address
_journal.techeditor_address
_journal_techeditor_code
_journal.techeditor_code
_journal_techeditor_email
_journal.techeditor_email
_journal_techeditor_fax
_journal.techeditor_fax
_journal_techeditor_name
_journal.techeditor_name
_journal_techeditor_notes
_journal.techeditor_notes
_journal_techeditor_phone
_journal.techeditor_phone
_journal_volume
_journal.volume
_journal_year
_journal.year

_chemical_[]
_chemical_absolute_configuration
_chemical.absolute_configuration
_chemical_compound_source
_chemical.compound_source
_chemical_enantioexcess_bulk
_chemical_enantioexcess_bulk_technique
_chemical_enantioexcess_crystal
_chemical_enantioexcess_crystal_technique
_chemical_conn_atom_[]
_chemical_conn_atom_charge
_chemical_conn_atom.charge
_chemical_conn_atom_display_x
_chemical_conn_atom.display_x
_chemical_conn_atom_display_y
_chemical_conn_atom.display_y
_chemical_conn_atom_NCA
_chemical_conn_atom.NCA
_chemical_conn_atom_NH
_chemical_conn_atom.NH
_chemical_conn_atom_number
_chemical_conn_atom.number
_chemical_conn_atom_type_symbol
_chemical_conn_atom.type_symbol
_chemical_conn_bond_[]
_chemical_conn_bond_atom_1
_chemical_conn_bond.atom_1
_chemical_conn_bond_atom_2
_chemical_conn_bond.atom_2
_chemical_conn_bond_type
_chemical_conn_bond.type
_chemical.entry_id
_chemical_formula_[]
_chemical_formula_analytical
_chemical_formula.analytical
_chemical_formula.entry_id
_chemical_formula_iupac
_chemical_formula.iupac
_chemical_formula_moiety
_chemical_formula.moiety
_chemical_formula_structural
_chemical_formula.structural
_chemical_formula_sum
_chemical_formula.sum
_chemical_formula_weight
_chemical_formula.weight
_chemical_formula_weight_meas
_chemical_formula.weight_meas
_chemical_melting_point
_chemical.melting_point
_chemical_melting_point_C
_chemical_melting_point_gt
_chemical.melting_point_gt
_chemical_melting_point_lt
_chemical.melting_point_lt
_chemical_name_common
_chemical.name_common
_chemical_name_mineral
_chemical.name_mineral
_chemical_name_structure_type
_chemical.name_structure_type
_chemical_name_systematic
_chemical.name_systematic
_chemical_optical_rotation
_chemical.optical_rotation
_chemical_properties_biological
_chemical.properties_biological
_chemical_properties_physical
_chemical.properties_physical
_chemical_temperature_decomposition
_chemical.temperature_decomposition
_chemical.temperature_decomposition_esd
_chemical_temperature_decomposition_gt
_chemical.temperature_decomposition_gt
_chemical_temperature_decomposition_lt
_chemical.temperature_decomposition_lt
_chemical_temperature_sublimation
_chemical.temperature_sublimation
_chemical.temperature_sublimation_esd
_chemical_temperature_sublimation_gt
_chemical.temperature_sublimation_gt
_chemical_temperature_sublimation_lt
_chemical.temperature_sublimation_lt

_space_group_[]
_space_group.Bravais_type
_space_group.centring_type
_space_group_crystal_system
_space_group.crystal_system
_space_group_id
_space_group.id
_space_group.IT_coordinate_system_code
_space_group_IT_number
_space_group.IT_number
_space_group.Laue_class
_space_group_[ms]
_space_group_name_Hall
_space_group.name_Hall
_space_group_name_H-M_alt
_space_group.name_H-M_alt
_space_group.name_H-M_alt_description
_space_group.name_H-M_full
_space_group.name_H-M_ref
_space_group.name_Schoenflies
_space_group.Patterson_name_H-M
_space_group.point_group_H-M
_space_group.reference_setting
_space_group_ssg_IT_number
_space_group_ssg_name
_space_group_ssg_name_IT
_space_group_ssg_name_WJJ
_space_group_ssg_WJJ_code
_space_group_symop_[]
_space_group_symop.generator_xyz
_space_group_symop_id
_space_group_symop.id
_space_group_symop_[ms]
_space_group_symop.operation_description
_space_group_symop_operation_xyz
_space_group_symop.operation_xyz
_space_group_symop_sg_id
_space_group_symop.sg_id
_space_group_symop_ssg_id
_space_group_symop_ssg_operation_algebraic
_space_group.transform_Pp_abc
_space_group.transform_Qq_xyz
_space_group_Wyckoff.coords_xyz
_space_group_Wyckoff.id
_space_group_Wyckoff.letter
_space_group_Wyckoff.multiplicity
_space_group_Wyckoff.sg_id
_space_group_Wyckoff.site_symmetry

_symmetry_[]
_symmetry_cell_setting
_symmetry.cell_setting
_symmetry.entry_id
_symmetry_equiv_[]
_symmetry_equiv.id
_symmetry_equiv_pos_as_xyz
_symmetry_equiv.pos_as_xyz
_symmetry_equiv_pos_site_id
_symmetry_Int_Tables_number
_symmetry.Int_Tables_number
_symmetry_space_group_name_Hall
_symmetry.space_group_name_Hall
_symmetry_space_group_name_H-M
_symmetry.space_group_name_H-M

_array_data.array_id
_array_data.binary_id
_array_data.data
_array_element_size.array_id
_array_element_size.index
_array_element_size.size
_array_intensities.array_id
_array_intensities.binary_id
_array_intensities.gain
_array_intensities.gain_esd
_array_intensities.linearity
_array_intensities.offset
_array_intensities.overload
_array_intensities.scaling
_array_intensities.undefined_value
_array_structure.byte_order
_array_structure.compression_type
_array_structure.encoding_type
_array_structure.id
_array_structure_list.array_id
_array_structure_list_axis.angle
_array_structure_list_axis.angle_increment
_array_structure_list_axis.angular_pitch
_array_structure_list_axis.axis_id
_array_structure_list_axis.axis_set_id
_array_structure_list_axis.displacement
_array_structure_list_axis.displacement_increment
_array_structure_list_axis.radial_pitch
_array_structure_list.axis_set_id
_array_structure_list.dimension
_array_structure_list.direction
_array_structure_list.index
_array_structure_list.precedence
_atom_local_axes_atom0
_atom_local_axes_atom1
_atom_local_axes_atom2
_atom_local_axes_atom_label
_atom_local_axes_ax1
_atom_local_axes_ax2
_atom_local_axes_[rho]
_atom_rho_multipole_atom_label
_atom_rho_multipole_coeff_P00
_atom_rho_multipole_coeff_P10
_atom_rho_multipole_coeff_P11
_atom_rho_multipole_coeff_P1-1
_atom_rho_multipole_coeff_P20
_atom_rho_multipole_coeff_P21
_atom_rho_multipole_coeff_P2-1
_atom_rho_multipole_coeff_P22
_atom_rho_multipole_coeff_P2-2
_atom_rho_multipole_coeff_P30
_atom_rho_multipole_coeff_P31
_atom_rho_multipole_coeff_P3-1
_atom_rho_multipole_coeff_P32
_atom_rho_multipole_coeff_P3-2
_atom_rho_multipole_coeff_P33
_atom_rho_multipole_coeff_P3-3
_atom_rho_multipole_coeff_P40
_atom_rho_multipole_coeff_P41
_atom_rho_multipole_coeff_P4-1
_atom_rho_multipole_coeff_P42
_atom_rho_multipole_coeff_P4-2
_atom_rho_multipole_coeff_P43
_atom_rho_multipole_coeff_P4-3
_atom_rho_multipole_coeff_P44
_atom_rho_multipole_coeff_P4-4
_atom_rho_multipole_coeff_Pc
_atom_rho_multipole_coeff_Pv
_atom_rho_multipole_configuration
_atom_rho_multipole_core_source
_atom_rho_multipole_kappa
_atom_rho_multipole_kappa_prime0
_atom_rho_multipole_kappa_prime1
_atom_rho_multipole_kappa_prime2
_atom_rho_multipole_kappa_prime3
_atom_rho_multipole_kappa_prime4
_atom_rho_multipole_radial_function_type
_atom_rho_multipole_radial_slater_n0
_atom_rho_multipole_radial_slater_n1
_atom_rho_multipole_radial_slater_n2
_atom_rho_multipole_radial_slater_n3
_atom_rho_multipole_radial_slater_n4
_atom_rho_multipole_radial_slater_zeta0
_atom_rho_multipole_radial_slater_zeta1
_atom_rho_multipole_radial_slater_zeta2
_atom_rho_multipole_radial_slater_zeta3
_atom_rho_multipole_radial_slater_zeta4
_atom_rho_multipole_[rho]
_atom_rho_multipole_scat_core
_atom_rho_multipole_scat_valence
_atom_rho_multipole_valence_source
_atom_site_[]
_atom_site_adp_type
_atom_site.adp_type
_atom_site_aniso_B_11
_atom_site.aniso_B[1][1]
_atom_site.aniso_B[1][1]_esd
_atom_site_aniso_B_11_nm
_atom_site_aniso_B_11_pm
_atom_site_aniso_B_12
_atom_site.aniso_B[1][2]
_atom_site.aniso_B[1][2]_esd
_atom_site_aniso_B_12_nm
_atom_site_aniso_B_12_pm
_atom_site_aniso_B_13
_atom_site.aniso_B[1][3]
_atom_site.aniso_B[1][3]_esd
_atom_site_aniso_B_13_nm
_atom_site_aniso_B_13_pm
_atom_site_aniso_B_22
_atom_site.aniso_B[2][2]
_atom_site.aniso_B[2][2]_esd
_atom_site_aniso_B_22_nm
_atom_site_aniso_B_22_pm
_atom_site_aniso_B_23
_atom_site.aniso_B[2][3]
_atom_site.aniso_B[2][3]_esd
_atom_site_aniso_B_23_nm
_atom_site_aniso_B_23_pm
_atom_site_aniso_B_33
_atom_site.aniso_B[3][3]
_atom_site.aniso_B[3][3]_esd
_atom_site_aniso_B_33_nm
_atom_site_aniso_B_33_pm
_atom_site_aniso_label
_atom_site_aniso_ratio
_atom_site.aniso_ratio
_atom_site_anisotrop.B[1][1]
_atom_site_anisotrop.B[1][1]_esd
_atom_site_anisotrop.B[1][2]
_atom_site_anisotrop.B[1][2]_esd
_atom_site_anisotrop.B[1][3]
_atom_site_anisotrop.B[1][3]_esd
_atom_site_anisotrop.B[2][2]
_atom_site_anisotrop.B[2][2]_esd
_atom_site_anisotrop.B[2][3]
_atom_site_anisotrop.B[2][3]_esd
_atom_site_anisotrop.B[3][3]
_atom_site_anisotrop.B[3][3]_esd
_atom_site_anisotrop.id
_atom_site_anisotrop.ratio
_atom_site_anisotrop.type_symbol
_atom_site_anisotrop.U[1][1]
_atom_site_anisotrop.U[1][1]_esd
_atom_site_anisotrop.U[1][2]
_atom_site_anisotrop.U[1][2]_esd
_atom_site_anisotrop.U[1][3]
_atom_site_anisotrop.U[1][3]_esd
_atom_site_anisotrop.U[2][2]
_atom_site_anisotrop.U[2][2]_esd
_atom_site_anisotrop.U[2][3]
_atom_site_anisotrop.U[2][3]_esd
_atom_site_anisotrop.U[3][3]
_atom_site_anisotrop.U[3][3]_esd
_atom_site_aniso_type_symbol
_atom_site_aniso_U_11
_atom_site.aniso_U[1][1]
_atom_site.aniso_U[1][1]_esd
_atom_site_aniso_U_11_nm
_atom_site_aniso_U_11_pm
_atom_site_aniso_U_12
_atom_site.aniso_U[1][2]
_atom_site.aniso_U[1][2]_esd
_atom_site_aniso_U_12_nm
_atom_site_aniso_U_12_pm
_atom_site_aniso_U_13
_atom_site.aniso_U[1][3]
_atom_site.aniso_U[1][3]_esd
_atom_site_aniso_U_13_nm
_atom_site_aniso_U_13_pm
_atom_site_aniso_U_22
_atom_site.aniso_U[2][2]
_atom_site.aniso_U[2][2]_esd
_atom_site_aniso_U_22_nm
_atom_site_aniso_U_22_pm
_atom_site_aniso_U_23
_atom_site.aniso_U[2][3]
_atom_site.aniso_U[2][3]_esd
_atom_site_aniso_U_23_nm
_atom_site_aniso_U_23_pm
_atom_site_aniso_U_33
_atom_site.aniso_U[3][3]
_atom_site.aniso_U[3][3]_esd
_atom_site_aniso_U_33_nm
_atom_site_aniso_U_33_pm
_atom_site_attached_hydrogens
_atom_site.attached_hydrogens
_atom_site.auth_asym_id
_atom_site.auth_atom_id
_atom_site.auth_comp_id
_atom_site.auth_seq_id
_atom_site_B_equiv_geom_mean
_atom_site.B_equiv_geom_mean
_atom_site.B_equiv_geom_mean_esd
_atom_site_B_iso_or_equiv
_atom_site.B_iso_or_equiv
_atom_site.B_iso_or_equiv_esd
_atom_site_B_iso_or_equiv_nm
_atom_site_B_iso_or_equiv_pm
_atom_site_calc_attached_atom
_atom_site.calc_attached_atom
_atom_site_calc_flag
_atom_site.calc_flag
_atom_site_Cartn_x
_atom_site.Cartn_x
_atom_site.Cartn_x_esd
_atom_site_Cartn_x_nm
_atom_site_Cartn_x_pm
_atom_site_Cartn_y
_atom_site.Cartn_y
_atom_site.Cartn_y_esd
_atom_site_Cartn_y_nm
_atom_site_Cartn_y_pm
_atom_site_Cartn_z
_atom_site.Cartn_z
_atom_site.Cartn_z_esd
_atom_site_Cartn_z_nm
_atom_site_Cartn_z_pm
_atom_site_chemical_conn_number
_atom_site.chemical_conn_number
_atom_site_constraints
_atom_site.constraints
_atom_site_description
_atom_site.details
_atom_site_disorder_assembly
_atom_site.disorder_assembly
_atom_site_disorder_group
_atom_site.disorder_group
_atom_site_displace_Fourier_[]
_atom_site_displace_Fourier_atom_site_label
_atom_site_displace_Fourier_axis
_atom_site_displace_Fourier_id
_atom_site_displace_Fourier_param_[]
_atom_site_displace_Fourier_param_cos
_atom_site_displace_Fourier_param_id
_atom_site_displace_Fourier_param_modulus
_atom_site_displace_Fourier_param_phase
_atom_site_displace_Fourier_param_sin
_atom_site_displace_Fourier_wave_vector_seq_id
_atom_site_displace_modulation_flag
_atom_site_displace_special_func_[]
_atom_site_displace_special_func_atom_site_label
_atom_site_displace_special_func_sawtooth_ax
_atom_site_displace_special_func_sawtooth_ay
_atom_site_displace_special_func_sawtooth_az
_atom_site_displace_special_func_sawtooth_c
_atom_site_displace_special_func_sawtooth_w
_atom_site.footnote_id
_atom_site_Fourier_wave_vector_[]
_atom_site_Fourier_wave_vector_description
_atom_site_Fourier_wave_vector_seq_id
_atom_site_Fourier_wave_vector_x
_atom_site_Fourier_wave_vector_y
_atom_site_Fourier_wave_vector_z
_atom_site_fract_x
_atom_site.fract_x
_atom_site.fract_x_esd
_atom_site_fract_y
_atom_site.fract_y
_atom_site.fract_y_esd
_atom_site_fract_z
_atom_site.fract_z
_atom_site.fract_z_esd
_atom_site.group_PDB
_atom_site.id
_atom_site_label
_atom_site.label_alt_id
_atom_site.label_asym_id
_atom_site.label_atom_id
_atom_site.label_comp_id
_atom_site_label_component_0
_atom_site_label_component_1
_atom_site_label_component_2
_atom_site_label_component_3
_atom_site_label_component_4
_atom_site_label_component_5
_atom_site_label_component_6
_atom_site.label_entity_id
_atom_site.label_seq_id
_atom_site_[ms]
_atom_site_occ_Fourier_[]
_atom_site_occ_Fourier_atom_site_label
_atom_site_occ_Fourier_id
_atom_site_occ_Fourier_wave_vector_seq_id
_atom_site_occ_Fourier_param_[]
_atom_site_occ_Fourier_param_cos
_atom_site_occ_Fourier_param_id
_atom_site_occ_Fourier_param_modulus
_atom_site_occ_Fourier_param_phase
_atom_site_occ_Fourier_param_sin
_atom_site_occ_modulation_flag
_atom_site_occ_special_func_[]
_atom_site_occ_special_func_atom_site_label
_atom_site_occ_special_func_crenel_c
_atom_site_occ_special_func_crenel_w
_atom_site_occupancy
_atom_site.occupancy
_atom_site.occupancy_esd
_atom_site_phason_[]
_atom_site_phason_atom_site_label
_atom_site_phason_coeff
_atom_site_phason_formula
_atom_site_refinement_flags
_atom_site.refinement_flags
_atom_site_refinement_flags_adp
_atom_site.refinement_flags_adp
_atom_site_refinement_flags_occupancy
_atom_site.refinement_flags_occupancy
_atom_site_refinement_flags_posn
_atom_site.refinement_flags_posn
_atom_site_restraints
_atom_site.restraints
_atom_site_site_symmetry_multiplicity
_atom_site_site_symmetry_order
_atom_site_[rho]
_atom_site_rot_Fourier_[]
_atom_site_rot_Fourier_atom_site_label
_atom_site_rot_Fourier_axis
_atom_site_rot_Fourier_id
_atom_site_rot_Fourier_param_[]
_atom_site_rot_Fourier_param_cos
_atom_site_rot_Fourier_param_id
_atom_site_rot_Fourier_param_modulus
_atom_site_rot_Fourier_param_phase
_atom_site_rot_Fourier_param_sin
_atom_site_rot_Fourier_wave_vector_seq_id
_atom_sites_[]
_atom_sites_alt.details
_atom_sites_alt_ens.details
_atom_sites_alt_ens.id
_atom_sites_alt_gen.alt_id
_atom_sites_alt_gen.ens_id
_atom_sites_alt.id
_atom_sites_Cartn_tran_matrix_11
_atom_sites_Cartn_tran_matrix_12
_atom_sites_Cartn_tran_matrix_13
_atom_sites_Cartn_tran_matrix_21
_atom_sites_Cartn_tran_matrix_22
_atom_sites_Cartn_tran_matrix_23
_atom_sites_Cartn_tran_matrix_31
_atom_sites_Cartn_tran_matrix_32
_atom_sites_Cartn_tran_matrix_33
_atom_sites.Cartn_transf_matrix[1][1]
_atom_sites.Cartn_transf_matrix[1][2]
_atom_sites.Cartn_transf_matrix[1][3]
_atom_sites.Cartn_transf_matrix[2][1]
_atom_sites.Cartn_transf_matrix[2][2]
_atom_sites.Cartn_transf_matrix[2][3]
_atom_sites.Cartn_transf_matrix[3][1]
_atom_sites.Cartn_transf_matrix[3][2]
_atom_sites.Cartn_transf_matrix[3][3]
_atom_sites_Cartn_transform_axes
_atom_sites.Cartn_transform_axes
_atom_sites.Cartn_transf_vector[1]
_atom_sites.Cartn_transf_vector[2]
_atom_sites.Cartn_transf_vector[3]
_atom_sites_Cartn_tran_vector_1
_atom_sites_Cartn_tran_vector_2
_atom_sites_Cartn_tran_vector_3
_atom_sites_displace_Fourier_[]
_atom_sites_displace_Fourier_axes_description
_atom_sites.entry_id
_atom_sites_footnote.id
_atom_sites_footnote.text
_atom_sites_fract_tran_matrix_11
_atom_sites_fract_tran_matrix_12
_atom_sites_fract_tran_matrix_13
_atom_sites_fract_tran_matrix_21
_atom_sites_fract_tran_matrix_22
_atom_sites_fract_tran_matrix_23
_atom_sites_fract_tran_matrix_31
_atom_sites_fract_tran_matrix_32
_atom_sites_fract_tran_matrix_33
_atom_sites.fract_transf_matrix[1][1]
_atom_sites.fract_transf_matrix[1][2]
_atom_sites.fract_transf_matrix[1][3]
_atom_sites.fract_transf_matrix[2][1]
_atom_sites.fract_transf_matrix[2][2]
_atom_sites.fract_transf_matrix[2][3]
_atom_sites.fract_transf_matrix[3][1]
_atom_sites.fract_transf_matrix[3][2]
_atom_sites.fract_transf_matrix[3][3]
_atom_sites.fract_transf_vector[1]
_atom_sites.fract_transf_vector[2]
_atom_sites.fract_transf_vector[3]
_atom_sites_fract_tran_vector_1
_atom_sites_fract_tran_vector_2
_atom_sites_fract_tran_vector_3
_atom_sites_modulation_[]
_atom_sites_modulation_global_phase_t_1
_atom_sites_modulation_global_phase_t_2
_atom_sites_modulation_global_phase_t_3
_atom_sites_modulation_global_phase_t_4
_atom_sites_modulation_global_phase_t_5
_atom_sites_modulation_global_phase_t_6
_atom_sites_modulation_global_phase_t_7
_atom_sites_modulation_global_phase_t_8
_atom_sites_rot_Fourier_[]
_atom_sites_rot_Fourier_axes_description
_atom_sites_solution_hydrogens
_atom_sites.solution_hydrogens
_atom_sites_solution_primary
_atom_sites.solution_primary
_atom_sites_solution_secondary
_atom_sites.solution_secondary
_atom_sites_special_details
_atom_sites.special_details
_atom_site_subsystem_code
_atom_site_symmetry_multiplicity
_atom_site.symmetry_multiplicity
_atom_site_thermal_displace_type
_atom_site.thermal_displace_type
_atom_site_type_symbol
_atom_site.type_symbol
_atom_site_U_equiv_geom_mean
_atom_site.U_equiv_geom_mean
_atom_site.U_equiv_geom_mean_esd
_atom_site_U_Fourier_[]
_atom_site_U_Fourier_atom_site_label
_atom_site_U_Fourier_id
_atom_site_U_Fourier_tens_elem
_atom_site_U_Fourier_wave_vector_seq_id
_atom_site_U_Fourier_param_[]
_atom_site_U_Fourier_param_cos
_atom_site_U_Fourier_param_id
_atom_site_U_Fourier_param_modulus
_atom_site_U_Fourier_param_phase
_atom_site_U_Fourier_param_sin
_atom_site_U_iso_or_equiv
_atom_site.U_iso_or_equiv
_atom_site.U_iso_or_equiv_esd
_atom_site_U_iso_or_equiv_nm
_atom_site_U_iso_or_equiv_pm
_atom_site_U_modulation_flag
_atom_site_Wyckoff_symbol
_atom_site.Wyckoff_symbol
_atom_type_[]
_atom_type_analytical_mass_%
_atom_type.analytical_mass_percent
_atom_type_description
_atom_type.description
_atom_type_number_in_cell
_atom_type.number_in_cell
_atom_type_oxidation_number
_atom_type.oxidation_number
_atom_type_radius_bond
_atom_type.radius_bond
_atom_type_radius_bond_nm
_atom_type_radius_bond_pm
_atom_type_radius_contact
_atom_type.radius_contact
_atom_type_radius_contact_nm
_atom_type_radius_contact_pm
_atom_type_scat_Cromer_Mann_a1
_atom_type.scat_Cromer_Mann_a1
_atom_type_scat_Cromer_Mann_a2
_atom_type.scat_Cromer_Mann_a2
_atom_type_scat_Cromer_Mann_a3
_atom_type.scat_Cromer_Mann_a3
_atom_type_scat_Cromer_Mann_a4
_atom_type.scat_Cromer_Mann_a4
_atom_type_scat_Cromer_Mann_b1
_atom_type.scat_Cromer_Mann_b1
_atom_type_scat_Cromer_Mann_b2
_atom_type.scat_Cromer_Mann_b2
_atom_type_scat_Cromer_Mann_b3
_atom_type.scat_Cromer_Mann_b3
_atom_type_scat_Cromer_Mann_b4
_atom_type.scat_Cromer_Mann_b4
_atom_type_scat_Cromer_Mann_c
_atom_type.scat_Cromer_Mann_c
_atom_type_scat_dispersion_imag
_atom_type.scat_dispersion_imag
_atom_type_scat_dispersion_real
_atom_type.scat_dispersion_real
_atom_type_scat_dispersion_source
_atom_type.scat_dispersion_source
_atom_type_scat_length_neutron
_atom_type.scat_length_neutron
_atom_type_scat_source
_atom_type.scat_source
_atom_type_scat_versus_stol_list
_atom_type.scat_versus_stol_list
_atom_type_symbol
_atom_type.symbol
_audit_[]
_audit_author_[]
_audit_author_address
_audit_author.address
_audit_author_name
_audit_author.name
_audit_block_code
_audit_block_doi
_audit_conform_[]
_audit_conform_dict_location
_audit_conform.dict_location
_audit_conform_dict_name
_audit_conform.dict_name
_audit_conform_dict_version
_audit_conform.dict_version
_audit_contact_author_[]
_audit_contact_author_address
_audit_contact_author.address
_audit_contact_author_email
_audit_contact_author.email
_audit_contact_author_fax
_audit_contact_author.fax
_audit_contact_author_name
_audit_contact_author.name
_audit_contact_author_phone
_audit_contact_author.phone
_audit_creation_date
_audit.creation_date
_audit_creation_method
_audit.creation_method
_audit_link_[]
_audit_link_block_code
_audit_link.block_code
_audit_link_block_description
_audit_link.block_description
_audit_link_[ms]
_audit.revision_id
_audit_update_record
_audit.update_record
_axis.depends_on
_axis.equipment
_axis.id
_axis.offset[1]
_axis.offset[2]
_axis.offset[3]
_axis.type
_axis.vector[1]
_axis.vector[2]
_axis.vector[3]
_category
_category.description
_category_examples.case
_category_examples.detail
_category_examples.id
_category_group.category_id
_category_group.id
_category_group_list.description
_category_group_list.id
_category_group_list.parent_id
_category.id
_category.implicit_key
_category_key.id
_category_key.name
_category.mandatory_code
_category_methods.category_id
_category_methods.method_id
_cell_[]
_cell_angle_alpha
_cell.angle_alpha
_cell.angle_alpha_esd
_cell_angle_beta
_cell.angle_beta
_cell.angle_beta_esd
_cell_angle_gamma
_cell.angle_gamma
_cell.angle_gamma_esd
_cell.details
_cell.entry_id
_cell_formula_units_Z
_cell.formula_units_Z
_cell_length_a
_cell.length_a
_cell.length_a_esd
_cell_length_a_nm
_cell_length_a_pm
_cell_length_b
_cell.length_b
_cell.length_b_esd
_cell_length_b_nm
_cell_length_b_pm
_cell_length_c
_cell.length_c
_cell.length_c_esd
_cell_length_c_nm
_cell_length_c_pm
_cell_measurement.entry_id
_cell_measurement_pressure
_cell_measurement.pressure
_cell_measurement.pressure_esd
_cell_measurement_pressure_gPa
_cell_measurement_radiation
_cell_measurement.radiation
_cell_measurement_refln_[]
_cell_measurement_refln_index_h
_cell_measurement_refln.index_h
_cell_measurement_refln_index_k
_cell_measurement_refln.index_k
_cell_measurement_refln_index_l
_cell_measurement_refln.index_l
_cell_measurement_reflns_used
_cell_measurement.reflns_used
_cell_measurement_refln_theta
_cell_measurement_refln.theta
_cell_measurement.temp
_cell_measurement_temperature
_cell_measurement_temperature_C
_cell_measurement.temp_esd
_cell_measurement_theta_max
_cell_measurement.theta_max
_cell_measurement_theta_min
_cell_measurement.theta_min
_cell_measurement_wavelength
_cell_measurement.wavelength
_cell_measurement_wavelength_nm
_cell_measurement_wavelength_pm

_cell_[ms]
_cell_modulation_dimension
_cell_reciprocal_basis_description

_cell_reciprocal_angle_alpha
_cell.reciprocal_angle_alpha
_cell.reciprocal_angle_alpha_esd
_cell_reciprocal_angle_beta
_cell.reciprocal_angle_beta
_cell.reciprocal_angle_beta_esd
_cell_reciprocal_angle_gamma
_cell.reciprocal_angle_gamma
_cell.reciprocal_angle_gamma_esd
_cell_reciprocal_length_a
_cell.reciprocal_length_a
_cell.reciprocal_length_a_esd
_cell_reciprocal_length_b
_cell.reciprocal_length_b
_cell.reciprocal_length_b_esd
_cell_reciprocal_length_c
_cell.reciprocal_length_c
_cell.reciprocal_length_c_esd
_cell_special_details

_cell_subsystem_[ms]
_cell_subsystem_code
_cell_subsystem_description
_cell_subsystem_matrix_W_1_1
_cell_subsystem_matrix_W_1_2
_cell_subsystem_matrix_W_1_3
_cell_subsystem_matrix_W_1_4
_cell_subsystem_matrix_W_1_5
_cell_subsystem_matrix_W_1_6
_cell_subsystem_matrix_W_1_7
_cell_subsystem_matrix_W_1_8
_cell_subsystem_matrix_W_1_9
_cell_subsystem_matrix_W_1_10
_cell_subsystem_matrix_W_1_11
_cell_subsystem_matrix_W_2_1
_cell_subsystem_matrix_W_2_2
_cell_subsystem_matrix_W_2_3
_cell_subsystem_matrix_W_2_4
_cell_subsystem_matrix_W_2_5
_cell_subsystem_matrix_W_2_6
_cell_subsystem_matrix_W_2_7
_cell_subsystem_matrix_W_2_8
_cell_subsystem_matrix_W_2_9
_cell_subsystem_matrix_W_2_10
_cell_subsystem_matrix_W_2_11
_cell_subsystem_matrix_W_3_1
_cell_subsystem_matrix_W_3_2
_cell_subsystem_matrix_W_3_3
_cell_subsystem_matrix_W_3_4
_cell_subsystem_matrix_W_3_5
_cell_subsystem_matrix_W_3_6
_cell_subsystem_matrix_W_3_7
_cell_subsystem_matrix_W_3_8
_cell_subsystem_matrix_W_3_9
_cell_subsystem_matrix_W_3_10
_cell_subsystem_matrix_W_3_11
_cell_subsystem_matrix_W_4_1
_cell_subsystem_matrix_W_4_2
_cell_subsystem_matrix_W_4_3
_cell_subsystem_matrix_W_4_4
_cell_subsystem_matrix_W_4_5
_cell_subsystem_matrix_W_4_6
_cell_subsystem_matrix_W_4_7
_cell_subsystem_matrix_W_4_8
_cell_subsystem_matrix_W_4_9
_cell_subsystem_matrix_W_4_10
_cell_subsystem_matrix_W_4_11
_cell_subsystem_matrix_W_5_1
_cell_subsystem_matrix_W_5_2
_cell_subsystem_matrix_W_5_3
_cell_subsystem_matrix_W_5_4
_cell_subsystem_matrix_W_5_5
_cell_subsystem_matrix_W_5_6
_cell_subsystem_matrix_W_5_7
_cell_subsystem_matrix_W_5_8
_cell_subsystem_matrix_W_5_9
_cell_subsystem_matrix_W_5_10
_cell_subsystem_matrix_W_5_11
_cell_subsystem_matrix_W_6_1
_cell_subsystem_matrix_W_6_2
_cell_subsystem_matrix_W_6_3
_cell_subsystem_matrix_W_6_4
_cell_subsystem_matrix_W_6_5
_cell_subsystem_matrix_W_6_6
_cell_subsystem_matrix_W_6_7
_cell_subsystem_matrix_W_6_8
_cell_subsystem_matrix_W_6_9
_cell_subsystem_matrix_W_6_10
_cell_subsystem_matrix_W_6_11
_cell_subsystem_matrix_W_7_1
_cell_subsystem_matrix_W_7_2
_cell_subsystem_matrix_W_7_3
_cell_subsystem_matrix_W_7_4
_cell_subsystem_matrix_W_7_5
_cell_subsystem_matrix_W_7_6
_cell_subsystem_matrix_W_7_7
_cell_subsystem_matrix_W_7_8
_cell_subsystem_matrix_W_7_9
_cell_subsystem_matrix_W_7_10
_cell_subsystem_matrix_W_7_11
_cell_subsystem_matrix_W_8_1
_cell_subsystem_matrix_W_8_2
_cell_subsystem_matrix_W_8_3
_cell_subsystem_matrix_W_8_4
_cell_subsystem_matrix_W_8_5
_cell_subsystem_matrix_W_8_6
_cell_subsystem_matrix_W_8_7
_cell_subsystem_matrix_W_8_8
_cell_subsystem_matrix_W_8_9
_cell_subsystem_matrix_W_8_10
_cell_subsystem_matrix_W_8_11
_cell_subsystem_matrix_W_9_1
_cell_subsystem_matrix_W_9_2
_cell_subsystem_matrix_W_9_3
_cell_subsystem_matrix_W_9_4
_cell_subsystem_matrix_W_9_5
_cell_subsystem_matrix_W_9_6
_cell_subsystem_matrix_W_9_7
_cell_subsystem_matrix_W_9_8
_cell_subsystem_matrix_W_9_9
_cell_subsystem_matrix_W_9_10
_cell_subsystem_matrix_W_9_11
_cell_subsystem_matrix_W_10_1
_cell_subsystem_matrix_W_10_2
_cell_subsystem_matrix_W_10_3
_cell_subsystem_matrix_W_10_4
_cell_subsystem_matrix_W_10_5
_cell_subsystem_matrix_W_10_6
_cell_subsystem_matrix_W_10_7
_cell_subsystem_matrix_W_10_8
_cell_subsystem_matrix_W_10_9
_cell_subsystem_matrix_W_10_10
_cell_subsystem_matrix_W_10_11
_cell_subsystem_matrix_W_11_1
_cell_subsystem_matrix_W_11_2
_cell_subsystem_matrix_W_11_3
_cell_subsystem_matrix_W_11_4
_cell_subsystem_matrix_W_11_5
_cell_subsystem_matrix_W_11_6
_cell_subsystem_matrix_W_11_7
_cell_subsystem_matrix_W_11_8
_cell_subsystem_matrix_W_11_9
_cell_subsystem_matrix_W_11_10
_cell_subsystem_matrix_W_11_11

_cell_subsystems_[ms]
_cell_subsystems_number

_cell_volume
_cell.volume
_cell.volume_esd
_cell_volume_nm
_cell_volume_pm

_cell_wave_vector_[ms]
_cell_wave_vector_seq_id
_cell_wave_vector_x
_cell_wave_vector_y
_cell_wave_vector_z

_cell_wave_vectors_[ms]
_cell_wave_vectors_meas_details
_cell_wave_vectors_pressure_max
_cell_wave_vectors_pressure_min
_cell_wave_vectors_temp_max
_cell_wave_vectors_temp_min
_cell_wave_vectors_variation

_cell.Z_PDB
_chem_comp_angle.atom_id_1
_chem_comp_angle.atom_id_2
_chem_comp_angle.atom_id_3
_chem_comp_angle.comp_id
_chem_comp_angle.value_angle
_chem_comp_angle.value_angle_esd
_chem_comp_angle.value_dist
_chem_comp_angle.value_dist_esd
_chem_comp_atom.alt_atom_id
_chem_comp_atom.atom_id
_chem_comp_atom.charge
_chem_comp_atom.comp_id
_chem_comp_atom.model_Cartn_x
_chem_comp_atom.model_Cartn_x_esd
_chem_comp_atom.model_Cartn_y
_chem_comp_atom.model_Cartn_y_esd
_chem_comp_atom.model_Cartn_z
_chem_comp_atom.model_Cartn_z_esd
_chem_comp_atom.partial_charge
_chem_comp_atom.substruct_code
_chem_comp_atom.type_symbol
_chem_comp_bond.atom_id_1
_chem_comp_bond.atom_id_2
_chem_comp_bond.comp_id
_chem_comp_bond.value_dist
_chem_comp_bond.value_dist_esd
_chem_comp_bond.value_order
_chem_comp_chir_atom.atom_id
_chem_comp_chir_atom.chir_id
_chem_comp_chir_atom.comp_id
_chem_comp_chir.atom_config
_chem_comp_chir_atom.dev
_chem_comp_chir.atom_id
_chem_comp_chir.comp_id
_chem_comp_chir.id
_chem_comp_chir.number_atoms_all
_chem_comp_chir.number_atoms_nh
_chem_comp_chir.volume_flag
_chem_comp_chir.volume_three
_chem_comp_chir.volume_three_esd
_chem_comp.formula
_chem_comp.formula_weight
_chem_comp.id
_chem_comp_link.details
_chem_comp_link.link_id
_chem_comp_link.type_comp_1
_chem_comp_link.type_comp_2
_chem_comp.model_details
_chem_comp.model_erf
_chem_comp.model_source
_chem_comp.mon_nstd_class
_chem_comp.mon_nstd_details
_chem_comp.mon_nstd_flag
_chem_comp.mon_nstd_parent
_chem_comp.mon_nstd_parent_comp_id
_chem_comp.name
_chem_comp.number_atoms_all
_chem_comp.number_atoms_nh
_chem_comp.one_letter_code
_chem_comp_plane_atom.atom_id
_chem_comp_plane_atom.comp_id
_chem_comp_plane_atom.dist_esd
_chem_comp_plane_atom.plane_id
_chem_comp_plane.comp_id
_chem_comp_plane.id
_chem_comp_plane.number_atoms_all
_chem_comp_plane.number_atoms_nh
_chem_comp.three_letter_code
_chem_comp_tor.atom_id_1
_chem_comp_tor.atom_id_2
_chem_comp_tor.atom_id_3
_chem_comp_tor.atom_id_4
_chem_comp_tor.comp_id
_chem_comp_tor.id
_chem_comp_tor_value.angle
_chem_comp_tor_value.angle_esd
_chem_comp_tor_value.comp_id
_chem_comp_tor_value.dist
_chem_comp_tor_value.dist_esd
_chem_comp_tor_value.tor_id
_chem_comp.type
_chem_link_angle.atom_1_comp_id
_chem_link_angle.atom_2_comp_id
_chem_link_angle.atom_3_comp_id
_chem_link_angle.atom_id_1
_chem_link_angle.atom_id_2
_chem_link_angle.atom_id_3
_chem_link_angle.link_id
_chem_link_angle.value_angle
_chem_link_angle.value_angle_esd
_chem_link_angle.value_dist
_chem_link_angle.value_dist_esd
_chem_link_bond.atom_1_comp_id
_chem_link_bond.atom_2_comp_id
_chem_link_bond.atom_id_1
_chem_link_bond.atom_id_2
_chem_link_bond.link_id
_chem_link_bond.value_dist
_chem_link_bond.value_dist_esd
_chem_link_bond.value_order
_chem_link_chir_atom.atom_comp_id
_chem_link_chir_atom.atom_id
_chem_link_chir_atom.chir_id
_chem_link_chir.atom_comp_id
_chem_link_chir.atom_config
_chem_link_chir_atom.dev
_chem_link_chir.atom_id
_chem_link_chir.id
_chem_link_chir.link_id
_chem_link_chir.number_atoms_all
_chem_link_chir.number_atoms_nh
_chem_link_chir.volume_flag
_chem_link_chir.volume_three
_chem_link_chir.volume_three_esd
_chem_link.details
_chem_link.id
_chem_link_plane_atom.atom_comp_id
_chem_link_plane_atom.atom_id
_chem_link_plane_atom.plane_id
_chem_link_plane.id
_chem_link_plane.link_id
_chem_link_plane.number_atoms_all
_chem_link_plane.number_atoms_nh
_chem_link_tor.atom_1_comp_id
_chem_link_tor.atom_2_comp_id
_chem_link_tor.atom_3_comp_id
_chem_link_tor.atom_4_comp_id
_chem_link_tor.atom_id_1
_chem_link_tor.atom_id_2
_chem_link_tor.atom_id_3
_chem_link_tor.atom_id_4
_chem_link_tor.id
_chem_link_tor.link_id
_chem_link_tor_value.angle
_chem_link_tor_value.angle_esd
_chem_link_tor_value.dist
_chem_link_tor_value.dist_esd
_chem_link_tor_value.tor_id
_cifdic_dictionary_[]
_cifdic_dictionary.date
_cifdic_dictionary.DDL_compliance
_cifdic_dictionary.description
_cifdic_dictionary.name
_cifdic_dictionary.reserved_prefix
_cifdic_dictionary.URL
_cifdic_dictionary.version
_citation_[]
_citation_abstract
_citation.abstract
_citation_abstract_id_CAS
_citation.abstract_id_CAS
_citation_author_[]
_citation_author_citation_id
_citation_author.citation_id
_citation_author_name
_citation_author.name
_citation_author_ordinal
_citation_author.ordinal
_citation_book_id_ISBN
_citation.book_id_ISBN
_citation_book_publisher
_citation.book_publisher
_citation_book_publisher_city
_citation.book_publisher_city
_citation_book_title
_citation.book_title
_citation_coordinate_linkage
_citation.coordinate_linkage
_citation_country
_citation.country
_citation_database_id_CSD
_citation.database_id_CSD
_citation_database_id_Medline
_citation.database_id_Medline
_citation.details
_citation_doi
_citation_editor_[]
_citation_editor_citation_id
_citation_editor.citation_id
_citation_editor_name
_citation_editor.name
_citation_editor_ordinal
_citation_editor.ordinal
_citation_id
_citation.id
_citation_journal_abbrev
_citation.journal_abbrev
_citation_journal_full
_citation.journal_full
_citation_journal_id_ASTM
_citation.journal_id_ASTM
_citation_journal_id_CSD
_citation.journal_id_CSD
_citation_journal_id_ISSN
_citation.journal_id_ISSN
_citation_journal_issue
_citation.journal_issue
_citation_journal_volume
_citation.journal_volume
_citation_language
_citation.language
_citation_page_first
_citation.page_first
_citation_page_last
_citation.page_last
_citation_publisher
_citation_special_details
_citation_title
_citation.title
_citation_year
_citation.year
_computing_[]
_computing_cell_refinement
_computing.cell_refinement
_computing_data_collection
_computing.data_collection
_computing_data_reduction
_computing.data_reduction
_computing.entry_id
_computing_molecular_graphics
_computing.molecular_graphics
_computing_publication_material
_computing.publication_material
_computing_structure_refinement
_computing.structure_refinement
_computing_structure_solution
_computing.structure_solution
_database_[]
_database_2.database_code
_database_2.database_id
_database_code_CAS
_database.code_CAS
_database_code_CSD
_database.code_CSD
_database_code_depnum_ccdc_archive
_database.code_depnum_ccdc_archive
_database_code_depnum_ccdc_fiz
_database.code_depnum_ccdc_fiz
_database_code_depnum_ccdc_journal
_database.code_depnum_ccdc_journal
_database_code_ICSD
_database.code_ICSD
_database_code_MDF
_database.code_MDF
_database_code_NBS
_database.code_NBS
_database_code_PDB
_database.code_PDB
_database_code_PDF
_database.code_PDF
_database_code_COD
_database.code_COD
_database_code_amcsd
_database.code_amcsd
_database_CSD_history
_database.CSD_history
_database_dataset_doi
_database.entry_id
_database_journal_ASTM
_database.journal_ASTM
_database_journal_CSD
_database.journal_CSD
_database_PDB_caveat.id
_database_PDB_caveat.text
_database_PDB_matrix.entry_id
_database_PDB_matrix.origx[1][1]
_database_PDB_matrix.origx[1][2]
_database_PDB_matrix.origx[1][3]
_database_PDB_matrix.origx[2][1]
_database_PDB_matrix.origx[2][2]
_database_PDB_matrix.origx[2][3]
_database_PDB_matrix.origx[3][1]
_database_PDB_matrix.origx[3][2]
_database_PDB_matrix.origx[3][3]
_database_PDB_matrix.origx_vector[1]
_database_PDB_matrix.origx_vector[2]
_database_PDB_matrix.origx_vector[3]
_database_PDB_matrix.scale[1][1]
_database_PDB_matrix.scale[1][2]
_database_PDB_matrix.scale[1][3]
_database_PDB_matrix.scale[2][1]
_database_PDB_matrix.scale[2][2]
_database_PDB_matrix.scale[2][3]
_database_PDB_matrix.scale[3][1]
_database_PDB_matrix.scale[3][2]
_database_PDB_matrix.scale[3][3]
_database_PDB_matrix.scale_vector[1]
_database_PDB_matrix.scale_vector[2]
_database_PDB_matrix.scale_vector[3]
_database_PDB_remark.id
_database_PDB_remark.text
_database_PDB_rev.author_name
_database_PDB_rev.date
_database_PDB_rev.date_original
_database_PDB_rev.mod_type
_database_PDB_rev.num
_database_PDB_rev_record.details
_database_PDB_rev_record.rev_num
_database_PDB_rev_record.type
_database_PDB_rev.replaced_by
_database_PDB_rev.replaces
_database_PDB_rev.status
_database_PDB_tvect.details
_database_PDB_tvect.id
_database_PDB_tvect.vector[1]
_database_PDB_tvect.vector[2]
_database_PDB_tvect.vector[3]
_datablock.description
_datablock.id
_datablock_methods.datablock_id
_datablock_methods.method_id
_definition
_dictionary.datablock_id
_dictionary_history
_dictionary_history.revision
_dictionary_history.update
_dictionary_history.version
_dictionary_name
_dictionary.title
_dictionary_update
_dictionary_version
_dictionary.version
_diffrn_[]
_diffrn_ambient_environment
_diffrn.ambient_environment
_diffrn_ambient_pressure
_diffrn.ambient_pressure
_diffrn.ambient_pressure_esd
_diffrn_ambient_pressure_gPa
_diffrn_ambient_pressure_gt
_diffrn.ambient_pressure_gt
_diffrn_ambient_pressure_lt
_diffrn.ambient_pressure_lt
_diffrn.ambient_temp
_diffrn.ambient_temp_details
_diffrn_ambient_temperature
_diffrn_ambient_temperature_C
_diffrn_ambient_temperature_gt
_diffrn_ambient_temperature_lt
_diffrn.ambient_temp_esd
_diffrn.ambient_temp_gt
_diffrn.ambient_temp_lt
_diffrn_attenuator_[]
_diffrn_attenuator_code
_diffrn_attenuator.code
_diffrn_attenuator_material
_diffrn_attenuator.material
_diffrn_attenuator_scale
_diffrn_attenuator.scale
_diffrn.crystal_id
_diffrn.crystal_support
_diffrn_crystal_treatment
_diffrn.crystal_treatment
_diffrn_data_frame.array_id
_diffrn_data_frame.binary_id
_diffrn_data_frame.detector_element_id
_diffrn_data_frame.id
_diffrn.details
_diffrn_detector
_diffrn_detector_[]
_diffrn_detector_area_resol_mean
_diffrn_detector.area_resol_mean
_diffrn_detector_axis.axis_id
_diffrn_detector_axis.detector_id
_diffrn_detector_axis.id
_diffrn_detector_details
_diffrn_detector.details
_diffrn_detector.detector
_diffrn_detector.diffrn_id
_diffrn_detector_dtime
_diffrn_detector.dtime
_diffrn_detector_element.center[1]
_diffrn_detector_element.center[2]
_diffrn_detector_element.detector_id
_diffrn_detector_element.id
_diffrn_detector.id
_diffrn_detector.number_of_axes
_diffrn_detector_type
_diffrn_detector.type
_diffrn_frame_data.array_id
_diffrn_frame_data.binary_id
_diffrn_frame_data.detector_element_id
_diffrn_frame_data.id
_diffrn.id
_diffrn_measured_fraction_theta_full
_diffrn_measured_fraction_theta_max
_diffrn_measurement_[]
_diffrn_measurement_axis.axis_id
_diffrn_measurement_axis.id
_diffrn_measurement_axis.measurement_device
_diffrn_measurement_axis.measurement_id
_diffrn_measurement_details
_diffrn_measurement.details
_diffrn_measurement_device
_diffrn_measurement.device
_diffrn_measurement_device_details
_diffrn_measurement.device_details
_diffrn_measurement_device_type
_diffrn_measurement.device_type
_diffrn_measurement.diffrn_id
_diffrn_measurement.id
_diffrn_measurement_method
_diffrn_measurement.method
_diffrn_measurement.number_of_axes
_diffrn_measurement_specimen_support
_diffrn_measurement.specimen_support
_diffrn_orient_matrix_[]
_diffrn_orient_matrix.diffrn_id
_diffrn_orient_matrix_type
_diffrn_orient_matrix.type
_diffrn_orient_matrix_UB_11
_diffrn_orient_matrix.UB[1][1]
_diffrn_orient_matrix_UB_12
_diffrn_orient_matrix.UB[1][2]
_diffrn_orient_matrix_UB_13
_diffrn_orient_matrix.UB[1][3]
_diffrn_orient_matrix_UB_21
_diffrn_orient_matrix.UB[2][1]
_diffrn_orient_matrix_UB_22
_diffrn_orient_matrix.UB[2][2]
_diffrn_orient_matrix_UB_23
_diffrn_orient_matrix.UB[2][3]
_diffrn_orient_matrix_UB_31
_diffrn_orient_matrix.UB[3][1]
_diffrn_orient_matrix_UB_32
_diffrn_orient_matrix.UB[3][2]
_diffrn_orient_matrix_UB_33
_diffrn_orient_matrix.UB[3][3]
_diffrn_orient_refln_[]
_diffrn_orient_refln_angle_chi
_diffrn_orient_refln.angle_chi
_diffrn_orient_refln_angle_kappa
_diffrn_orient_refln.angle_kappa
_diffrn_orient_refln_angle_omega
_diffrn_orient_refln.angle_omega
_diffrn_orient_refln_angle_phi
_diffrn_orient_refln.angle_phi
_diffrn_orient_refln_angle_psi
_diffrn_orient_refln.angle_psi
_diffrn_orient_refln_angle_theta
_diffrn_orient_refln.angle_theta
_diffrn_orient_refln.diffrn_id
_diffrn_orient_refln_index_h
_diffrn_orient_refln.index_h
_diffrn_orient_refln_index_k
_diffrn_orient_refln.index_k
_diffrn_orient_refln_index_l
_diffrn_orient_refln.index_l
_diffrn_radiation_[]
_diffrn_radiation_collimation
_diffrn_radiation.collimation
_diffrn_radiation_detector
_diffrn_radiation_detector_dtime
_diffrn_radiation.diffrn_id
_diffrn_radiation.div_x_source
_diffrn_radiation.div_x_y_source
_diffrn_radiation.div_y_source
_diffrn_radiation_filter_edge
_diffrn_radiation.filter_edge
_diffrn_radiation_filter_edge_nm
_diffrn_radiation_filter_edge_pm
_diffrn_radiation_inhomogeneity
_diffrn_radiation.inhomogeneity
_diffrn_radiation_monochromator
_diffrn_radiation.monochromator
_diffrn_radiation_polarisn_norm
_diffrn_radiation.polarisn_norm
_diffrn_radiation_polarisn_ratio
_diffrn_radiation.polarisn_ratio
_diffrn_radiation.polarizn_source_norm
_diffrn_radiation.polarizn_source_ratio
_diffrn_radiation_probe
_diffrn_radiation.probe
_diffrn_radiation_source
_diffrn_radiation_type
_diffrn_radiation.type
_diffrn_radiation_wavelength_[]
_diffrn_radiation_wavelength
_diffrn_radiation_wavelength_details
_diffrn_radiation_wavelength_determination
_diffrn_radiation_wavelength_id
_diffrn_radiation_wavelength.id
_diffrn_radiation.wavelength_id
_diffrn_radiation_wavelength_nm
_diffrn_radiation_wavelength_pm
_diffrn_radiation_wavelength.wavelength
_diffrn_radiation_wavelength_wt
_diffrn_radiation_wavelength.wt
_diffrn_radiation_xray_symbol
_diffrn_radiation.xray_symbol
_diffrn_refln_[]
_diffrn_refln_angle_chi
_diffrn_refln.angle_chi
_diffrn_refln_angle_kappa
_diffrn_refln.angle_kappa
_diffrn_refln_angle_omega
_diffrn_refln.angle_omega
_diffrn_refln_angle_phi
_diffrn_refln.angle_phi
_diffrn_refln_angle_psi
_diffrn_refln.angle_psi
_diffrn_refln_angle_theta
_diffrn_refln.angle_theta
_diffrn_refln_attenuator_code
_diffrn_refln.attenuator_code
_diffrn_refln_class_code
_diffrn_refln.class_code
_diffrn_refln_counts_bg_1
_diffrn_refln.counts_bg_1
_diffrn_refln_counts_bg_2
_diffrn_refln.counts_bg_2
_diffrn_refln_counts_net
_diffrn_refln.counts_net
_diffrn_refln_counts_peak
_diffrn_refln.counts_peak
_diffrn_refln_counts_total
_diffrn_refln.counts_total
_diffrn_refln_crystal_id
_diffrn_refln_detect_slit_horiz
_diffrn_refln.detect_slit_horiz
_diffrn_refln_detect_slit_vert
_diffrn_refln.detect_slit_vert
_diffrn_refln.diffrn_id
_diffrn_refln_elapsed_time
_diffrn_refln.elapsed_time
_diffrn_refln_elapsed_time_hr
_diffrn_refln_elapsed_time_sec
_diffrn_refln.frame_id
_diffrn_refln.id
_diffrn_refln_index_h
_diffrn_refln.index_h
_diffrn_refln_index_k
_diffrn_refln.index_k
_diffrn_refln_index_l
_diffrn_refln.index_l

_diffrn_refln_[ms]
_diffrn_refln_index_m_1
_diffrn_refln_index_m_2
_diffrn_refln_index_m_3
_diffrn_refln_index_m_4
_diffrn_refln_index_m_5
_diffrn_refln_index_m_6
_diffrn_refln_index_m_7
_diffrn_refln_index_m_8

_diffrn_refln_intensity_net
_diffrn_refln.intensity_net
_diffrn_refln_intensity_sigma
_diffrn_refln.intensity_sigma
_diffrn_refln_intensity_u
_diffrn_refln.intensity_u
_diffrn_reflns_[]
_diffrn_reflns_av_R_equivalents
_diffrn_reflns.av_R_equivalents
_diffrn_reflns_av_sigmaI/netI
_diffrn_reflns.av_sigmaI_over_netI
_diffrn_reflns_av_unetI/netI
_diffrn_reflns.av_unetI/netI
_diffrn_reflns_Laue_measured_fraction_full
_diffrn_reflns_Laue_measured_fraction_max
_diffrn_refln_scale_group_code
_diffrn_refln.scale_group_code
_diffrn_refln_scan_mode
_diffrn_refln.scan_mode
_diffrn_refln_scan_mode_backgd
_diffrn_refln.scan_mode_backgd
_diffrn_refln_scan_rate
_diffrn_refln.scan_rate
_diffrn_refln_scan_time_backgd
_diffrn_refln.scan_time_backgd
_diffrn_refln_scan_width
_diffrn_refln.scan_width
_diffrn_reflns_class_[]
_diffrn_reflns_class_av_R_eq
_diffrn_reflns_class.av_R_eq
_diffrn_reflns_class_av_sgI/I
_diffrn_reflns_class.av_sgI/I
_diffrn_reflns_class_av_uI/I
_diffrn_reflns_class.av_uI/I
_diffrn_reflns_class_code
_diffrn_reflns_class.code
_diffrn_reflns_class_description
_diffrn_reflns_class.description
_diffrn_reflns_class_d_res_high
_diffrn_reflns_class.d_res_high
_diffrn_reflns_class_d_res_low
_diffrn_reflns_class.d_res_low
_diffrn_reflns_class_number
_diffrn_reflns_class.number
_diffrn_reflns.diffrn_id
_diffrn_refln_sint/lambda
_diffrn_refln_sint/lambda_nm
_diffrn_refln_sint/lambda_pm
_diffrn_refln.sint_over_lambda
_diffrn_reflns_limit_h_max
_diffrn_reflns.limit_h_max
_diffrn_reflns_limit_h_min
_diffrn_reflns.limit_h_min

_diffrn_reflns_[ms]
_diffrn_reflns_limit_index_m_1_max
_diffrn_reflns_limit_index_m_1_min
_diffrn_reflns_limit_index_m_2_max
_diffrn_reflns_limit_index_m_2_min
_diffrn_reflns_limit_index_m_3_max
_diffrn_reflns_limit_index_m_3_min
_diffrn_reflns_limit_index_m_4_max
_diffrn_reflns_limit_index_m_4_min
_diffrn_reflns_limit_index_m_5_max
_diffrn_reflns_limit_index_m_5_min
_diffrn_reflns_limit_index_m_6_max
_diffrn_reflns_limit_index_m_6_min
_diffrn_reflns_limit_index_m_7_max
_diffrn_reflns_limit_index_m_7_min
_diffrn_reflns_limit_index_m_8_max
_diffrn_reflns_limit_index_m_8_min
_diffrn_reflns_satellite_order_max

_diffrn_reflns_limit_k_max
_diffrn_reflns.limit_k_max
_diffrn_reflns_limit_k_min
_diffrn_reflns.limit_k_min
_diffrn_reflns_limit_l_max
_diffrn_reflns.limit_l_max
_diffrn_reflns_limit_l_min
_diffrn_reflns.limit_l_min
_diffrn_reflns_number
_diffrn_reflns.number
_diffrn_reflns_point_group_measured_fraction_full
_diffrn_reflns_point_group_measured_fraction_max
_diffrn_reflns_reduction_process
_diffrn_reflns.reduction_process
_diffrn_reflns_resolution_full
_diffrn_reflns_resolution_max
_diffrn_refln_standard_code
_diffrn_refln.standard_code
_diffrn_reflns_theta_full
_diffrn_reflns_theta_max
_diffrn_reflns.theta_max
_diffrn_reflns_theta_min
_diffrn_reflns.theta_min
_diffrn_reflns_transf_matrix_11
_diffrn_reflns.transf_matrix[1][1]
_diffrn_reflns_transf_matrix_12
_diffrn_reflns.transf_matrix[1][2]
_diffrn_reflns_transf_matrix_13
_diffrn_reflns.transf_matrix[1][3]
_diffrn_reflns_transf_matrix_21
_diffrn_reflns.transf_matrix[2][1]
_diffrn_reflns_transf_matrix_22
_diffrn_reflns.transf_matrix[2][2]
_diffrn_reflns_transf_matrix_23
_diffrn_reflns.transf_matrix[2][3]
_diffrn_reflns_transf_matrix_31
_diffrn_reflns.transf_matrix[3][1]
_diffrn_reflns_transf_matrix_32
_diffrn_reflns.transf_matrix[3][2]
_diffrn_reflns_transf_matrix_33
_diffrn_reflns.transf_matrix[3][3]
_diffrn_refln_wavelength
_diffrn_refln.wavelength
_diffrn_refln_wavelength_id
_diffrn_refln.wavelength_id
_diffrn_refln_wavelength_nm
_diffrn_refln_wavelength_pm
_diffrn_scale_group_[]
_diffrn_scale_group_code
_diffrn_scale_group.code
_diffrn_scale_group_I_net
_diffrn_scale_group.I_net
_diffrn_scan_axis.angle_increment
_diffrn_scan_axis.angle_range
_diffrn_scan_axis.angle_rstrt_incr
_diffrn_scan_axis.angle_start
_diffrn_scan_axis.axis_id
_diffrn_scan_axis.displacement_increment
_diffrn_scan_axis.displacement_range
_diffrn_scan_axis.displacement_rstrt_incr
_diffrn_scan_axis.displacement_start
_diffrn_scan_axis.scan_id
_diffrn_scan.date_end
_diffrn_scan.date_start
_diffrn_scan_frame_axis.angle
_diffrn_scan_frame_axis.angle_increment
_diffrn_scan_frame_axis.angle_rstrt_incr
_diffrn_scan_frame_axis.axis_id
_diffrn_scan_frame_axis.displacement
_diffrn_scan_frame_axis.displacement_increment
_diffrn_scan_frame_axis.displacement_rstrt_incr
_diffrn_scan_frame_axis.frame_id
_diffrn_scan_frame.date
_diffrn_scan_frame.frame_id
_diffrn_scan_frame.frame_number
_diffrn_scan.frame_id_end
_diffrn_scan.frame_id_start
_diffrn_scan_frame.integration_time
_diffrn_scan.frames
_diffrn_scan_frame.scan_id
_diffrn_scan.id
_diffrn_scan.integration_time
_diffrn_source
_diffrn_source_[]
_diffrn_source_current
_diffrn_source.current
_diffrn_source_details
_diffrn_source.details
_diffrn_source.diffrn_id
_diffrn_source_power
_diffrn_source.power
_diffrn_source_size
_diffrn_source.size
_diffrn_source.source
_diffrn_source_take-off_angle
_diffrn_source.take-off_angle
_diffrn_source_target
_diffrn_source.target
_diffrn_source_type
_diffrn_source.type
_diffrn_source_voltage
_diffrn_source.voltage
_diffrn_special_details
_diffrn_standard_refln_[]
_diffrn_standard_refln_code
_diffrn_standard_refln.code
_diffrn_standard_refln.diffrn_id
_diffrn_standard_refln_index_h
_diffrn_standard_refln.index_h
_diffrn_standard_refln_index_k
_diffrn_standard_refln.index_k
_diffrn_standard_refln_index_l
_diffrn_standard_refln.index_l

_diffrn_standard_refln_[ms]
_diffrn_standard_refln_index_m_1
_diffrn_standard_refln_index_m_2
_diffrn_standard_refln_index_m_3
_diffrn_standard_refln_index_m_4
_diffrn_standard_refln_index_m_5
_diffrn_standard_refln_index_m_6
_diffrn_standard_refln_index_m_7
_diffrn_standard_refln_index_m_8

_diffrn_standards_[]
_diffrn_standards_decay_%
_diffrn_standards.decay_%
_diffrn_standards.diffrn_id
_diffrn_standards_interval_count
_diffrn_standards.interval_count
_diffrn_standards_interval_time
_diffrn_standards.interval_time
_diffrn_standards_number
_diffrn_standards.number
_diffrn_standards_scale_sigma
_diffrn_standards.scale_sigma
_diffrn_standards_scale_u
_diffrn_standards.scale_u
_diffrn_symmetry_description
_entity.details
_entity.formula_weight
_entity.id
_entity_keywords.entity_id
_entity_keywords.text
_entity_link.details
_entity_link.entity_id_1
_entity_link.entity_id_2
_entity_link.entity_seq_num_1
_entity_link.entity_seq_num_2
_entity_link.link_id
_entity_name_com.entity_id
_entity_name_com.name
_entity_name_sys.entity_id
_entity_name_sys.name
_entity_name_sys.system
_entity_poly.entity_id
_entity_poly.nstd_chirality
_entity_poly.nstd_linkage
_entity_poly.nstd_monomer
_entity_poly.number_of_monomers
_entity_poly_seq.entity_id
_entity_poly_seq.hetero
_entity_poly_seq.mon_id
_entity_poly_seq.num
_entity_poly.type
_entity_poly.type_details
_entity_src_gen.entity_id
_entity_src_gen.gene_src_common_name
_entity_src_gen.gene_src_details
_entity_src_gen.gene_src_genus
_entity_src_gen.gene_src_species
_entity_src_gen.gene_src_strain
_entity_src_gen.gene_src_tissue
_entity_src_gen.gene_src_tissue_fraction
_entity_src_gen.host_org_common_name
_entity_src_gen.host_org_details
_entity_src_gen.host_org_genus
_entity_src_gen.host_org_species
_entity_src_gen.host_org_strain
_entity_src_gen.plasmid_details
_entity_src_gen.plasmid_name
_entity.src_method
_entity_src_nat.common_name
_entity_src_nat.details
_entity_src_nat.entity_id
_entity_src_nat.genus
_entity_src_nat.species
_entity_src_nat.strain
_entity_src_nat.tissue
_entity_src_nat.tissue_fraction
_entity.type
_entry.id
_entry_link.details
_entry_link.entry_id
_entry_link.id
_enumeration
_enumeration_default
_enumeration_detail
_enumeration_range
_example
_example_detail
_exptl_[]
_exptl_absorpt_coefficient_mu
_exptl.absorpt_coefficient_mu
_exptl_absorpt_coefficient_mu_cm
_exptl_absorpt_correction_T_max
_exptl.absorpt_correction_T_max
_exptl_absorpt_correction_T_min
_exptl.absorpt_correction_T_min
_exptl_absorpt_correction_type
_exptl.absorpt_correction_type
_exptl_absorpt_process_details
_exptl.absorpt_process_details
_exptl_crystal_[]
_exptl_crystal_colour
_exptl_crystal.colour
_exptl_crystal_colour_lustre
_exptl_crystal.colour_lustre
_exptl_crystal_colour_modifier
_exptl_crystal.colour_modifier
_exptl_crystal_colour_primary
_exptl_crystal.colour_primary
_exptl_crystal_density_diffrn
_exptl_crystal.density_diffrn
_exptl_crystal.density_Matthews
_exptl_crystal_density_meas
_exptl_crystal.density_meas
_exptl_crystal.density_meas_esd
_exptl_crystal_density_meas_gt
_exptl_crystal.density_meas_gt
_exptl_crystal_density_meas_lt
_exptl_crystal.density_meas_lt
_exptl_crystal_density_meas_temp
_exptl_crystal.density_meas_temp
_exptl_crystal.density_meas_temp_esd
_exptl_crystal_density_meas_temp_gt
_exptl_crystal.density_meas_temp_gt
_exptl_crystal_density_meas_temp_lt
_exptl_crystal.density_meas_temp_lt
_exptl_crystal_density_method
_exptl_crystal.density_method
_exptl_crystal.density_percent_sol
_exptl_crystal_description
_exptl_crystal.description
_exptl_crystal_F_000
_exptl_crystal.F_000
_exptl_crystal_face_[]
_exptl_crystal_face.crystal_id
_exptl_crystal_face_diffr_chi
_exptl_crystal_face.diffr_chi
_exptl_crystal_face_diffr_kappa
_exptl_crystal_face.diffr_kappa
_exptl_crystal_face_diffr_phi
_exptl_crystal_face.diffr_phi
_exptl_crystal_face_diffr_psi
_exptl_crystal_face.diffr_psi
_exptl_crystal_face_index_h
_exptl_crystal_face.index_h
_exptl_crystal_face_index_k
_exptl_crystal_face.index_k
_exptl_crystal_face_index_l
_exptl_crystal_face.index_l

_exptl_crystal_face_[ms]
_exptl_crystal_face_index_m_1
_exptl_crystal_face_index_m_2
_exptl_crystal_face_index_m_3
_exptl_crystal_face_index_m_4
_exptl_crystal_face_index_m_5
_exptl_crystal_face_index_m_6
_exptl_crystal_face_index_m_7
_exptl_crystal_face_index_m_8

_exptl_crystal_face_perp_dist
_exptl_crystal_face.perp_dist
_exptl_crystal_face_perp_dist_cm
_exptl_crystal_grow.apparatus
_exptl_crystal_grow.atmosphere
_exptl_crystal_grow_comp.conc
_exptl_crystal_grow_comp.crystal_id
_exptl_crystal_grow_comp.details
_exptl_crystal_grow_comp.id
_exptl_crystal_grow_comp.name
_exptl_crystal_grow_comp.sol_id
_exptl_crystal_grow_comp.volume
_exptl_crystal_grow.crystal_id
_exptl_crystal_grow.details
_exptl_crystal_grow.method
_exptl_crystal_grow.method_ref
_exptl_crystal_grow.pH
_exptl_crystal_grow.pressure
_exptl_crystal_grow.pressure_esd
_exptl_crystal_grow.seeding
_exptl_crystal_grow.seeding_ref
_exptl_crystal_grow.temp
_exptl_crystal_grow.temp_details
_exptl_crystal_grow.temp_esd
_exptl_crystal_grow.time
_exptl_crystal_id
_exptl_crystal.id

_exptl_crystal_[ms]
_exptl_crystal_type_of_structure

_exptl_crystal_preparation
_exptl_crystal.preparation
_exptl_crystal_pressure_history
_exptl_crystal_recrystallization_method
_exptl_crystal_size_length
_exptl_crystal_size_max
_exptl_crystal.size_max
_exptl_crystal_size_max_cm
_exptl_crystal_size_mid
_exptl_crystal.size_mid
_exptl_crystal_size_mid_cm
_exptl_crystal_size_min
_exptl_crystal.size_min
_exptl_crystal_size_min_cm
_exptl_crystal_size_rad
_exptl_crystal.size_rad
_exptl_crystal_size_rad_cm
_exptl_crystals_number
_exptl.crystals_number
_exptl_crystal_thermal_history

_exptl.details
_exptl.entry_id
_exptl.method
_exptl.method_details
_exptl_special_details
_exptl_transmission_factor_max
_exptl_transmission_factor_min
_geom_[]
_geom_angle
_geom_angle_[]
_geom_angle.atom_site_auth_asym_id_1
_geom_angle.atom_site_auth_asym_id_2
_geom_angle.atom_site_auth_asym_id_3
_geom_angle.atom_site_auth_atom_id_1
_geom_angle.atom_site_auth_atom_id_2
_geom_angle.atom_site_auth_atom_id_3
_geom_angle.atom_site_auth_comp_id_1
_geom_angle.atom_site_auth_comp_id_2
_geom_angle.atom_site_auth_comp_id_3
_geom_angle.atom_site_auth_seq_id_1
_geom_angle.atom_site_auth_seq_id_2
_geom_angle.atom_site_auth_seq_id_3
_geom_angle.atom_site_id_1
_geom_angle.atom_site_id_2
_geom_angle.atom_site_id_3
_geom_angle_atom_site_label_1
_geom_angle_atom_site_label_2
_geom_angle_atom_site_label_3
_geom_angle.atom_site_label_alt_id_1
_geom_angle.atom_site_label_alt_id_2
_geom_angle.atom_site_label_alt_id_3
_geom_angle.atom_site_label_asym_id_1
_geom_angle.atom_site_label_asym_id_2
_geom_angle.atom_site_label_asym_id_3
_geom_angle.atom_site_label_atom_id_1
_geom_angle.atom_site_label_atom_id_2
_geom_angle.atom_site_label_atom_id_3
_geom_angle.atom_site_label_comp_id_1
_geom_angle.atom_site_label_comp_id_2
_geom_angle.atom_site_label_comp_id_3
_geom_angle.atom_site_label_seq_id_1
_geom_angle.atom_site_label_seq_id_2
_geom_angle.atom_site_label_seq_id_3

_geom_angle_[ms]
_geom_angle_av
_geom_angle_DHA
_geom_angle.value
_geom_angle.value_esd
_geom_angle_max
_geom_angle_min
_geom_angle_site_ssg_symmetry_1
_geom_angle_site_ssg_symmetry_2
_geom_angle_site_ssg_symmetry_3
_geom_angle_site_symmetry_1
_geom_angle.site_symmetry_1
_geom_angle_site_symmetry_2
_geom_angle.site_symmetry_2
_geom_angle_site_symmetry_3
_geom_angle.site_symmetry_3
_geom_angle_publ_flag
_geom_angle.publ_flag

_geom_bond_[]
_geom_bond.atom_site_auth_asym_id_1
_geom_bond.atom_site_auth_asym_id_2
_geom_bond.atom_site_auth_atom_id_1
_geom_bond.atom_site_auth_atom_id_2
_geom_bond.atom_site_auth_comp_id_1
_geom_bond.atom_site_auth_comp_id_2
_geom_bond.atom_site_auth_seq_id_1
_geom_bond.atom_site_auth_seq_id_2
_geom_bond.atom_site_id_1
_geom_bond.atom_site_id_2
_geom_bond_atom_site_label_1
_geom_bond_atom_site_label_2
_geom_bond_atom_site_label_A
_geom_bond.atom_site_label_alt_id_1
_geom_bond.atom_site_label_alt_id_2
_geom_bond.atom_site_label_asym_id_1
_geom_bond.atom_site_label_asym_id_2
_geom_bond.atom_site_label_atom_id_1
_geom_bond.atom_site_label_atom_id_2
_geom_bond.atom_site_label_comp_id_1
_geom_bond.atom_site_label_comp_id_2
_geom_bond_atom_site_label_D
_geom_bond_atom_site_label_H
_geom_bond.atom_site_label_seq_id_1
_geom_bond.atom_site_label_seq_id_2
_geom_bond.dist
_geom_bond_distance
_geom_bond_distance_av
_geom_bond_distance_DH
_geom_bond_distance_max
_geom_bond_distance_min
_geom_bond_distance_nm
_geom_bond_distance_pm
_geom_bond.dist_esd
_geom_bond_multiplicity
_geom_bond_[ms]
_geom_bond_publ_flag
_geom_bond.publ_flag
_geom_bond_site_ssg_symmetry_1
_geom_bond_site_ssg_symmetry_2
_geom_bond_site_symmetry_1
_geom_bond.site_symmetry_1
_geom_bond_site_symmetry_2
_geom_bond.site_symmetry_2
_geom_bond_valence
_geom_bond.valence
_geom_contact_[]
_geom_contact.atom_site_auth_asym_id_1
_geom_contact.atom_site_auth_asym_id_2
_geom_contact.atom_site_auth_atom_id_1
_geom_contact.atom_site_auth_atom_id_2
_geom_contact.atom_site_auth_comp_id_1
_geom_contact.atom_site_auth_comp_id_2
_geom_contact.atom_site_auth_seq_id_1
_geom_contact.atom_site_auth_seq_id_2
_geom_contact.atom_site_id_1
_geom_contact.atom_site_id_2
_geom_contact_atom_site_label_1
_geom_contact_atom_site_label_2
_geom_contact.atom_site_label_alt_id_1
_geom_contact.atom_site_label_alt_id_2
_geom_contact.atom_site_label_asym_id_1
_geom_contact.atom_site_label_asym_id_2
_geom_contact.atom_site_label_atom_id_1
_geom_contact.atom_site_label_atom_id_2
_geom_contact.atom_site_label_comp_id_1
_geom_contact.atom_site_label_comp_id_2
_geom_contact.atom_site_label_seq_id_1
_geom_contact.atom_site_label_seq_id_2
_geom_contact.dist
_geom_contact_distance
_geom_contact_distance_av
_geom_contact_distance_DA
_geom_contact_distance_HA
_geom_contact_distance_max
_geom_contact_distance_min
_geom_contact_distance_nm
_geom_contact_distance_pm
_geom_contact.dist_esd
_geom_contact_[ms]
_geom_contact_site_ssg_symmetry_1
_geom_contact_site_ssg_symmetry_2
_geom_contact_site_symmetry_1
_geom_contact.site_symmetry_1
_geom_contact_site_symmetry_2
_geom_contact.site_symmetry_2
_geom_contact_site_symmetry_A
_geom_contact_site_symmetry_D
_geom_contact_site_symmetry_H
_geom_contact_publ_flag
_geom_contact.publ_flag
_geom.details
_geom.entry_id
_geom_extra_table_[]
_geom_extra_tableA_col_1
_geom_extra_tableA_col_10
_geom_extra_tableA_col_11
_geom_extra_tableA_col_12
_geom_extra_tableA_col_13
_geom_extra_tableA_col_14
_geom_extra_tableA_col_2
_geom_extra_tableA_col_3
_geom_extra_tableA_col_4
_geom_extra_tableA_col_5
_geom_extra_tableA_col_6
_geom_extra_tableA_col_7
_geom_extra_tableA_col_8
_geom_extra_tableA_col_9
_geom_extra_tableB_col_1
_geom_extra_tableB_col_10
_geom_extra_tableB_col_11
_geom_extra_tableB_col_12
_geom_extra_tableB_col_13
_geom_extra_tableB_col_14
_geom_extra_tableB_col_2
_geom_extra_tableB_col_3
_geom_extra_tableB_col_4
_geom_extra_tableB_col_5
_geom_extra_tableB_col_6
_geom_extra_tableB_col_7
_geom_extra_tableB_col_8
_geom_extra_tableB_col_9
_geom_extra_tableC_col_1
_geom_extra_tableC_col_10
_geom_extra_tableC_col_11
_geom_extra_tableC_col_12
_geom_extra_tableC_col_13
_geom_extra_tableC_col_14
_geom_extra_tableC_col_2
_geom_extra_tableC_col_3
_geom_extra_tableC_col_4
_geom_extra_tableC_col_5
_geom_extra_tableC_col_6
_geom_extra_tableC_col_7
_geom_extra_tableC_col_8
_geom_extra_tableC_col_9
_geom_extra_table_head_A
_geom_extra_table_head_B
_geom_extra_table_head_C
_geom_extra_tables_[]
_geom_hbond_[]
_geom_hbond_angle_DHA
_geom_hbond.angle_DHA
_geom_hbond.angle_DHA_esd
_geom_hbond.atom_site_auth_asym_id_A
_geom_hbond.atom_site_auth_asym_id_D
_geom_hbond.atom_site_auth_asym_id_H
_geom_hbond.atom_site_auth_atom_id_A
_geom_hbond.atom_site_auth_atom_id_D
_geom_hbond.atom_site_auth_atom_id_H
_geom_hbond.atom_site_auth_comp_id_A
_geom_hbond.atom_site_auth_comp_id_D
_geom_hbond.atom_site_auth_comp_id_H
_geom_hbond.atom_site_auth_seq_id_A
_geom_hbond.atom_site_auth_seq_id_D
_geom_hbond.atom_site_auth_seq_id_H
_geom_hbond.atom_site_id_A
_geom_hbond.atom_site_id_D
_geom_hbond.atom_site_id_H
_geom_hbond_atom_site_label_A
_geom_hbond.atom_site_label_alt_id_A
_geom_hbond.atom_site_label_alt_id_D
_geom_hbond.atom_site_label_alt_id_H
_geom_hbond.atom_site_label_asym_id_A
_geom_hbond.atom_site_label_asym_id_D
_geom_hbond.atom_site_label_asym_id_H
_geom_hbond.atom_site_label_atom_id_A
_geom_hbond.atom_site_label_atom_id_D
_geom_hbond.atom_site_label_atom_id_H
_geom_hbond.atom_site_label_comp_id_A
_geom_hbond.atom_site_label_comp_id_D
_geom_hbond.atom_site_label_comp_id_H
_geom_hbond_atom_site_label_D
_geom_hbond_atom_site_label_H
_geom_hbond.atom_site_label_seq_id_A
_geom_hbond.atom_site_label_seq_id_D
_geom_hbond.atom_site_label_seq_id_H
_geom_hbond_distance_DA
_geom_hbond_distance_DH
_geom_hbond_distance_HA
_geom_hbond.dist_DA
_geom_hbond.dist_DA_esd
_geom_hbond.dist_DH
_geom_hbond.dist_DH_esd
_geom_hbond.dist_HA
_geom_hbond.dist_HA_esd
_geom_hbond_publ_flag
_geom_hbond.publ_flag
_geom_hbond_site_symmetry_A
_geom_hbond.site_symmetry_A
_geom_hbond_site_symmetry_D
_geom_hbond.site_symmetry_D
_geom_hbond_site_symmetry_H
_geom_hbond.site_symmetry_H
_geom_special_details
_geom_table_footnote_A
_geom_table_footnote_B
_geom_table_footnote_C
_geom_table_headnote_A
_geom_table_headnote_B
_geom_table_headnote_C
_geom_torsion
_geom_torsion_[]
_geom_torsion.atom_site_auth_asym_id_1
_geom_torsion.atom_site_auth_asym_id_2
_geom_torsion.atom_site_auth_asym_id_3
_geom_torsion.atom_site_auth_asym_id_4
_geom_torsion.atom_site_auth_atom_id_1
_geom_torsion.atom_site_auth_atom_id_2
_geom_torsion.atom_site_auth_atom_id_3
_geom_torsion.atom_site_auth_atom_id_4
_geom_torsion.atom_site_auth_comp_id_1
_geom_torsion.atom_site_auth_comp_id_2
_geom_torsion.atom_site_auth_comp_id_3
_geom_torsion.atom_site_auth_comp_id_4
_geom_torsion.atom_site_auth_seq_id_1
_geom_torsion.atom_site_auth_seq_id_2
_geom_torsion.atom_site_auth_seq_id_3
_geom_torsion.atom_site_auth_seq_id_4
_geom_torsion.atom_site_id_1
_geom_torsion.atom_site_id_2
_geom_torsion.atom_site_id_3
_geom_torsion.atom_site_id_4
_geom_torsion_atom_site_label_1
_geom_torsion_atom_site_label_2
_geom_torsion_atom_site_label_3
_geom_torsion_atom_site_label_4
_geom_torsion.atom_site_label_alt_id_1
_geom_torsion.atom_site_label_alt_id_2
_geom_torsion.atom_site_label_alt_id_3
_geom_torsion.atom_site_label_alt_id_4
_geom_torsion.atom_site_label_asym_id_1
_geom_torsion.atom_site_label_asym_id_2
_geom_torsion.atom_site_label_asym_id_3
_geom_torsion.atom_site_label_asym_id_4
_geom_torsion.atom_site_label_atom_id_1
_geom_torsion.atom_site_label_atom_id_2
_geom_torsion.atom_site_label_atom_id_3
_geom_torsion.atom_site_label_atom_id_4
_geom_torsion.atom_site_label_comp_id_1
_geom_torsion.atom_site_label_comp_id_2
_geom_torsion.atom_site_label_comp_id_3
_geom_torsion.atom_site_label_comp_id_4
_geom_torsion.atom_site_label_seq_id_1
_geom_torsion.atom_site_label_seq_id_2
_geom_torsion.atom_site_label_seq_id_3
_geom_torsion.atom_site_label_seq_id_4
_geom_torsion_[ms]
_geom_torsion_av
_geom_torsion_max
_geom_torsion_min
_geom_torsion_site_ssg_symmetry_1
_geom_torsion_site_ssg_symmetry_2
_geom_torsion_site_ssg_symmetry_3
_geom_torsion_site_ssg_symmetry_4
_geom_torsion_site_symmetry_1
_geom_torsion.site_symmetry_1
_geom_torsion_site_symmetry_2
_geom_torsion.site_symmetry_2
_geom_torsion_site_symmetry_3
_geom_torsion.site_symmetry_3
_geom_torsion_site_symmetry_4
_geom_torsion.site_symmetry_4
_geom_torsion_publ_flag
_geom_torsion.publ_flag
_geom_torsion.value
_geom_torsion.value_esd
_item_aliases.alias_name
_item_aliases.dictionary
_item_aliases.name
_item_aliases.version
_item.category_id
_item_default.name
_item_default.value
_item_dependent.dependent_name
_item_dependent.name
_item_description.description
_item_description.name
_item_enumeration.detail
_item_enumeration.name
_item_enumeration.value
_item_examples.case
_item_examples.detail
_item_examples.name
_item_linked.child_name
_item_linked.parent_name
_item.mandatory_code
_item_methods.method_id
_item_methods.name
_item.name
_item_range.maximum
_item_range.minimum
_item_range.name
_item_related.function_code
_item_related.name
_item_related.related_name
_item_structure.code
_item_structure_list.code
_item_structure_list.dimension
_item_structure_list.index
_item_structure.name
_item_structure.organization
_item_sub_category.id
_item_sub_category.name
_item_type.code
_item_type_conditions.code
_item_type_conditions.name
_item_type_list.code
_item_type_list.construct
_item_type_list.detail
_item_type_list.primitive_code
_item_type.name
_item_units.code
_item_units_conversion.factor
_item_units_conversion.from_code
_item_units_conversion.operator
_item_units_conversion.to_code
_item_units_list.code
_item_units_list.detail
_item_units.name
_iucr_compatibility_tag
_list
_list_level
_list_link_child
_list_link_parent
_list_mandatory
_list_reference
_list_uniqueness
_method_list.code
_method_list.detail
_method_list.id
_method_list.inline
_method_list.language
_name
_ndb_category_description.description
_ndb_category_description.id
_ndb_category_examples.case
_ndb_category_examples.detail
_ndb_category_examples.id
_ndb_item_description.description
_ndb_item_description.name
_ndb_item_enumeration.detail
_ndb_item_enumeration.name
_ndb_item_enumeration.value
_ndb_item_examples.case
_ndb_item_examples.detail
_ndb_item_examples.name
);

my @unclassified_tags_part_2 = qw(
_pd_block_[pd]
_pd_calc_[pd]
_pd_calib_[pd]
_pd_char_[pd]
_pd_data_[pd]
_pd_instr_[pd]
_pd_meas_[pd]
_pd_peak_[pd]
_pd_prep_[pd]
_pd_proc_ls_[pd]
_pd_phase_[pd]
_pd_proc_[pd]
_pd_refln_[pd]
_pd_spec_[pd]
_phasing_averaging.details
_phasing_averaging.entry_id
_phasing_averaging.method
_phasing_isomorphous.details
_phasing_isomorphous.entry_id
_phasing_isomorphous.method
_phasing_isomorphous.parent
_phasing_MAD_clust.expt_id
_phasing_MAD_clust.id
_phasing_MAD_clust.number_set
_phasing_mad.details
_phasing_MAD.details
_phasing_mad.entry_id
_phasing_MAD.entry_id
_phasing_MAD_expt.delta_delta_phi
_phasing_MAD_expt.delta_phi
_phasing_MAD_expt.delta_phi_sigma
_phasing_MAD_expt.id
_phasing_MAD_expt.mean_fom
_phasing_MAD_expt.number_clust
_phasing_MAD_expt.R_normal_all
_phasing_MAD_expt.R_normal_anom_scat
_phasing_mad.method
_phasing_MAD.method
_phasing_MAD_ratio.clust_id
_phasing_MAD_ratio.d_res_high
_phasing_MAD_ratio.d_res_low
_phasing_MAD_ratio.expt_id
_phasing_MAD_ratio.ratio_one_wl
_phasing_MAD_ratio.ratio_one_wl_centric
_phasing_MAD_ratio.ratio_two_wl
_phasing_MAD_ratio.wavelength_1
_phasing_MAD_ratio.wavelength_2
_phasing_MAD_set.clust_id
_phasing_MAD_set.d_res_high
_phasing_MAD_set.d_res_low
_phasing_MAD_set.expt_id
_phasing_MAD_set.f_double_prime
_phasing_MAD_set.f_prime
_phasing_MAD_set.set_id
_phasing_MAD_set.wavelength
_phasing_MAD_set.wavelength_details
_phasing.method
_phasing_MIR_der.der_set_id
_phasing_MIR_der.details
_phasing_MIR_der.d_res_high
_phasing_MIR_der.d_res_low
_phasing_MIR_der.id
_phasing_MIR_der.native_set_id
_phasing_MIR_der.number_of_sites
_phasing_MIR_der.power_acentric
_phasing_MIR_der.power_centric
_phasing_MIR_der.R_cullis_acentric
_phasing_MIR_der.R_cullis_anomalous
_phasing_MIR_der.R_cullis_centric
_phasing_MIR_der_refln.der_id
_phasing_MIR_der_refln.F_calc
_phasing_MIR_der_refln.F_calc_au
_phasing_MIR_der_refln.F_meas
_phasing_MIR_der_refln.F_meas_au
_phasing_MIR_der_refln.F_meas_sigma
_phasing_MIR_der_refln.F_meas_sigma_au
_phasing_MIR_der_refln.HL_A_iso
_phasing_MIR_der_refln.HL_B_iso
_phasing_MIR_der_refln.HL_C_iso
_phasing_MIR_der_refln.HL_D_iso
_phasing_MIR_der_refln.index_h
_phasing_MIR_der_refln.index_k
_phasing_MIR_der_refln.index_l
_phasing_MIR_der_refln.phase_calc
_phasing_MIR_der.reflns_acentric
_phasing_MIR_der.reflns_anomalous
_phasing_MIR_der.reflns_centric
_phasing_MIR_der.reflns_criteria
_phasing_MIR_der_refln.set_id
_phasing_MIR_der_shell.der_id
_phasing_MIR_der_shell.d_res_high
_phasing_MIR_der_shell.d_res_low
_phasing_MIR_der_shell.fom
_phasing_MIR_der_shell.ha_ampl
_phasing_MIR_der_shell.loc
_phasing_MIR_der_shell.phase
_phasing_MIR_der_shell.power
_phasing_MIR_der_shell.R_cullis
_phasing_MIR_der_shell.reflns
_phasing_MIR_der_shell.R_kraut
_phasing_MIR_der_site.atom_type_symbol
_phasing_MIR_der_site.B_iso
_phasing_MIR_der_site.B_iso_esd
_phasing_MIR_der_site.Cartn_x
_phasing_MIR_der_site.Cartn_x_esd
_phasing_MIR_der_site.Cartn_y
_phasing_MIR_der_site.Cartn_y_esd
_phasing_MIR_der_site.Cartn_z
_phasing_MIR_der_site.Cartn_z_esd
_phasing_MIR_der_site.der_id
_phasing_MIR_der_site.details
_phasing_MIR_der_site.fract_x
_phasing_MIR_der_site.fract_x_esd
_phasing_MIR_der_site.fract_y
_phasing_MIR_der_site.fract_y_esd
_phasing_MIR_der_site.fract_z
_phasing_MIR_der_site.fract_z_esd
_phasing_MIR_der_site.id
_phasing_MIR_der_site.occupancy
_phasing_MIR_der_site.occupancy_anom
_phasing_MIR_der_site.occupancy_anom_su
_phasing_MIR_der_site.occupancy_iso
_phasing_MIR_der_site.occupancy_iso_su
_phasing_mir.details
_phasing_MIR.details
_phasing_MIR.d_res_high
_phasing_MIR.d_res_low
_phasing_mir.entry_id
_phasing_MIR.entry_id
_phasing_MIR.FOM
_phasing_MIR.FOM_acentric
_phasing_MIR.FOM_centric
_phasing_mir.method
_phasing_MIR.method
_phasing_MIR.reflns
_phasing_MIR.reflns_acentric
_phasing_MIR.reflns_centric
_phasing_MIR.reflns_criterion
_phasing_MIR_shell.d_res_high
_phasing_MIR_shell.d_res_low
_phasing_MIR_shell.fom
_phasing_MIR_shell.FOM
_phasing_MIR_shell.FOM_acentric
_phasing_MIR_shell.FOM_centric
_phasing_MIR_shell.loc
_phasing_MIR_shell.mean_phase
_phasing_MIR_shell.power
_phasing_MIR_shell.R_cullis
_phasing_MIR_shell.reflns
_phasing_MIR_shell.reflns_acentric
_phasing_MIR_shell.reflns_anomalous
_phasing_MIR_shell.reflns_centric
_phasing_MIR_shell.R_kraut
_phasing_set.cell_angle_alpha
_phasing_set.cell_angle_beta
_phasing_set.cell_angle_gamma
_phasing_set.cell_length_a
_phasing_set.cell_length_b
_phasing_set.cell_length_c
_phasing_set.detector_specific
_phasing_set.detector_type
_phasing_set.id
_phasing_set.radiation_source_specific
_phasing_set.radiation_wavelength
_phasing_set_refln.F_meas
_phasing_set_refln.F_meas_au
_phasing_set_refln.F_meas_sigma
_phasing_set_refln.F_meas_sigma_au
_phasing_set_refln.index_h
_phasing_set_refln.index_k
_phasing_set_refln.index_l
_phasing_set_refln.set_id
_phasing_set.temp
_platon_squeeze_details
_platon_squeeze_void_average_x
_platon_squeeze_void_average_y
_platon_squeeze_void_average_z
_platon_squeeze_void_content
_platon_squeeze_void_count_electrons
_platon_squeeze_void_nr
_platon_squeeze_void_volume
_refine_[]
_refine_analyze.entry_id
_refine_analyze.Luzzati_coordinate_error_free
_refine_analyze.Luzzati_coordinate_error_obs
_refine_analyze.Luzzati_d_res_low_free
_refine_analyze.Luzzati_d_res_low_obs
_refine_analyze.Luzzati_sigma_a_free
_refine_analyze.Luzzati_sigma_a_free_details
_refine_analyze.Luzzati_sigma_a_obs
_refine_analyze.Luzzati_sigma_a_obs_details
_refine_analyze.number_disordered_residues
_refine_analyze.occupancy_sum_hydrogen
_refine_analyze.occupancy_sum_non_hydrogen
_refine_analyze.RG_d_res_high
_refine_analyze.RG_d_res_low
_refine_analyze.RG_free
_refine_analyze.RG_free_work_ratio
_refine_analyze.RG_work
_refine.aniso_B[1][1]
_refine.aniso_B[1][2]
_refine.aniso_B[1][3]
_refine.aniso_B[2][2]
_refine.aniso_B[2][3]
_refine.aniso_B[3][3]
_refine_B_iso.class
_refine_B_iso.details
_refine.B_iso_max
_refine.B_iso_mean
_refine.B_iso_min
_refine_B_iso.treatment
_refine_B_iso.value
_refine.correlation_coeff_Fo_to_Fc
_refine.correlation_coeff_Fo_to_Fc_free
_refine.details
_refine_diff_density_max
_refine.diff_density_max
_refine.diff_density_max_esd
_refine_diff_density_max_nm
_refine_diff_density_max_pm
_refine_diff_density_min
_refine.diff_density_min
_refine.diff_density_min_esd
_refine_diff_density_min_nm
_refine_diff_density_min_pm
_refine_diff_density_rms
_refine.diff_density_rms
_refine.diff_density_rms_esd
_refine_diff_density_rms_nm
_refine_diff_density_rms_pm
_refine.entry_id
_refine_funct_minimized.number_terms
_refine_funct_minimized.residual
_refine_funct_minimized.type
_refine_funct_minimized.weight
_refine_hist.cycle_id
_refine_hist.details
_refine_hist.d_res_high
_refine_hist.d_res_low
_refine_hist.number_atoms_solvent
_refine_hist.number_atoms_total
_refine_hist.number_reflns_all
_refine_hist.number_reflns_obs
_refine_hist.number_reflns_R_free
_refine_hist.number_reflns_R_work
_refine_hist.R_factor_all
_refine_hist.R_factor_obs
_refine_hist.R_factor_R_free
_refine_hist.R_factor_R_work
_refine_ls_abs_structure_details
_refine.ls_abs_structure_details
_refine_ls_abs_structure_Flack
_refine.ls_abs_structure_Flack
_refine.ls_abs_structure_Flack_esd
_refine_ls_abs_structure_Rogers
_refine.ls_abs_structure_Rogers
_refine.ls_abs_structure_Rogers_esd
_refine_ls_class_[]
_refine_ls_class_code
_refine_ls_class.code
_refine_ls_class_d_res_high
_refine_ls_class.d_res_high
_refine_ls_class_d_res_low
_refine_ls_class.d_res_low
_refine_ls_class_R_factor_all
_refine_ls_class.R_factor_all
_refine_ls_class_R_factor_gt
_refine_ls_class.R_factor_gt
_refine_ls_class_R_Fsqd_factor
_refine_ls_class.R_Fsqd_factor
_refine_ls_class_R_I_factor
_refine_ls_class.R_I_factor
_refine_ls_class_wR_factor_all
_refine_ls_class.wR_factor_all
_refine_ls_d_res_high
_refine.ls_d_res_high
_refine_ls_d_res_low
_refine.ls_d_res_low
_refine_ls_extinction_coef
_refine.ls_extinction_coef
_refine.ls_extinction_coef_esd
_refine_ls_extinction_expression
_refine.ls_extinction_expression
_refine_ls_extinction_method
_refine.ls_extinction_method
_refine_ls_F_calc_details
_refine_ls_F_calc_formula
_refine_ls_F_calc_precision
_refine_ls_goodness_of_fit_all
_refine.ls_goodness_of_fit_all
_refine.ls_goodness_of_fit_all_esd
_refine_ls_goodness_of_fit_gt
_refine.ls_goodness_of_fit_gt
_refine_ls_goodness_of_fit_obs
_refine.ls_goodness_of_fit_obs
_refine.ls_goodness_of_fit_obs_esd
_refine_ls_goodness_of_fit_ref
_refine.ls_goodness_of_fit_ref
_refine_ls_hydrogen_treatment
_refine.ls_hydrogen_treatment
_refine_ls_matrix_type
_refine.ls_matrix_type
_refine_[ms]
_refine_ls_mod_func_description
_refine_ls_mod_hydrogen_treatment
_refine_ls_mod_overall_phason_coeff
_refine_ls_mod_overall_phason_formula
_refine_ls_number_constraints
_refine.ls_number_constraints
_refine_ls_number_parameters
_refine.ls_number_parameters
_refine_ls_number_reflns
_refine.ls_number_reflns_all
_refine.ls_number_reflns_obs
_refine.ls_number_reflns_R_free
_refine.ls_number_reflns_R_work
_refine_ls_number_restraints
_refine.ls_number_restraints
_refine.ls_percent_reflns_obs
_refine.ls_percent_reflns_R_free
_refine.ls_redundancy_reflns_all
_refine.ls_redundancy_reflns_obs
_refine_ls_restrained_S_all
_refine.ls_restrained_S_all
_refine_ls_restrained_S_gt
_refine_ls_restrained_S_obs
_refine.ls_restrained_S_obs
_refine_ls_restr.criterion
_refine_ls_restr.dev_ideal
_refine_ls_restr.dev_ideal_target
_refine_ls_restr_ncs.dom_id
_refine_ls_restr_ncs.ncs_model_details
_refine_ls_restr_ncs.rms_dev_B_iso
_refine_ls_restr_ncs.rms_dev_position
_refine_ls_restr_ncs.weight_B_iso
_refine_ls_restr_ncs.weight_position
_refine_ls_restr.number
_refine_ls_restr.rejects
_refine_ls_restr.type
_refine_ls_restr_type.distance_cutoff_high
_refine_ls_restr_type.distance_cutoff_low
_refine_ls_restr_type.type
_refine_ls_restr.weight
_refine_ls_R_factor_all
_refine.ls_R_factor_all
_refine_ls_R_factor_gt
_refine.ls_R_factor_gt
_refine_ls_R_factor_obs
_refine.ls_R_factor_obs
_refine.ls_R_factor_R_free
_refine.ls_R_factor_R_free_error
_refine.ls_R_factor_R_free_error_details
_refine.ls_R_factor_R_work
_refine_ls_R_Fsqd_factor
_refine.ls_R_Fsqd_factor_obs
_refine_ls_R_I_factor
_refine.ls_R_I_factor_obs
_refine_ls_shell.d_res_high
_refine_ls_shell.d_res_low
_refine_ls_shell.number_reflns_all
_refine_ls_shell.number_reflns_obs
_refine_ls_shell.number_reflns_R_free
_refine_ls_shell.number_reflns_R_work
_refine_ls_shell.percent_reflns_obs
_refine_ls_shell.percent_reflns_R_free
_refine_ls_shell.redundancy_reflns_all
_refine_ls_shell.redundancy_reflns_obs
_refine_ls_shell.R_factor_all
_refine_ls_shell.R_factor_obs
_refine_ls_shell.R_factor_R_free
_refine_ls_shell.R_factor_R_free_error
_refine_ls_shell.R_factor_R_work
_refine_ls_shell.wR_factor_all
_refine_ls_shell.wR_factor_obs
_refine_ls_shell.wR_factor_R_free
_refine_ls_shell.wR_factor_R_work
_refine_ls_shift/esd_max
_refine_ls_shift/esd_mean
_refine.ls_shift_over_esd_max
_refine.ls_shift_over_esd_mean
_refine.ls_shift_over_su_max
_refine.ls_shift_over_su_max_lt
_refine.ls_shift_over_su_mean
_refine.ls_shift_over_su_mean_lt
_refine_ls_shift/su_max
_refine_ls_shift/su_max_lt
_refine_ls_shift/su_mean
_refine_ls_shift/su_mean_lt
_refine_ls_structure_factor_coef
_refine.ls_structure_factor_coef
_refine_ls_weighting_details
_refine.ls_weighting_details
_refine_ls_weighting_scheme
_refine.ls_weighting_scheme
_refine_ls_wR_factor_all
_refine.ls_wR_factor_all
_refine_ls_wR_factor_gt
_refine_ls_wR_factor_obs
_refine.ls_wR_factor_obs
_refine_ls_wR_factor_ref
_refine.ls_wR_factor_R_free
_refine.ls_wR_factor_R_work
_refine_occupancy.class
_refine_occupancy.details
_refine.occupancy_max
_refine.occupancy_min
_refine_occupancy.treatment
_refine_occupancy.value
_refine.overall_FOM_free_R_set
_refine.overall_FOM_work_R_set
_refine.overall_SU_B
_refine.overall_SU_ML
_refine.overall_SU_R_Cruickshank_DPI
_refine.overall_SU_R_free
_refine.solvent_model_details
_refine.solvent_model_param_bsol
_refine.solvent_model_param_ksol
_refine_special_details
_refln_[]
_refln_A_calc
_refln.A_calc
_refln.A_calc_au
_refln_A_meas
_refln.A_meas
_refln.A_meas_au
_refln_B_calc
_refln.B_calc
_refln.B_calc_au
_refln_B_meas
_refln.B_meas
_refln.B_meas_au
_refln_class_code
_refln.class_code
_refln_crystal_id
_refln.crystal_id
_refln_d_spacing
_refln.d_spacing
_refln_F_calc
_refln.F_calc
_refln.F_calc_au
_refln_F_meas
_refln.F_meas
_refln.F_meas_au
_refln.F_meas_sigma
_refln.F_meas_sigma_au
_refln.fom
_refln_F_sigma
_refln_F_squared_calc
_refln.F_squared_calc
_refln_F_squared_meas
_refln.F_squared_meas
_refln_F_squared_sigma
_refln.F_squared_sigma
_refln_include_status
_refln.include_status
_refln_index_h
_refln.index_h
_refln_index_k
_refln.index_k
_refln_index_l
_refln.index_l
_refln_[ms]
_refln_index_m_1
_refln_index_m_2
_refln_index_m_3
_refln_index_m_4
_refln_index_m_5
_refln_index_m_6
_refln_index_m_7
_refln_index_m_8
_refln_intensity_calc
_refln.intensity_calc
_refln_intensity_meas
_refln.intensity_meas
_refln_intensity_sigma
_refln.intensity_sigma
_refln_mean_path_length_tbar
_refln.mean_path_length_tbar
_refln_mean_path_length_tbar_cm
_refln_observed_status
_refln_phase_calc
_refln.phase_calc
_refln_phase_meas
_refln.phase_meas
_refln_refinement_status
_refln.refinement_status
_reflns_[]
_reflns.B_iso_Wilson_estimate
_refln_scale_group_code
_refln.scale_group_code
_reflns_class_[]
_reflns_class_code
_reflns_class.code
_reflns_class_description
_reflns_class.description
_reflns_class_d_res_high
_reflns_class.d_res_high
_reflns_class_d_res_low
_reflns_class.d_res_low
_reflns_class_number_gt
_reflns_class.number_gt
_reflns_class_number_total
_reflns_class.number_total
_reflns_class_R_factor_all
_reflns_class.R_factor_all
_reflns_class_R_factor_gt
_reflns_class.R_factor_gt
_reflns_class_R_Fsqd_factor
_reflns_class.R_Fsqd_factor
_reflns_class_R_I_factor
_reflns_class.R_I_factor
_reflns_class_wR_factor_all
_reflns_class.wR_factor_all
_reflns.data_reduction_details
_reflns.data_reduction_method
_reflns.details
_reflns_d_resolution_high
_reflns.d_resolution_high
_reflns_d_resolution_high_nm
_reflns_d_resolution_high_pm
_reflns_d_resolution_low
_reflns.d_resolution_low
_reflns_d_resolution_low_nm
_reflns_d_resolution_low_pm
_reflns.entry_id
_reflns_Friedel_coverage
_reflns.Friedel_coverage
_reflns_Friedel_fraction_full
_reflns_Friedel_fraction_max
_refln_sint/lambda
_refln_sint/lambda_nm
_refln_sint/lambda_pm
_refln.sint_over_lambda
_reflns_limit_h_max
_reflns.limit_h_max
_reflns_limit_h_min
_reflns.limit_h_min
_reflns_[ms]
_reflns_limit_index_m_1_max
_reflns_limit_index_m_1_min
_reflns_limit_index_m_2_max
_reflns_limit_index_m_2_min
_reflns_limit_index_m_3_max
_reflns_limit_index_m_3_min
_reflns_limit_index_m_4_max
_reflns_limit_index_m_4_min
_reflns_limit_index_m_5_max
_reflns_limit_index_m_5_min
_reflns_limit_index_m_6_max
_reflns_limit_index_m_6_min
_reflns_limit_index_m_7_max
_reflns_limit_index_m_7_min
_reflns_limit_index_m_8_max
_reflns_limit_index_m_8_min
_reflns_limit_k_max
_reflns.limit_k_max
_reflns_limit_k_min
_reflns.limit_k_min
_reflns_limit_l_max
_reflns.limit_l_max
_reflns_limit_l_min
_reflns.limit_l_min
_reflns.number_all
_reflns_number_gt
_reflns.number_gt
_reflns.number_obs
_reflns_number_observed
_reflns_number_total
_reflns_observed_criterion
_reflns.observed_criterion
_reflns.observed_criterion_F_max
_reflns.observed_criterion_F_min
_reflns.observed_criterion_I_max
_reflns.observed_criterion_I_min
_reflns.observed_criterion_sigma_F
_reflns.observed_criterion_sigma_I
_reflns.percent_possible_obs
_reflns.R_free_details
_reflns.Rmerge_F_all
_reflns.Rmerge_F_obs
_reflns_scale_[]
_reflns_scale_group_code
_reflns_scale.group_code
_reflns_scale_meas_F
_reflns_scale.meas_F
_reflns_scale_meas_F_squared
_reflns_scale.meas_F_squared
_reflns_scale_meas_intensity
_reflns_scale.meas_intensity
_reflns_shell_[]
_reflns_shell_d_res_high
_reflns_shell.d_res_high
_reflns_shell_d_res_low
_reflns_shell.d_res_low
_reflns_shell_meanI_over_sigI_all
_reflns_shell.meanI_over_sigI_all
_reflns_shell_meanI_over_sigI_gt
_reflns_shell.meanI_over_sigI_gt
_reflns_shell_meanI_over_sigI_obs
_reflns_shell.meanI_over_sigI_obs
_reflns_shell_meanI_over_uI_all
_reflns_shell.meanI_over_uI_all
_reflns_shell_meanI_over_uI_gt
_reflns_shell.meanI_over_uI_gt
_reflns_shell_number_measured_all
_reflns_shell.number_measured_all
_reflns_shell_number_measured_gt
_reflns_shell.number_measured_gt
_reflns_shell_number_measured_obs
_reflns_shell.number_measured_obs
_reflns_shell_number_possible
_reflns_shell.number_possible
_reflns_shell_number_unique_all
_reflns_shell.number_unique_all
_reflns_shell_number_unique_gt
_reflns_shell.number_unique_gt
_reflns_shell_number_unique_obs
_reflns_shell.number_unique_obs
_reflns_shell_percent_possible_all
_reflns_shell.percent_possible_all
_reflns_shell_percent_possible_gt
_reflns_shell.percent_possible_gt
_reflns_shell_percent_possible_obs
_reflns_shell.percent_possible_obs
_reflns_shell_Rmerge_F_all
_reflns_shell.Rmerge_F_all
_reflns_shell_Rmerge_F_gt
_reflns_shell.Rmerge_F_gt
_reflns_shell_Rmerge_F_obs
_reflns_shell.Rmerge_F_obs
_reflns_shell_Rmerge_I_all
_reflns_shell.Rmerge_I_all
_reflns_shell_Rmerge_I_gt
_reflns_shell.Rmerge_I_gt
_reflns_shell_Rmerge_I_obs
_reflns_shell.Rmerge_I_obs
_reflns_special_details
_refln.status
_reflns_threshold_expression
_reflns.threshold_expression
_refln_symmetry_epsilon
_refln.symmetry_epsilon
_refln_symmetry_multiplicity
_refln.symmetry_multiplicity
_refln_sys_abs.I
_refln_sys_abs.index_h
_refln_sys_abs.index_k
_refln_sys_abs.index_l
_refln_sys_abs.I_over_sigmaI
_refln_sys_abs.sigmaI
_refln_wavelength
_refln.wavelength
_refln_wavelength_id
_refln.wavelength_id
_refln_wavelength_nm
_refln_wavelength_pm
_related_function
_related_item
_software.citation_id
_software.classification
_software.compiler_name
_software.compiler_version
_software.contact_author
_software.contact_author_email
_software.date
_software.dependencies
_software.description
_software.hardware
_software.language
_software.location
_software.mods
_software.name
_software.os
_software.os_version
_software.type
_software.version
_struct_asym.details
_struct_asym.entity_id
_struct_asym.id
_struct_biol.details
_struct_biol_gen.asym_id
_struct_biol_gen.biol_id
_struct_biol_gen.details
_struct_biol_gen.symmetry
_struct_biol.id
_struct_biol_keywords.biol_id
_struct_biol_keywords.text
_struct_biol_view.biol_id
_struct_biol_view.details
_struct_biol_view.id
_struct_biol_view.rot_matrix[1][1]
_struct_biol_view.rot_matrix[1][2]
_struct_biol_view.rot_matrix[1][3]
_struct_biol_view.rot_matrix[2][1]
_struct_biol_view.rot_matrix[2][2]
_struct_biol_view.rot_matrix[2][3]
_struct_biol_view.rot_matrix[3][1]
_struct_biol_view.rot_matrix[3][2]
_struct_biol_view.rot_matrix[3][3]
_struct_conf.beg_auth_asym_id
_struct_conf.beg_auth_comp_id
_struct_conf.beg_auth_seq_id
_struct_conf.beg_label_asym_id
_struct_conf.beg_label_comp_id
_struct_conf.beg_label_seq_id
_struct_conf.conf_type_id
_struct_conf.details
_struct_conf.end_auth_asym_id
_struct_conf.end_auth_comp_id
_struct_conf.end_auth_seq_id
_struct_conf.end_label_asym_id
_struct_conf.end_label_comp_id
_struct_conf.end_label_seq_id
_struct_conf.id
_struct_conf_type.criteria
_struct_conf_type.id
_struct_conf_type.reference
_struct_conn.conn_type_id
_struct_conn.details
_struct_conn.id
_struct_conn.ptnr1_auth_asym_id
_struct_conn.ptnr1_auth_atom_id
_struct_conn.ptnr1_auth_comp_id
_struct_conn.ptnr1_auth_seq_id
_struct_conn.ptnr1_label_alt_id
_struct_conn.ptnr1_label_asym_id
_struct_conn.ptnr1_label_atom_id
_struct_conn.ptnr1_label_comp_id
_struct_conn.ptnr1_label_seq_id
_struct_conn.ptnr1_role
_struct_conn.ptnr1_symmetry
_struct_conn.ptnr2_auth_asym_id
_struct_conn.ptnr2_auth_atom_id
_struct_conn.ptnr2_auth_comp_id
_struct_conn.ptnr2_auth_seq_id
_struct_conn.ptnr2_label_alt_id
_struct_conn.ptnr2_label_asym_id
_struct_conn.ptnr2_label_atom_id
_struct_conn.ptnr2_label_comp_id
_struct_conn.ptnr2_label_seq_id
_struct_conn.ptnr2_role
_struct_conn.ptnr2_symmetry
_struct_conn_type.criteria
_struct_conn_type.id
_struct_conn_type.reference
_struct.entry_id
_struct_keywords.entry_id
_struct_keywords.text
_struct_mon_details.entry_id
_struct_mon_details.prot_cis
_struct_mon_details.RSCC
_struct_mon_details.RSR
_struct_mon_nucl.alpha
_struct_mon_nucl.auth_asym_id
_struct_mon_nucl.auth_comp_id
_struct_mon_nucl.auth_seq_id
_struct_mon_nucl.beta
_struct_mon_nucl.chi1
_struct_mon_nucl.chi2
_struct_mon_nucl.delta
_struct_mon_nucl.details
_struct_mon_nucl.epsilon
_struct_mon_nucl.gamma
_struct_mon_nucl.label_alt_id
_struct_mon_nucl.label_asym_id
_struct_mon_nucl.label_comp_id
_struct_mon_nucl.label_seq_id
_struct_mon_nucl.mean_B_all
_struct_mon_nucl.mean_B_base
_struct_mon_nucl.mean_B_phos
_struct_mon_nucl.mean_B_sugar
_struct_mon_nucl.nu0
_struct_mon_nucl.nu1
_struct_mon_nucl.nu2
_struct_mon_nucl.nu3
_struct_mon_nucl.nu4
_struct_mon_nucl.P
_struct_mon_nucl.RSCC_all
_struct_mon_nucl.RSCC_base
_struct_mon_nucl.RSCC_phos
_struct_mon_nucl.RSCC_sugar
_struct_mon_nucl.RSR_all
_struct_mon_nucl.RSR_base
_struct_mon_nucl.RSR_phos
_struct_mon_nucl.RSR_sugar
_struct_mon_nucl.tau0
_struct_mon_nucl.tau1
_struct_mon_nucl.tau2
_struct_mon_nucl.tau3
_struct_mon_nucl.tau4
_struct_mon_nucl.taum
_struct_mon_nucl.zeta
_struct_mon_prot.auth_asym_id
_struct_mon_prot.auth_comp_id
_struct_mon_prot.auth_seq_id
_struct_mon_prot.chi1
_struct_mon_prot.chi2
_struct_mon_prot.chi3
_struct_mon_prot.chi4
_struct_mon_prot.chi5
_struct_mon_prot_cis.auth_asym_id
_struct_mon_prot_cis.auth_comp_id
_struct_mon_prot_cis.auth_seq_id
_struct_mon_prot_cis.label_alt_id
_struct_mon_prot_cis.label_asym_id
_struct_mon_prot_cis.label_comp_id
_struct_mon_prot_cis.label_seq_id
_struct_mon_prot.details
_struct_mon_prot.label_alt_id
_struct_mon_prot.label_asym_id
_struct_mon_prot.label_comp_id
_struct_mon_prot.label_seq_id
_struct_mon_prot.mean_B_all
_struct_mon_prot.mean_B_main
_struct_mon_prot.mean_B_side
_struct_mon_prot.omega
_struct_mon_prot.phi
_struct_mon_prot.psi
_struct_mon_prot.RSCC_all
_struct_mon_prot.RSCC_main
_struct_mon_prot.RSCC_side
_struct_mon_prot.RSR_all
_struct_mon_prot.RSR_main
_struct_mon_prot.RSR_side
_struct_ncs_dom.details
_struct_ncs_dom.id
_struct_ncs_dom_lim.beg_auth_asym_id
_struct_ncs_dom_lim.beg_auth_comp_id
_struct_ncs_dom_lim.beg_auth_seq_id
_struct_ncs_dom_lim.beg_label_alt_id
_struct_ncs_dom_lim.beg_label_asym_id
_struct_ncs_dom_lim.beg_label_comp_id
_struct_ncs_dom_lim.beg_label_seq_id
_struct_ncs_dom_lim.dom_id
_struct_ncs_dom_lim.end_auth_asym_id
_struct_ncs_dom_lim.end_auth_comp_id
_struct_ncs_dom_lim.end_auth_seq_id
_struct_ncs_dom_lim.end_label_alt_id
_struct_ncs_dom_lim.end_label_asym_id
_struct_ncs_dom_lim.end_label_comp_id
_struct_ncs_dom_lim.end_label_seq_id
_struct_ncs_ens.details
_struct_ncs_ens_gen.dom_id_1
_struct_ncs_ens_gen.dom_id_2
_struct_ncs_ens_gen.ens_id
_struct_ncs_ens_gen.oper_id
_struct_ncs_ens.id
_struct_ncs_ens.point_group
_struct_ncs_oper.code
_struct_ncs_oper.details
_struct_ncs_oper.id
_struct_ncs_oper.matrix[1][1]
_struct_ncs_oper.matrix[1][2]
_struct_ncs_oper.matrix[1][3]
_struct_ncs_oper.matrix[2][1]
_struct_ncs_oper.matrix[2][2]
_struct_ncs_oper.matrix[2][3]
_struct_ncs_oper.matrix[3][1]
_struct_ncs_oper.matrix[3][2]
_struct_ncs_oper.matrix[3][3]
_struct_ncs_oper.vector[1]
_struct_ncs_oper.vector[2]
_struct_ncs_oper.vector[3]
_struct_ref.biol_id
_struct_ref.db_code
_struct_ref.db_name
_struct_ref.details
_struct_ref.entity_id
_struct_ref.id
_struct_ref.seq_align
_struct_ref_seq.align_id
_struct_ref_seq.db_align_beg
_struct_ref_seq.db_align_end
_struct_ref_seq.details
_struct_ref.seq_dif
_struct_ref_seq_dif.align_id
_struct_ref_seq_dif.db_mon_id
_struct_ref_seq_dif.details
_struct_ref_seq_dif.mon_id
_struct_ref_seq_dif.seq_num
_struct_ref_seq.ref_id
_struct_ref_seq.seq_align_beg
_struct_ref_seq.seq_align_end
_struct_sheet.details
_struct_sheet_hbond.range_1_beg_auth_atom_id
_struct_sheet_hbond.range_1_beg_auth_seq_id
_struct_sheet_hbond.range_1_beg_label_atom_id
_struct_sheet_hbond.range_1_beg_label_seq_id
_struct_sheet_hbond.range_1_end_auth_atom_id
_struct_sheet_hbond.range_1_end_auth_seq_id
_struct_sheet_hbond.range_1_end_label_atom_id
_struct_sheet_hbond.range_1_end_label_seq_id
_struct_sheet_hbond.range_2_beg_auth_atom_id
_struct_sheet_hbond.range_2_beg_auth_seq_id
_struct_sheet_hbond.range_2_beg_label_atom_id
_struct_sheet_hbond.range_2_beg_label_seq_id
_struct_sheet_hbond.range_2_end_auth_atom_id
_struct_sheet_hbond.range_2_end_auth_seq_id
_struct_sheet_hbond.range_2_end_label_atom_id
_struct_sheet_hbond.range_2_end_label_seq_id
_struct_sheet_hbond.range_id_1
_struct_sheet_hbond.range_id_2
_struct_sheet_hbond.sheet_id
_struct_sheet.id
_struct_sheet.number_strands
_struct_sheet_order.offset
_struct_sheet_order.range_id_1
_struct_sheet_order.range_id_2
_struct_sheet_order.sense
_struct_sheet_order.sheet_id
_struct_sheet_range.beg_auth_asym_id
_struct_sheet_range.beg_auth_comp_id
_struct_sheet_range.beg_auth_seq_id
_struct_sheet_range.beg_label_asym_id
_struct_sheet_range.beg_label_comp_id
_struct_sheet_range.beg_label_seq_id
_struct_sheet_range.end_auth_asym_id
_struct_sheet_range.end_auth_comp_id
_struct_sheet_range.end_auth_seq_id
_struct_sheet_range.end_label_asym_id
_struct_sheet_range.end_label_comp_id
_struct_sheet_range.end_label_seq_id
_struct_sheet_range.id
_struct_sheet_range.sheet_id
_struct_sheet_range.symmetry
_struct_sheet_topology.offset
_struct_sheet_topology.range_id_1
_struct_sheet_topology.range_id_2
_struct_sheet_topology.sense
_struct_sheet_topology.sheet_id
_struct_sheet.type
_struct_site.details
_struct_site_gen.auth_asym_id
_struct_site_gen.auth_atom_id
_struct_site_gen.auth_comp_id
_struct_site_gen.auth_seq_id
_struct_site_gen.details
_struct_site_gen.id
_struct_site_gen.label_alt_id
_struct_site_gen.label_asym_id
_struct_site_gen.label_atom_id
_struct_site_gen.label_comp_id
_struct_site_gen.label_seq_id
_struct_site_gen.site_id
_struct_site_gen.symmetry
_struct_site.id
_struct_site_keywords.site_id
_struct_site_keywords.text
_struct_site_view.details
_struct_site_view.id
_struct_site_view.rot_matrix[1][1]
_struct_site_view.rot_matrix[1][2]
_struct_site_view.rot_matrix[1][3]
_struct_site_view.rot_matrix[2][1]
_struct_site_view.rot_matrix[2][2]
_struct_site_view.rot_matrix[2][3]
_struct_site_view.rot_matrix[3][1]
_struct_site_view.rot_matrix[3][2]
_struct_site_view.rot_matrix[3][3]
_struct_site_view.site_id
_struct.title
_sub_category.description
_sub_category_examples.case
_sub_category_examples.detail
_sub_category_examples.id
_sub_category.id
_sub_category_methods.method_id
_sub_category_methods.sub_category_id
_type
_type_conditions
_type_construct
_units
_units_detail
_valence_param_[]
_valence_param_atom_1
_valence_param.atom_1
_valence_param_atom_1_valence
_valence_param.atom_1_valence
_valence_param_atom_2
_valence_param.atom_2
_valence_param_atom_2_valence
_valence_param.atom_2_valence
_valence_param_B
_valence_param.B
_valence_param_details
_valence_param.details
_valence_param_id
_valence_param.id
_valence_param_ref_id
_valence_param.ref_id
_valence_param_Ro
_valence_param.Ro
_valence_ref_[]
_valence_ref_id
_valence_ref.id
_valence_ref_reference
_valence_ref.reference
_vrf_[]
_vrf_VALIDATOR_comments

_oxford_atom_site_special_shape
_oxford_diffrn_Wilson_B_factor
_oxford_diffrn_Wilson_scale
_oxford_refine_ls_r_factor_ref
_oxford_refine_ls_scale
_oxford_reflns_number_all
_oxford_reflns_threshold_expression_ref
_oxford_structure_analysis_title
_oxford_twin_element_scale_factors

_chemical_identifier_inchi
_chemical_identifier_inchi_key
_chemical_identifier_inchi_version

_iucr_refine_instructions_details

_journal_article_reference
_journal_pages_number
_journal_article_page_count
);

# Dictionary name: cif_pd.dic 
# Dictionary version: 1.0.1
# Last updated on: 2005-06-14
# Retrieved on: 2020-02-14
# Retrieved from: ftp://ftp.iucr.org/pub/cif_pd.dic
my @cif_pd_tags = qw(
    _pd_block_diffractogram_id
    _pd_block_id
    _pd_calc_intensity_net
    _pd_calc_intensity_total
    _pd_calc_method
    _pd_calc_point_id
    _pd_calib_2theta_off_max
    _pd_calib_2theta_off_min
    _pd_calib_2theta_off_point
    _pd_calib_2theta_offset
    _pd_calib_detector_id
    _pd_calib_detector_response
    _pd_calibration_conversion_eqn
    _pd_calibration_special_details
    _pd_calib_std_external_block_id
    _pd_calib_std_external_name
    _pd_calib_std_internal_mass_%
    _pd_calib_std_internal_name
    _pd_char_atten_coef_mu_calc
    _pd_char_atten_coef_mu_obs
    _pd_char_colour
    _pd_char_particle_morphology
    _pd_char_special_details
    _pd_data_point_id
    _pd_instr_2theta_monochr_post
    _pd_instr_2theta_monochr_pre
    _pd_instr_beam_size_ax
    _pd_instr_beam_size_eq
    _pd_instr_cons_illum_flag
    _pd_instr_cons_illum_len
    _pd_instr_dist_anal/detc
    _pd_instr_dist_mono/spec
    _pd_instr_dist_spec/anal
    _pd_instr_dist_spec/detc
    _pd_instr_dist_src/mono
    _pd_instr_dist_src/spec
    _pd_instr_divg_ax_anal/detc
    _pd_instr_divg_ax_mono/spec
    _pd_instr_divg_ax_spec/anal
    _pd_instr_divg_ax_spec/detc
    _pd_instr_divg_ax_src/mono
    _pd_instr_divg_ax_src/spec
    _pd_instr_divg_eq_anal/detc
    _pd_instr_divg_eq_mono/spec
    _pd_instr_divg_eq_spec/anal
    _pd_instr_divg_eq_spec/detc
    _pd_instr_divg_eq_src/mono
    _pd_instr_divg_eq_src/spec
    _pd_instr_geometry
    _pd_instr_location
    _pd_instr_monochr_post_spec
    _pd_instr_monochr_pre_spec
    _pd_instr_slit_ax_anal/detc
    _pd_instr_slit_ax_mono/spec
    _pd_instr_slit_ax_spec/anal
    _pd_instr_slit_ax_spec/detc
    _pd_instr_slit_ax_src/mono
    _pd_instr_slit_ax_src/spec
    _pd_instr_slit_eq_anal/detc
    _pd_instr_slit_eq_mono/spec
    _pd_instr_slit_eq_spec/anal
    _pd_instr_slit_eq_spec/detc
    _pd_instr_slit_eq_src/mono
    _pd_instr_slit_eq_src/spec
    _pd_instr_soller_ax_anal/detc
    _pd_instr_soller_ax_mono/spec
    _pd_instr_soller_ax_spec/anal
    _pd_instr_soller_ax_spec/detc
    _pd_instr_soller_ax_src/mono
    _pd_instr_soller_ax_src/spec
    _pd_instr_soller_eq_anal/detc
    _pd_instr_soller_eq_mono/spec
    _pd_instr_soller_eq_spec/anal
    _pd_instr_soller_eq_spec/detc
    _pd_instr_soller_eq_src/mono
    _pd_instr_soller_eq_src/spec
    _pd_instr_source_size_ax
    _pd_instr_source_size_eq
    _pd_instr_special_details
    _pd_instr_var_illum_len
    _pd_meas_2theta_fixed
    _pd_meas_2theta_range_inc
    _pd_meas_2theta_range_max
    _pd_meas_2theta_range_min
    _pd_meas_2theta_scan
    _pd_meas_angle_2theta
    _pd_meas_angle_chi
    _pd_meas_angle_omega
    _pd_meas_angle_phi
    _pd_meas_counts_background
    _pd_meas_counts_container
    _pd_meas_counts_monitor
    _pd_meas_counts_total
    _pd_meas_datetime_initiated
    _pd_meas_detector_id
    _pd_meas_info_author_address
    _pd_meas_info_author_email
    _pd_meas_info_author_fax
    _pd_meas_info_author_name
    _pd_meas_info_author_phone
    _pd_meas_intensity_background
    _pd_meas_intensity_container
    _pd_meas_intensity_monitor
    _pd_meas_intensity_total
    _pd_meas_number_of_points
    _pd_meas_point_id
    _pd_meas_position
    _pd_meas_rocking_angle
    _pd_meas_rocking_axis
    _pd_meas_scan_method
    _pd_meas_special_details
    _pd_meas_step_count_time
    _pd_meas_time_of_flight
    _pd_meas_units_of_intensity
    _pd_peak_2theta_centroid
    _pd_peak_2theta_maximum
    _pd_peak_d_spacing
    _pd_peak_id
    _pd_peak_intensity
    _pd_peak_pk_height
    _pd_peak_special_details
    _pd_peak_wavelength_id
    _pd_peak_width_2theta
    _pd_peak_width_d_spacing
    _pd_phase_block_id
    _pd_phase_id
    _pd_phase_mass_%
    _pd_phase_name
    _pd_prep_conditions
    _pd_prep_cool_rate
    _pd_prep_pressure
    _pd_prep_temperature
    _pd_proc_2theta_corrected
    _pd_proc_2theta_range_inc
    _pd_proc_2theta_range_max
    _pd_proc_2theta_range_min
    _pd_proc_d_spacing
    _pd_proc_energy_detection
    _pd_proc_energy_incident
    _pd_proc_info_author_address
    _pd_proc_info_author_email
    _pd_proc_info_author_fax
    _pd_proc_info_author_name
    _pd_proc_info_author_phone
    _pd_proc_info_data_reduction
    _pd_proc_info_datetime
    _pd_proc_info_excluded_regions
    _pd_proc_info_special_details
    _pd_proc_intensity_bkg_calc
    _pd_proc_intensity_bkg_fix
    _pd_proc_intensity_incident
    _pd_proc_intensity_net
    _pd_proc_intensity_norm
    _pd_proc_intensity_total
    _pd_proc_ls_background_function
    _pd_proc_ls_peak_cutoff
    _pd_proc_ls_pref_orient_corr
    _pd_proc_ls_profile_function
    _pd_proc_ls_prof_R_factor
    _pd_proc_ls_prof_wR_expected
    _pd_proc_ls_prof_wR_factor
    _pd_proc_ls_special_details
    _pd_proc_ls_weight
    _pd_proc_number_of_points
    _pd_proc_point_id
    _pd_proc_recip_len_Q
    _pd_proc_wavelength
    _pd_refln_peak_id
    _pd_refln_phase_id
    _pd_refln_wavelength_id
    _pd_spec_description
    _pd_spec_mounting
    _pd_spec_mount_mode
    _pd_spec_orientation
    _pd_spec_preparation
    _pd_spec_shape
    _pd_spec_size_axial
    _pd_spec_size_equat
    _pd_spec_size_thick
    _pd_spec_special_details
);

# Dictionary name: cif_core_restraints.dic 
# Dictionary version: 1.0
# Last updated on: 2011-03-09
# Retrieved on: 2020-02-14
# Retrieved from: ftp://ftp.iucr.org/pub/cif_core_restraints.dic
my @cif_core_restraint_tags = qw(
    _restr_special_details
    _restr_angle_atom_site_label_1
    _restr_angle_atom_site_label_2
    _restr_angle_atom_site_label_3
    _restr_angle_details
    _restr_angle_diff
    _restr_angle_site_symmetry_1
    _restr_angle_site_symmetry_2
    _restr_angle_site_symmetry_3
    _restr_angle_target
    _restr_angle_target_weight_param
    _restr_distance_atom_site_label_1
    _restr_distance_atom_site_label_2
    _restr_distance_details
    _restr_distance_diff
    _restr_distance_site_symmetry_1
    _restr_distance_site_symmetry_2
    _restr_distance_target
    _restr_distance_target_weight_param
    _restr_distance_min_A
    _restr_distance_min_atom_site_label_1
    _restr_distance_min_atom_site_label_2
    _restr_distance_min_B
    _restr_distance_min_C
    _restr_distance_min_details
    _restr_distance_min_difference
    _restr_distance_min_distance
    _restr_distance_min_E
    _restr_distance_min_F
    _restr_distance_min_G
    _restr_distance_min_site_symmetry_1
    _restr_distance_min_site_symmetry_2
    _restr_equal_angle_atom_site_label_1
    _restr_equal_angle_atom_site_label_2
    _restr_equal_angle_atom_site_label_3
    _restr_equal_angle_class_id
    _restr_equal_angle_detail
    _restr_equal_angle_site_symmetry_1
    _restr_equal_angle_site_symmetry_2
    _restr_equal_angle_site_symmetry_3
    _restr_equal_angle_class_average
    _restr_equal_angle_class_class_id
    _restr_equal_angle_class_detail
    _restr_equal_angle_class_diff_max
    _restr_equal_angle_class_esd
    _restr_equal_angle_class_target_weight_param
    _restr_equal_distance_atom_site_label_1
    _restr_equal_distance_atom_site_label_2
    _restr_equal_distance_class_id
    _restr_equal_distance_details
    _restr_equal_distance_site_symmetry_1
    _restr_equal_distance_site_symmetry_2
    _restr_equal_distance_class_average
    _restr_equal_distance_class_class_id
    _restr_equal_distance_class_details
    _restr_equal_distance_class_diff_max
    _restr_equal_distance_class_esd
    _restr_equal_distance_class_target_weight_param
    _restr_equal_torsion_atom_site_label_1
    _restr_equal_torsion_atom_site_label_2
    _restr_equal_torsion_atom_site_label_3
    _restr_equal_torsion_atom_site_label_4
    _restr_equal_torsion_class_id
    _restr_equal_torsion_details
    _restr_equal_torsion_site_symmetry_1
    _restr_equal_torsion_site_symmetry_2
    _restr_equal_torsion_site_symmetry_3
    _restr_equal_torsion_site_symmetry_4
    _restr_equal_torsion_class_average
    _restr_equal_torsion_class_class_id
    _restr_equal_torsion_class_details
    _restr_equal_torsion_class_diff_max
    _restr_equal_torsion_class_esd
    _restr_equal_torsion_class_target_weight_param
    _restr_parameter_atom_coefficient
    _restr_parameter_atom_site_label
    _restr_parameter_class_id
    _restr_parameter_id
    _restr_parameter_class_class_id
    _restr_parameter_class_details
    _restr_parameter_class_parameter_type
    _restr_parameter_class_target
    _restr_parameter_class_target_weight_param
    _restr_plane_atom_site_label
    _restr_plane_class_id
    _restr_plane_details
    _restr_plane_displacement
    _restr_plane_id
    _restr_plane_site_symmetry
    _restr_plane_target_weight_param
    _restr_plane_class_class_id
    _restr_plane_class_details
    _restr_plane_class_displacement_esd
    _restr_plane_class_displacement_max
    _restr_plane_class_displacement_max_atom_site_label
    _restr_plane_class_displacement_max_site_symmetry
    _restr_rigid_body_id
    _restr_rigid_body_class_id
    _restr_rigid_body_atom_site_label
    _restr_rigid_body_site_symmetry
    _restr_rigid_body_details
    _restr_rigid_body_class_class_id
    _restr_rigid_body_class_details
    _restr_torsion_angle_target
    _restr_torsion_atom_site_label_1
    _restr_torsion_atom_site_label_2
    _restr_torsion_atom_site_label_3
    _restr_torsion_atom_site_label_4
    _restr_torsion_details
    _restr_torsion_diff
    _restr_torsion_site_symmetry_1
    _restr_torsion_site_symmetry_2
    _restr_torsion_site_symmetry_3
    _restr_torsion_site_symmetry_4
    _restr_torsion_weight_param
    _restr_U_iso_atom_site_label
    _restr_U_iso_weight_param
    _restr_U_rigid_atom_site_label_1
    _restr_U_rigid_atom_site_label_2
    _restr_U_rigid_details
    _restr_U_rigid_diff
    _restr_U_rigid_site_symmetry_1
    _restr_U_rigid_site_symmetry_2
    _restr_U_rigid_target_weight_param
    _restr_U_rigid_U_parallel
    _restr_U_similar_atom_site_label_1
    _restr_U_similar_atom_site_label_2
    _restr_U_similar_weight_param
);

##
# == Source dictionary metadata ==
# Dictionary name: cif_twinning.dic
# Dictionary version: 1.0
# Last updated on: 2014-02-14
# Retrieved on: 2020-02-16
# Retrieved from: ftp://ftp.iucr.org/pub/cif_twinning_1.0.dic
##
my @cif_twinning_tags = qw(
    _twin_dimensionality
    _twin_formation_mechanism
    _twin_morphology
    _twin_special_details
    _twin_individual_id
    _twin_individual_mass_fraction_refined
    _twin_individual_twin_lattice_type
    _twin_individual_twin_matrix_11
    _twin_individual_twin_matrix_12
    _twin_individual_twin_matrix_13
    _twin_individual_twin_matrix_21
    _twin_individual_twin_matrix_22
    _twin_individual_twin_matrix_23
    _twin_individual_twin_matrix_31
    _twin_individual_twin_matrix_32
    _twin_individual_twin_matrix_33
    _twin_refln_datum_id
    _twin_refln_F_squared_calc
    _twin_refln_F_squared_calc_individual
    _twin_refln_F_squared_meas
    _twin_refln_F_squared_sigma
    _twin_refln_include_status
    _twin_refln_index_h
    _twin_refln_index_k
    _twin_refln_index_l
    _twin_refln_individual_id
);

##
# In addition to the 'cif_core_restraints.dic', 'cif_pd.dic' and
# 'cif_twinning.dic' dictionaries the data names were also retrieved
# from the following dictionaries:
##
# == Source dictionary metadata ==
# Dictionary name: cif_core.dic 
# Dictionary version: 2.4.5
# Last updated on: 2014-11-21
# Retrieved on: 2020-02-16
# Retrieved from: ftp://ftp.iucr.org/pub/cif_core.dic
##
##
# == Source dictionary metadata ==
# Dictionary name: cif_ms.dic 
# Dictionary version: 1.0.1
# Last updated on: 2005-06-16
# Retrieved on: 2020-02-14
# Retrieved from: ftp://ftp.iucr.org/pub/cif_ms.dic
##
##
# == Source dictionary metadata ==
# Dictionary name: cif_rho.dic
# Dictionary version: 1.0.1
# Last updated on: 2005-06-14
# Retrieved on: 2020-02-16
# Retrieved from: ftp://ftp.iucr.org/pub/cif_rho.dic
##
@tag_list = (
    @unclassified_tags_part_1,
    @cif_pd_tags,
    @unclassified_tags_part_2,
    @cif_core_restraint_tags,
    @cif_twinning_tags,
);

1;
