// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: proto/pbconnect/connect.proto

package pbconnect

import (
	fmt "fmt"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	pbcommon "github.com/hashicorp/consul/proto/pbcommon"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// CARoots is the list of all currently trusted CA Roots.
type CARoots struct {
	// ActiveRootID is the ID of a root in Roots that is the active CA root.
	// Other roots are still valid if they're in the Roots list but are in
	// the process of being rotated out.
	ActiveRootID string `protobuf:"bytes,1,opt,name=ActiveRootID,proto3" json:"ActiveRootID,omitempty"`
	// TrustDomain is the identification root for this Consul cluster. All
	// certificates signed by the cluster's CA must have their identifying URI in
	// this domain.
	//
	// This does not include the protocol (currently spiffe://) since we may
	// implement other protocols in future with equivalent semantics. It should be
	// compared against the "authority" section of a URI (i.e. host:port).
	//
	// We need to support migrating a cluster between trust domains to support
	// Multi-DC migration in Enterprise. In this case the current trust domain is
	// here but entries in Roots may also have ExternalTrustDomain set to a
	// non-empty value implying they were previous roots that are still trusted
	// but under a different trust domain.
	//
	// Note that we DON'T validate trust domain during AuthZ since it causes
	// issues of loss of connectivity during migration between trust domains. The
	// only time the additional validation adds value is where the cluster shares
	// an external root (e.g. organization-wide root) with another distinct Consul
	// cluster or PKI system. In this case, x509 Name Constraints can be added to
	// enforce that Consul's CA can only validly sign or trust certs within the
	// same trust-domain. Name constraints as enforced by TLS handshake also allow
	// seamless rotation between trust domains thanks to cross-signing.
	TrustDomain string `protobuf:"bytes,2,opt,name=TrustDomain,proto3" json:"TrustDomain,omitempty"`
	// Roots is a list of root CA certs to trust.
	Roots []*CARoot `protobuf:"bytes,3,rep,name=Roots,proto3" json:"Roots,omitempty"`
	// QueryMeta here is mainly used to contain the latest Raft Index that could
	// be used to perform a blocking query.
	QueryMeta            *pbcommon.QueryMeta `protobuf:"bytes,4,opt,name=QueryMeta,proto3" json:"QueryMeta,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *CARoots) Reset()         { *m = CARoots{} }
func (m *CARoots) String() string { return proto.CompactTextString(m) }
func (*CARoots) ProtoMessage()    {}
func (*CARoots) Descriptor() ([]byte, []int) {
	return fileDescriptor_80627e709958eb04, []int{0}
}
func (m *CARoots) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CARoots) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CARoots.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CARoots) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CARoots.Merge(m, src)
}
func (m *CARoots) XXX_Size() int {
	return m.Size()
}
func (m *CARoots) XXX_DiscardUnknown() {
	xxx_messageInfo_CARoots.DiscardUnknown(m)
}

var xxx_messageInfo_CARoots proto.InternalMessageInfo

func (m *CARoots) GetActiveRootID() string {
	if m != nil {
		return m.ActiveRootID
	}
	return ""
}

func (m *CARoots) GetTrustDomain() string {
	if m != nil {
		return m.TrustDomain
	}
	return ""
}

func (m *CARoots) GetRoots() []*CARoot {
	if m != nil {
		return m.Roots
	}
	return nil
}

func (m *CARoots) GetQueryMeta() *pbcommon.QueryMeta {
	if m != nil {
		return m.QueryMeta
	}
	return nil
}

type CARoot struct {
	// ID is a globally unique ID (UUID) representing this CA root.
	ID string `protobuf:"bytes,1,opt,name=ID,proto3" json:"ID,omitempty"`
	// Name is a human-friendly name for this CA root. This value is
	// opaque to Consul and is not used for anything internally.
	Name string `protobuf:"bytes,2,opt,name=Name,proto3" json:"Name,omitempty"`
	// SerialNumber is the x509 serial number of the certificate.
	SerialNumber uint64 `protobuf:"varint,3,opt,name=SerialNumber,proto3" json:"SerialNumber,omitempty"`
	// SigningKeyID is the ID of the public key that corresponds to the private
	// key used to sign leaf certificates. Is is the HexString format of the
	// raw AuthorityKeyID bytes.
	SigningKeyID string `protobuf:"bytes,4,opt,name=SigningKeyID,proto3" json:"SigningKeyID,omitempty"`
	// ExternalTrustDomain is the trust domain this root was generated under. It
	// is usually empty implying "the current cluster trust-domain". It is set
	// only in the case that a cluster changes trust domain and then all old roots
	// that are still trusted have the old trust domain set here.
	//
	// We currently DON'T validate these trust domains explicitly anywhere, see
	// IndexedRoots.TrustDomain doc. We retain this information for debugging and
	// future flexibility.
	ExternalTrustDomain string `protobuf:"bytes,5,opt,name=ExternalTrustDomain,proto3" json:"ExternalTrustDomain,omitempty"`
	// Time validity bounds.
	NotBefore *types.Timestamp `protobuf:"bytes,6,opt,name=NotBefore,proto3" json:"NotBefore,omitempty"`
	NotAfter  *types.Timestamp `protobuf:"bytes,7,opt,name=NotAfter,proto3" json:"NotAfter,omitempty"`
	// RootCert is the PEM-encoded public certificate.
	RootCert string `protobuf:"bytes,8,opt,name=RootCert,proto3" json:"RootCert,omitempty"`
	// IntermediateCerts is a list of PEM-encoded intermediate certs to
	// attach to any leaf certs signed by this CA.
	IntermediateCerts []string `protobuf:"bytes,9,rep,name=IntermediateCerts,proto3" json:"IntermediateCerts,omitempty"`
	// SigningCert is the PEM-encoded signing certificate and SigningKey
	// is the PEM-encoded private key for the signing certificate. These
	// may actually be empty if the CA plugin in use manages these for us.
	SigningCert string `protobuf:"bytes,10,opt,name=SigningCert,proto3" json:"SigningCert,omitempty"`
	SigningKey  string `protobuf:"bytes,11,opt,name=SigningKey,proto3" json:"SigningKey,omitempty"`
	// Active is true if this is the current active CA. This must only
	// be true for exactly one CA. For any method that modifies roots in the
	// state store, tests should be written to verify that multiple roots
	// cannot be active.
	Active bool `protobuf:"varint,12,opt,name=Active,proto3" json:"Active,omitempty"`
	// RotatedOutAt is the time at which this CA was removed from the state.
	// This will only be set on roots that have been rotated out from being the
	// active root.
	RotatedOutAt *types.Timestamp `protobuf:"bytes,13,opt,name=RotatedOutAt,proto3" json:"RotatedOutAt,omitempty"`
	// PrivateKeyType is the type of the private key used to sign certificates. It
	// may be "rsa" or "ec". This is provided as a convenience to avoid parsing
	// the public key to from the certificate to infer the type.
	PrivateKeyType string `protobuf:"bytes,14,opt,name=PrivateKeyType,proto3" json:"PrivateKeyType,omitempty"`
	// PrivateKeyBits is the length of the private key used to sign certificates.
	// This is provided as a convenience to avoid parsing the public key from the
	// certificate to infer the type.
	PrivateKeyBits       int32               `protobuf:"varint,15,opt,name=PrivateKeyBits,proto3" json:"PrivateKeyBits,omitempty"`
	RaftIndex            *pbcommon.RaftIndex `protobuf:"bytes,16,opt,name=RaftIndex,proto3" json:"RaftIndex,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *CARoot) Reset()         { *m = CARoot{} }
func (m *CARoot) String() string { return proto.CompactTextString(m) }
func (*CARoot) ProtoMessage()    {}
func (*CARoot) Descriptor() ([]byte, []int) {
	return fileDescriptor_80627e709958eb04, []int{1}
}
func (m *CARoot) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CARoot) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CARoot.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CARoot) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CARoot.Merge(m, src)
}
func (m *CARoot) XXX_Size() int {
	return m.Size()
}
func (m *CARoot) XXX_DiscardUnknown() {
	xxx_messageInfo_CARoot.DiscardUnknown(m)
}

var xxx_messageInfo_CARoot proto.InternalMessageInfo

func (m *CARoot) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *CARoot) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CARoot) GetSerialNumber() uint64 {
	if m != nil {
		return m.SerialNumber
	}
	return 0
}

func (m *CARoot) GetSigningKeyID() string {
	if m != nil {
		return m.SigningKeyID
	}
	return ""
}

func (m *CARoot) GetExternalTrustDomain() string {
	if m != nil {
		return m.ExternalTrustDomain
	}
	return ""
}

func (m *CARoot) GetNotBefore() *types.Timestamp {
	if m != nil {
		return m.NotBefore
	}
	return nil
}

func (m *CARoot) GetNotAfter() *types.Timestamp {
	if m != nil {
		return m.NotAfter
	}
	return nil
}

func (m *CARoot) GetRootCert() string {
	if m != nil {
		return m.RootCert
	}
	return ""
}

func (m *CARoot) GetIntermediateCerts() []string {
	if m != nil {
		return m.IntermediateCerts
	}
	return nil
}

func (m *CARoot) GetSigningCert() string {
	if m != nil {
		return m.SigningCert
	}
	return ""
}

func (m *CARoot) GetSigningKey() string {
	if m != nil {
		return m.SigningKey
	}
	return ""
}

func (m *CARoot) GetActive() bool {
	if m != nil {
		return m.Active
	}
	return false
}

func (m *CARoot) GetRotatedOutAt() *types.Timestamp {
	if m != nil {
		return m.RotatedOutAt
	}
	return nil
}

func (m *CARoot) GetPrivateKeyType() string {
	if m != nil {
		return m.PrivateKeyType
	}
	return ""
}

func (m *CARoot) GetPrivateKeyBits() int32 {
	if m != nil {
		return m.PrivateKeyBits
	}
	return 0
}

func (m *CARoot) GetRaftIndex() *pbcommon.RaftIndex {
	if m != nil {
		return m.RaftIndex
	}
	return nil
}

type IssuedCert struct {
	// SerialNumber is the unique serial number for this certificate.
	// This is encoded in standard hex separated by :.
	SerialNumber string `protobuf:"bytes,1,opt,name=SerialNumber,proto3" json:"SerialNumber,omitempty"`
	// CertPEM and PrivateKeyPEM are the PEM-encoded certificate and private
	// key for that cert, respectively. This should not be stored in the
	// state store, but is present in the sign API response.
	CertPEM       string `protobuf:"bytes,2,opt,name=CertPEM,proto3" json:"CertPEM,omitempty"`
	PrivateKeyPEM string `protobuf:"bytes,3,opt,name=PrivateKeyPEM,proto3" json:"PrivateKeyPEM,omitempty"`
	// Service is the name of the service for which the cert was issued.
	// ServiceURI is the cert URI value.
	Service    string `protobuf:"bytes,4,opt,name=Service,proto3" json:"Service,omitempty"`
	ServiceURI string `protobuf:"bytes,5,opt,name=ServiceURI,proto3" json:"ServiceURI,omitempty"`
	// Agent is the name of the node for which the cert was issued.
	// AgentURI is the cert URI value.
	Agent    string `protobuf:"bytes,6,opt,name=Agent,proto3" json:"Agent,omitempty"`
	AgentURI string `protobuf:"bytes,7,opt,name=AgentURI,proto3" json:"AgentURI,omitempty"`
	// ValidAfter and ValidBefore are the validity periods for the
	// certificate.
	ValidAfter  *types.Timestamp `protobuf:"bytes,8,opt,name=ValidAfter,proto3" json:"ValidAfter,omitempty"`
	ValidBefore *types.Timestamp `protobuf:"bytes,9,opt,name=ValidBefore,proto3" json:"ValidBefore,omitempty"`
	// EnterpriseMeta is the Consul Enterprise specific metadata
	EnterpriseMeta       *pbcommon.EnterpriseMeta `protobuf:"bytes,10,opt,name=EnterpriseMeta,proto3" json:"EnterpriseMeta,omitempty"`
	RaftIndex            *pbcommon.RaftIndex      `protobuf:"bytes,11,opt,name=RaftIndex,proto3" json:"RaftIndex,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *IssuedCert) Reset()         { *m = IssuedCert{} }
func (m *IssuedCert) String() string { return proto.CompactTextString(m) }
func (*IssuedCert) ProtoMessage()    {}
func (*IssuedCert) Descriptor() ([]byte, []int) {
	return fileDescriptor_80627e709958eb04, []int{2}
}
func (m *IssuedCert) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IssuedCert) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IssuedCert.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IssuedCert) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IssuedCert.Merge(m, src)
}
func (m *IssuedCert) XXX_Size() int {
	return m.Size()
}
func (m *IssuedCert) XXX_DiscardUnknown() {
	xxx_messageInfo_IssuedCert.DiscardUnknown(m)
}

var xxx_messageInfo_IssuedCert proto.InternalMessageInfo

func (m *IssuedCert) GetSerialNumber() string {
	if m != nil {
		return m.SerialNumber
	}
	return ""
}

func (m *IssuedCert) GetCertPEM() string {
	if m != nil {
		return m.CertPEM
	}
	return ""
}

func (m *IssuedCert) GetPrivateKeyPEM() string {
	if m != nil {
		return m.PrivateKeyPEM
	}
	return ""
}

func (m *IssuedCert) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

func (m *IssuedCert) GetServiceURI() string {
	if m != nil {
		return m.ServiceURI
	}
	return ""
}

func (m *IssuedCert) GetAgent() string {
	if m != nil {
		return m.Agent
	}
	return ""
}

func (m *IssuedCert) GetAgentURI() string {
	if m != nil {
		return m.AgentURI
	}
	return ""
}

func (m *IssuedCert) GetValidAfter() *types.Timestamp {
	if m != nil {
		return m.ValidAfter
	}
	return nil
}

func (m *IssuedCert) GetValidBefore() *types.Timestamp {
	if m != nil {
		return m.ValidBefore
	}
	return nil
}

func (m *IssuedCert) GetEnterpriseMeta() *pbcommon.EnterpriseMeta {
	if m != nil {
		return m.EnterpriseMeta
	}
	return nil
}

func (m *IssuedCert) GetRaftIndex() *pbcommon.RaftIndex {
	if m != nil {
		return m.RaftIndex
	}
	return nil
}

func init() {
	proto.RegisterType((*CARoots)(nil), "connect.CARoots")
	proto.RegisterType((*CARoot)(nil), "connect.CARoot")
	proto.RegisterType((*IssuedCert)(nil), "connect.IssuedCert")
}

func init() { proto.RegisterFile("proto/pbconnect/connect.proto", fileDescriptor_80627e709958eb04) }

var fileDescriptor_80627e709958eb04 = []byte{
	// 659 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x54, 0xdd, 0x6a, 0xdb, 0x4a,
	0x10, 0x3e, 0x8a, 0x7f, 0x35, 0x4e, 0x9c, 0x93, 0x3d, 0x87, 0xb0, 0xf8, 0x70, 0x5c, 0x61, 0xda,
	0x62, 0x68, 0xb1, 0x4a, 0x0a, 0xa5, 0x94, 0x36, 0xe0, 0xc4, 0xb9, 0x10, 0x21, 0x6e, 0xba, 0x49,
	0x7b, 0xd1, 0x3b, 0xd9, 0x1e, 0x3b, 0x0b, 0x96, 0xd6, 0xac, 0x56, 0x21, 0x7e, 0x93, 0xbe, 0x41,
	0x1f, 0xa5, 0xbd, 0xec, 0x23, 0x94, 0xf4, 0x39, 0x0a, 0x65, 0x57, 0x92, 0x2d, 0xb9, 0x05, 0x5f,
	0x79, 0xe7, 0x9b, 0x6f, 0x46, 0x33, 0xfb, 0x7d, 0x5e, 0xf8, 0x7f, 0x21, 0x85, 0x12, 0xee, 0x62,
	0x34, 0x16, 0x61, 0x88, 0x63, 0xe5, 0xa6, 0xbf, 0x3d, 0x83, 0x93, 0x5a, 0x1a, 0xb6, 0x1e, 0xcc,
	0x84, 0x98, 0xcd, 0xd1, 0x35, 0xf0, 0x28, 0x9e, 0xba, 0x8a, 0x07, 0x18, 0x29, 0x3f, 0x58, 0x24,
	0xcc, 0xd6, 0x7f, 0xeb, 0x46, 0x41, 0x20, 0x42, 0x37, 0xf9, 0x49, 0x92, 0x9d, 0xcf, 0x16, 0xd4,
	0x4e, 0xfb, 0x4c, 0x08, 0x15, 0x91, 0x0e, 0xec, 0xf6, 0xc7, 0x8a, 0xdf, 0xa2, 0x0e, 0xbd, 0x01,
	0xb5, 0x1c, 0xab, 0x6b, 0xb3, 0x02, 0x46, 0x1c, 0x68, 0x5c, 0xcb, 0x38, 0x52, 0x03, 0x11, 0xf8,
	0x3c, 0xa4, 0x3b, 0x86, 0x92, 0x87, 0xc8, 0x23, 0xa8, 0x98, 0x76, 0xb4, 0xe4, 0x94, 0xba, 0x8d,
	0xa3, 0xfd, 0x5e, 0x36, 0x77, 0xf2, 0x19, 0x96, 0x64, 0x89, 0x0b, 0xf6, 0xbb, 0x18, 0xe5, 0xf2,
	0x02, 0x95, 0x4f, 0xcb, 0x8e, 0xd5, 0x6d, 0x1c, 0x1d, 0xf4, 0xd2, 0xd1, 0x56, 0x09, 0xb6, 0xe6,
	0x74, 0x7e, 0x96, 0xa1, 0x9a, 0xb4, 0x20, 0x4d, 0xd8, 0x59, 0x8d, 0xb7, 0xe3, 0x0d, 0x08, 0x81,
	0xf2, 0xd0, 0x0f, 0x30, 0x9d, 0xc6, 0x9c, 0xf5, 0x32, 0x57, 0x28, 0xb9, 0x3f, 0x1f, 0xc6, 0xc1,
	0x08, 0x25, 0x2d, 0x39, 0x56, 0xb7, 0xcc, 0x0a, 0x98, 0xe1, 0xf0, 0x59, 0xc8, 0xc3, 0xd9, 0x39,
	0x2e, 0xbd, 0x81, 0x19, 0xc3, 0x66, 0x05, 0x8c, 0x3c, 0x83, 0x7f, 0xce, 0xee, 0x14, 0xca, 0xd0,
	0x9f, 0xe7, 0x17, 0xaf, 0x18, 0xea, 0x9f, 0x52, 0xe4, 0x25, 0xd8, 0x43, 0xa1, 0x4e, 0x70, 0x2a,
	0x24, 0xd2, 0xaa, 0xd9, 0xac, 0xd5, 0x4b, 0x44, 0xea, 0x65, 0x22, 0xf5, 0xae, 0x33, 0x91, 0xd8,
	0x9a, 0x4c, 0x5e, 0x40, 0x7d, 0x28, 0x54, 0x7f, 0xaa, 0x50, 0xd2, 0xda, 0xd6, 0xc2, 0x15, 0x97,
	0xb4, 0xa0, 0xae, 0xef, 0xe5, 0x14, 0xa5, 0xa2, 0x75, 0x33, 0xd8, 0x2a, 0x26, 0x4f, 0xe1, 0xc0,
	0x0b, 0x15, 0xca, 0x00, 0x27, 0xdc, 0x57, 0xa8, 0xb1, 0x88, 0xda, 0x4e, 0xa9, 0x6b, 0xb3, 0xdf,
	0x13, 0x5a, 0xde, 0x74, 0x7b, 0xd3, 0x0c, 0x12, 0x79, 0x73, 0x10, 0x69, 0x03, 0xac, 0xef, 0x87,
	0x36, 0x0c, 0x21, 0x87, 0x90, 0x43, 0xa8, 0x26, 0x86, 0xa1, 0xbb, 0x8e, 0xd5, 0xad, 0xb3, 0x34,
	0x22, 0xc7, 0xb0, 0xcb, 0x84, 0xf2, 0x15, 0x4e, 0xde, 0xc6, 0xaa, 0xaf, 0xe8, 0xde, 0xd6, 0xfd,
	0x0a, 0x7c, 0xf2, 0x18, 0x9a, 0x97, 0x92, 0xdf, 0xfa, 0x0a, 0xcf, 0x71, 0x79, 0xbd, 0x5c, 0x20,
	0x6d, 0x9a, 0x6f, 0x6f, 0xa0, 0x45, 0xde, 0x09, 0x57, 0x11, 0xdd, 0x77, 0xac, 0x6e, 0x85, 0x6d,
	0xa0, 0xda, 0x7f, 0xcc, 0x9f, 0x2a, 0x2f, 0x9c, 0xe0, 0x1d, 0xfd, 0xbb, 0xe8, 0xbf, 0x55, 0x82,
	0xad, 0x39, 0x9d, 0x2f, 0x25, 0x00, 0x2f, 0x8a, 0x62, 0x9c, 0x98, 0x7b, 0xd8, 0xf4, 0x57, 0xfa,
	0x67, 0x29, 0xf8, 0x8b, 0x42, 0x4d, 0x73, 0x2f, 0xcf, 0x2e, 0x52, 0x6b, 0x66, 0x21, 0x79, 0x08,
	0x7b, 0xeb, 0x79, 0x74, 0xbe, 0x64, 0xf2, 0x45, 0x50, 0xd7, 0x5f, 0xa1, 0xbc, 0xe5, 0x63, 0x4c,
	0xad, 0x99, 0x85, 0x46, 0x85, 0xe4, 0xf8, 0x9e, 0x79, 0xa9, 0x19, 0x73, 0x08, 0xf9, 0x17, 0x2a,
	0xfd, 0x19, 0x86, 0xca, 0xf8, 0xcf, 0x66, 0x49, 0xa0, 0x7d, 0x62, 0x0e, 0xba, 0xa6, 0x96, 0xf8,
	0x24, 0x8b, 0xc9, 0x2b, 0x80, 0x0f, 0xfe, 0x9c, 0x4f, 0x12, 0xf7, 0xd5, 0xb7, 0xaa, 0x93, 0x63,
	0x93, 0xd7, 0xd0, 0x30, 0x51, 0xea, 0x79, 0x7b, 0x6b, 0x71, 0x9e, 0x4e, 0x8e, 0xa1, 0x79, 0xa6,
	0x8d, 0xb8, 0x90, 0x3c, 0x42, 0xf3, 0x1c, 0x80, 0x69, 0x70, 0x98, 0xc9, 0x51, 0xcc, 0xb2, 0x0d,
	0x76, 0x51, 0xc9, 0xc6, 0x76, 0x25, 0x4f, 0xde, 0x7c, 0xbd, 0x6f, 0x5b, 0xdf, 0xee, 0xdb, 0xd6,
	0xf7, 0xfb, 0xb6, 0xf5, 0xe9, 0x47, 0xfb, 0xaf, 0x8f, 0x4f, 0x66, 0x5c, 0xdd, 0xc4, 0x23, 0x5d,
	0xe5, 0xde, 0xf8, 0xd1, 0x0d, 0x1f, 0x0b, 0xb9, 0xd0, 0x0f, 0x6e, 0x14, 0xcf, 0xdd, 0x8d, 0x77,
	0x78, 0x54, 0x35, 0xc0, 0xf3, 0x5f, 0x01, 0x00, 0x00, 0xff, 0xff, 0xa9, 0x98, 0x92, 0x5c, 0xa1,
	0x05, 0x00, 0x00,
}

func (m *CARoots) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CARoots) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CARoots) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.QueryMeta != nil {
		{
			size, err := m.QueryMeta.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnect(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Roots) > 0 {
		for iNdEx := len(m.Roots) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Roots[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintConnect(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.TrustDomain) > 0 {
		i -= len(m.TrustDomain)
		copy(dAtA[i:], m.TrustDomain)
		i = encodeVarintConnect(dAtA, i, uint64(len(m.TrustDomain)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ActiveRootID) > 0 {
		i -= len(m.ActiveRootID)
		copy(dAtA[i:], m.ActiveRootID)
		i = encodeVarintConnect(dAtA, i, uint64(len(m.ActiveRootID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CARoot) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CARoot) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CARoot) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.RaftIndex != nil {
		{
			size, err := m.RaftIndex.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnect(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if m.PrivateKeyBits != 0 {
		i = encodeVarintConnect(dAtA, i, uint64(m.PrivateKeyBits))
		i--
		dAtA[i] = 0x78
	}
	if len(m.PrivateKeyType) > 0 {
		i -= len(m.PrivateKeyType)
		copy(dAtA[i:], m.PrivateKeyType)
		i = encodeVarintConnect(dAtA, i, uint64(len(m.PrivateKeyType)))
		i--
		dAtA[i] = 0x72
	}
	if m.RotatedOutAt != nil {
		{
			size, err := m.RotatedOutAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnect(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	if m.Active {
		i--
		if m.Active {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x60
	}
	if len(m.SigningKey) > 0 {
		i -= len(m.SigningKey)
		copy(dAtA[i:], m.SigningKey)
		i = encodeVarintConnect(dAtA, i, uint64(len(m.SigningKey)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.SigningCert) > 0 {
		i -= len(m.SigningCert)
		copy(dAtA[i:], m.SigningCert)
		i = encodeVarintConnect(dAtA, i, uint64(len(m.SigningCert)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.IntermediateCerts) > 0 {
		for iNdEx := len(m.IntermediateCerts) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.IntermediateCerts[iNdEx])
			copy(dAtA[i:], m.IntermediateCerts[iNdEx])
			i = encodeVarintConnect(dAtA, i, uint64(len(m.IntermediateCerts[iNdEx])))
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.RootCert) > 0 {
		i -= len(m.RootCert)
		copy(dAtA[i:], m.RootCert)
		i = encodeVarintConnect(dAtA, i, uint64(len(m.RootCert)))
		i--
		dAtA[i] = 0x42
	}
	if m.NotAfter != nil {
		{
			size, err := m.NotAfter.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnect(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.NotBefore != nil {
		{
			size, err := m.NotBefore.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnect(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.ExternalTrustDomain) > 0 {
		i -= len(m.ExternalTrustDomain)
		copy(dAtA[i:], m.ExternalTrustDomain)
		i = encodeVarintConnect(dAtA, i, uint64(len(m.ExternalTrustDomain)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.SigningKeyID) > 0 {
		i -= len(m.SigningKeyID)
		copy(dAtA[i:], m.SigningKeyID)
		i = encodeVarintConnect(dAtA, i, uint64(len(m.SigningKeyID)))
		i--
		dAtA[i] = 0x22
	}
	if m.SerialNumber != 0 {
		i = encodeVarintConnect(dAtA, i, uint64(m.SerialNumber))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintConnect(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ID) > 0 {
		i -= len(m.ID)
		copy(dAtA[i:], m.ID)
		i = encodeVarintConnect(dAtA, i, uint64(len(m.ID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IssuedCert) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IssuedCert) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IssuedCert) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.RaftIndex != nil {
		{
			size, err := m.RaftIndex.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnect(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.EnterpriseMeta != nil {
		{
			size, err := m.EnterpriseMeta.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnect(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.ValidBefore != nil {
		{
			size, err := m.ValidBefore.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnect(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.ValidAfter != nil {
		{
			size, err := m.ValidAfter.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnect(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if len(m.AgentURI) > 0 {
		i -= len(m.AgentURI)
		copy(dAtA[i:], m.AgentURI)
		i = encodeVarintConnect(dAtA, i, uint64(len(m.AgentURI)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Agent) > 0 {
		i -= len(m.Agent)
		copy(dAtA[i:], m.Agent)
		i = encodeVarintConnect(dAtA, i, uint64(len(m.Agent)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.ServiceURI) > 0 {
		i -= len(m.ServiceURI)
		copy(dAtA[i:], m.ServiceURI)
		i = encodeVarintConnect(dAtA, i, uint64(len(m.ServiceURI)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Service) > 0 {
		i -= len(m.Service)
		copy(dAtA[i:], m.Service)
		i = encodeVarintConnect(dAtA, i, uint64(len(m.Service)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.PrivateKeyPEM) > 0 {
		i -= len(m.PrivateKeyPEM)
		copy(dAtA[i:], m.PrivateKeyPEM)
		i = encodeVarintConnect(dAtA, i, uint64(len(m.PrivateKeyPEM)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.CertPEM) > 0 {
		i -= len(m.CertPEM)
		copy(dAtA[i:], m.CertPEM)
		i = encodeVarintConnect(dAtA, i, uint64(len(m.CertPEM)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.SerialNumber) > 0 {
		i -= len(m.SerialNumber)
		copy(dAtA[i:], m.SerialNumber)
		i = encodeVarintConnect(dAtA, i, uint64(len(m.SerialNumber)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintConnect(dAtA []byte, offset int, v uint64) int {
	offset -= sovConnect(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *CARoots) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ActiveRootID)
	if l > 0 {
		n += 1 + l + sovConnect(uint64(l))
	}
	l = len(m.TrustDomain)
	if l > 0 {
		n += 1 + l + sovConnect(uint64(l))
	}
	if len(m.Roots) > 0 {
		for _, e := range m.Roots {
			l = e.Size()
			n += 1 + l + sovConnect(uint64(l))
		}
	}
	if m.QueryMeta != nil {
		l = m.QueryMeta.Size()
		n += 1 + l + sovConnect(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CARoot) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovConnect(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovConnect(uint64(l))
	}
	if m.SerialNumber != 0 {
		n += 1 + sovConnect(uint64(m.SerialNumber))
	}
	l = len(m.SigningKeyID)
	if l > 0 {
		n += 1 + l + sovConnect(uint64(l))
	}
	l = len(m.ExternalTrustDomain)
	if l > 0 {
		n += 1 + l + sovConnect(uint64(l))
	}
	if m.NotBefore != nil {
		l = m.NotBefore.Size()
		n += 1 + l + sovConnect(uint64(l))
	}
	if m.NotAfter != nil {
		l = m.NotAfter.Size()
		n += 1 + l + sovConnect(uint64(l))
	}
	l = len(m.RootCert)
	if l > 0 {
		n += 1 + l + sovConnect(uint64(l))
	}
	if len(m.IntermediateCerts) > 0 {
		for _, s := range m.IntermediateCerts {
			l = len(s)
			n += 1 + l + sovConnect(uint64(l))
		}
	}
	l = len(m.SigningCert)
	if l > 0 {
		n += 1 + l + sovConnect(uint64(l))
	}
	l = len(m.SigningKey)
	if l > 0 {
		n += 1 + l + sovConnect(uint64(l))
	}
	if m.Active {
		n += 2
	}
	if m.RotatedOutAt != nil {
		l = m.RotatedOutAt.Size()
		n += 1 + l + sovConnect(uint64(l))
	}
	l = len(m.PrivateKeyType)
	if l > 0 {
		n += 1 + l + sovConnect(uint64(l))
	}
	if m.PrivateKeyBits != 0 {
		n += 1 + sovConnect(uint64(m.PrivateKeyBits))
	}
	if m.RaftIndex != nil {
		l = m.RaftIndex.Size()
		n += 2 + l + sovConnect(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IssuedCert) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SerialNumber)
	if l > 0 {
		n += 1 + l + sovConnect(uint64(l))
	}
	l = len(m.CertPEM)
	if l > 0 {
		n += 1 + l + sovConnect(uint64(l))
	}
	l = len(m.PrivateKeyPEM)
	if l > 0 {
		n += 1 + l + sovConnect(uint64(l))
	}
	l = len(m.Service)
	if l > 0 {
		n += 1 + l + sovConnect(uint64(l))
	}
	l = len(m.ServiceURI)
	if l > 0 {
		n += 1 + l + sovConnect(uint64(l))
	}
	l = len(m.Agent)
	if l > 0 {
		n += 1 + l + sovConnect(uint64(l))
	}
	l = len(m.AgentURI)
	if l > 0 {
		n += 1 + l + sovConnect(uint64(l))
	}
	if m.ValidAfter != nil {
		l = m.ValidAfter.Size()
		n += 1 + l + sovConnect(uint64(l))
	}
	if m.ValidBefore != nil {
		l = m.ValidBefore.Size()
		n += 1 + l + sovConnect(uint64(l))
	}
	if m.EnterpriseMeta != nil {
		l = m.EnterpriseMeta.Size()
		n += 1 + l + sovConnect(uint64(l))
	}
	if m.RaftIndex != nil {
		l = m.RaftIndex.Size()
		n += 1 + l + sovConnect(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovConnect(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozConnect(x uint64) (n int) {
	return sovConnect(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *CARoots) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnect
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CARoots: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CARoots: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActiveRootID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ActiveRootID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TrustDomain", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TrustDomain = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Roots", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Roots = append(m.Roots, &CARoot{})
			if err := m.Roots[len(m.Roots)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.QueryMeta == nil {
				m.QueryMeta = &pbcommon.QueryMeta{}
			}
			if err := m.QueryMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConnect(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnect
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CARoot) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnect
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CARoot: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CARoot: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SerialNumber", wireType)
			}
			m.SerialNumber = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SerialNumber |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SigningKeyID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SigningKeyID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExternalTrustDomain", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExternalTrustDomain = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotBefore", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NotBefore == nil {
				m.NotBefore = &types.Timestamp{}
			}
			if err := m.NotBefore.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotAfter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NotAfter == nil {
				m.NotAfter = &types.Timestamp{}
			}
			if err := m.NotAfter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RootCert", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RootCert = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntermediateCerts", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IntermediateCerts = append(m.IntermediateCerts, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SigningCert", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SigningCert = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SigningKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SigningKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Active", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Active = bool(v != 0)
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RotatedOutAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RotatedOutAt == nil {
				m.RotatedOutAt = &types.Timestamp{}
			}
			if err := m.RotatedOutAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrivateKeyType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrivateKeyType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrivateKeyBits", wireType)
			}
			m.PrivateKeyBits = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PrivateKeyBits |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftIndex", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RaftIndex == nil {
				m.RaftIndex = &pbcommon.RaftIndex{}
			}
			if err := m.RaftIndex.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConnect(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnect
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IssuedCert) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnect
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IssuedCert: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IssuedCert: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SerialNumber", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SerialNumber = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CertPEM", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CertPEM = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrivateKeyPEM", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrivateKeyPEM = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Service", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Service = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceURI", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServiceURI = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Agent", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Agent = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentURI", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AgentURI = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidAfter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ValidAfter == nil {
				m.ValidAfter = &types.Timestamp{}
			}
			if err := m.ValidAfter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidBefore", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ValidBefore == nil {
				m.ValidBefore = &types.Timestamp{}
			}
			if err := m.ValidBefore.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnterpriseMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EnterpriseMeta == nil {
				m.EnterpriseMeta = &pbcommon.EnterpriseMeta{}
			}
			if err := m.EnterpriseMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftIndex", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnect
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnect
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RaftIndex == nil {
				m.RaftIndex = &pbcommon.RaftIndex{}
			}
			if err := m.RaftIndex.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConnect(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnect
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipConnect(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowConnect
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConnect
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthConnect
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupConnect
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthConnect
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthConnect        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowConnect          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupConnect = fmt.Errorf("proto: unexpected end of group")
)
