/* $Id: irplib_polynomial.h,v 1.9 2012-01-12 10:40:21 llundin Exp $
 *
 * This file is part of the ESO Common Pipeline Library
 * Copyright (C) 2007 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: llundin $
 * $Date: 2012-01-12 10:40:21 $
 * $Revision: 1.9 $
 * $Name: not supported by cvs2svn $
 */

#ifndef IRPLIB_POLYNOMIAL_H
#define IRPLIB_POLYNOMIAL_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>

/*-----------------------------------------------------------------------------
                              Function prototypes
 -----------------------------------------------------------------------------*/

/* TEMPORARY SUPPORT OF CPL 5.x */
#ifndef CPL_SIZE_FORMAT
#define CPL_SIZE_FORMAT "d"
#define cpl_size int
#endif

#if defined CPL_VERSION_CODE && CPL_VERSION_CODE > CPL_VERSION(5, 92, 0)
#define irplib_polynomial_add cpl_polynomial_add
#define irplib_polynomial_subtract cpl_polynomial_subtract
#define irplib_polynomial_multiply_scalar cpl_polynomial_multiply_scalar
#else
cpl_error_code irplib_polynomial_add(cpl_polynomial *,
                                     const cpl_polynomial *,
                                     const cpl_polynomial *);

cpl_error_code irplib_polynomial_subtract(cpl_polynomial *,
                                          const cpl_polynomial *,
                                          const cpl_polynomial *);

cpl_error_code irplib_polynomial_multiply_scalar(cpl_polynomial *,
                                                 const cpl_polynomial *,
                                                 double);
#endif

/* END TEMPORARY SUPPORT OF CPL 5.x */

cpl_error_code irplib_polynomial_solve_1d_all(const cpl_polynomial *,
                                              cpl_vector *, cpl_size *);

#endif
