#include "mon-book.h"

/* *********************************************************************

    This file determines which spells are contained in monster spellbooks.
    It is used by /util/gen-mst.pl to generate spellbook enums, which are
    listed in mon-mst.h.

    Template Format:

    {    mon_spellbook_type,
        {
            { spell type, frequency, flags },
            { spell type, frequency, flags },
            [...]
        }
    }

********************************************************************* */

static const mon_spellbook mspell_list[] =
{
    {  MST_ORC_WIZARD_I,
      {
       { SPELL_MAGIC_DART, 18, MON_SPELL_WIZARD },
       { SPELL_SLOW, 9, MON_SPELL_WIZARD },
       { SPELL_HASTE, 9, MON_SPELL_WIZARD  },
       { SPELL_BLINK, 18, MON_SPELL_WIZARD },
      }
    },

    {  MST_ORC_WIZARD_II,
      {
       { SPELL_THROW_FLAME, 9, MON_SPELL_WIZARD },
       { SPELL_INVISIBILITY, 9, MON_SPELL_WIZARD  },
       { SPELL_MAGIC_DART, 9, MON_SPELL_WIZARD },
       { SPELL_CONFUSE, 18, MON_SPELL_WIZARD },
      }
    },

    {  MST_ORC_WIZARD_III,
      {
       { SPELL_THROW_FROST, 9, MON_SPELL_WIZARD },
       { SPELL_CANTRIP, 9, MON_SPELL_WIZARD },
       { SPELL_HASTE, 9, MON_SPELL_WIZARD  },
       { SPELL_THROW_FLAME, 9, MON_SPELL_WIZARD },
       { SPELL_MAGIC_DART, 9, MON_SPELL_WIZARD },
       { SPELL_INVISIBILITY, 9, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_UNBORN,
      {
       { SPELL_AGONY, 10, MON_SPELL_WIZARD },
       { SPELL_DISPEL_UNDEAD, 10, MON_SPELL_WIZARD },
       { SPELL_INJURY_MIRROR, 20, MON_SPELL_PRIEST },
       { SPELL_ANIMATE_DEAD, 10, MON_SPELL_WIZARD },
       { SPELL_HAUNT, 10, MON_SPELL_WIZARD },
      }
    },

    {  MST_BK_TROG,
      {
       { SPELL_BROTHERS_IN_ARMS, 21, MON_SPELL_PRIEST },
       { SPELL_BERSERKER_RAGE, 21, MON_SPELL_PRIEST },
       { SPELL_TROGS_HAND, 21, MON_SPELL_PRIEST  },
      }
    },

    {  MST_BK_YREDELEMNUL,
      {
       { SPELL_DRAIN_LIFE, 30, MON_SPELL_PRIEST },
       { SPELL_ANIMATE_DEAD, 15, MON_SPELL_PRIEST },
       { SPELL_INJURY_MIRROR, 15, MON_SPELL_PRIEST  },
      }
    },

    {  MST_GUARDIAN_SERPENT,
      {
       { SPELL_VENOM_BOLT, 19, MON_SPELL_WIZARD },
       { SPELL_SLOW, 19, MON_SPELL_WIZARD },
       { SPELL_BLINK_ALLIES_ENCIRCLE, 19, MON_SPELL_WIZARD },
      }
    },

    {  MST_HELLION,
      {
       { SPELL_HELLFIRE_BURST, 57, MON_SPELL_DEMONIC },
      }
    },

    {  MST_VAMPIRE,
      {
       { SPELL_VAMPIRIC_DRAINING, 28, MON_SPELL_WIZARD },
       { SPELL_CONFUSE, 14, MON_SPELL_WIZARD },
       { SPELL_INVISIBILITY, 14, MON_SPELL_WIZARD },
      }
    },

    {  MST_VAMPIRE_KNIGHT,
      {
       { SPELL_BLINK_CLOSE, 12, MON_SPELL_WIZARD },
       { SPELL_PARALYSE, 12, MON_SPELL_WIZARD },
       { SPELL_HASTE, 12, MON_SPELL_WIZARD  },
       { SPELL_INVISIBILITY, 12, MON_SPELL_WIZARD },
       { SPELL_VAMPIRIC_DRAINING, 12, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_VAMPIRE_MAGE,
      {
       { SPELL_BOLT_OF_DRAINING, 10, MON_SPELL_WIZARD },
       { SPELL_SUMMON_UNDEAD, 10, MON_SPELL_WIZARD },
       { SPELL_INVISIBILITY, 20, MON_SPELL_WIZARD },
       { SPELL_VAMPIRIC_DRAINING, 10, MON_SPELL_WIZARD },
       { SPELL_ANIMATE_DEAD, 10, MON_SPELL_WIZARD },
      }
    },

    {  MST_EFREET,
      {
       { SPELL_BOLT_OF_FIRE, 29, MON_SPELL_DEMONIC },
       { SPELL_FIREBALL, 29, MON_SPELL_DEMONIC },
      }
    },

    {  MST_FIRE_GIANT,
      {
       { SPELL_BOLT_OF_FIRE, 29, MON_SPELL_WIZARD },
       { SPELL_FIREBALL, 29, MON_SPELL_WIZARD },
      }
    },

    {  MST_MARGERY,
      {
       { SPELL_BOLT_OF_FIRE, 36, MON_SPELL_WIZARD },
       { SPELL_FIREBALL, 36, MON_SPELL_WIZARD },
      }
    },

    {  MST_BRAIN_WORM,
      {
       { SPELL_BRAIN_FEED, 55, MON_SPELL_NATURAL /*???*/},
      }
    },

    {  MST_GIANT_ORANGE_BRAIN,
      {
       { SPELL_BRAIN_FEED, 10, MON_SPELL_MAGICAL },
       { SPELL_CAUSE_FEAR, 10, MON_SPELL_MAGICAL },
       { SPELL_SHADOW_CREATURES, 10, MON_SPELL_MAGICAL },
       { SPELL_MASS_CONFUSION, 10, MON_SPELL_MAGICAL },
       { SPELL_BLINK, 10, MON_SPELL_MAGICAL },
       { SPELL_TELEPORT_SELF, 10, MON_SPELL_MAGICAL | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_RAKSHASA,
      {
       { SPELL_ISKENDERUNS_MYSTIC_BLAST, 20, MON_SPELL_DEMONIC },
       { SPELL_PHANTOM_MIRROR, 20, MON_SPELL_DEMONIC  },
       { SPELL_BLINK, 10, MON_SPELL_DEMONIC },
      }
    },

    {  MST_GREAT_ORB_OF_EYES,
      {
       { SPELL_PARALYSE, 12, MON_SPELL_MAGICAL },
       { SPELL_DISINTEGRATE, 12, MON_SPELL_MAGICAL },
       { SPELL_DRAIN_MAGIC, 12, MON_SPELL_MAGICAL },
       { SPELL_CONFUSE, 12, MON_SPELL_MAGICAL },
       { SPELL_TELEPORT_OTHER, 12, MON_SPELL_MAGICAL | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_KRAKEN,
      {
       { SPELL_CREATE_TENTACLES, 44, MON_SPELL_NATURAL },
       { SPELL_INK_CLOUD, 22, MON_SPELL_NATURAL | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_ORC_SORCERER,
      {
       { SPELL_BOLT_OF_FIRE, 12, MON_SPELL_WIZARD },
       { SPELL_BOLT_OF_DRAINING, 12, MON_SPELL_WIZARD },
       { SPELL_SUMMON_DEMON, 12, MON_SPELL_WIZARD  },
       { SPELL_PARALYSE, 12, MON_SPELL_WIZARD },
       { SPELL_ANIMATE_DEAD, 12, MON_SPELL_WIZARD },
      }
    },

    {  MST_STEAM_DRAGON,
      {
       { SPELL_STEAM_BALL, 54, MON_SPELL_NATURAL | MON_SPELL_BREATH
                                | MON_SPELL_NOISY },
      }
    },

    {  MST_HELL_KNIGHT_I,
      {
       { SPELL_PAIN, 13, MON_SPELL_WIZARD },
       { SPELL_THROW_FLAME, 13, MON_SPELL_WIZARD },
       { SPELL_HASTE, 26, MON_SPELL_WIZARD },
      }
    },

    {  MST_HELL_KNIGHT_II,
      {
       { SPELL_PAIN, 17, MON_SPELL_WIZARD },
       { SPELL_BOLT_OF_FIRE, 17, MON_SPELL_WIZARD },
       { SPELL_BLINK, 17, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_NECROMANCER_I,
      {
       { SPELL_BOLT_OF_COLD, 15, MON_SPELL_WIZARD },
       { SPELL_AGONY, 15, MON_SPELL_WIZARD },
       { SPELL_ANIMATE_DEAD, 15, MON_SPELL_WIZARD },
       { SPELL_SIMULACRUM, 15, MON_SPELL_WIZARD },
      }
    },

    {  MST_NECROMANCER_II,
      {
       { SPELL_BOLT_OF_FIRE, 10, MON_SPELL_WIZARD },
       { SPELL_AGONY, 10, MON_SPELL_WIZARD },
       { SPELL_INNER_FLAME, 10, MON_SPELL_WIZARD },
       { SPELL_INVISIBILITY, 10, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
       { SPELL_ANIMATE_DEAD, 20, MON_SPELL_WIZARD },
      }
    },

    {  MST_WIZARD_I,
      {
       { SPELL_MAGIC_DART, 10, MON_SPELL_WIZARD },
       { SPELL_PARALYSE, 10, MON_SPELL_WIZARD },
       { SPELL_HASTE, 10, MON_SPELL_WIZARD  },
       { SPELL_LIGHTNING_BOLT, 10, MON_SPELL_WIZARD },
       { SPELL_CONFUSE, 10, MON_SPELL_WIZARD },
       { SPELL_TELEPORT_SELF, 10, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_WIZARD_II,
      {
       { SPELL_VENOM_BOLT, 10, MON_SPELL_WIZARD },
       { SPELL_ISKENDERUNS_MYSTIC_BLAST, 10, MON_SPELL_WIZARD },
       { SPELL_INVISIBILITY, 10, MON_SPELL_WIZARD },
       { SPELL_CONFUSE, 10, MON_SPELL_WIZARD },
       { SPELL_SLOW, 10, MON_SPELL_WIZARD },
       { SPELL_TELEPORT_SELF, 10, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_WIZARD_III,
      {
       { SPELL_LEHUDIBS_CRYSTAL_SPEAR, 12, MON_SPELL_WIZARD },
       { SPELL_BLINK, 12, MON_SPELL_WIZARD },
       { SPELL_BOLT_OF_FIRE, 12, MON_SPELL_WIZARD },
       { SPELL_BOLT_OF_COLD, 12, MON_SPELL_WIZARD },
      }
    },

    {  MST_WIZARD_IV,
      {
       { SPELL_STONE_ARROW, 10, MON_SPELL_WIZARD },
       { SPELL_STING, 10, MON_SPELL_WIZARD },
       { SPELL_BLINK, 10, MON_SPELL_WIZARD },
       { SPELL_LIGHTNING_BOLT, 10, MON_SPELL_WIZARD },
       { SPELL_BANISHMENT, 10, MON_SPELL_WIZARD },
      }
    },

    {  MST_WIZARD_V,
      {
       { SPELL_PARALYSE, 10, MON_SPELL_WIZARD },
       { SPELL_THROW_FLAME, 10, MON_SPELL_WIZARD },
       { SPELL_INVISIBILITY, 10, MON_SPELL_WIZARD  },
       { SPELL_FIREBALL, 10, MON_SPELL_WIZARD },
       { SPELL_TELEPORT_OTHER, 20, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_ORC_PRIEST,
      {
       { SPELL_PAIN, 13, MON_SPELL_PRIEST },
       { SPELL_CANTRIP, 13, MON_SPELL_PRIEST  },
       { SPELL_SMITING, 13, MON_SPELL_PRIEST },
       { SPELL_HEAL_OTHER, 13, MON_SPELL_PRIEST },
      }
    },

    {  MST_ORC_HIGH_PRIEST,
      {
       { SPELL_PAIN, 10, MON_SPELL_PRIEST },
       { SPELL_SUMMON_DEMON, 20, MON_SPELL_PRIEST  },
       { SPELL_SMITING, 10, MON_SPELL_PRIEST },
       { SPELL_HEAL_OTHER, 10, MON_SPELL_PRIEST },
       { SPELL_MINOR_HEALING, 10, MON_SPELL_PRIEST | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_MOTTLED_DRAGON,
      {
       { SPELL_STICKY_FLAME_RANGE, 55, MON_SPELL_NATURAL | MON_SPELL_BREATH
                                        | MON_SPELL_NOISY },
      }
    },

    {  MST_FIEND,
      {
       { SPELL_HELLFIRE, 34, MON_SPELL_DEMONIC },
       { SPELL_SYMBOL_OF_TORMENT, 17, MON_SPELL_DEMONIC },
      }
    },

    {  MST_HELL_SENTINEL,
      {
       { SPELL_HELLFIRE, 28, MON_SPELL_DEMONIC },
       { SPELL_IRON_SHOT, 14, MON_SPELL_DEMONIC },
      }
    },

    {  MST_ICE_FIEND,
      {
       { SPELL_BOLT_OF_COLD, 46, MON_SPELL_DEMONIC },
       { SPELL_SYMBOL_OF_TORMENT, 23, MON_SPELL_DEMONIC },
      }
    },

    {  MST_SHADOW_FIEND,
      {
       { SPELL_BOLT_OF_COLD, 17, MON_SPELL_DEMONIC },
       { SPELL_BOLT_OF_DRAINING, 17, MON_SPELL_DEMONIC },
       { SPELL_SYMBOL_OF_TORMENT, 17, MON_SPELL_DEMONIC },
       { SPELL_DISPEL_UNDEAD, 17, MON_SPELL_DEMONIC },
      }
    },

    {  MST_TORMENTOR,
      {
       { SPELL_PAIN, 28, MON_SPELL_DEMONIC },
       { SPELL_SYMBOL_OF_TORMENT, 29, MON_SPELL_DEMONIC },
      }
    },

    {  MST_STORM_DRAGON,
      {
       { SPELL_LIGHTNING_BOLT, 64, MON_SPELL_NATURAL | MON_SPELL_BREATH
                                    | MON_SPELL_NOISY },
      }
    },

    {  MST_WHITE_IMP,
      {
       { SPELL_THROW_FROST, 52, MON_SPELL_DEMONIC },
      }
    },

    {  MST_YNOXINUL,
      {
       { SPELL_IRON_SHOT, 19, MON_SPELL_DEMONIC },
       { SPELL_SUMMON_UFETUBUS, 38, MON_SPELL_DEMONIC  },
      }
    },

    {  MST_NEQOXEC,
      {
       { SPELL_MALMUTATE, 19, MON_SPELL_DEMONIC },
       { SPELL_BRAIN_FEED, 19, MON_SPELL_DEMONIC },
       { SPELL_SUMMON_MINOR_DEMON, 19, MON_SPELL_DEMONIC },
      }
    },

    {  MST_HELLWING,
      {
       { SPELL_CIGOTUVIS_EMBRACE, 28, MON_SPELL_DEMONIC },
       { SPELL_TELEPORT_OTHER, 28, MON_SPELL_DEMONIC },
       { SPELL_TELEPORT_SELF, 28, MON_SPELL_DEMONIC | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_SMOKE_DEMON,
      {
       { SPELL_STICKY_FLAME_RANGE, 19, MON_SPELL_DEMONIC },
       { SPELL_STEAM_BALL, 19, MON_SPELL_DEMONIC },
       { SPELL_SMITING, 19, MON_SPELL_DEMONIC },
      }
    },

    {  MST_CACODEMON,
      {
       { SPELL_ENERGY_BOLT, 13, MON_SPELL_DEMONIC },
       { SPELL_SLOW, 13, MON_SPELL_DEMONIC },
       { SPELL_CONFUSE, 13, MON_SPELL_DEMONIC },
       { SPELL_MALMUTATE, 13, MON_SPELL_DEMONIC },
       { SPELL_DIG, 13, MON_SPELL_DEMONIC },
      }
    },

    {  MST_GREEN_DEATH,
      {
       { SPELL_POISON_ARROW, 21, MON_SPELL_DEMONIC },
       { SPELL_POISONOUS_CLOUD, 21, MON_SPELL_DEMONIC },
       { SPELL_VENOM_BOLT, 21, MON_SPELL_DEMONIC },
      }
    },

    {  MST_BALRUG,
      {
       { SPELL_BOLT_OF_FIRE, 16, MON_SPELL_DEMONIC },
       { SPELL_FIREBALL, 16, MON_SPELL_DEMONIC },
       { SPELL_STICKY_FLAME_RANGE, 16, MON_SPELL_DEMONIC },
       { SPELL_SMITING, 16, MON_SPELL_DEMONIC },
      }
    },

    {  MST_BLIZZARD_DEMON,
      {
       { SPELL_LIGHTNING_BOLT, 16, MON_SPELL_DEMONIC },
       { SPELL_FREEZING_CLOUD, 16, MON_SPELL_DEMONIC },
       { SPELL_AIRSTRIKE, 16, MON_SPELL_DEMONIC },
       { SPELL_BOLT_OF_COLD, 16, MON_SPELL_DEMONIC },
      }
    },

    {  MST_TITAN,
      {
       { SPELL_LIGHTNING_BOLT, 18, MON_SPELL_WIZARD },
       { SPELL_MINOR_HEALING, 36, MON_SPELL_WIZARD },
       { SPELL_AIRSTRIKE, 18, MON_SPELL_WIZARD },
      }
    },

    {  MST_GOLDEN_DRAGON,
      {
       { SPELL_BOLT_OF_FIRE, 23, MON_SPELL_NATURAL | MON_SPELL_BREATH
                                  | MON_SPELL_NOISY },
       { SPELL_BOLT_OF_COLD, 23, MON_SPELL_NATURAL | MON_SPELL_BREATH
                                  | MON_SPELL_NOISY },
       { SPELL_POISONOUS_CLOUD, 23, MON_SPELL_NATURAL | MON_SPELL_BREATH
                                  | MON_SPELL_NOISY },
      }
    },

    {  MST_DEEP_ELF_SUMMONER,
      {
       { SPELL_BLINK, 15, MON_SPELL_WIZARD },
       { SPELL_SUMMON_VERMIN, 45, MON_SPELL_WIZARD  },
      }
    },

    {  MST_DEEP_ELF_CONJURER,
      {
       { SPELL_BOLT_OF_FIRE, 15, MON_SPELL_WIZARD },
       { SPELL_BOLT_OF_COLD, 15, MON_SPELL_WIZARD },
       { SPELL_LIGHTNING_BOLT, 15, MON_SPELL_WIZARD },
       { SPELL_BOLT_OF_DRAINING, 15, MON_SPELL_WIZARD },
      }
    },

    {  MST_DEEP_ELF_PRIEST,
      {
       { SPELL_PAIN, 14, MON_SPELL_PRIEST },
       { SPELL_MALIGN_OFFERING, 14, MON_SPELL_PRIEST },
       { SPELL_SMITING, 14, MON_SPELL_PRIEST },
       { SPELL_TWISTED_RESURRECTION, 14, MON_SPELL_PRIEST },
      }
    },

    {  MST_DEEP_ELF_HIGH_PRIEST,
      {
       { SPELL_SUMMON_DEMON, 12, MON_SPELL_PRIEST },
       { SPELL_HELLFIRE_BURST, 12, MON_SPELL_PRIEST },
       { SPELL_MALIGN_OFFERING, 12, MON_SPELL_PRIEST },
       { SPELL_SMITING, 12, MON_SPELL_PRIEST },
       { SPELL_TWISTED_RESURRECTION, 12, MON_SPELL_PRIEST },
      }
    },

    {  MST_DEEP_ELF_DEMONOLOGIST,
      {
       { SPELL_SUMMON_DEMON, 24, MON_SPELL_WIZARD  },
       { SPELL_SUMMON_GREATER_DEMON, 24, MON_SPELL_WIZARD },
       { SPELL_BANISHMENT, 12, MON_SPELL_WIZARD },
      }
    },

    {  MST_DEEP_ELF_ANNIHILATOR,
      {
       { SPELL_LIGHTNING_BOLT, 11, MON_SPELL_WIZARD },
       { SPELL_LEHUDIBS_CRYSTAL_SPEAR, 11, MON_SPELL_WIZARD },
       { SPELL_BLINK, 22, MON_SPELL_WIZARD },
       { SPELL_IRON_SHOT, 11, MON_SPELL_WIZARD },
       { SPELL_POISON_ARROW, 11, MON_SPELL_WIZARD },
      }
    },

    {  MST_DEEP_ELF_SORCERER,
      {
       { SPELL_CORROSIVE_BOLT, 11, MON_SPELL_WIZARD },
       { SPELL_BANISHMENT, 11, MON_SPELL_WIZARD },
       { SPELL_HASTE, 22, MON_SPELL_WIZARD },
       { SPELL_SUMMON_DEMON, 11, MON_SPELL_WIZARD },
       { SPELL_HELLFIRE, 11, MON_SPELL_WIZARD },
      }
    },

    {  MST_DEEP_ELF_DEATH_MAGE,
      {
       { SPELL_BOLT_OF_DRAINING, 22, MON_SPELL_WIZARD },
       { SPELL_VAMPIRIC_DRAINING, 22, MON_SPELL_WIZARD },
       { SPELL_CALL_LOST_SOUL, 11, MON_SPELL_WIZARD },
       { SPELL_TWISTED_RESURRECTION, 11, MON_SPELL_WIZARD },
      }
    },

    {  MST_KOBOLD_DEMONOLOGIST,
      {
       { SPELL_SUMMON_MINOR_DEMON, 19, MON_SPELL_WIZARD },
       { SPELL_SUMMON_DEMON, 19, MON_SPELL_WIZARD },
       { SPELL_CANTRIP, 19, MON_SPELL_WIZARD },
      }
    },

    {  MST_NAGA,
      {
       { SPELL_SPIT_POISON, 55, MON_SPELL_NATURAL | MON_SPELL_BREATH },
      }
    },

    {  MST_NAGA_MAGE,
      {
       { SPELL_SPIT_POISON, 55, MON_SPELL_NATURAL | MON_SPELL_BREATH },
       { SPELL_VENOM_BOLT, 10, MON_SPELL_WIZARD },
       { SPELL_ISKENDERUNS_MYSTIC_BLAST, 10, MON_SPELL_WIZARD },
       { SPELL_HASTE, 10, MON_SPELL_WIZARD  },
       { SPELL_POISON_ARROW, 10, MON_SPELL_WIZARD },
       { SPELL_TELEPORT_OTHER, 10, MON_SPELL_WIZARD },
       { SPELL_TELEPORT_SELF, 10, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_CURSE_SKULL,
      {
       { SPELL_SUMMON_UNDEAD, 48, MON_SPELL_MAGICAL | MON_SPELL_NOISY },
       { SPELL_SYMBOL_OF_TORMENT, 16, MON_SPELL_MAGICAL | MON_SPELL_NOISY },
      }
    },

    {  MST_SHINING_EYE,
      {
       { SPELL_MALMUTATE, 57, MON_SPELL_MAGICAL },
      }
    },

    {  MST_FROST_GIANT,
      {
       { SPELL_BOLT_OF_COLD, 66, MON_SPELL_WIZARD },
      }
    },

    {  MST_ANGEL,
      {
       { SPELL_MINOR_HEALING, 62, MON_SPELL_DEMONIC },
      }
    },

    {  MST_DAEVA,
      {
       { SPELL_SMITING, 64, MON_SPELL_DEMONIC },
      }
    },

    {  MST_SHADOW_DRAGON,
      {
       { SPELL_BOLT_OF_DRAINING, 67, MON_SPELL_NATURAL | MON_SPELL_BREATH },
      }
    },

    {  MST_SPHINX,
      {
       { SPELL_CONFUSE, 11, MON_SPELL_WIZARD },
       { SPELL_PARALYSE, 11, MON_SPELL_WIZARD },
       { SPELL_MINOR_HEALING, 22, MON_SPELL_WIZARD },
       { SPELL_SMITING, 11, MON_SPELL_WIZARD },
       { SPELL_SLOW, 11, MON_SPELL_WIZARD },
      }
    },

    {  MST_MUMMY_PRIEST,
      {
       { SPELL_SUMMON_DEMON, 12, MON_SPELL_PRIEST },
       { SPELL_SMITING, 12, MON_SPELL_PRIEST },
       { SPELL_SYMBOL_OF_TORMENT, 12, MON_SPELL_PRIEST },
       { SPELL_SUMMON_UNDEAD, 24, MON_SPELL_PRIEST },
      }
    },

    {  MST_ELECTRIC_GOLEM,
      {
       { SPELL_LIGHTNING_BOLT, 44, MON_SPELL_MAGICAL },
       { SPELL_BLINK, 22, MON_SPELL_MAGICAL },
      }
    },

    {  MST_ORB_OF_FIRE,
      {
       { SPELL_BOLT_OF_FIRE, 32, MON_SPELL_MAGICAL },
       { SPELL_FIREBALL, 32, MON_SPELL_MAGICAL },
       { SPELL_MALMUTATE, 16, MON_SPELL_MAGICAL },
      }
    },

    {  MST_SHADOW_IMP,
      {
       { SPELL_PAIN, 17, MON_SPELL_DEMONIC },
       { SPELL_ANIMATE_DEAD, 34, MON_SPELL_DEMONIC },
      }
    },

    {  MST_HELL_HOG,
      {
       { SPELL_STICKY_FLAME, 61, MON_SPELL_NATURAL },
      }
    },

    {  MST_SWAMP_DRAGON,
      {
       { SPELL_POISONOUS_CLOUD, 59, MON_SPELL_NATURAL | MON_SPELL_BREATH
                                     | MON_SPELL_NOISY },
      }
    },

    {  MST_SWAMP_DRAKE,
      {
       { SPELL_NOXIOUS_CLOUD, 54, MON_SPELL_NATURAL | MON_SPELL_BREATH },
      }
    },

    {  MST_SERPENT_OF_HELL,
      {
       { SPELL_SERPENT_OF_HELL_BREATH, 35, MON_SPELL_NATURAL | MON_SPELL_BREATH
                                            | MON_SPELL_NOISY },
       { SPELL_SUMMON_DRAGON, 35, MON_SPELL_DEMONIC },
      }
    },

    {  MST_BOGGART,
      {
       { SPELL_SHADOW_CREATURES, 33, MON_SPELL_WIZARD },
       { SPELL_INVISIBILITY, 11, MON_SPELL_WIZARD },
       { SPELL_BLINK, 11, MON_SPELL_WIZARD },
      }
    },

    {  MST_EYE_OF_DEVASTATION,
      {
       { SPELL_ENERGY_BOLT, 60, MON_SPELL_MAGICAL },
      }
    },

    {  MST_QUICKSILVER_DRAGON,
      {
       { SPELL_QUICKSILVER_BOLT, 66, MON_SPELL_NATURAL | MON_SPELL_BREATH
                                      | MON_SPELL_NOISY },
      }
    },

    {  MST_IRON_DRAGON,
      {
       { SPELL_METAL_SPLINTERS, 68, MON_SPELL_NATURAL | MON_SPELL_BREATH
                                     | MON_SPELL_NOISY },
      }
    },

    {  MST_NORRIS,
      {
       { SPELL_BRAIN_FEED, 12, MON_SPELL_PRIEST },
       { SPELL_SMITING, 12, MON_SPELL_PRIEST },
       { SPELL_INVISIBILITY, 12, MON_SPELL_PRIEST },
       { SPELL_CONFUSE, 12, MON_SPELL_PRIEST },
       { SPELL_PARALYSE, 12, MON_SPELL_PRIEST },
      }
    },

    {  MST_DEATH_DRAKE,
      {
       { SPELL_MIASMA_BREATH, 59, MON_SPELL_NATURAL | MON_SPELL_BREATH },
      }
    },

    {  MST_AZRAEL,
      {
       { SPELL_BOLT_OF_FIRE, 13, MON_SPELL_DEMONIC },
       { SPELL_STICKY_FLAME_RANGE, 13, MON_SPELL_DEMONIC },
       { SPELL_FIREBALL, 13, MON_SPELL_DEMONIC },
       { SPELL_HELLFIRE, 13, MON_SPELL_DEMONIC },
       { SPELL_HELLFIRE_BURST, 13, MON_SPELL_DEMONIC | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_DRAC_SCORCHER,
      {
       { SPELL_BOLT_OF_FIRE, 13, MON_SPELL_WIZARD },
       { SPELL_BOLT_OF_MAGMA, 13, MON_SPELL_WIZARD },
       { SPELL_FIREBALL, 13, MON_SPELL_WIZARD },
       { SPELL_HELLFIRE, 13, MON_SPELL_WIZARD },
       { SPELL_HELLFIRE_BURST, 13, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_DRAC_CALLER,
      {
       { SPELL_SUMMON_DRAKES, 66, MON_SPELL_WIZARD },
      }
    },

    {  MST_DRAC_SHIFTER,
      {
       { SPELL_DIMENSION_ANCHOR, 15, MON_SPELL_WIZARD },
       { SPELL_BLINK_OTHER, 15, MON_SPELL_WIZARD },
       { SPELL_BLINK_RANGE, 15, MON_SPELL_WIZARD },
       { SPELL_BLINK_ALLIES_ENCIRCLE, 15, MON_SPELL_WIZARD },
       { SPELL_BLINK_AWAY, 15, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_CURSE_TOE,
      {
       { SPELL_SYMBOL_OF_TORMENT, 26, MON_SPELL_MAGICAL },
       { SPELL_SUMMON_MUSHROOMS, 39, MON_SPELL_MAGICAL },
      }
    },

    {  MST_ICE_STATUE,
      {
       { SPELL_BOLT_OF_COLD, 12, MON_SPELL_MAGICAL },
       { SPELL_THROW_ICICLE, 12, MON_SPELL_MAGICAL },
       { SPELL_FREEZING_CLOUD, 12, MON_SPELL_MAGICAL },
       { SPELL_SUMMON_ICE_BEAST, 24, MON_SPELL_MAGICAL },
      }
    },

    // fake spell for monsters berserking when fleeing
    {  MST_BERSERK_ESCAPE,
      {
       { SPELL_BERSERKER_RAGE, 57, MON_SPELL_NATURAL | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_MERFOLK_AQUAMANCER,
      {
        { SPELL_PRIMAL_WAVE, 16, MON_SPELL_WIZARD },
        { SPELL_STEAM_BALL, 16, MON_SPELL_WIZARD },
        { SPELL_THROW_ICICLE, 16, MON_SPELL_WIZARD },
        { SPELL_BLINK, 16, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_ALLIGATOR,
      {
       { SPELL_SWIFTNESS, 62, MON_SPELL_NATURAL },
      }
    },

    // ---------------------
    // uniques' "spellbooks"
    // ---------------------

    {  MST_JESSICA,
      {
       { SPELL_PAIN, 17, MON_SPELL_WIZARD },
       { SPELL_SLOW, 8, MON_SPELL_WIZARD },
       { SPELL_HASTE, 8, MON_SPELL_WIZARD  },
       { SPELL_BLINK, 17, MON_SPELL_WIZARD },
      }
    },

    {  MST_RUPERT,
      {
       { SPELL_PARALYSE, 16, MON_SPELL_MAGICAL | MON_SPELL_NO_SILENT },
       { SPELL_CONFUSE, 16, MON_SPELL_MAGICAL | MON_SPELL_NO_SILENT },
       { SPELL_BERSERKER_RAGE, 33, MON_SPELL_MAGICAL },
      }
    },

    // statue, earth spells
    // Blink Other for foes out of the other spells' range
    { MST_ROXANNE,
      {
       { SPELL_LEHUDIBS_CRYSTAL_SPEAR, 13, MON_SPELL_WIZARD },
       { SPELL_IRON_SHOT, 13, MON_SPELL_WIZARD },
       { SPELL_BLINK_OTHER_CLOSE, 13, MON_SPELL_WIZARD },
       { SPELL_BOLT_OF_MAGMA, 13, MON_SPELL_WIZARD },
       { SPELL_ISKENDERUNS_MYSTIC_BLAST, 13, MON_SPELL_WIZARD },
      }
    },

    {  MST_SONJA,
      {
       { SPELL_BLINK, 28, MON_SPELL_WIZARD  },
       { SPELL_TELEPORT_SELF, 28, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    { MST_MENKAURE,
      {
       { SPELL_PAIN, 18, MON_SPELL_WIZARD },
       { SPELL_HASTE, 18, MON_SPELL_WIZARD  },
       { SPELL_SYMBOL_OF_TORMENT, 18, MON_SPELL_WIZARD },
      }
    },

    { MST_EUSTACHIO,
      {
       { SPELL_SUMMON_SMALL_MAMMAL, 14, MON_SPELL_WIZARD },
       { SPELL_SUMMON_MINOR_DEMON, 14, MON_SPELL_WIZARD },
       { SPELL_BLINK, 27, MON_SPELL_WIZARD },
      }
    },

    { MST_ILSUIW,
      {
       { SPELL_THROW_ICICLE, 11, MON_SPELL_WIZARD },
       { SPELL_CALL_TIDE, 11, MON_SPELL_WIZARD },
       { SPELL_INVISIBILITY, 11, MON_SPELL_WIZARD },
       { SPELL_BLINK, 11, MON_SPELL_WIZARD },
       { SPELL_WATER_ELEMENTALS, 22, MON_SPELL_WIZARD },
      }
    },

    {  MST_PRINCE_RIBBIT,
      {
       { SPELL_BLINK, 29, MON_SPELL_NATURAL },
       { SPELL_TELEPORT_SELF, 66, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_NESSOS,
      {
       { SPELL_BLINK_RANGE, 30, MON_SPELL_WIZARD },
       { SPELL_HASTE, 30, MON_SPELL_WIZARD  },
      }
    },

    {  MST_KIRKE,
      {
       { SPELL_PORKALATOR, 22, MON_SPELL_WIZARD },
       { SPELL_SLOW, 11, MON_SPELL_WIZARD },
       { SPELL_MONSTROUS_MENAGERIE, 11, MON_SPELL_WIZARD },
       { SPELL_CORONA, 11, MON_SPELL_WIZARD },
       { SPELL_INVISIBILITY, 11, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
       { SPELL_DEFLECT_MISSILES, 11, MON_SPELL_WIZARD },
      }
    },

    {  MST_DOWAN,
      {
       { SPELL_THROW_FROST, 9, MON_SPELL_WIZARD },
       { SPELL_CORONA, 9, MON_SPELL_WIZARD },
       { SPELL_BLINK, 9, MON_SPELL_WIZARD },
       { SPELL_THROW_FLAME, 9, MON_SPELL_WIZARD },
       { SPELL_HASTE_OTHER, 9, MON_SPELL_WIZARD },
      }
    },

    {  MST_FANNAR,
      {
       { SPELL_BOLT_OF_COLD, 10, MON_SPELL_WIZARD },
       { SPELL_OZOCUBUS_REFRIGERATION, 20, MON_SPELL_WIZARD },
       { SPELL_SUMMON_ICE_BEAST, 20, MON_SPELL_WIZARD },
       { SPELL_BLINK, 10, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
       { SPELL_OZOCUBUS_ARMOUR, 10, MON_SPELL_WIZARD },
       { SPELL_CONDENSATION_SHIELD, 10, MON_SPELL_WIZARD },
      }
    },

    {  MST_GASTRONOK,
      {
       { SPELL_AIRSTRIKE, 23, MON_SPELL_WIZARD },
       { SPELL_SLOW, 12, MON_SPELL_WIZARD },
       { SPELL_SWIFTNESS, 12, MON_SPELL_WIZARD },
       { SPELL_SUMMON_SMALL_MAMMAL, 12, MON_SPELL_WIZARD },
       { SPELL_CANTRIP, 12, MON_SPELL_WIZARD },
      }
    },

    {  MST_MAURICE,
      {
       { SPELL_INVISIBILITY, 14, MON_SPELL_WIZARD  },
       { SPELL_SWIFTNESS, 14, MON_SPELL_WIZARD },
       { SPELL_BLINK, 14, MON_SPELL_WIZARD },
       { SPELL_TELEPORT_SELF, 14, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    // demon lords
    {  MST_GERYON,
      {
       { SPELL_SUMMON_HELL_BEAST, 65, MON_SPELL_DEMONIC | MON_SPELL_NO_SILENT },
      }
    },

    {  MST_DISPATER,
      {
       { SPELL_SUMMON_GREATER_DEMON, 26, MON_SPELL_DEMONIC },
       { SPELL_LEHUDIBS_CRYSTAL_SPEAR, 13, MON_SPELL_DEMONIC },
       { SPELL_IRON_SHOT, 13, MON_SPELL_DEMONIC },
       { SPELL_HELLFIRE, 13, MON_SPELL_DEMONIC },
      }
    },

    {  MST_ASMODEUS,
      {
       { SPELL_BOLT_OF_FIRE, 22, MON_SPELL_DEMONIC },
       { SPELL_HELLFIRE, 22, MON_SPELL_DEMONIC },
       { SPELL_FIRE_SUMMON, 22, MON_SPELL_DEMONIC },
      }
    },

    {  MST_ERESHKIGAL,
      {
       { SPELL_BOLT_OF_COLD, 11, MON_SPELL_DEMONIC },
       { SPELL_SILENCE, 11, MON_SPELL_DEMONIC },
       { SPELL_SUMMON_GREATER_DEMON, 11, MON_SPELL_DEMONIC },
       { SPELL_SYMBOL_OF_TORMENT, 11, MON_SPELL_DEMONIC },
       { SPELL_PARALYSE, 11, MON_SPELL_DEMONIC },
       { SPELL_MAJOR_HEALING, 11, MON_SPELL_DEMONIC | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_ANTAEUS,
      {
       { SPELL_LIGHTNING_BOLT, 24, MON_SPELL_DEMONIC },
       { SPELL_FLASH_FREEZE, 48, MON_SPELL_DEMONIC },
      }
    },

    {  MST_MNOLEG,
      {
       { SPELL_SUMMON_EYEBALLS, 13, MON_SPELL_DEMONIC },
       { SPELL_MALIGN_GATEWAY, 27, MON_SPELL_DEMONIC },
       { SPELL_SUMMON_HORRIBLE_THINGS, 27, MON_SPELL_DEMONIC },
      }
    },

    {  MST_LOM_LOBON,
      {
       { SPELL_GLACIATE, 30, MON_SPELL_DEMONIC },
       { SPELL_CONJURE_BALL_LIGHTNING, 30, MON_SPELL_DEMONIC },
       { SPELL_MAJOR_HEALING, 30, MON_SPELL_DEMONIC },
       { SPELL_TORNADO, 60, MON_SPELL_DEMONIC },
       { SPELL_BLINK_RANGE, 30, MON_SPELL_DEMONIC },
      }
    },

    {  MST_CEREBOV,
      {
       { SPELL_FIRE_STORM, 11, MON_SPELL_DEMONIC },
       { SPELL_IRON_SHOT, 11, MON_SPELL_DEMONIC },
       { SPELL_HASTE, 36, MON_SPELL_DEMONIC  },
       { SPELL_SUMMON_GREATER_DEMON, 11, MON_SPELL_DEMONIC },
      }
    },

    {  MST_GLOORX_VLOQ,
      {
       { SPELL_POISON_ARROW, 20, MON_SPELL_DEMONIC },
       { SPELL_MIASMA_BREATH, 20, MON_SPELL_DEMONIC },
       { SPELL_SYMBOL_OF_TORMENT, 20, MON_SPELL_DEMONIC },
       { SPELL_BOLT_OF_DRAINING, 20, MON_SPELL_DEMONIC },
       { SPELL_DISPEL_UNDEAD, 20, MON_SPELL_DEMONIC },
      }
    },

    {  MST_KHUFU,
      {
       { SPELL_SUMMON_EMPEROR_SCORPIONS, 11, MON_SPELL_WIZARD },
       { SPELL_SMITING, 23, MON_SPELL_WIZARD },
       { SPELL_SYMBOL_OF_TORMENT, 11, MON_SPELL_WIZARD },
       { SPELL_SUMMON_UNDEAD, 11, MON_SPELL_WIZARD },
       { SPELL_TOMB_OF_DOROKLOHE, 11, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_NIKOLA,
      {
       { SPELL_SHOCK, 11, MON_SPELL_WIZARD },
       { SPELL_LIGHTNING_BOLT, 11, MON_SPELL_WIZARD },
       { SPELL_CHAIN_LIGHTNING, 23, MON_SPELL_WIZARD },
       { SPELL_BLINK, 23, MON_SPELL_WIZARD },
      }
    },

    {  MST_DISSOLUTION,
      {
       { SPELL_SUMMON_EYEBALLS, 62, MON_SPELL_PRIEST },
      }
    },

    {  MST_AIZUL,
      {
       { SPELL_VENOM_BOLT, 32, MON_SPELL_WIZARD },
       { SPELL_POISON_ARROW, 16, MON_SPELL_WIZARD },
       { SPELL_SLEEP, 16, MON_SPELL_WIZARD },
      }
    },

    {  MST_EXECUTIONER,
      {
       { SPELL_PAIN, 21, MON_SPELL_DEMONIC },
       { SPELL_HASTE, 41, MON_SPELL_DEMONIC },
      }
    },

    {  MST_IGNACIO,
      {
       { SPELL_AGONY, 17, MON_SPELL_DEMONIC },
       { SPELL_PAIN, 17, MON_SPELL_DEMONIC },
       { SPELL_HASTE, 34, MON_SPELL_DEMONIC },
      }
    },

    {  MST_HAROLD,
      {
       { SPELL_BOLT_OF_FIRE, 30, MON_SPELL_WIZARD },
       { SPELL_BLINK, 29, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_MARA,
      {
       { SPELL_BLINK, 29, MON_SPELL_NATURAL },
       { SPELL_BOLT_OF_FIRE, 14, MON_SPELL_DEMONIC },
       { SPELL_FAKE_MARA_SUMMON, 14, MON_SPELL_DEMONIC  },
       { SPELL_SUMMON_ILLUSION, 14, MON_SPELL_DEMONIC },
       { SPELL_PAIN, 14, MON_SPELL_DEMONIC },
       { SPELL_TELEPORT_SELF, 14, MON_SPELL_DEMONIC | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_BORIS,
      {
       { SPELL_IRON_SHOT, 12, MON_SPELL_WIZARD },
       { SPELL_BOLT_OF_COLD, 12, MON_SPELL_WIZARD },
       { SPELL_INVISIBILITY, 24, MON_SPELL_WIZARD },
       { SPELL_ANIMATE_DEAD, 12, MON_SPELL_WIZARD },
       { SPELL_IOOD, 12, MON_SPELL_WIZARD },
      }
    },

    {  MST_FREDERICK,
      {
       { SPELL_ISKENDERUNS_MYSTIC_BLAST, 12, MON_SPELL_WIZARD },
       { SPELL_BOLT_OF_COLD, 12, MON_SPELL_WIZARD },
       { SPELL_SPELLFORGED_SERVITOR, 24, MON_SPELL_WIZARD },
       { SPELL_IRON_SHOT, 12, MON_SPELL_WIZARD },
      }
    },

    {  MST_BK_OKAWARU,
      {
       { SPELL_MIGHT, 34, MON_SPELL_PRIEST  },
       { SPELL_HASTE, 34, MON_SPELL_PRIEST  },
      }
    },

    {  MST_SPRIGGAN_DRUID,
      {
       { SPELL_STONE_ARROW, 15, MON_SPELL_WIZARD },
       { SPELL_AWAKEN_FOREST, 15, MON_SPELL_WIZARD },
       { SPELL_DRUIDS_CALL, 15, MON_SPELL_WIZARD },
       { SPELL_MINOR_HEALING, 15, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_SPRIGGAN_AIR_MAGE,
      {
       { SPELL_AIRSTRIKE, 32, MON_SPELL_WIZARD },
       { SPELL_LIGHTNING_BOLT, 16, MON_SPELL_WIZARD },
       { SPELL_CONTROL_WINDS, 16, MON_SPELL_WIZARD },
       { SPELL_DEFLECT_MISSILES, 16, MON_SPELL_WIZARD },
      }
    },

    { MST_THE_ENCHANTRESS,
      {
       { SPELL_DIMENSION_ANCHOR, 11, MON_SPELL_WIZARD },
       { SPELL_SLOW, 11, MON_SPELL_WIZARD },
       { SPELL_HASTE, 11, MON_SPELL_WIZARD  },
       { SPELL_MASS_CONFUSION, 11, MON_SPELL_WIZARD },
       { SPELL_STRIP_RESISTANCE, 11, MON_SPELL_WIZARD },
       { SPELL_INVISIBILITY, 11, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
       { SPELL_DEFLECT_MISSILES, 11, MON_SPELL_WIZARD },
      }
    },

    {  MST_HELLEPHANT,
      {
       { SPELL_FIRE_BREATH, 35, MON_SPELL_NATURAL | MON_SPELL_BREATH },
       { SPELL_BLINK, 35, MON_SPELL_MAGICAL },
      }
    },

    {  MST_GRINDER,
      {
       { SPELL_PAIN, 19, MON_SPELL_DEMONIC },
       { SPELL_PARALYSE, 19, MON_SPELL_DEMONIC },
       { SPELL_BLINK, 19, MON_SPELL_DEMONIC },
      }
    },

    {  MST_IRON_ELEMENTAL,
      {
       { SPELL_IRON_SHOT, 21, MON_SPELL_MAGICAL },
       { SPELL_SLOW, 21, MON_SPELL_MAGICAL },
       { SPELL_METAL_SPLINTERS, 21, MON_SPELL_MAGICAL },
      }
    },

    {  MST_IRON_GIANT,
      {
       { SPELL_IRON_SHOT, 36, MON_SPELL_MAGICAL },
       { SPELL_IRON_ELEMENTALS, 36, MON_SPELL_MAGICAL },
      }
    },

    {  MST_MENNAS,
      {
       { SPELL_MASS_CONFUSION, 17, MON_SPELL_WIZARD },
       { SPELL_SILENCE, 17, MON_SPELL_WIZARD },
       { SPELL_MINOR_HEALING, 34, MON_SPELL_WIZARD },
      }
    },

    {  MST_NERGALLE,
      {
       { SPELL_BOLT_OF_DRAINING, 12, MON_SPELL_WIZARD },
       { SPELL_SUMMON_SPECTRAL_ORCS, 24, MON_SPELL_WIZARD },
       { SPELL_HASTE_OTHER, 12, MON_SPELL_WIZARD },
       { SPELL_DEATHS_DOOR, 12, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_JUMPING_SPIDER,
      {
       { SPELL_BLINK_CLOSE, 29, MON_SPELL_NATURAL },
       { SPELL_BLINK_AWAY, 29, MON_SPELL_NATURAL },
      }
    },

    {  MST_ORB_SPIDER,
      {
       { SPELL_IOOD, 57, MON_SPELL_NATURAL },
      }
    },

    {  MST_PEARL_DRAGON,
      {
       { SPELL_HOLY_BREATH, 68, MON_SPELL_NATURAL | MON_SPELL_BREATH
                                 | MON_SPELL_NOISY },
      }
    },

    {  MST_OPHAN,
      {
       { SPELL_BOLT_OF_FIRE, 32, MON_SPELL_DEMONIC },
       { SPELL_HOLY_FLAMES, 32, MON_SPELL_DEMONIC },
      }
    },

    {  MST_BOG_BODY,
      {
       { SPELL_BOLT_OF_COLD, 28, MON_SPELL_WIZARD },
       { SPELL_SLOW, 28, MON_SPELL_WIZARD },
       { SPELL_CORPSE_ROT, 28, MON_SPELL_WIZARD },
      }
    },

    {  MST_JORY,
      {
       { SPELL_LEHUDIBS_CRYSTAL_SPEAR, 17, MON_SPELL_WIZARD },
       { SPELL_MESMERISE, 17, MON_SPELL_WIZARD },
       { SPELL_BLINK_CLOSE, 17, MON_SPELL_WIZARD },
       { SPELL_VAMPIRIC_DRAINING, 17, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_EIDOLON,
      {
       { SPELL_BOLT_OF_DRAINING, 21, MON_SPELL_MAGICAL },
       { SPELL_CAUSE_FEAR, 21, MON_SPELL_MAGICAL },
      }
    },

    {  MST_BASILISK,
      {
       { SPELL_PETRIFY, 56, MON_SPELL_NATURAL },
      }
    },

    {  MST_CATOBLEPAS,
      {
       { SPELL_PETRIFYING_CLOUD, 41, MON_SPELL_NATURAL },
      }
    },

    {  MST_SHADOW_DEMON,
      {
       { SPELL_SHADOW_CREATURES, 30, MON_SPELL_DEMONIC },
       { SPELL_SUMMON_DEMON, 30, MON_SPELL_DEMONIC },
      }
    },

    {  MST_GNOLL_SHAMAN,
      {
       { SPELL_CORONA, 11, MON_SPELL_PRIEST },
       { SPELL_HEAL_OTHER, 21, MON_SPELL_PRIEST },
       { SPELL_HASTE_OTHER, 11, MON_SPELL_PRIEST },
       { SPELL_MINOR_HEALING, 11, MON_SPELL_PRIEST | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_ARACHNE,
      {
       { SPELL_ENSNARE, 34, MON_SPELL_WIZARD },
       { SPELL_POISON_ARROW, 11, MON_SPELL_WIZARD },
       { SPELL_VENOM_BOLT, 11, MON_SPELL_WIZARD },
       { SPELL_BLINK, 11, MON_SPELL_WIZARD },
      }
    },

    {  MST_HELLBINDER,
      {
       { SPELL_SUMMON_MINOR_DEMON, 14, MON_SPELL_WIZARD },
       { SPELL_SUMMON_DEMON, 14, MON_SPELL_WIZARD },
       { SPELL_HASTE, 14, MON_SPELL_WIZARD },
       { SPELL_HELLFIRE, 14, MON_SPELL_WIZARD },
       { SPELL_BLINK_AWAY, 14, MON_SPELL_WIZARD },
      }
    },

    {  MST_CLOUD_MAGE,
      {
       { SPELL_MEPHITIC_CLOUD, 12, MON_SPELL_WIZARD },
       { SPELL_FREEZING_CLOUD, 12, MON_SPELL_WIZARD },
       { SPELL_POISONOUS_CLOUD, 12, MON_SPELL_WIZARD },
       { SPELL_AIRSTRIKE, 12, MON_SPELL_WIZARD },
       { SPELL_BLINK_RANGE, 23, MON_SPELL_WIZARD },
      }
    },

    {  MST_SOUL_EATER,
      {
       { SPELL_DRAIN_LIFE, 30, MON_SPELL_DEMONIC },
      }
    },

    {  MST_WRETCHED_STAR,
      {
       { SPELL_ISKENDERUNS_MYSTIC_BLAST, 60, MON_SPELL_MAGICAL },
       { SPELL_CORRUPTING_PULSE, 40, MON_SPELL_NATURAL }, // XXX: _MAGICAL?
      }
    },

    {  MST_TENTACLED_STARSPAWN,
      {
       { SPELL_CREATE_TENTACLES, 66, MON_SPELL_NATURAL },
      }
    },

    {  MST_FRANCES,
      {
       { SPELL_THROW_ICICLE, 11, MON_SPELL_WIZARD },
       { SPELL_SUMMON_DEMON, 11, MON_SPELL_WIZARD },
       { SPELL_HASTE, 21, MON_SPELL_WIZARD },
       { SPELL_IRON_SHOT, 11, MON_SPELL_WIZARD },
       { SPELL_SUMMON_DEMON, 11, MON_SPELL_WIZARD },
      }
    },

    {  MST_NATASHA,
      {
       { SPELL_MAGIC_DART, 13, MON_SPELL_WIZARD },
       { SPELL_SLOW, 13, MON_SPELL_WIZARD },
       { SPELL_CALL_IMP, 13, MON_SPELL_WIZARD },
       { SPELL_CONJURE_FLAME, 13, MON_SPELL_WIZARD },
      }
    },

    {  MST_THRASHING_HORROR,
      {
       { SPELL_MIGHT, 59, MON_SPELL_NATURAL | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_JORGRUN,
      {
       { SPELL_LRD, 16, MON_SPELL_WIZARD },
       { SPELL_PETRIFY, 16, MON_SPELL_WIZARD },
       { SPELL_SHATTER, 16, MON_SPELL_WIZARD },
       { SPELL_DIG, 16, MON_SPELL_WIZARD },
      }
    },

    {  MST_DEEP_TROLL_EARTH_MAGE,
      {
       { SPELL_LRD, 31, MON_SPELL_WIZARD },
       { SPELL_DIG, 31, MON_SPELL_WIZARD },
      }
    },

    {  MST_DEEP_TROLL_SHAMAN,
      {
       { SPELL_HASTE_OTHER, 21, MON_SPELL_PRIEST },
       { SPELL_MIGHT_OTHER, 21, MON_SPELL_PRIEST },
       { SPELL_MINOR_HEALING, 21, MON_SPELL_PRIEST | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_VAULT_SENTINEL,
      {
       { SPELL_SIGNAL_HORN, 50, MON_SPELL_NATURAL | MON_SPELL_NO_SILENT
                                | MON_SPELL_BREATH },
       { SPELL_SENTINEL_MARK, 58, MON_SPELL_WIZARD },
      }
    },

    {  MST_IRONBRAND_CONVOKER,
      {
       { SPELL_MIGHT_OTHER, 30, MON_SPELL_WIZARD },
       { SPELL_WORD_OF_RECALL, 30, MON_SPELL_WIZARD },
      }
    },

    {  MST_IRONHEART_PRESERVER,
      {
       { SPELL_INJURY_BOND, 21, MON_SPELL_WIZARD },
       { SPELL_MINOR_HEALING, 41, MON_SPELL_WIZARD },
      }
    },

    {  MST_TEST_SPAWNER,
      {
       { SPELL_SHADOW_CREATURES, 100, MON_SPELL_DEMONIC },
       { SPELL_PLANEREND, 67, MON_SPELL_DEMONIC },
       { SPELL_PHANTOM_MIRROR, 33, MON_SPELL_DEMONIC },
      }
    },

    {  MST_ANCIENT_CHAMPION_I,
      {
       { SPELL_IRON_SHOT, 21, MON_SPELL_WIZARD },
       { SPELL_PAIN, 21, MON_SPELL_WIZARD },
       { SPELL_HASTE, 21, MON_SPELL_WIZARD  },
      }
    },

    {  MST_ANCIENT_CHAMPION_II,
      {
       { SPELL_BOLT_OF_DRAINING, 21, MON_SPELL_WIZARD },
       { SPELL_STONE_ARROW, 21, MON_SPELL_WIZARD },
       { SPELL_HASTE, 21, MON_SPELL_WIZARD  },
      }
    },

    {  MST_ANCIENT_CHAMPION_III,
      {
       { SPELL_VENOM_BOLT, 21, MON_SPELL_WIZARD },
       { SPELL_HAUNT, 21, MON_SPELL_WIZARD },
       { SPELL_ANIMATE_DEAD, 21, MON_SPELL_WIZARD },
      }
    },

    {  MST_ANCIENT_CHAMPION_IV,
      {
       { SPELL_ISKENDERUNS_MYSTIC_BLAST, 21, MON_SPELL_WIZARD },
       { SPELL_SLOW, 21, MON_SPELL_WIZARD },
       { SPELL_HASTE, 21, MON_SPELL_WIZARD  },
      }
    },

    {  MST_REVENANT,
      {
       { SPELL_GHOSTLY_FIREBALL, 17, MON_SPELL_MAGICAL },
       { SPELL_GHOSTLY_FLAMES, 17, MON_SPELL_MAGICAL },
       { SPELL_DISPEL_UNDEAD, 17, MON_SPELL_MAGICAL },
       { SPELL_BLINK_AWAY, 17, MON_SPELL_MAGICAL | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_DRYAD,
      {
       { SPELL_AWAKEN_VINES, 23, MON_SPELL_WIZARD },
       { SPELL_AWAKEN_FOREST, 23, MON_SPELL_WIZARD },
       { SPELL_MINOR_HEALING, 11, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_FAUN_I,
      {
       { SPELL_CORONA, 15, MON_SPELL_WIZARD },
       { SPELL_SLOW, 30, MON_SPELL_WIZARD },
      }
    },

    {  MST_FAUN_II,
      {
       { SPELL_CORONA, 15, MON_SPELL_WIZARD },
       { SPELL_CONFUSE, 10, MON_SPELL_WIZARD },
      }
    },

    {  MST_SATYR,
      {
       { SPELL_BATTLECRY, 25, MON_SPELL_NATURAL | MON_SPELL_NO_SILENT
                              | MON_SPELL_NOISY },
       { SPELL_CAUSE_FEAR, 32, MON_SPELL_WIZARD },
       { SPELL_SLEEP, 16, MON_SPELL_WIZARD },
      }
    },

    {  MST_TENGU_CONJURER_I,
      {
       { SPELL_FORCE_LANCE, 10, MON_SPELL_WIZARD },
       { SPELL_ISKENDERUNS_MYSTIC_BLAST, 19, MON_SPELL_WIZARD },
       { SPELL_BATTLESPHERE, 19, MON_SPELL_WIZARD  },
       { SPELL_BLINK, 10, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_TENGU_CONJURER_II,
      {
       { SPELL_THROW_FLAME, 10, MON_SPELL_WIZARD },
       { SPELL_BOLT_OF_MAGMA, 19, MON_SPELL_WIZARD },
       { SPELL_BATTLESPHERE, 19, MON_SPELL_WIZARD  },
       { SPELL_BLINK, 10, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_TENGU_CONJURER_III,
      {
       { SPELL_SHOCK, 10, MON_SPELL_WIZARD },
       { SPELL_LIGHTNING_BOLT, 19, MON_SPELL_WIZARD },
       { SPELL_BATTLESPHERE, 19, MON_SPELL_WIZARD  },
       { SPELL_BLINK, 10, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_TENGU_CONJURER_IV,
      {
       { SPELL_MEPHITIC_CLOUD, 10, MON_SPELL_WIZARD },
       { SPELL_VENOM_BOLT, 19, MON_SPELL_WIZARD },
       { SPELL_BATTLESPHERE, 19, MON_SPELL_WIZARD  },
       { SPELL_BLINK, 10, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_TENGU_REAVER_I,
      {
       { SPELL_LIGHTNING_BOLT, 27, MON_SPELL_WIZARD },
       { SPELL_BATTLESPHERE, 27, MON_SPELL_WIZARD  },
       { SPELL_FREEZING_CLOUD, 13, MON_SPELL_WIZARD },
      }
    },

    {  MST_TENGU_REAVER_II,
      {
       { SPELL_BOLT_OF_MAGMA, 17, MON_SPELL_WIZARD },
       { SPELL_BATTLESPHERE, 34, MON_SPELL_WIZARD  },
       { SPELL_FIREBALL, 17, MON_SPELL_WIZARD },
      }
    },

    {  MST_TENGU_REAVER_III,
      {
       { SPELL_VENOM_BOLT, 13, MON_SPELL_WIZARD },
       { SPELL_CORROSIVE_BOLT, 13, MON_SPELL_WIZARD },
       { SPELL_BATTLESPHERE, 27, MON_SPELL_WIZARD  },
       { SPELL_POISONOUS_CLOUD, 13, MON_SPELL_WIZARD },
      }
    },

    {  MST_SOJOBO,
      {
       { SPELL_LIGHTNING_BOLT, 14, MON_SPELL_WIZARD },
       { SPELL_WIND_BLAST, 28, MON_SPELL_WIZARD },
       { SPELL_AIRSTRIKE, 14, MON_SPELL_WIZARD },
       { SPELL_AIR_ELEMENTALS, 14, MON_SPELL_WIZARD },
       { SPELL_DEFLECT_MISSILES, 14, MON_SPELL_WIZARD },
      }
    },

    {  MST_WIND_DRAKE,
      {
       { SPELL_WIND_BLAST, 50, MON_SPELL_NATURAL | MON_SPELL_BREATH },
       { SPELL_AIRSTRIKE, 29, MON_SPELL_NATURAL },
       { SPELL_DEFLECT_MISSILES, 29, MON_SPELL_NATURAL },
      }
    },

    {  MST_THORN_HUNTER,
      {
       { SPELL_THORN_VOLLEY, 43, MON_SPELL_NATURAL },
       { SPELL_WALL_OF_BRAMBLES, 22, MON_SPELL_NATURAL },
      }
    },

    {  MST_WATER_NYMPH,
      {
       { SPELL_WATERSTRIKE, 60, MON_SPELL_WIZARD },
      }
    },

    {  MST_DRACONIAN_ZEALOT,
      {
       { SPELL_SUMMON_DEMON, 11, MON_SPELL_PRIEST },
       { SPELL_HELLFIRE_BURST, 11, MON_SPELL_PRIEST },
       { SPELL_SMITING, 11, MON_SPELL_PRIEST },
       { SPELL_ANIMATE_DEAD, 11, MON_SPELL_PRIEST },
       { SPELL_MINOR_HEALING, 22, MON_SPELL_PRIEST },
      }
    },

    // deep elf ie
    {  MST_DEEP_ELF_MAGE_I,
      {
       { SPELL_FREEZE, 22, MON_SPELL_WIZARD },
       { SPELL_THROW_ICICLE, 22, MON_SPELL_WIZARD },
       { SPELL_SUMMON_ICE_BEAST, 11, MON_SPELL_WIZARD },
      }
    },

    // deep elf ee
    {  MST_DEEP_ELF_MAGE_II,
      {
       { SPELL_BOLT_OF_MAGMA, 19, MON_SPELL_WIZARD },
       { SPELL_STONE_ARROW, 37, MON_SPELL_WIZARD },
      }
    },

    // deep elf wz
    {  MST_DEEP_ELF_MAGE_III,
      {
       { SPELL_ISKENDERUNS_MYSTIC_BLAST, 11, MON_SPELL_WIZARD },
       { SPELL_SLOW, 11, MON_SPELL_WIZARD },
       { SPELL_VENOM_BOLT, 11, MON_SPELL_WIZARD },
       { SPELL_BLINK, 22, MON_SPELL_WIZARD },
      }
    },

    // deep elf --fe
    {  MST_DEEP_ELF_MAGE_IV,
      {
       { SPELL_FLAME_TONGUE, 11, MON_SPELL_WIZARD },
       { SPELL_STICKY_FLAME_RANGE, 11, MON_SPELL_WIZARD },
       { SPELL_FIREBALL, 22, MON_SPELL_WIZARD },
       { SPELL_THROW_FLAME, 11, MON_SPELL_WIZARD },
      }
    },

    // deep elf cj
    {  MST_DEEP_ELF_MAGE_V,
      {
       { SPELL_MAGIC_DART, 11, MON_SPELL_WIZARD },
       { SPELL_FORCE_LANCE, 11, MON_SPELL_WIZARD },
       { SPELL_BATTLESPHERE, 22, MON_SPELL_WIZARD  },
       { SPELL_ISKENDERUNS_MYSTIC_BLAST, 11, MON_SPELL_WIZARD },
      }
    },

    {  MST_ASTERION,
      {
       { SPELL_MAJOR_DESTRUCTION, 11, MON_SPELL_PRIEST },
       { SPELL_SPECTRAL_WEAPON, 22, MON_SPELL_WIZARD },
       { SPELL_HASTE, 32, MON_SPELL_WIZARD },
      }
    },

    {  MST_RAIJU,
      {
       { SPELL_BLINKBOLT, 57, MON_SPELL_NATURAL },
      }
    },

    {  MST_OGRE_MAGE_I,
      {
       { SPELL_HASTE_OTHER, 10, MON_SPELL_WIZARD },
       { SPELL_PARALYSE, 10, MON_SPELL_WIZARD },
       { SPELL_HASTE, 10, MON_SPELL_WIZARD },
       { SPELL_LIGHTNING_BOLT, 10, MON_SPELL_WIZARD },
       { SPELL_CONFUSE, 10, MON_SPELL_WIZARD },
       { SPELL_TELEPORT_SELF, 10, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_OGRE_MAGE_II,
      {
       { SPELL_HASTE_OTHER, 10, MON_SPELL_WIZARD },
       { SPELL_ISKENDERUNS_MYSTIC_BLAST, 10, MON_SPELL_WIZARD },
       { SPELL_INVISIBILITY, 10, MON_SPELL_WIZARD },
       { SPELL_CONFUSE, 10, MON_SPELL_WIZARD },
       { SPELL_SLOW, 10, MON_SPELL_WIZARD },
       { SPELL_TELEPORT_SELF, 10, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_OGRE_MAGE_III,
      {
       { SPELL_HASTE_OTHER, 10, MON_SPELL_WIZARD },
       { SPELL_LEHUDIBS_CRYSTAL_SPEAR, 10, MON_SPELL_WIZARD },
       { SPELL_BLINK, 10, MON_SPELL_WIZARD },
       { SPELL_BOLT_OF_FIRE, 10, MON_SPELL_WIZARD },
       { SPELL_BOLT_OF_COLD, 10, MON_SPELL_WIZARD },
       { SPELL_MINOR_HEALING, 10, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_OGRE_MAGE_IV,
      {
       { SPELL_HASTE_OTHER, 10, MON_SPELL_WIZARD },
       { SPELL_STING, 10, MON_SPELL_WIZARD },
       { SPELL_BLINK, 10, MON_SPELL_WIZARD },
       { SPELL_LIGHTNING_BOLT, 10, MON_SPELL_WIZARD },
       { SPELL_BANISHMENT, 10, MON_SPELL_WIZARD },
       { SPELL_MINOR_HEALING, 10, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_OGRE_MAGE_V,
      {
       { SPELL_HASTE_OTHER, 10, MON_SPELL_WIZARD },
       { SPELL_THROW_FLAME, 10, MON_SPELL_WIZARD },
       { SPELL_INVISIBILITY, 10, MON_SPELL_WIZARD  },
       { SPELL_TELEPORT_OTHER, 20, MON_SPELL_WIZARD },
       { SPELL_FIREBALL, 10, MON_SPELL_WIZARD },
      }
    },

    {  MST_NAGA_SNIPER,
      {
       { SPELL_SPIT_POISON, 55, MON_SPELL_NATURAL | MON_SPELL_BREATH },
       { SPELL_PORTAL_PROJECTILE, 59, MON_SPELL_WIZARD },
      }
    },

    {  MST_NAGA_RITUALIST,
      {
       { SPELL_SPIT_POISON, 55, MON_SPELL_NATURAL | MON_SPELL_BREATH },
       { SPELL_FORCE_LANCE, 12, MON_SPELL_WIZARD },
       { SPELL_OLGREBS_TOXIC_RADIANCE, 23, MON_SPELL_WIZARD },
       { SPELL_VIRULENCE, 23, MON_SPELL_WIZARD },
      }
    },

    {  MST_SALAMANDER_MYSTIC,
      {
       { SPELL_ISKENDERUNS_MYSTIC_BLAST, 12, MON_SPELL_WIZARD },
       { SPELL_BOLT_OF_MAGMA, 12, MON_SPELL_WIZARD },
       { SPELL_HASTE_OTHER, 24, MON_SPELL_WIZARD },
       { SPELL_IGNITE_POISON_SINGLE, 12, MON_SPELL_WIZARD },
      }
    },

    {  MST_WORLDBINDER,
      {
       { SPELL_FORCEFUL_INVITATION, 58, MON_SPELL_MAGICAL },
      }
    },

    {  MST_DEMONSPAWN_BLOOD_SAINT,
      {
       { SPELL_LEGENDARY_DESTRUCTION, 32, MON_SPELL_PRIEST },
       { SPELL_EPHEMERAL_INFUSION, 32, MON_SPELL_PRIEST },
      }
    },

    {  MST_DEMONSPAWN_CORRUPTER,
      {
       { SPELL_PLANEREND, 32, MON_SPELL_PRIEST },
       { SPELL_CORRUPT_BODY, 32, MON_SPELL_PRIEST },
      }
    },

    {  MST_DEMONSPAWN_CHAOS_CHAMPION,
      {
       { SPELL_RANDOM_BOLT, 16, MON_SPELL_PRIEST },
       { SPELL_CHAOTIC_MIRROR, 16, MON_SPELL_PRIEST },
      }
    },

    {  MST_DEMONSPAWN_BLACK_SUN,
      {
       { SPELL_BOLT_OF_DRAINING, 13, MON_SPELL_WIZARD },
       { SPELL_MALIGN_OFFERING, 13, MON_SPELL_PRIEST },
       { SPELL_BLACK_MARK, 26, MON_SPELL_PRIEST },
       { SPELL_DISPEL_UNDEAD, 13, MON_SPELL_WIZARD },
      }
    },

    {  MST_DEMONSPAWN_WARMONGER,
      {
       { SPELL_SAP_MAGIC, 16, MON_SPELL_PRIEST },
       { SPELL_GRAND_AVATAR, 32, MON_SPELL_PRIEST },
      }
    },

    {  MST_DRACONIAN_KNIGHT,
      {
       { SPELL_BOLT_OF_COLD, 13, MON_SPELL_WIZARD },
       { SPELL_THROW_ICICLE, 13, MON_SPELL_WIZARD },
       { SPELL_HASTE, 13, MON_SPELL_WIZARD },
       { SPELL_SIMULACRUM, 13, MON_SPELL_WIZARD },
       { SPELL_INVISIBILITY, 13, MON_SPELL_WIZARD },
       { SPELL_OZOCUBUS_ARMOUR, 13, MON_SPELL_WIZARD },
      }
    },

    {  MST_VASHNIA,
      {
       { SPELL_SPIT_POISON, 55, MON_SPELL_NATURAL | MON_SPELL_BREATH },
       { SPELL_PORTAL_PROJECTILE, 22, MON_SPELL_WIZARD },
       { SPELL_BLINK_ALLIES_AWAY, 22, MON_SPELL_WIZARD },
       { SPELL_BLINK_AWAY, 11, MON_SPELL_WIZARD },
       { SPELL_BLINK_OTHER, 11, MON_SPELL_WIZARD | MON_SPELL_EMERGENCY },
       { SPELL_SHROUD_OF_GOLUBRIA, 11, MON_SPELL_WIZARD },
      }
    },

    {  MST_CRYSTAL_GUARDIAN,
      {
       { SPELL_CRYSTAL_BOLT, 66, MON_SPELL_MAGICAL },
      }
    },

    {  MST_GARGOYLE,
      {
       { SPELL_STONE_ARROW, 56, MON_SPELL_NATURAL },
      }
    },

    {  MST_MOLTEN_GARGOYLE,
      {
       { SPELL_BOLT_OF_MAGMA, 57, MON_SPELL_NATURAL },
      }
    },

    {  MST_OCTOPODE_CRUSHER,
      {
       { SPELL_IRON_SHOT, 26, MON_SPELL_WIZARD },
       { SPELL_TENTACLE_THROW, 80, MON_SPELL_NATURAL },
      }
    },

    {  MST_JOSEPHINE,
      {
       { SPELL_GHOSTLY_FIREBALL, 24, MON_SPELL_WIZARD },
       { SPELL_VAMPIRIC_DRAINING, 12, MON_SPELL_WIZARD },
       { SPELL_ANIMATE_DEAD, 12, MON_SPELL_WIZARD },
       { SPELL_DISPEL_UNDEAD, 12, MON_SPELL_WIZARD },
      }
    },

    {  MST_OBSIDIAN_STATUE,
      {
       { SPELL_SUMMON_MINOR_DEMON, 30, MON_SPELL_DEMONIC },
       { SPELL_SUMMON_DEMON, 30, MON_SPELL_DEMONIC },
      }
    },

    {  MST_ORANGE_CRYSTAL_STATUE,
      {
       // Not really natural, but it shouldn't be AM'd...
       { SPELL_BRAIN_FEED, 20, MON_SPELL_NATURAL },
       { SPELL_DRAINING_GAZE, 20, MON_SPELL_NATURAL },
       { SPELL_MASS_CONFUSION, 20, MON_SPELL_NATURAL },
      }
    },

    {  MST_MURRAY,
      {
       { SPELL_SUMMON_UNDEAD, 33, MON_SPELL_MAGICAL | MON_SPELL_NOISY },
       { SPELL_BLACK_MARK, 22, MON_SPELL_MAGICAL | MON_SPELL_NOISY },
       { SPELL_SYMBOL_OF_TORMENT, 11, MON_SPELL_MAGICAL | MON_SPELL_NOISY },
      }
    },

    {  MST_ELEMENTAL_WELLSPRING,
      {
       { SPELL_PRIMAL_WAVE, 65, MON_SPELL_MAGICAL },
      }
    },

    {  MST_GREATER_MUMMY_I,
      {
       { SPELL_SUMMON_MANA_VIPER, 13, MON_SPELL_WIZARD },
       { SPELL_SMITING, 13, MON_SPELL_WIZARD },
       { SPELL_SYMBOL_OF_TORMENT, 13, MON_SPELL_WIZARD },
       { SPELL_SUMMON_UNDEAD, 26, MON_SPELL_WIZARD },
      }
    },

    {  MST_GREATER_MUMMY_II,
      {
       { SPELL_SUMMON_DEMON, 13, MON_SPELL_WIZARD },
       { SPELL_SMITING, 13, MON_SPELL_WIZARD },
       { SPELL_SYMBOL_OF_TORMENT, 13, MON_SPELL_WIZARD },
       { SPELL_SUMMON_EMPEROR_SCORPIONS, 26, MON_SPELL_WIZARD },
      }
    },

    {  MST_GREATER_MUMMY_III,
      {
       { SPELL_SUMMON_DEMON, 13, MON_SPELL_WIZARD },
       { SPELL_SMITING, 13, MON_SPELL_WIZARD },
       { SPELL_SYMBOL_OF_TORMENT, 13, MON_SPELL_WIZARD },
       { SPELL_SUMMON_UNDEAD, 26, MON_SPELL_WIZARD },
      }
    },

    {  MST_GREATER_MUMMY_IV,
      {
       { SPELL_SUMMON_EMPEROR_SCORPIONS, 13, MON_SPELL_WIZARD },
       { SPELL_SMITING, 13, MON_SPELL_WIZARD },
       { SPELL_SYMBOL_OF_TORMENT, 13, MON_SPELL_WIZARD },
       { SPELL_SUMMON_SCARABS, 26, MON_SPELL_WIZARD },
      }
    },

    {  MST_FIRE_BREATH,
      {
       { SPELL_FIRE_BREATH, 62, MON_SPELL_NATURAL | MON_SPELL_BREATH },
      }
    },

    {  MST_FIRE_DRAGON_BREATH,
      {
       { SPELL_FIRE_BREATH, 62, MON_SPELL_NATURAL | MON_SPELL_BREATH
                                 | MON_SPELL_NOISY },
      }
    },

    {  MST_XTAHUA,
      {
       { SPELL_SEARING_BREATH, 62, MON_SPELL_NATURAL | MON_SPELL_BREATH
                                    | MON_SPELL_NOISY },
      }
    },

    {  MST_HELL_HOUND,
      {
       { SPELL_FIRE_BREATH, 20, MON_SPELL_NATURAL | MON_SPELL_BREATH },
      }
    },

    {  MST_FIRE_CRAB,
      {
       { SPELL_FLAMING_CLOUD, 62, MON_SPELL_NATURAL },
      }
    },

    {  MST_APOCALYPSE_CRAB,
      {
       { SPELL_CHAOS_BREATH, 62, MON_SPELL_NATURAL },
      }
    },

    {  MST_GHOST_CRAB,
      {
       { SPELL_GHOSTLY_FLAMES, 62, MON_SPELL_NATURAL },
      }
    },

    {  MST_ICE_DRAGON_BREATH,
      {
       { SPELL_COLD_BREATH, 62, MON_SPELL_NATURAL | MON_SPELL_BREATH
                                 | MON_SPELL_NOISY },
      }
    },

    {  MST_LAVA_SNAKE,
      {
       { SPELL_SPIT_LAVA, 100, MON_SPELL_NATURAL | MON_SPELL_BREATH },
      }
    },

    {  MST_ACID_SPIT,
      {
       { SPELL_SPIT_ACID, 67, MON_SPELL_NATURAL },
      }
    },

    {  MST_OKLOB_SAPLING,
      {
       { SPELL_SPIT_ACID, 50, MON_SPELL_NATURAL },
      }
    },

    {  MST_ELECTRIC_EEL,
      {
       { SPELL_ELECTRICAL_BOLT, 100, MON_SPELL_NATURAL },
      }
    },

    {  MST_SHOCK_SERPENT,
      {
       { SPELL_ELECTRICAL_BOLT, 33, MON_SPELL_NATURAL },
      }
    },

    {  MST_BURNING_BUSH,
      {
       { SPELL_THROW_FLAME, 67, MON_SPELL_NATURAL },
      }
    },

    {  MST_MANTICORE,
      {
       { SPELL_THROW_BARBS, 100, MON_SPELL_NATURAL },
      }
    },

    {  MST_DRACONIAN_ANNIHILATOR,
      {
       { SPELL_LIGHTNING_BOLT, 11, MON_SPELL_WIZARD },
       { SPELL_LEHUDIBS_CRYSTAL_SPEAR, 11, MON_SPELL_WIZARD },
       { SPELL_BLINK, 22, MON_SPELL_WIZARD },
       { SPELL_IRON_SHOT, 11, MON_SPELL_WIZARD },
       { SPELL_POISON_ARROW, 11, MON_SPELL_WIZARD },
      }
    },

    {  MST_BATTLECRY,
      {
       { SPELL_BATTLECRY, 100, MON_SPELL_NATURAL | MON_SPELL_INSTANT
                               | MON_SPELL_NOISY | MON_SPELL_NO_SILENT },
      }
    },

    {  MST_ROBIN,
      {
        { SPELL_BATTLECRY, 50, MON_SPELL_NATURAL | MON_SPELL_INSTANT
                                | MON_SPELL_NO_SILENT },
        { SPELL_GOBLIN_TOSS, 80, MON_SPELL_NATURAL }
      }
    },

    {  MST_SAINT_ROKA,
      {
       { SPELL_BATTLECRY, 100, MON_SPELL_NATURAL | MON_SPELL_INSTANT
                               | MON_SPELL_NOISY | MON_SPELL_NO_SILENT },
       { SPELL_SMITING, 64, MON_SPELL_PRIEST },
      }
    },

    {  MST_VAULT_WARDEN,
      {
       { SPELL_SEAL_DOORS, 50, MON_SPELL_MAGICAL | MON_SPELL_NO_SILENT },
      }
    },

    {  MST_FLAYED_GHOST,
      {
       { SPELL_FLAY, 40, MON_SPELL_MAGICAL },
      }
    },

    {  MST_MOTH_OF_WRATH,
      {
       { SPELL_BERSERK_OTHER, 66, MON_SPELL_NATURAL },
      }
    },

    {  MST_QUEEN_BEE,
      {
       { SPELL_BERSERK_OTHER, 50, MON_SPELL_NATURAL },
       { SPELL_BERSERK_OTHER, 75, MON_SPELL_NATURAL | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_PHANTASMAL_WARRIOR,
      {
       { SPELL_BLINK_CLOSE, 67, MON_SPELL_NATURAL },
      }
    },

    {  MST_SHADOW,
      {
       { SPELL_INVISIBILITY, 33, MON_SPELL_NATURAL },
      }
    },

    {  MST_SNORG,
      {
       { SPELL_BERSERKER_RAGE, 40, MON_SPELL_NATURAL },
      }
    },

    {  MST_SIREN,
      {
       { SPELL_SIREN_SONG, 160, MON_SPELL_NATURAL | MON_SPELL_NO_SILENT },
      }
    },

    {  MST_MERFOLK_AVATAR,
      {
       { SPELL_AVATAR_SONG, 160, MON_SPELL_NATURAL | MON_SPELL_NO_SILENT },
      }
    },

    {  MST_BLINKER,
      {
       { SPELL_BLINK, 29, MON_SPELL_NATURAL },
      }
    },

    {  MST_GIANT_EYEBALL,
      {
       { SPELL_PARALYSIS_GAZE, 100, MON_SPELL_NATURAL | MON_SPELL_INSTANT },
      }
    },

    {  MST_DRAIN_GAZE,
      {
       { SPELL_DRAINING_GAZE, 100, MON_SPELL_NATURAL | MON_SPELL_INSTANT },
      }
    },

    {  MST_GOLDEN_EYE,
      {
       { SPELL_CONFUSION_GAZE, 100, MON_SPELL_NATURAL | MON_SPELL_INSTANT },
       { SPELL_BLINK, 29, MON_SPELL_NATURAL },
      }
    },

    {  MST_USHABTI,
      {
       { SPELL_DEATH_RATTLE, 57, MON_SPELL_NATURAL },
      }
    },

    {  MST_ANUBIS_GUARD,
      {
       { SPELL_HUNTING_CRY, 56, MON_SPELL_NATURAL | MON_SPELL_NOISY
                                | MON_SPELL_NO_SILENT | MON_SPELL_BREATH },
       { SPELL_BOLT_OF_DRAINING, 56, MON_SPELL_NATURAL | MON_SPELL_BREATH },
       { SPELL_DISPEL_UNDEAD, 44, MON_SPELL_PRIEST },
      }
    },

    {  MST_DEEP_ELF_KNIGHT_I,
      {
       { SPELL_DAZZLING_SPRAY, 24, MON_SPELL_WIZARD },
       { SPELL_CONJURE_FLAME, 12, MON_SPELL_WIZARD },
       { SPELL_INVISIBILITY, 12, MON_SPELL_WIZARD },
       { SPELL_SWIFTNESS, 12, MON_SPELL_WIZARD },
      }
    },

    {  MST_DEEP_ELF_KNIGHT_II,
      {
       { SPELL_THROW_ICICLE, 24, MON_SPELL_WIZARD },
       { SPELL_HASTE, 12, MON_SPELL_WIZARD },
       { SPELL_INVISIBILITY, 12, MON_SPELL_WIZARD },
       { SPELL_CONDENSATION_SHIELD, 12, MON_SPELL_WIZARD },
      }
    },

    {  MST_DEEP_ELF_KNIGHT_III,
      {
       { SPELL_STONE_ARROW, 24, MON_SPELL_WIZARD },
       { SPELL_ISKENDERUNS_MYSTIC_BLAST, 12, MON_SPELL_WIZARD },
       { SPELL_HASTE, 12, MON_SPELL_WIZARD },
       { SPELL_SHROUD_OF_GOLUBRIA, 12, MON_SPELL_WIZARD },
      }
    },

    {  MST_SERAPH,
      {
       { SPELL_HUNTING_CRY, 50, MON_SPELL_NATURAL | MON_SPELL_NOISY
                                | MON_SPELL_NO_SILENT | MON_SPELL_BREATH },
       { SPELL_SUMMON_HOLIES, 50, MON_SPELL_PRIEST },
       { SPELL_INJURY_BOND, 50, MON_SPELL_DEMONIC },
       { SPELL_CLEANSING_FLAME, 25, MON_SPELL_PRIEST },
       { SPELL_SMITING, 13, MON_SPELL_DEMONIC },
       { SPELL_MINOR_HEALING, 12, MON_SPELL_DEMONIC | MON_SPELL_EMERGENCY },
      }
    },

    {  MST_SHARD_SHRIKE,
      {
        { SPELL_THROW_ICICLE, 24, MON_SPELL_NATURAL | MON_SPELL_BREATH },
      }
    },

    {  MST_INSUBSTANTIAL_WISP,
      {
       { SPELL_BLINK, 18, MON_SPELL_NATURAL },
       { SPELL_DISCHARGE, 32, MON_SPELL_NATURAL },
      }
    },
};
