--- This module defines the AST structure generated by the parser 
--- and used for the translation of SQL statements.
--- @author Julia Krone
--- @version 0.1
-- ---------------------------------------------------------------

module SQLAst where

import Time(CalendarTime)

data Statement = Select SelectHead Order (Maybe Int)
               | Update Table [Assign] Condition
               | UpdateEntity Table Value 
               | Delete Table Condition
               | Insert Table [ColumnRef] [[Value]]
               | Transaction  
               | InTransaction [Statement]
               | Commit
               | Rollback

--contains the table (Unique for a given alias
-- Def (default) in case no alias is given),
-- name of column, type of column, nullable, CDBI-alias
data ColumnRef = Column Tab String Type Bool Int

data Tab = Unique String | Def [String]

data Type = I | B | F | C | S | D | Key String | Entity String | Unknown

data Assign = Assign ColumnRef Value

data Value = Emb String Type
           | IntExp Int 
           | KeyExp String Int -- referenced table (name) and value
           | FloatExp Float 
           | StringExp String
           | DateExp CalendarTime
           | BoolExp Bool 
           | CharExp Char
           | AbsNull

data SelectHead = Set ASetOp SelectHead SelectHead
                | Query SelectClause TableRef Condition (Maybe Group)

data SelectClause = SelAll ASpecifier 
                  | SelColumns ASpecifier [SelElement]

data SelElement = Aggregation AFun ASpecifier ColumnRef
                | Col ColumnRef
                | Case Condition Operand Operand

data Table = Table String String Int -- name alias and CDBI-alias              
data TableRef = TableRef Table (Maybe JoinClause)
     
data JoinClause = CrossJoin Table (Maybe JoinClause) 
                | InnerJoin Table JoinCond (Maybe JoinClause)

data JoinCond =  JC Condition
                 
data ASpecifier = AAll | ADistinct

data Condition = FK (String,Int) AbsRel (String,Int)--(Table, Alias) Relation (Table,Alias)
               | Cmp ALogOp Condition Condition
               | Not Condition
               | Exists Statement
               | IsNull Operand
               | NotNull Operand
               | AIn Operand [Value]
               | ABinOp AstOp Operand Operand
               | ABetween Operand Operand Operand
               | NoCond

data AbsRel = AMToN String
            | ANToOne String
            | AOneToN String 
            | NotSpec String
               
type Operand = Either ColumnRef Value
data AstOp = ALth | ALe | AGth | AGe | AEq | AUnEq | ALike
data ALogOp = AAnd | AOr
data ASetOp = AUnion | AExcept | AIntersect

data Group = GroupBy [ColumnRef] Having
data Having = SimpleHave Condition
            | AggrHave AFun ASpecifier ColumnRef AstOp Operand
            | Neg Having
            | CmpHave ALogOp Having Having
            | NoHave

data AFun = ASum | ACount | AAvg | AMin | AMax            

data Order = OrderBy [(ColumnRef, Dir)]
data Dir = Asc | Desc