# Cylc: How to Contribute

## Report Bugs

Report bugs by opening an issue at [Cylc Issues on 
Github](https://github.com/cylc/cylc-flow/issues). Give the Cylc version
affected by the bug (you should test the latest release if possible) and a
recipe to reproduce the problem.

## Request Enhancements

Request enhancements by opening an issue at [Cylc Issues @
Github](https://github.com/cylc/cylc-flow/issues). Describe your use case in
detail.

## Contribute Code

All contributions to Cylc are made via Pull Requests against the *master*
branch of [cylc/cylc-flow](https://github.com/cylc/cylc-flow). Non-trivial
developments must be discussed and agreed in advance in a [Cylc
Issue](https://github.com/cylc/cylc-flow/issues) as the team may not be able to
consider large changes that appear out of the blue. New contributors should
add their details to the [Code Contributors](#code-contributors) section of
this file as part of their first Pull Request, and reviewers are responsible
for checking this before merging the new branch into *master*. 

## Code Contributors

The following people have contributed to this code under the terms of
the Contributor Licence Agreement and Certificate of Origin detailed
below (_except for the parenthesised names, which represent contributions
from outside of NIWA and the Met Office that predate the explicit introduction
of this Agreement in July 2018; they must be un-parenthesised in future pull
requests_).

 - Hilary Oliver
 - Matt Shin
 - Ben Fitzpatrick
 - Andrew Clark
 - Oliver Sanders
 - Declan Valters
 - Sadie Bartholomew
 - (Luis Kornblueh)
 - Kerry Day
 - Prasanna Challuri
 - David Matthews
 - Tim Whitcomb
 - (Scott Wales)
 - Tomek Trzeciak
 - (Thomas Coleman)
 - Bruno Kinoshita
 - (Annette Osprey)
 - (Jonathan Thomas)
 - Rosalyn Hatcher
 - (Domingo Manubens Gil)
 - Jonny Williams
 - (Milton Woods)
 - (Alex Reinecke)
 - (Chan Wilson)
 - (Kevin Pulo)
 - Lois Hugget
 - (Martin Dix)
 - (Ivor Blockley)
 - Alexander Paulsell
 - David Sutherland
 - Martin Ryan

(All contributors are identifiable with email addresses in the git version
control logs or otherwise.)

## Contributor Licence Agreement and Certificate of Origin

By making a contribution to this project, I certify that:

(a) The contribution was created in whole or in part by me and I have
    the right to submit it, either on my behalf or on behalf of my
    employer, under the terms and conditions as described by this file;
    or

(b) The contribution is based upon previous work that, to the best of
    my knowledge, is covered under an appropriate licence and I have
    the right or permission from the copyright owner under that licence
    to submit that work with modifications, whether created in whole or
    in part by me, under the terms and conditions as described by
    this file; or

(c) The contribution was provided directly to me by some other person
    who certified (a) or (b) and I have not modified it.

(d) I understand and agree that this project and the contribution
    are public and that a record of the contribution (including my
    name and email address) is retained for the full term of
    the copyright and may be redistributed consistent with this project
    or the licence(s) involved.

(e) I, or my employer, grant to NIWA and all recipients of
    this software a perpetual, worldwide, non-exclusive, no-charge,
    royalty-free, irrevocable copyright licence to reproduce, modify,
    prepare derivative works of, publicly display, publicly perform,
    sub-licence, and distribute this contribution and such modifications
    and derivative works consistent with this project or the licence(s)
    involved or other appropriate open source licence(s) specified by
    the project and approved by the
    [Open Source Initiative (OSI)](http://www.opensource.org/).

(f) If I become aware of anything that would make any of the above
    inaccurate, in any way, I will let NIWA know as soon as
    I become aware.

(The Cylc Contributor Licence Agreement and Certificate of Origin is
inspired that of [Rose](https://github.com/metomi/rose), which in turn was
inspired by the Certificate of Origin used by Enyo and the Linux Kernel.)
