#load "UbuntuRuntimeIdentifiers.Library.fsx"
#load "GetRuntimeJsonPath.fsx"
open System
open GetRuntimeJsonPath
open UbuntuRuntimeIdentifiers.Library

let runtimeJsonFilePath = getRuntimeJsonPath()

let dotnetRIDs = parseRuntimeIdentifiersFromRuntimeJsonFile runtimeJsonFilePath

let ridIsMissingInRuntimeJson rid =
    not (Set.contains rid dotnetRIDs)

let missingRIDs =
    ubuntuDotnetRIDsSinceTrustyTahr
    |> Seq.where ridIsMissingInRuntimeJson

if (Seq.isEmpty missingRIDs) then
    printfn "INFO: Okay (No missing RID found)"
else
    missingRIDs
    |> Seq.iter (fun missingRid -> 
        Console.ForegroundColor <- ConsoleColor.Red
        eprintfn $"ERROR: RID (Runtime Identifier) '{missingRid}' is missing in '{runtimeJsonFilePath}'!"
        Console.ResetColor()
        eprintfn $"INFO: This means that dotnet developers are unable to target '{missingRid}' for their application."
        eprintfn $"INFO: Possible solution: add '{missingRid}' RID as a patch and create Pull Request upstream."
        eprintfn "")
    
    Environment.Exit(-1)
