C Copyright 1981-2012 ECMWF.
C
C This software is licensed under the terms of the Apache Licence
C Version 2.0 which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
C
C In applying this licence, ECMWF does not waive the privileges and immunities
C granted to it by virtue of its status as an intergovernmental organisation
C nor does it submit to any jurisdiction.
C

      SUBROUTINE ABORTX (HNAME)
C
C---->
C**** ABORTX - Terminates execution of program.
C
C     Purpose.
C     --------
C
C     Terminates execution of program.
C
C**   Interface.
C     ----------
C
C     CALL ABORTX (HNAME)
C
C
C     Input Parameters.
C     -----------------
C
C     HNAME      - Name of calling routine.
C
C     Output Parameters.
C     ------------------
C
C     None.
C
C     Method.
C     -------
C
C     Prints message and terminates.
C
C     Externals.
C     ----------
C
#ifdef VAX
C     EXIT
#endif
#if (defined IBM) && (!defined rs6000)
C     SYSABN
#endif
#ifdef CRAY
C     ABORT
#endif
#if defined(sun) || defined (sgi) || (defined rs6000)
C     ABORT
#endif
#ifdef CYBER
C     ABORT
#endif
#ifdef __uxp__
C     ABORT
#endif
#ifdef __hpux
C     JABORT
#endif
C
C     Reference.
C     ----------
C
C     None.
C
C     Comments.
C     ---------
C
#ifdef VAX
C     VAX version of routine.
#endif
#if (defined IBM) && (!defined rs6000)
C     IBM version of routine.
#endif
#ifdef CRAY
C     Cray version of routine.
#endif
#if defined(sun) || defined (sgi)
C     SUN/SGI version of routine.
#endif
#ifdef CYBER
C     Cyber version of routine.
#endif
#ifdef __uxp__
C     Fujitsu version of routine.
#endif
C
C     Author.
C     -------
C
C     J. Hennessy      ECMWF      13.11.91
C
C     Modifications.
C     --------------
C
C     None.
C
C----<
C
      IMPLICIT NONE
C
#include "grprs.h"
C
      CHARACTER*(*) HNAME
C
C     ------------------------------------------------------------------
C*    Section 1 . Print message and terminate.
C     ------------------------------------------------------------------
C
  100 CONTINUE
C
      WRITE(GRPRSM,9001) HNAME
C
#ifdef VAX
      CALL EXIT (-1)
#endif
#if (defined IBM) && (!defined rs6000)
      CALL SYSABN (1)
#endif
#ifdef CRAY
      CALL ABORT
#endif
#ifdef CYBER
      CALL ABORT ('US',0,' ')
#endif
#if defined(__uxp__)
      CALL ABORT
#endif
#if defined(sun) || defined (sgi) || (defined rs6000)
      CALL ABORT
#endif
#ifdef __hpux
      CALL JABORT
#endif
CC    ensure a return (STOP is F77 and sets a return value)
      STOP 1
C
C     ------------------------------------------------------------------
C*    Section 9 . Format statements.
C     ------------------------------------------------------------------
C
  900 CONTINUE
C
 9001 FORMAT (1H ,'ABORTX : Routine ',A,' has requested program',
     C               ' termination.')
C
      RETURN
C
      END

