C Copyright 1981-2012 ECMWF.
C
C This software is licensed under the terms of the Apache Licence 
C Version 2.0 which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
C
C In applying this licence, ECMWF does not waive the privileges and immunities 
C granted to it by virtue of its status as an intergovernmental organisation 
C nor does it submit to any jurisdiction.
C

      INTEGER FUNCTION HSP2GG3(KTRUNC,KGAUSS,KPTS,PLATS,KSIZE)
C
C---->
C**** HSP2GG3
C
C     Purpose
C     -------
C
C     This routine finds a suitable gaussian grid for a given
C     spectral truncation.
C
C
C     Interface
C     ---------
C
C     IRET = HSP2GG3(KTRUNC,KGAUSS,KPTS,KSIZE)
C
C
C     Input parameters
C     ----------------
C
C     KTRUNC - The spectral truncation
C
C
C     Output parameters
C     -----------------
C
C     KGAUSS - The gaussian number
C     KPTS   - Array giving number of points along each line of latitude
C              in the reduced gaussian grid (both hemispheres)
C     PLATS  - Array giving gaussian latitudes (both hemispheres)
C     KSIZE  - The number of points in the reduced gaussian grid
C
C     Returns 0 if all OK, otherwise there is an error.
C
C
C     Common block usage
C     ------------------
C
C     None
C
C
C     Method
C     ------
C
C     None
C
C
C     Externals
C     ---------
C
C     JGETGG - Reads the definition of a gaussian grid
C
C
C     Reference
C     ---------
C
C     None.
C
C
C     Comments
C     --------
C
C     None.
C
C
C     Author
C     ------
C
C     J.D.Chambers      ECMWF      February 2001
C
C
C     Modifications
C     -------------
C
C     S.Curic     ECMWF      March 2005
C     Added checking for a automatic trancation T255, T399, T799, T2047 
C     and corresponding gaussian grid.
C
C     S.Curic     ECMWF      April 2008
C     Added checking for a automatic trancation T1279
C     and corresponding gaussian grid.
C
C
C     S.Curic     ECMWF      Semptember 2009
C     Match T255 and T213 against N128 instead of N160
C     upon Alan Geer request
C
C----<
C     -----------------------------------------------------------------|
C*    Section 0. Definition of variables.
C     -----------------------------------------------------------------|
C
      IMPLICIT NONE
C
#include "parim.h"
C
C     Function arguments
C
      INTEGER KTRUNC, KGAUSS, KPTS(*), KSIZE
      REAL PLATS(*)
#include "jparams.h"
C
C     Local variables
C
      INTEGER LOOP, IRET
      LOGICAL LDEBUG
C
C
C     -----------------------------------------------------------------|
C     Section 1.  Initialise.
C     -----------------------------------------------------------------|
C
  100 CONTINUE
C
      HSP2GG3 = 0

      CALL JDEBUG()
      LDEBUG = ( NDBG.NE.0 )
C
      IF(KGAUSS.EQ.1024) THEN      ! Mariano
        KTRUNC = 2047
      ELSEIF(KTRUNC.EQ.640) THEN ! Jan Haseler
        KTRUNC = 1279
      ELSEIF(KGAUSS.EQ.400) THEN   ! Oper 2005
        KTRUNC = 799
      ELSEIF(KGAUSS.EQ.320) THEN
        KTRUNC = 639
      ELSEIF(KGAUSS.EQ.256) THEN   ! Oper 2004
        KTRUNC = 511
      ELSEIF(KGAUSS.EQ.200) THEN   ! Enfo 2005
        KTRUNC = 399
      ELSEIF(KGAUSS.EQ.160) THEN
        KTRUNC = 319
      ELSEIF(KGAUSS.EQ.128) THEN   ! Enfo 2004
        KTRUNC = 255
      ELSEIF(KGAUSS.EQ.128) THEN
        KTRUNC = 213
      ELSEIF(KGAUSS.EQ.96) THEN   ! Elias 2014
        KTRUNC = 191
      ELSEIF(KGAUSS.EQ.80) THEN
        KTRUNC = 159
      ELSEIF(KGAUSS.EQ.48) THEN
        KTRUNC = 95
      ELSEIF(KGAUSS.EQ.48) THEN
        KTRUNC = 63
      ELSE
        CALL INTLOG(JP_ERROR,'HSP2GG3: Unmatched truncation',KTRUNC)
        HSP2GG3 = 1
        GOTO 900
      ENDIF
C
C     Get the reduced gaussian grid information and count the
C     number of points.
C
      CALL JGETGG(KGAUSS,'R',PLATS,KPTS,IRET)
      IF( IRET.NE.0 ) THEN
        CALL INTLOG(JP_ERROR,
     X    'HSP2GG3: JGETGG failed to get gaussian data',JPQUIET)
        HSP2GG3 = 2
        GOTO 900
      ENDIF
C
      KSIZE = 0
      DO LOOP = 1, KGAUSS*2
        KSIZE = KSIZE + KPTS(LOOP)
      ENDDO

      IF( LDEBUG ) THEN
          CALL INTLOG(JP_DEBUG,
     X    'HSP2GG3: Output Gaussian number :',KGAUSS)
          CALL INTLOG(JP_DEBUG,
     X    'HSP2GG3: Corresponding Spectral Truncation:',KTRUNC)
      ENDIF
C
C     -----------------------------------------------------------------|
C     Section 9.  Return.
C     -----------------------------------------------------------------|
C
  900 CONTINUE
C
      RETURN
      END
