      SUBROUTINE GRPRS4N(KSEC0,KSEC2,KSEC4,PSEC4)
C
C**** GRPRS4N - Print information from Section 4 of GRIB code.
C
C     Purpose.
C     --------
C
C           Print the information in the Binary data section
C           Section (Section 4) of decoded GRIB data.
C
C**   Interface.
C     ----------
C
C           CALL GRPRS4N(KSEC0,KSEC2,KSEC4,PSEC4)
C
C           Integer    K.
C           Real       P.
C           Logical    O.
C           Character  H.
C
C               Input Parameters.
C               -----------------
C
C               KSEC0 - Array of decoded integers from Section 0.
C
C               KSEC2 - Array of decoded integers from Section 2.
C
C               KSEC4 - Array of decoded integers from Section 4.
C
C               PSEC4 - Array of decoded reals from Section 4.
C
C               Output Parameters.
C               ------------------
C
C               None.
C
C     Method.
C     -------
C
C           Fields printed as integers or reals.
C
C     Externals.
C     ----------
C
C           SETPAR
C           INXBIT.
C
C     Reference.
C     ----------
C
C           WMO Manual on Codes re GRIB Code.
C           See also routine GRIBEX.
C
C     Comments.
C     ---------
C
C           Routine contains Sections 0 to 1 and Section 9.
C
C     Author.
C     -------
C
C           J. Hennessy    ECMWF 11.09.91
C
C     Modifications.
C     --------------
C
C
C     J. Hennessy    ECMWF 21.07.92
C
C     J.D.Chambers   ECMWF 20.10.93
C     Distinguish between real and integer values
C     in print of gridpoint values
C
C     J.D.Chambers   ECMWF 09.05.94
C     Print complex packing information
C
C     J.D.Chambers   ECMWF 14.06.95
C     Change format for printing missing data indicator to
C     allow for MAGICS value (-1.5E+21)
C
C     J. Clochard, Meteo France, for ECMWF - January 1998.
C     Take into account second-order packing for grid-point data.
C
C     -----------------------------------------------------------------
C*    Section 0. Definition of variables.
C     -----------------------------------------------------------------
C
      IMPLICIT NONE
C
      INTEGER INUM
C
      INTEGER IVALUE, IBIT, IDUM, INSPT, IRET
#ifdef REAL_8
      INTEGER*8 JDCVAL(5)
      REAL RJDCVAL(5)
      EQUIVALENCE (JDCVAL(1),RJDCVAL(1))
#else
      INTEGER JDCVAL(5)
#endif
C
      INTEGER KSEC0
      INTEGER KSEC2
      INTEGER KSEC4
C
      DIMENSION KSEC0(*)
      DIMENSION KSEC2(*)
      DIMENSION KSEC4(*)
C
      REAL PSEC4(*)
C
      INTEGER LOOP1, LOOP2, START, IEND, IREST
      LOGICAL LMATRIX
C
C     -----------------------------------------------------------------
C*    Section 1 . Print integer information from KSEC4.
C     -----------------------------------------------------------------
C
  100 CONTINUE
C
      WRITE (*,9000)
      WRITE (*,9001)
      WRITE (*,9002)
C
      WRITE (*,9003) KSEC4(1)
      WRITE (*,9004) KSEC4(2)
      WRITE (*,9005) KSEC4(3)
      WRITE (*,9006) KSEC4(4)
      WRITE (*,9007) KSEC4(5)
      WRITE (*,9008) KSEC4(6)
      WRITE (*,9009) KSEC4(7)
      WRITE (*,9010) KSEC4(8)
      WRITE (*,9011) KSEC4(9)
      WRITE (*,9012) KSEC4(10)
C
C     If complex packing ..
C
      IF ( KSEC4(4).EQ.64 ) THEN
C
        IF ( KSEC4(3).EQ.128 ) THEN
          WRITE (*,9116) KSEC4(16)
          WRITE (*,9117) KSEC4(17)
          WRITE (*,9118) KSEC4(18)
          WRITE (*,9119) KSEC4(19)
          WRITE (*,9120) KSEC4(20)
        ELSE
          WRITE (*,9013) KSEC4(11)
          WRITE (*,9014) KSEC4(12)
          WRITE (*,9015) KSEC4(13)
          WRITE (*,9016) KSEC4(14)+KSEC4(15)
        ENDIF
C
      ENDIF
C
C     Number of non-missing values
C
      IF ( KSEC4(21).NE.0 )  WRITE (*,9017) KSEC4(21)
C
C     Information on matrix of values , if present.
C
      LMATRIX = (KSEC4(8).EQ.64)
      IF ( LMATRIX ) THEN
        WRITE (*,9020) KSEC4(50)
        WRITE (*,9021) KSEC4(51)
        WRITE (*,9022) KSEC4(52)
        WRITE (*,9023)
        WRITE (*,9024) KSEC4(53)
        WRITE (*,9025) KSEC4(54)
        WRITE (*,9023)
        WRITE (*,9026) KSEC4(55)
        WRITE (*,9027) KSEC4(56)
        WRITE (*,9028) KSEC4(57)
      ENDIF
C
C     -----------------------------------------------------------------
C*    Section 2. Print values from PSEC4.
C     -----------------------------------------------------------------
C
  200 CONTINUE
C
      WRITE (*,9000)
C
      INUM = KSEC4(1)
      IF (INUM.LT.0)  INUM = - INUM
      IF (INUM.GT.600000) INUM = 600000
C
C     Print first INUM values.
C
      WRITE (*,*) ' First ',INUM,' data values.'
      WRITE (*,*)
C
C
      IF ( KSEC4(5) .EQ. 0 ) THEN
C
C     Print real values ...
C
        IEND = (INUM/5)*5
        DO LOOP1 = 1, IEND, 5
          WRITE(*,5000) PSEC4(LOOP1),PSEC4(LOOP1+1),
     X                  PSEC4(LOOP1+2),PSEC4(LOOP1+3),
     X                  PSEC4(LOOP1+4)
        ENDDO
C
        IREST = INUM - IEND
        IF( IREST.EQ.4 ) THEN
          WRITE(*,5000) PSEC4(IEND+1),PSEC4(IEND+2),
     X                  PSEC4(IEND+3),PSEC4(IEND+4)
        ELSE IF( IREST.EQ.3 ) THEN
          WRITE(*,5000) PSEC4(IEND+1),PSEC4(IEND+2),PSEC4(IEND+3)
        ELSE IF( IREST.EQ.2 ) THEN
          WRITE(*,5000) PSEC4(IEND+1),PSEC4(IEND+2)
        ELSE IF( IREST.EQ.1 ) THEN
          WRITE(*,5000) PSEC4(IEND+1)
        ENDIF
C
      ELSE
C
C       Print integer values ...
C
        IBIT = 32
        IEND = (INUM/5)*5
        DO LOOP1 = 1, IEND, 5
          DO LOOP2 = 1, 5
#ifdef REAL_8
            RJDCVAL(LOOP2) = PSEC4(LOOP1+LOOP2-1)
#else
            INSPT = 0
            CALL INXBIT(JDCVAL(LOOP2),5,INSPT,PSEC4(LOOP1+LOOP2-1),1,
     X                  IBIT,IBIT,'C',IRET)
#endif
          ENDDO
          WRITE(*,5001)
     X      JDCVAL(1),JDCVAL(2),JDCVAL(3),JDCVAL(4),JDCVAL(5)
        ENDDO
C
        IREST = INUM - IEND
        DO LOOP2 = 1, IREST
#ifdef REAL_8
          RJDCVAL(LOOP2) = PSEC4(LOOP1+LOOP2-1)
#else
          INSPT = 0
          CALL INXBIT(JDCVAL(LOOP2),5,INSPT,PSEC4(LOOP1+LOOP2-1),1,
     X                IBIT,IBIT,'C',IRET)
#endif
C
        ENDDO
        IF( IREST.EQ.4 ) THEN
          WRITE(*,5001) JDCVAL(1),JDCVAL(2),JDCVAL(3),JDCVAL(4)
        ELSE IF( IREST.EQ.3 ) THEN
          WRITE(*,5001) JDCVAL(1),JDCVAL(2),JDCVAL(3)
        ELSE IF( IREST.EQ.2 ) THEN
          WRITE(*,5001) JDCVAL(1),JDCVAL(2)
        ELSE IF( IREST.EQ.1 ) THEN
          WRITE(*,5001) JDCVAL(1)
        ENDIF
C
      ENDIF
C
C     -----------------------------------------------------------------
C*    Section 9 . Format statements. Return to calling routine.
C     -----------------------------------------------------------------
C
  900 CONTINUE
C
 5000 FORMAT(5(1X,F20.12))
 5001 FORMAT(5(1X,I20))
 9000 FORMAT(' ')
 9001 FORMAT(' Section 4 - Binary Data  Section.')
 9002 FORMAT(' -------------------------------------')
 9003 FORMAT(' Number of data values coded/decoded.         ',I9)
 9004 FORMAT(' Number of bits per data value.               ',I9)
 9005 FORMAT(' Type of data       (0=grid pt, 128=spectral).',I9)
 9006 FORMAT(' Type of packing    (0=simple, 64=complex).   ',I9)
 9007 FORMAT(' Type of data       (0=float, 32=integer).    ',I9)
 9008 FORMAT(' Additional flags   (0=none, 16=present).     ',I9)
 9009 FORMAT(' Reserved.                                    ',I9)
 9010 FORMAT(' Number of values   (0=single, 64=matrix).    ',I9)
 9011 FORMAT(' Secondary bit-maps (0=none, 32=present).     ',I9)
 9012 FORMAT(' Values width       (0=constant, 16=variable).',I9)
 9013 FORMAT(' Bits number of 2nd order values    (none=>0).',I9)
 9014 FORMAT(' General extend. 2-order packing (0=no,8=yes).',I9)
 9015 FORMAT(' Boustrophedonic ordering        (0=no,4=yes).',I9)
 9016 FORMAT(' Spatial differencing order          (0=none).',I9)
 9017 FORMAT(' Number of non-missing values                 ',I9)
 9120 FORMAT(' Pentagonal resolution parameter M for subset.',I9)
 9020 FORMAT(' First dimension (rows) of each matrix.       ',I9)
 9021 FORMAT(' Second dimension (columns) of each matrix.   ',I9)
 9022 FORMAT(' First dimension coordinate values definition.',I9)
 9023 FORMAT(' (Code Table 12)')
 9024 FORMAT(' NC1 - Number of coefficients for 1st dimension.',I7)
 9025 FORMAT(' Second dimension coordinate values definition.',I8)
 9026 FORMAT(' NC2 - Number of coefficients for 2nd dimension.',I7)
 9027 FORMAT(' 1st dimension physical signifance (Table 13). ',I8)
 9028 FORMAT(' 2nd dimension physical signifance (Table 13). ',I8)
 9031 FORMAT(' First ',I4,' data values.')
 9032 FORMAT(' ',F30.15)
C
 9033 FORMAT(' ',I15)
C
 9116 FORMAT(' Byte offset of start of packed data (N).     ',I9)
 9117 FORMAT(' Power (P * 1000).                            ',I9)
 9118 FORMAT(' Pentagonal resolution parameter J for subset.',I9)
 9119 FORMAT(' Pentagonal resolution parameter K for subset.',I9)
      RETURN
C
      END
