/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Authors : Mandy Wu <mandy.wu@intel.com>
 *
 * Copyright © 2011 Intel Corporation. (www.intel.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 */

/* APIs : e_ews_connection_get_attachments */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <glib.h>
#include <glib/gprintf.h>

#include "server/e-ews-connection.h"
#include "server/e-ews-item.h"
#include "server/e-ews-message.h"

#include "utils.h"

static void op_test_get_attachments (void);
void get_attachments_tests_run (void);

static GMainLoop *main_loop;

static void
get_attachments_ready_callback (GObject *object,
                                GAsyncResult *res,
                                gpointer user_data)
{
	EEwsConnection *cnc = E_EWS_CONNECTION (object);
	GError *error = NULL;
	GSList *ids = NULL, *l;

	e_ews_connection_get_attachments_finish (cnc, res, &ids, &error);

	if (error != NULL) {
		g_print ("Unable to get attachment: %s :%d \n", error->message, error->code);
		goto quit;
	}

	for (l = ids; l != NULL; l = g_slist_next (l)) {
		g_print ("Attachment uri is: %s\n", (gchar *) l->data);
		g_free (l->data);
	}

quit:
	g_main_loop_quit (main_loop);
}

static void
op_test_get_attachments (void)
{
	const gchar *username;
	const gchar *password;
	const gchar *uri;
	const gchar *attachmentid;
	EEwsConnection *cnc;
	GCancellable *cancellable;
	CamelEwsSettings *settings;
	GSList *ids = NULL;
	gchar *tmpdir;

	cancellable = g_cancellable_new ();

	util_get_login_info_from_env (&username, &password, &uri);
	g_assert_cmpstr (username, !=, NULL);
	g_assert_cmpstr (password, !=, NULL);
	g_assert_cmpstr (uri, !=, NULL);

	settings = g_object_new (
		CAMEL_TYPE_EWS_SETTINGS,
		"user", username, NULL);

	cnc = e_ews_connection_new (uri, settings);
	e_ews_connection_set_password (cnc, password);

	g_object_unref (settings);

	attachmentid = "AAASAG1hbmR5Lnd1QGludGVsLmNvbQBGAAAAAACdSXexmsgJTpd3WpdX6ulXBwAm9E+BClHfQqEnvCoGvhheAAAAjpb6AACIeDU1D80fTrC3245yXdhOADUAPRB8AAABEgAQAIlh9YZzdzdMtvWW9ZI7+vM=";
	ids = g_slist_append (ids, (gpointer *) attachmentid);
	attachmentid = "AAASAG1hbmR5Lnd1QGludGVsLmNvbQBGAAAAAACdSXexmsgJTpd3WpdX6ulXBwAm9E+BClHfQqEnvCoGvhheAAAAjpb6AACIeDU1D80fTrC3245yXdhOADUAPRB8AAABEgAQADgh/XHkRSZEoCsn9BHi5Fc=";
	ids = g_slist_append (ids, (gpointer *) attachmentid);

	tmpdir = g_build_filename (g_get_tmp_dir (), NULL);

	e_ews_connection_get_attachments (
		cnc, EWS_PRIORITY_MEDIUM,
		"xuidx", ids, tmpdir, TRUE,
		NULL, NULL, cancellable,
		get_attachments_ready_callback, NULL);
	g_free (tmpdir);
}

static gboolean
idle_cb (gpointer data)
{
	g_print ("Testing get attachments..... \n");
	op_test_get_attachments ();

	return FALSE;
}

/*Run tests*/
void get_attachments_tests_run (void)
{
	g_type_init ();

	main_loop = g_main_loop_new (NULL, TRUE);
	g_idle_add ((GSourceFunc) idle_cb, NULL);
	g_main_loop_run (main_loop);

	/* terminate */
	g_main_loop_unref (main_loop);
}
