# EYE reasoning

### Architecture and design

The Semantic Web Databus and Proofbus from [Tim Berners-Lee](http://www.w3.org/People/Berners-Lee/) which is  
like a world wide welding machine transforming data into pragmatic proofs:  
  
<img src="https://www.w3.org/DesignIssues/diagrams/sweb-bus.png" width="60%" height="60%" alt="PDB"/>  

### Examples and Test Cases

* bayesian networks e.g.
    [ccd](https://github.com/josd/eye/tree/master/reasoning/ccd),
    [nbbn](https://github.com/josd/eye/tree/master/reasoning/nbbn),
    [swet](https://github.com/josd/eye/tree/master/reasoning/swet)
* control systems e.g.
    [cs](https://github.com/josd/eye/tree/master/reasoning/cs)
* ershovian compilation e.g.
    [dt](https://github.com/josd/eye/tree/master/reasoning/dt),
    [preduction](https://github.com/josd/eye/tree/master/reasoning/preduction)
* logic puzzles e.g.
    [4color](https://github.com/josd/eye/tree/master/reasoning/4color),
    [dp](https://github.com/josd/eye/tree/master/reasoning/dp),
    [einstein](https://github.com/josd/eye/tree/master/reasoning/einstein),
    [graph](https://github.com/josd/eye/tree/master/reasoning/graph),
    [hanoi](https://github.com/josd/eye/tree/master/reasoning/hanoi),
    [witch](https://github.com/josd/eye/tree/master/reasoning/witch)
* markovian networks e.g.
    [mmln](https://github.com/josd/eye/tree/master/reasoning/mmln)
* mathematical computation e.g.
    [dpe](https://github.com/josd/eye/tree/master/reasoning/dpe),
    [equation4](https://github.com/josd/eye/tree/master/reasoning/equation4),
    [fib](https://github.com/josd/eye/tree/master/reasoning/fib),
    [lldm](https://github.com/josd/eye/tree/master/reasoning/lldm),
    [pi](https://github.com/josd/eye/tree/master/reasoning/pi),
    [tak](https://github.com/josd/eye/tree/master/reasoning/tak)
* neural networks e.g.
    [fcm](https://github.com/josd/eye/tree/master/reasoning/fcm),
    [fgcm](https://github.com/josd/eye/tree/master/reasoning/fgcm)
* quantum computation e.g.
    [dqc](https://github.com/josd/eye/tree/master/reasoning/dqc)
* turing machines e.g.
    [turing](https://github.com/josd/eye/tree/master/reasoning/turing),
    [usm](https://github.com/josd/eye/tree/master/reasoning/usm)
* workflow composers e.g.
    [gps](https://github.com/josd/eye/tree/master/reasoning/gps),
    [map](https://github.com/josd/eye/tree/master/reasoning/map),
    [resto](https://github.com/josd/eye/tree/master/reasoning/resto),
    [restpath](https://github.com/josd/eye/tree/master/reasoning/restpath)
