#!/bin/sh
# $Id$
#
# mimic install but use soft links instead
#
# Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
# This program is free software. You can redistribute it and/or modify it
# under the terms of the GNU General Public License, either version 2 of
# the License, or (at your option) any later version. See COPYING.


if [ $1 = '-c' ]; then
	# -c -> ignored
	shift
fi

if [ $1 = '-m' ]; then
	# mode -> ignore
	shift
	shift
fi

eval TRG="\${$#}"

# more than two arguments? -> target is directory.
if [ $# -gt 2 ]; then
	if [ ! -d "$TRG" ]; then
		echo "$TRG is not a directory."
		exit 1
	fi
fi

TARGET_IS_DIR=0
if [ -d "$TRG" ]; then 
	TARGET_IS_DIR=1
fi

while [ $# -gt 1 ]; do
	SRC=$1
	shift

	if [ ! -e "$(pwd)/$SRC" ]; then
		echo "$SRC no such file or directory."
		exit 1
	fi

	if [ $TARGET_IS_DIR -eq 1 ]; then
		DST="$TRG/$(basename $SRC)"
	else
		DST="$TRG"
	fi


	
	if [ -e "$DST" -a \( ! \( -h "$DST" \) \) ]; then
		echo "$DST exists and is not a symbolic link. Skipping."
		continue
	fi

	echo ln -sf "$(pwd)/$SRC" "$TRG"
	ln -sf "$(pwd)/$SRC" "$TRG"
done
