/*
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __ASSERT_H_INCLUDED
#define __ASSERT_H_INCLUDED

#include "build_config.h"

#define __assert_fail	MODE_PREFIX(__assert_fail)

extern void
__assert_fail(
	const char *expr,
	const char *file,
	int line,
	const char *func
) __attribute__((__noreturn__));

#ifdef NDEBUG

#define assert(expr)	\
if (__builtin_constant_p(expr) && ! (expr)) { \
	__assert_fail(#expr, __FILE__, __LINE__, __PRETTY_FUNCTION__); \
}

#else /* NDEBUG */

#define assert(expr)	\
if (! (expr)) { \
	__assert_fail(#expr, __FILE__, __LINE__, __PRETTY_FUNCTION__); \
}

#endif /* !NDEBUG */

#endif /* __ASSERT_H_INCLUDED */
