/*
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __CONST_H_INCLUDED
#define __CONST_H_INCLUDED

#include "segment.h"
#include "compiler.h"

/* ==================== REAL-MODE ==================== */
#if defined(RUNTIME_RM) || defined(INIT_RM) 

#define const_get(c) \
	( \
		  (sizeof(c) == 1) ? get_byte(PTR_SEG(&c), PTR_OFF(&c)) \
		: (sizeof(c) == 2) ? get_word(PTR_SEG(&c), PTR_OFF(&c)) \
		: (sizeof(c) == 4) ? get_long(PTR_SEG(&c), PTR_OFF(&c)) \
		: -1 \
	)
#endif /* REAL-MODE */

/* ==================== PROTECTED MODE ==================== */
#if defined(RUNTIME_PM)

#define const_get(c) c

#endif /* PROTECTED MODE */

#endif /* __CONST_H_INCLUDED */
