/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.RABytes;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.Codec;

public class QTRLECodec
extends BaseCodec
implements Codec {
    public byte[] compress(byte[] data, int x, int y, int[] dims, Object options) throws FormatException {
        throw new FormatException("QTRLE compression not supported.");
    }

    public byte[] decompress(byte[] data, Object options) throws FormatException {
        if (options == null || !(options instanceof Object[])) {
            return null;
        }
        Object[] o = (Object[])options;
        byte[] prev = (byte[])o[1];
        int[] dims = (int[])o[0];
        int x = dims[0];
        int y = dims[1];
        int bpp = dims[2];
        int numLines = y;
        if (data.length < 8) {
            return prev;
        }
        try {
            RABytes s = new RABytes(data);
            s.skipBytes(4);
            short header = s.readShort();
            int off = 0;
            int start = 0;
            byte[] output = new byte[x * y * bpp];
            if ((header & 8) == 8) {
                int i;
                start = s.readShort();
                s.skipBytes(2);
                numLines = s.readShort();
                s.skipBytes(2);
                if (prev != null) {
                    for (i = 0; i < start; ++i) {
                        off = i * x * bpp;
                        System.arraycopy(prev, off, output, off, x * bpp);
                    }
                }
                off += x * bpp;
                if (prev != null) {
                    for (i = start + numLines; i < y; ++i) {
                        int offset = i * x * bpp;
                        System.arraycopy(prev, offset, output, offset, x * bpp);
                    }
                }
            } else {
                throw new FormatException("Unsupported header : " + header);
            }
            int skip = 0;
            byte rle = 0;
            int rowPointer = start * x * bpp;
            for (int i = 0; i < numLines; ++i) {
                block28: {
                    skip = s.read();
                    if (skip < 0) {
                        skip += 256;
                    }
                    if (prev != null) {
                        try {
                            System.arraycopy(prev, rowPointer, output, rowPointer, (skip - 1) * bpp);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            // empty catch block
                        }
                    }
                    off = rowPointer + (skip - 1) * bpp;
                    do {
                        if ((rle = (byte)(s.read() & 0xFF)) == 0) {
                            skip = s.read();
                            if (prev != null) {
                                try {
                                    System.arraycopy(prev, off, output, off, (skip - 1) * bpp);
                                }
                                catch (ArrayIndexOutOfBoundsException e) {
                                    // empty catch block
                                }
                            }
                            off += (skip - 1) * bpp;
                            continue;
                        }
                        if (rle == -1) {
                            if (off < rowPointer + x * bpp && prev != null) {
                                System.arraycopy(prev, off, output, off, rowPointer + x * bpp - off);
                            }
                            break block28;
                        }
                        if (rle < -1) {
                            for (int j = 0; j < -1 * rle && off < output.length; off += bpp, ++j) {
                                System.arraycopy(data, (int)s.getFilePointer(), output, off, bpp);
                            }
                            s.skipBytes(bpp);
                            continue;
                        }
                        int len = rle * bpp;
                        if (output.length - off < len) {
                            len = output.length - off;
                        }
                        if (s.length() - s.getFilePointer() < (long)len) {
                            len = (int)(s.length() - s.getFilePointer());
                        }
                        if (len < 0) {
                            len = 0;
                        }
                        if (off > output.length) {
                            off = output.length;
                        }
                        s.read(output, off, len);
                        off += len;
                    } while (s.getFilePointer() < s.length());
                    return output;
                }
                rowPointer += x * bpp;
            }
            return output;
        }
        catch (IOException e) {
            throw new FormatException(e);
        }
    }
}

