/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Vector;
import nom.tam.fits.BinaryTableHeaderParser;
import nom.tam.fits.Column;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;
import nom.tam.util.ColumnTable;
import nom.tam.util.TableException;

public class BinaryTable
extends Data {
    byte[] hashArea = new byte[0];
    int hashPtr = 0;
    Vector columns;
    int[] sizes;
    int[][] dimens;
    Object[] modelRow;
    ColumnTable table;

    public BinaryTable() throws FitsException {
        this.columns = new Vector();
        try {
            this.table = new ColumnTable(new Object[0], new int[0]);
        }
        catch (TableException e) {
            throw new FitsException("Unable to create table:" + e);
        }
        this.dataArray = this.table;
        this.dimens = new int[0][];
        this.sizes = new int[0];
        this.modelRow = new Object[0];
    }

    public BinaryTable(Header myHeader) throws FitsException {
        BinaryTableHeaderParser parser = new BinaryTableHeaderParser(myHeader);
        this.modelRow = parser.getModelRow();
        int naxis2 = myHeader.getIntValue("NAXIS2");
        int nfields = myHeader.getIntValue("TFIELDS");
        this.columns = new Vector(nfields);
        this.sizes = new int[nfields];
        this.dimens = new int[nfields][];
        this.modelRow = parser.getModelRow();
        int size = this.useModelRow(this.modelRow, naxis2);
        Object[] arrCol = new Object[nfields];
        this.columns.copyInto(arrCol);
        try {
            this.table = new ColumnTable(arrCol, this.sizes);
        }
        catch (TableException e) {
            throw new FitsException("Unable to create table:" + e);
        }
        int hsize = myHeader.trueDataSize();
        if (size < hsize) {
            this.hashArea = new byte[hsize - size];
            this.hashPtr = this.hashArea.length;
        } else if (size > hsize) {
            throw new FitsException("Size inconsistency in header and data: Check NAXIS1 and PCOUNT");
        }
    }

    protected int useModelRow(Object[] model, int nrow) {
        int totalsize = 0;
        for (int col = 0; col < model.length; ++col) {
            Class base = ArrayFuncs.getBaseClass(model[col]);
            this.dimens[col] = ArrayFuncs.getDimensions(model[col]);
            int size = 1;
            for (int dim = 0; dim < this.dimens[col].length; ++dim) {
                size *= this.dimens[col][dim];
            }
            this.sizes[col] = size;
            Object array = Array.newInstance(base, size * nrow);
            this.columns.addElement(array);
            totalsize += size * nrow * ArrayFuncs.getBaseLength(model[col]);
        }
        return totalsize;
    }

    public BinaryTable(Object[][] data) throws FitsException {
        this.modelRow = data[0];
        this.dimens = new int[this.modelRow.length][];
        this.sizes = new int[this.modelRow.length];
        this.columns = new Vector(this.modelRow.length);
        this.useModelRow(this.modelRow, data.length);
        this.hashPtr = 0;
        this.rowToColumn(data);
        Object[] ocols = new Object[this.columns.size()];
        this.columns.copyInto(ocols);
        try {
            this.table = new ColumnTable(ocols, this.sizes);
        }
        catch (TableException e) {
            throw new FitsException("Error creating ColumnTable");
        }
    }

    private void rowToColumn(Object[][] data) {
        for (int col = 0; col < this.modelRow.length; ++col) {
            Object column = this.columns.elementAt(col);
            for (int row = 0; row < data.length; ++row) {
                System.arraycopy(ArrayFuncs.flatten(data[row][col]), 0, column, row * this.sizes[col], this.sizes[col]);
            }
        }
    }

    public Object[] getRow(int row) throws FitsException {
        if (!this.validRow(row)) {
            throw new FitsException("Invalid row");
        }
        Object[] data = new Object[this.modelRow.length];
        for (int col = 0; col < this.modelRow.length; ++col) {
            data[col] = ArrayFuncs.curl(this.table.getElement(row, col), this.dimens[col]);
        }
        return data;
    }

    public void setRow(int row, Object[] data) throws FitsException {
        if (data.length != this.getNcol()) {
            throw new FitsException("Updated row size does not agree with table");
        }
        Object[] ydata = new Object[data.length];
        for (int col = 0; col < data.length; ++col) {
            ydata[col] = ArrayFuncs.flatten(data[col]);
        }
        try {
            this.table.setRow(row, ydata);
        }
        catch (TableException e) {
            throw new FitsException("Error modifying table: " + e);
        }
    }

    public void setColumn(int col, Object[] xcol) throws FitsException {
        int nrow = xcol.length;
        if (nrow != this.getNrow()) {
            throw new FitsException("Replacement column had wrong number of rows");
        }
        int[] dims = ArrayFuncs.getDimensions(xcol[0]);
        int size = 1;
        for (int dim = 0; dim < dims.length; ++dim) {
            size *= dims[dim];
        }
        if (size != this.sizes[col]) {
            throw new FitsException("Replacement column has size mismatch");
        }
        Object x = this.columns.elementAt(col);
        if (ArrayFuncs.getBaseClass(xcol) != ArrayFuncs.getBaseClass(x)) {
            throw new FitsException("Replactment column has type mismatch");
        }
        for (int row = 0; row < nrow; ++row) {
            System.arraycopy(ArrayFuncs.flatten(xcol[row]), 0, x, row * size, size);
        }
    }

    public void setFlattenedColumn(int col, Object data) throws FitsException {
        Object x = this.columns.elementAt(col);
        if (x.getClass() != data.getClass() || Array.getLength(x) != Array.getLength(data)) {
            throw new FitsException("Replacement column mismatch");
        }
        System.arraycopy(data, 0, x, 0, this.sizes[col]);
    }

    public Object[] getColumn(int col) throws FitsException {
        if (!this.validColumn(col)) {
            throw new FitsException("Invalid column");
        }
        int[] dims = new int[this.dimens[col].length + 1];
        System.arraycopy(this.dimens[col], 0, dims, 0, this.dimens[col].length);
        dims[this.dimens[col].length] = this.getNrow();
        return (Object[])ArrayFuncs.curl(this.columns.elementAt(col), dims);
    }

    public Object getFlattenedColumn(int col) throws FitsException {
        if (!this.validColumn(col)) {
            throw new FitsException("Invalid column");
        }
        return this.columns.elementAt(col);
    }

    public Object getElement(int i, int j) throws FitsException {
        if (!this.validRow(i) || !this.validColumn(j)) {
            throw new FitsException("No such element");
        }
        return this.table.getElement(i, j);
    }

    public void addRow(Object[] o) throws FitsException {
        Vector newColumns = new Vector(this.columns.size());
        for (int col = 0; col < this.columns.size(); ++col) {
            Object oldArray = this.columns.elementAt(col);
            int olen = Array.getLength(oldArray);
            Class obase = ArrayFuncs.getBaseClass(oldArray);
            Object newArray = Array.newInstance(obase, olen + this.sizes[col]);
            System.arraycopy(oldArray, 0, newArray, 0, olen);
            System.arraycopy(ArrayFuncs.flatten(o[col]), 0, newArray, olen, this.sizes[col]);
        }
        this.columns = newColumns;
        Object[] arrCol = new Object[this.columns.size()];
        this.columns.copyInto(arrCol);
        try {
            this.table = new ColumnTable(arrCol, this.sizes);
        }
        catch (TableException e) {
            throw new FitsException("Unable to modify table:" + e);
        }
    }

    public void addColumn(Object[] o) throws FitsException {
        int[] dims = ArrayFuncs.getDimensions(o[0]);
        this.addFlattenedColumn(ArrayFuncs.flatten(o), dims);
    }

    public void addFlattenedColumn(Object o, int[] dims) throws FitsException {
        int[] newsizes = new int[this.sizes.length + 1];
        int[][] newdimens = new int[this.dimens.length + 1][];
        Object[] newmodel = new Object[this.modelRow.length + 1];
        int size = 1;
        for (int dim = 0; dim < dims.length; ++dim) {
            size *= dims[dim];
        }
        for (int col = 0; col < this.sizes.length; ++col) {
            newsizes[col] = this.sizes[col];
            newdimens[col] = this.dimens[col];
            newmodel[col] = this.modelRow[col];
        }
        this.sizes = newsizes;
        this.dimens = newdimens;
        this.modelRow = newmodel;
        this.sizes[this.sizes.length - 1] = size;
        this.dimens[this.sizes.length - 1] = dims;
        this.modelRow[this.sizes.length - 1] = Array.newInstance(ArrayFuncs.getBaseClass(o), dims);
        this.columns.addElement(o);
        Object[] arrCol = new Object[this.columns.size()];
        this.columns.copyInto(arrCol);
        try {
            this.table = new ColumnTable(arrCol, this.sizes);
        }
        catch (TableException e) {
            throw new FitsException("Unable to modify table:" + e);
        }
        this.dataArray = this.table;
    }

    public int getNrow() {
        return this.table.getNrow();
    }

    public int getNcol() {
        return this.table.getNcol();
    }

    protected boolean validRow(int i) {
        return this.getNrow() > 0 && i >= 0 && i < this.getNrow();
    }

    protected boolean validColumn(int j) {
        return j >= 0 && j < this.getNcol();
    }

    public void setElement(int i, int j, Object o) throws FitsException {
        try {
            this.table.setElement(i, j, ArrayFuncs.flatten(o));
        }
        catch (TableException e) {
            throw new FitsException("Error modifying table:" + e);
        }
    }

    protected void expandHashArea(int need) {
        if (this.hashPtr + need > this.hashArea.length) {
            int newlen = (int)((double)(this.hashPtr + need) * 1.5);
            if (newlen < 16384) {
                newlen = 16384;
            }
            byte[] newHash = new byte[newlen];
            System.arraycopy(this.hashArea, 0, newHash, 0, this.hashPtr);
            this.hashArea = newHash;
        }
    }

    protected void writeTrueData(BufferedDataOutputStream o) throws FitsException {
        try {
            this.table.write(o);
            o.write(this.hashArea, 0, this.hashPtr);
        }
        catch (IOException e) {
            throw new FitsException("Error writing binary table data:" + e);
        }
    }

    public void read(BufferedDataInputStream i) throws FitsException {
        this.readTrueData(i);
    }

    protected void readTrueData(BufferedDataInputStream i) throws FitsException {
        try {
            int len = this.table.read(i);
            if (this.hashArea.length > 0) {
                i.readPrimitiveArray(this.hashArea);
            }
            if ((len += this.hashArea.length) % 2880 != 0) {
                byte[] padding = new byte[2880 - len % 2880];
                i.readPrimitiveArray(padding);
            }
        }
        catch (IOException e) {
            throw new FitsException("Error reading binary table data:" + e);
        }
    }

    public int getTrueSize() {
        return super.getTrueSize() + this.hashPtr;
    }

    public Column addVarData(Object[] data) throws FitsException {
        int size = ArrayFuncs.computeSize(data);
        int baseLength = ArrayFuncs.getBaseLength(data);
        if (data instanceof Object[][]) {
            baseLength *= 2;
        }
        int offset = this.hashPtr;
        this.expandHashArea(size);
        ByteArrayOutputStream bo = new ByteArrayOutputStream(size);
        try {
            BufferedDataOutputStream o = new BufferedDataOutputStream(bo);
            o.writePrimitiveArray(data);
            o.flush();
            o.close();
        }
        catch (IOException e) {
            throw new FitsException("Unable to write variable column length data");
        }
        System.arraycopy(bo.toByteArray(), 0, this.hashArea, this.hashPtr, size);
        this.hashPtr += size;
        int nrow = data.length;
        int[][] pointers = new int[nrow][2];
        int myMax = 0;
        for (int i = 0; i < nrow; ++i) {
            int rowLength;
            pointers[i][0] = rowLength = Array.getLength(data[i]);
            pointers[i][1] = offset;
            offset += rowLength * baseLength;
            if (rowLength <= myMax) continue;
            myMax = rowLength;
        }
        Column newColumn = new Column();
        newColumn.setData((Object[])pointers);
        return newColumn;
    }

    public Object getVarData(int col, Class baseClass, boolean complex) throws FitsException {
        int[] dims;
        if (col < 0 || col >= this.getNcol()) {
            throw new FitsException("Invalid column specified for variable length extraction");
        }
        if (complex) {
            dims = new int[3];
            dims[2] = 0;
        } else {
            dims = new int[]{this.getNrow(), 0};
        }
        Object[] newArray = (Object[])Array.newInstance(baseClass, dims);
        int baseLength = ArrayFuncs.getBaseLength(newArray);
        if (complex) {
            baseLength *= 2;
        }
        int offset = 0;
        BufferedDataInputStream inp = new BufferedDataInputStream(new ByteArrayInputStream(this.hashArea));
        int[] ptrs = (int[])this.table.getColumn(col);
        for (int i = 0; i < this.getNrow(); ++i) {
            if (ptrs[2 * i + 1] < offset) {
                inp = new BufferedDataInputStream(new ByteArrayInputStream(this.hashArea));
                offset = 0;
            }
            try {
                inp.skipBytes(ptrs[2 * i + 1] - offset);
                int[] xdims = complex ? new int[]{ptrs[2 * i], 2} : new int[]{ptrs[2 * i]};
                newArray[i] = Array.newInstance(baseClass, xdims);
                inp.readPrimitiveArray(newArray[i]);
                offset += baseLength * ptrs[2 * i];
                continue;
            }
            catch (IOException e) {
                throw new FitsException("Error decoding hash area at offset=" + offset + ".  Exception: Exception " + e);
            }
        }
        return newArray;
    }

    public void write(BufferedDataOutputStream os) throws FitsException {
        try {
            int len = this.table.write(os);
            if (this.hashPtr > 0) {
                os.write(this.hashArea);
            }
            if ((len += this.hashPtr) % 2880 != 0) {
                byte[] pad = new byte[2880 - len % 2880];
                for (int i = 0; i < pad.length; ++i) {
                    pad[i] = 0;
                }
                os.write(pad);
            }
        }
        catch (IOException e) {
            throw new FitsException("Unable to write table:" + e);
        }
    }

    public int getHeapSize() {
        return this.hashPtr;
    }

    public int[][] getDimens() {
        return this.dimens;
    }

    public Class[] getBases() {
        return this.table.getBases();
    }

    public char[] getTypes() {
        return this.table.getTypes();
    }

    public int[] getSizes() {
        return this.sizes;
    }
}

