/*
 * Decompiled with CFR 0.152.
 */
package ucar.util.prefs.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import ucar.util.prefs.ui.Field;

public class FldInputVerifier
extends InputVerifier
implements KeyListener {
    private static Color color = new Color(243, 255, 159);
    private PopupFactory popupFactory = PopupFactory.getSharedInstance();
    private Popup popup;
    private Field fld;
    private JPanel main;
    private JLabel message = new JLabel();

    public FldInputVerifier(Component c, Field fld) {
        this.fld = fld;
        c.addKeyListener(this);
        this.main = new JPanel();
        this.main.setBackground(color);
        this.message.setBackground(color);
        this.main.add(this.message);
    }

    public boolean verify(JComponent c) {
        StringBuffer buff = new StringBuffer();
        if (!this.fld.validate(buff)) {
            this.message.setText(buff.toString());
            c.setBackground(Color.PINK);
            this.makePopup(c);
            return false;
        }
        c.setBackground(Color.WHITE);
        this.removePopup();
        return true;
    }

    private void makePopup(JComponent c) {
        this.removePopup();
        Point p = c.getLocationOnScreen();
        Dimension cDim = c.getSize();
        this.popup = this.popupFactory.getPopup(c, this.main, (int)p.getX() + 15, (int)(p.getY() + cDim.getHeight()));
        this.popup.show();
    }

    private void removePopup() {
        if (this.popup != null) {
            this.popup.hide();
        }
        this.popup = null;
    }

    public void keyPressed(KeyEvent e) {
        this.removePopup();
    }

    public void keyTyped(KeyEvent e) {
        this.removePopup();
    }

    public void keyReleased(KeyEvent e) {
        this.removePopup();
    }
}

