/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Linear2DSet;
import visad.LinearLatLonSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.data.hdfeos.GctpFunction;
import visad.data.hdfeos.LambertAzimuthalEqualArea;
import visad.data.hdfeos.LambertConformalConic;
import visad.data.hdfeos.PolarStereographic;

public class GctpMap {
    double[] projparms;
    public int projcode;
    Unit[] setUnits = null;
    int zonecode;
    int sphrcode;
    int xdimsize;
    int ydimsize;
    double[] uprLeft;
    double[] lwrRight;

    public GctpMap(int projcode, int zonecode, int sphrcode, int xdimsize, int ydimsize, double[] projparms, double[] uprLeft, double[] lwrRight) {
        this.projcode = projcode;
        this.projparms = projparms;
        this.zonecode = zonecode;
        this.sphrcode = sphrcode;
        this.xdimsize = xdimsize;
        this.ydimsize = ydimsize;
        this.uprLeft = uprLeft;
        this.lwrRight = lwrRight;
    }

    public CoordinateSystem getVisADCoordinateSystem() throws VisADException {
        CoordinateSystem coord_sys = null;
        double[] r_major = new double[1];
        double[] r_minor = new double[1];
        double[] radius = new double[1];
        double[] center_lon = new double[1];
        double[] center_lat = new double[1];
        double[] lat_1 = new double[1];
        double[] lat_2 = new double[1];
        double false_easting = this.projparms[6];
        double false_northing = this.projparms[7];
        RealType r_lat = RealType.Latitude;
        RealType r_lon = RealType.Longitude;
        RealType[] components = new RealType[]{r_lon, r_lat};
        RealTupleType Reference2 = new RealTupleType(components);
        GctpFunction.sphdz(this.sphrcode, this.projparms, r_major, r_minor, radius);
        switch (this.projcode) {
            case 11: {
                int stat = GctpFunction.paksz(this.projparms[4], center_lon);
                if (stat != 0) {
                    // empty if block
                }
                if ((stat = GctpFunction.paksz(this.projparms[5], center_lat)) != 0) {
                    // empty if block
                }
                coord_sys = new LambertAzimuthalEqualArea(Reference2, radius[0], center_lon[0], center_lat[0], false_easting, false_northing);
                break;
            }
            case 6: {
                int stat = GctpFunction.paksz(this.projparms[4], center_lon);
                if (stat != 0) {
                    // empty if block
                }
                if ((stat = GctpFunction.paksz(this.projparms[5], lat_1)) != 0) {
                    // empty if block
                }
                coord_sys = new PolarStereographic(Reference2, r_major[0], r_minor[0], center_lon[0], lat_1[0], false_easting, false_northing);
                break;
            }
            case 4: {
                coord_sys = new LambertConformalConic(Reference2, r_major[0], r_minor[0], lat_1[0], lat_2[0], center_lon[0], center_lat[0], false_easting, false_northing);
                break;
            }
            case 0: {
                this.uprLeft[0] = this.uprLeft[0] * 1.0E-6;
                this.lwrRight[0] = this.lwrRight[0] * 1.0E-6;
                this.uprLeft[1] = this.uprLeft[1] * 1.0E-6;
                this.lwrRight[1] = this.lwrRight[1] * 1.0E-6;
                this.setUnits = new Unit[2];
                this.setUnits[0] = CommonUnit.degree;
                this.setUnits[1] = CommonUnit.degree;
            }
        }
        return coord_sys;
    }

    public Unit[] getUnits() {
        return this.setUnits;
    }

    public Set getVisADSet(MathType map) throws VisADException {
        int length1 = this.xdimsize;
        int length2 = this.ydimsize;
        Linear2DSet VisADset = this.projcode == 0 ? new LinearLatLonSet(map, this.uprLeft[0], this.lwrRight[0], length1, this.lwrRight[1], this.uprLeft[1], length2) : new Linear2DSet(map, this.uprLeft[0], this.lwrRight[0], length1, this.lwrRight[1], this.uprLeft[1], length2);
        return VisADset;
    }
}

