/* -------------------------------------------
     This file was created with csUtility.java 

    Unicode mapping table generated from java mapping and UnicodeData.txt

#
#    Name:     ISO8859_7 to Unicode table
#    Unicode version: Java 1.3
#
#    Format: Three tab-separated columns
#        Column #1 is the ISO8859_7 code (in hex)
#        Column #2 is the Unicode (in hex as 0xXXXX)
#        Column #3 is the Unicode name (follows a comment sign, '#')
#
#    The entries are in ISO8859_7 order
#
0x00	0x0000	#NULL
0x01	0x0001	#START OF HEADING
0x02	0x0002	#START OF TEXT
0x03	0x0003	#END OF TEXT
0x04	0x0004	#END OF TRANSMISSION
0x05	0x0005	#ENQUIRY
0x06	0x0006	#ACKNOWLEDGE
0x07	0x0007	#BELL
0x08	0x0008	#BACKSPACE
0x09	0x0009	#CHARACTER TABULATION
0x0a	0x000a	#LINE FEED (LF)
0x0b	0x000b	#LINE TABULATION
0x0c	0x000c	#FORM FEED (FF)
0x0d	0x000d	#CARRIAGE RETURN (CR)
0x0e	0x000e	#SHIFT OUT
0x0f	0x000f	#SHIFT IN
0x10	0x0010	#DATA LINK ESCAPE
0x11	0x0011	#DEVICE CONTROL ONE
0x12	0x0012	#DEVICE CONTROL TWO
0x13	0x0013	#DEVICE CONTROL THREE
0x14	0x0014	#DEVICE CONTROL FOUR
0x15	0x0015	#NEGATIVE ACKNOWLEDGE
0x16	0x0016	#SYNCHRONOUS IDLE
0x17	0x0017	#END OF TRANSMISSION BLOCK
0x18	0x0018	#CANCEL
0x19	0x0019	#END OF MEDIUM
0x1a	0x001a	#SUBSTITUTE
0x1b	0x001b	#ESCAPE
0x1c	0x001c	#INFORMATION SEPARATOR FOUR
0x1d	0x001d	#INFORMATION SEPARATOR THREE
0x1e	0x001e	#INFORMATION SEPARATOR TWO
0x1f	0x001f	#INFORMATION SEPARATOR ONE
0x20	0x0020	#SPACE
0x21	0x0021	#EXCLAMATION MARK
0x22	0x0022	#QUOTATION MARK
0x23	0x0023	#NUMBER SIGN
0x24	0x0024	#DOLLAR SIGN
0x25	0x0025	#PERCENT SIGN
0x26	0x0026	#AMPERSAND
0x27	0x0027	#APOSTROPHE
0x28	0x0028	#LEFT PARENTHESIS
0x29	0x0029	#RIGHT PARENTHESIS
0x2a	0x002a	#ASTERISK
0x2b	0x002b	#PLUS SIGN
0x2c	0x002c	#COMMA
0x2d	0x002d	#HYPHEN-MINUS
0x2e	0x002e	#FULL STOP
0x2f	0x002f	#SOLIDUS
0x30	0x0030	#DIGIT ZERO
0x31	0x0031	#DIGIT ONE
0x32	0x0032	#DIGIT TWO
0x33	0x0033	#DIGIT THREE
0x34	0x0034	#DIGIT FOUR
0x35	0x0035	#DIGIT FIVE
0x36	0x0036	#DIGIT SIX
0x37	0x0037	#DIGIT SEVEN
0x38	0x0038	#DIGIT EIGHT
0x39	0x0039	#DIGIT NINE
0x3a	0x003a	#COLON
0x3b	0x003b	#SEMICOLON
0x3c	0x003c	#LESS-THAN SIGN
0x3d	0x003d	#EQUALS SIGN
0x3e	0x003e	#GREATER-THAN SIGN
0x3f	0x003f	#QUESTION MARK
0x40	0x0040	#COMMERCIAL AT
0x41	0x0041	#LATIN CAPITAL LETTER A
0x42	0x0042	#LATIN CAPITAL LETTER B
0x43	0x0043	#LATIN CAPITAL LETTER C
0x44	0x0044	#LATIN CAPITAL LETTER D
0x45	0x0045	#LATIN CAPITAL LETTER E
0x46	0x0046	#LATIN CAPITAL LETTER F
0x47	0x0047	#LATIN CAPITAL LETTER G
0x48	0x0048	#LATIN CAPITAL LETTER H
0x49	0x0049	#LATIN CAPITAL LETTER I
0x4a	0x004a	#LATIN CAPITAL LETTER J
0x4b	0x004b	#LATIN CAPITAL LETTER K
0x4c	0x004c	#LATIN CAPITAL LETTER L
0x4d	0x004d	#LATIN CAPITAL LETTER M
0x4e	0x004e	#LATIN CAPITAL LETTER N
0x4f	0x004f	#LATIN CAPITAL LETTER O
0x50	0x0050	#LATIN CAPITAL LETTER P
0x51	0x0051	#LATIN CAPITAL LETTER Q
0x52	0x0052	#LATIN CAPITAL LETTER R
0x53	0x0053	#LATIN CAPITAL LETTER S
0x54	0x0054	#LATIN CAPITAL LETTER T
0x55	0x0055	#LATIN CAPITAL LETTER U
0x56	0x0056	#LATIN CAPITAL LETTER V
0x57	0x0057	#LATIN CAPITAL LETTER W
0x58	0x0058	#LATIN CAPITAL LETTER X
0x59	0x0059	#LATIN CAPITAL LETTER Y
0x5a	0x005a	#LATIN CAPITAL LETTER Z
0x5b	0x005b	#LEFT SQUARE BRACKET
0x5c	0x005c	#REVERSE SOLIDUS
0x5d	0x005d	#RIGHT SQUARE BRACKET
0x5e	0x005e	#CIRCUMFLEX ACCENT
0x5f	0x005f	#LOW LINE
0x60	0x0060	#GRAVE ACCENT
0x61	0x0061	#LATIN SMALL LETTER A
0x62	0x0062	#LATIN SMALL LETTER B
0x63	0x0063	#LATIN SMALL LETTER C
0x64	0x0064	#LATIN SMALL LETTER D
0x65	0x0065	#LATIN SMALL LETTER E
0x66	0x0066	#LATIN SMALL LETTER F
0x67	0x0067	#LATIN SMALL LETTER G
0x68	0x0068	#LATIN SMALL LETTER H
0x69	0x0069	#LATIN SMALL LETTER I
0x6a	0x006a	#LATIN SMALL LETTER J
0x6b	0x006b	#LATIN SMALL LETTER K
0x6c	0x006c	#LATIN SMALL LETTER L
0x6d	0x006d	#LATIN SMALL LETTER M
0x6e	0x006e	#LATIN SMALL LETTER N
0x6f	0x006f	#LATIN SMALL LETTER O
0x70	0x0070	#LATIN SMALL LETTER P
0x71	0x0071	#LATIN SMALL LETTER Q
0x72	0x0072	#LATIN SMALL LETTER R
0x73	0x0073	#LATIN SMALL LETTER S
0x74	0x0074	#LATIN SMALL LETTER T
0x75	0x0075	#LATIN SMALL LETTER U
0x76	0x0076	#LATIN SMALL LETTER V
0x77	0x0077	#LATIN SMALL LETTER W
0x78	0x0078	#LATIN SMALL LETTER X
0x79	0x0079	#LATIN SMALL LETTER Y
0x7a	0x007a	#LATIN SMALL LETTER Z
0x7b	0x007b	#LEFT CURLY BRACKET
0x7c	0x007c	#VERTICAL LINE
0x7d	0x007d	#RIGHT CURLY BRACKET
0x7e	0x007e	#TILDE
0x7f	0x007f	#DELETE
0x80	0x0080	#
0x81	0x0081	#
0x82	0x0082	#BREAK PERMITTED HERE
0x83	0x0083	#NO BREAK HERE
0x84	0x0084	#
0x85	0x0085	#NEXT LINE (NEL)
0x86	0x0086	#START OF SELECTED AREA
0x87	0x0087	#END OF SELECTED AREA
0x88	0x0088	#CHARACTER TABULATION SET
0x89	0x0089	#CHARACTER TABULATION WITH JUSTIFICATION
0x8a	0x008a	#LINE TABULATION SET
0x8b	0x008b	#PARTIAL LINE FORWARD
0x8c	0x008c	#PARTIAL LINE BACKWARD
0x8d	0x008d	#REVERSE LINE FEED
0x8e	0x008e	#SINGLE SHIFT TWO
0x8f	0x008f	#SINGLE SHIFT THREE
0x90	0x0090	#DEVICE CONTROL STRING
0x91	0x0091	#PRIVATE USE ONE
0x92	0x0092	#PRIVATE USE TWO
0x93	0x0093	#SET TRANSMIT STATE
0x94	0x0094	#CANCEL CHARACTER
0x95	0x0095	#MESSAGE WAITING
0x96	0x0096	#START OF GUARDED AREA
0x97	0x0097	#END OF GUARDED AREA
0x98	0x0098	#START OF STRING
0x99	0x0099	#
0x9a	0x009a	#SINGLE CHARACTER INTRODUCER
0x9b	0x009b	#CONTROL SEQUENCE INTRODUCER
0x9c	0x009c	#STRING TERMINATOR
0x9d	0x009d	#OPERATING SYSTEM COMMAND
0x9e	0x009e	#PRIVACY MESSAGE
0x9f	0x009f	#APPLICATION PROGRAM COMMAND
0xa0	0x00a0	#NO-BREAK SPACE
0xa1	0x02bd	#MODIFIER LETTER REVERSED COMMA
0xa2	0x02bc	#MODIFIER LETTER APOSTROPHE
0xa3	0x00a3	#POUND SIGN
0xa4	     	#UNDEFINED
0xa5	     	#UNDEFINED
0xa6	0x00a6	#BROKEN BAR
0xa7	0x00a7	#SECTION SIGN
0xa8	0x00a8	#DIAERESIS
0xa9	0x00a9	#COPYRIGHT SIGN
0xaa	     	#UNDEFINED
0xab	0x00ab	#LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
0xac	0x00ac	#NOT SIGN
0xad	0x00ad	#SOFT HYPHEN
0xae	     	#UNDEFINED
0xaf	0x2015	#HORIZONTAL BAR
0xb0	0x00b0	#DEGREE SIGN
0xb1	0x00b1	#PLUS-MINUS SIGN
0xb2	0x00b2	#SUPERSCRIPT TWO
0xb3	0x00b3	#SUPERSCRIPT THREE
0xb4	0x0384	#GREEK TONOS
0xb5	0x0385	#GREEK DIALYTIKA TONOS
0xb6	0x0386	#GREEK CAPITAL LETTER ALPHA WITH TONOS
0xb7	0x00b7	#MIDDLE DOT
0xb8	0x0388	#GREEK CAPITAL LETTER EPSILON WITH TONOS
0xb9	0x0389	#GREEK CAPITAL LETTER ETA WITH TONOS
0xba	0x038a	#GREEK CAPITAL LETTER IOTA WITH TONOS
0xbb	0x00bb	#RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
0xbc	0x038c	#GREEK CAPITAL LETTER OMICRON WITH TONOS
0xbd	0x00bd	#VULGAR FRACTION ONE HALF
0xbe	0x038e	#GREEK CAPITAL LETTER UPSILON WITH TONOS
0xbf	0x038f	#GREEK CAPITAL LETTER OMEGA WITH TONOS
0xc0	0x0390	#GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
0xc1	0x0391	#GREEK CAPITAL LETTER ALPHA
0xc2	0x0392	#GREEK CAPITAL LETTER BETA
0xc3	0x0393	#GREEK CAPITAL LETTER GAMMA
0xc4	0x0394	#GREEK CAPITAL LETTER DELTA
0xc5	0x0395	#GREEK CAPITAL LETTER EPSILON
0xc6	0x0396	#GREEK CAPITAL LETTER ZETA
0xc7	0x0397	#GREEK CAPITAL LETTER ETA
0xc8	0x0398	#GREEK CAPITAL LETTER THETA
0xc9	0x0399	#GREEK CAPITAL LETTER IOTA
0xca	0x039a	#GREEK CAPITAL LETTER KAPPA
0xcb	0x039b	#GREEK CAPITAL LETTER LAMDA
0xcc	0x039c	#GREEK CAPITAL LETTER MU
0xcd	0x039d	#GREEK CAPITAL LETTER NU
0xce	0x039e	#GREEK CAPITAL LETTER XI
0xcf	0x039f	#GREEK CAPITAL LETTER OMICRON
0xd0	0x03a0	#GREEK CAPITAL LETTER PI
0xd1	0x03a1	#GREEK CAPITAL LETTER RHO
0xd2	     	#UNDEFINED
0xd3	0x03a3	#GREEK CAPITAL LETTER SIGMA
0xd4	0x03a4	#GREEK CAPITAL LETTER TAU
0xd5	0x03a5	#GREEK CAPITAL LETTER UPSILON
0xd6	0x03a6	#GREEK CAPITAL LETTER PHI
0xd7	0x03a7	#GREEK CAPITAL LETTER CHI
0xd8	0x03a8	#GREEK CAPITAL LETTER PSI
0xd9	0x03a9	#GREEK CAPITAL LETTER OMEGA
0xda	0x03aa	#GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
0xdb	0x03ab	#GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
0xdc	0x03ac	#GREEK SMALL LETTER ALPHA WITH TONOS
0xdd	0x03ad	#GREEK SMALL LETTER EPSILON WITH TONOS
0xde	0x03ae	#GREEK SMALL LETTER ETA WITH TONOS
0xdf	0x03af	#GREEK SMALL LETTER IOTA WITH TONOS
0xe0	0x03b0	#GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
0xe1	0x03b1	#GREEK SMALL LETTER ALPHA
0xe2	0x03b2	#GREEK SMALL LETTER BETA
0xe3	0x03b3	#GREEK SMALL LETTER GAMMA
0xe4	0x03b4	#GREEK SMALL LETTER DELTA
0xe5	0x03b5	#GREEK SMALL LETTER EPSILON
0xe6	0x03b6	#GREEK SMALL LETTER ZETA
0xe7	0x03b7	#GREEK SMALL LETTER ETA
0xe8	0x03b8	#GREEK SMALL LETTER THETA
0xe9	0x03b9	#GREEK SMALL LETTER IOTA
0xea	0x03ba	#GREEK SMALL LETTER KAPPA
0xeb	0x03bb	#GREEK SMALL LETTER LAMDA
0xec	0x03bc	#GREEK SMALL LETTER MU
0xed	0x03bd	#GREEK SMALL LETTER NU
0xee	0x03be	#GREEK SMALL LETTER XI
0xef	0x03bf	#GREEK SMALL LETTER OMICRON
0xf0	0x03c0	#GREEK SMALL LETTER PI
0xf1	0x03c1	#GREEK SMALL LETTER RHO
0xf2	0x03c2	#GREEK SMALL LETTER FINAL SIGMA
0xf3	0x03c3	#GREEK SMALL LETTER SIGMA
0xf4	0x03c4	#GREEK SMALL LETTER TAU
0xf5	0x03c5	#GREEK SMALL LETTER UPSILON
0xf6	0x03c6	#GREEK SMALL LETTER PHI
0xf7	0x03c7	#GREEK SMALL LETTER CHI
0xf8	0x03c8	#GREEK SMALL LETTER PSI
0xf9	0x03c9	#GREEK SMALL LETTER OMEGA
0xfa	0x03ca	#GREEK SMALL LETTER IOTA WITH DIALYTIKA
0xfb	0x03cb	#GREEK SMALL LETTER UPSILON WITH DIALYTIKA
0xfc	0x03cc	#GREEK SMALL LETTER OMICRON WITH TONOS
0xfd	0x03cd	#GREEK SMALL LETTER UPSILON WITH TONOS
0xfe	0x03ce	#GREEK SMALL LETTER OMEGA WITH TONOS
0xff	     	#UNDEFINED


 * The contents of this file are subject to the Interbase Public
 * License Version 1.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy
 * of the License at http://www.Inprise.com/IPL.html
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code was created by Inprise Corporation
 * and its predecessors. Portions created by Inprise Corporation are
 * Copyright (C) Inprise Corporation.
 *
 * All Rights Reserved.
 * Contributor(s): Blas Rodriguez Somoza.
   -------------------------------------------- */
static const int CANT_MAP_CHARACTER = 0;

static const USHORT to_unicode_map[256] = {
/* 00 */  0x0000 /*                                          NULL */,
/* 01 */  0x0001 /*                              START OF HEADING */,
/* 02 */  0x0002 /*                                 START OF TEXT */,
/* 03 */  0x0003 /*                                   END OF TEXT */,
/* 04 */  0x0004 /*                           END OF TRANSMISSION */,
/* 05 */  0x0005 /*                                       ENQUIRY */,
/* 06 */  0x0006 /*                                   ACKNOWLEDGE */,
/* 07 */  0x0007 /*                                          BELL */,
/* 08 */  0x0008 /*                                     BACKSPACE */,
/* 09 */  0x0009 /*                          CHARACTER TABULATION */,
/* 0A */  0x000A /*                                LINE FEED (LF) */,
/* 0B */  0x000B /*                               LINE TABULATION */,
/* 0C */  0x000C /*                                FORM FEED (FF) */,
/* 0D */  0x000D /*                          CARRIAGE RETURN (CR) */,
/* 0E */  0x000E /*                                     SHIFT OUT */,
/* 0F */  0x000F /*                                      SHIFT IN */,
/* 10 */  0x0010 /*                              DATA LINK ESCAPE */,
/* 11 */  0x0011 /*                            DEVICE CONTROL ONE */,
/* 12 */  0x0012 /*                            DEVICE CONTROL TWO */,
/* 13 */  0x0013 /*                          DEVICE CONTROL THREE */,
/* 14 */  0x0014 /*                           DEVICE CONTROL FOUR */,
/* 15 */  0x0015 /*                          NEGATIVE ACKNOWLEDGE */,
/* 16 */  0x0016 /*                              SYNCHRONOUS IDLE */,
/* 17 */  0x0017 /*                     END OF TRANSMISSION BLOCK */,
/* 18 */  0x0018 /*                                        CANCEL */,
/* 19 */  0x0019 /*                                 END OF MEDIUM */,
/* 1A */  0x001A /*                                    SUBSTITUTE */,
/* 1B */  0x001B /*                                        ESCAPE */,
/* 1C */  0x001C /*                    INFORMATION SEPARATOR FOUR */,
/* 1D */  0x001D /*                   INFORMATION SEPARATOR THREE */,
/* 1E */  0x001E /*                     INFORMATION SEPARATOR TWO */,
/* 1F */  0x001F /*                     INFORMATION SEPARATOR ONE */,
/* 20 */  0x0020 /*                                         SPACE */,
/* 21 */  0x0021 /*                              EXCLAMATION MARK */,
/* 22 */  0x0022 /*                                QUOTATION MARK */,
/* 23 */  0x0023 /*                                   NUMBER SIGN */,
/* 24 */  0x0024 /*                                   DOLLAR SIGN */,
/* 25 */  0x0025 /*                                  PERCENT SIGN */,
/* 26 */  0x0026 /*                                     AMPERSAND */,
/* 27 */  0x0027 /*                                    APOSTROPHE */,
/* 28 */  0x0028 /*                              LEFT PARENTHESIS */,
/* 29 */  0x0029 /*                             RIGHT PARENTHESIS */,
/* 2A */  0x002A /*                                      ASTERISK */,
/* 2B */  0x002B /*                                     PLUS SIGN */,
/* 2C */  0x002C /*                                         COMMA */,
/* 2D */  0x002D /*                                  HYPHEN-MINUS */,
/* 2E */  0x002E /*                                     FULL STOP */,
/* 2F */  0x002F /*                                       SOLIDUS */,
/* 30 */  0x0030 /*                                    DIGIT ZERO */,
/* 31 */  0x0031 /*                                     DIGIT ONE */,
/* 32 */  0x0032 /*                                     DIGIT TWO */,
/* 33 */  0x0033 /*                                   DIGIT THREE */,
/* 34 */  0x0034 /*                                    DIGIT FOUR */,
/* 35 */  0x0035 /*                                    DIGIT FIVE */,
/* 36 */  0x0036 /*                                     DIGIT SIX */,
/* 37 */  0x0037 /*                                   DIGIT SEVEN */,
/* 38 */  0x0038 /*                                   DIGIT EIGHT */,
/* 39 */  0x0039 /*                                    DIGIT NINE */,
/* 3A */  0x003A /*                                         COLON */,
/* 3B */  0x003B /*                                     SEMICOLON */,
/* 3C */  0x003C /*                                LESS-THAN SIGN */,
/* 3D */  0x003D /*                                   EQUALS SIGN */,
/* 3E */  0x003E /*                             GREATER-THAN SIGN */,
/* 3F */  0x003F /*                                 QUESTION MARK */,
/* 40 */  0x0040 /*                                 COMMERCIAL AT */,
/* 41 */  0x0041 /*                        LATIN CAPITAL LETTER A */,
/* 42 */  0x0042 /*                        LATIN CAPITAL LETTER B */,
/* 43 */  0x0043 /*                        LATIN CAPITAL LETTER C */,
/* 44 */  0x0044 /*                        LATIN CAPITAL LETTER D */,
/* 45 */  0x0045 /*                        LATIN CAPITAL LETTER E */,
/* 46 */  0x0046 /*                        LATIN CAPITAL LETTER F */,
/* 47 */  0x0047 /*                        LATIN CAPITAL LETTER G */,
/* 48 */  0x0048 /*                        LATIN CAPITAL LETTER H */,
/* 49 */  0x0049 /*                        LATIN CAPITAL LETTER I */,
/* 4A */  0x004A /*                        LATIN CAPITAL LETTER J */,
/* 4B */  0x004B /*                        LATIN CAPITAL LETTER K */,
/* 4C */  0x004C /*                        LATIN CAPITAL LETTER L */,
/* 4D */  0x004D /*                        LATIN CAPITAL LETTER M */,
/* 4E */  0x004E /*                        LATIN CAPITAL LETTER N */,
/* 4F */  0x004F /*                        LATIN CAPITAL LETTER O */,
/* 50 */  0x0050 /*                        LATIN CAPITAL LETTER P */,
/* 51 */  0x0051 /*                        LATIN CAPITAL LETTER Q */,
/* 52 */  0x0052 /*                        LATIN CAPITAL LETTER R */,
/* 53 */  0x0053 /*                        LATIN CAPITAL LETTER S */,
/* 54 */  0x0054 /*                        LATIN CAPITAL LETTER T */,
/* 55 */  0x0055 /*                        LATIN CAPITAL LETTER U */,
/* 56 */  0x0056 /*                        LATIN CAPITAL LETTER V */,
/* 57 */  0x0057 /*                        LATIN CAPITAL LETTER W */,
/* 58 */  0x0058 /*                        LATIN CAPITAL LETTER X */,
/* 59 */  0x0059 /*                        LATIN CAPITAL LETTER Y */,
/* 5A */  0x005A /*                        LATIN CAPITAL LETTER Z */,
/* 5B */  0x005B /*                           LEFT SQUARE BRACKET */,
/* 5C */  0x005C /*                               REVERSE SOLIDUS */,
/* 5D */  0x005D /*                          RIGHT SQUARE BRACKET */,
/* 5E */  0x005E /*                             CIRCUMFLEX ACCENT */,
/* 5F */  0x005F /*                                      LOW LINE */,
/* 60 */  0x0060 /*                                  GRAVE ACCENT */,
/* 61 */  0x0061 /*                          LATIN SMALL LETTER A */,
/* 62 */  0x0062 /*                          LATIN SMALL LETTER B */,
/* 63 */  0x0063 /*                          LATIN SMALL LETTER C */,
/* 64 */  0x0064 /*                          LATIN SMALL LETTER D */,
/* 65 */  0x0065 /*                          LATIN SMALL LETTER E */,
/* 66 */  0x0066 /*                          LATIN SMALL LETTER F */,
/* 67 */  0x0067 /*                          LATIN SMALL LETTER G */,
/* 68 */  0x0068 /*                          LATIN SMALL LETTER H */,
/* 69 */  0x0069 /*                          LATIN SMALL LETTER I */,
/* 6A */  0x006A /*                          LATIN SMALL LETTER J */,
/* 6B */  0x006B /*                          LATIN SMALL LETTER K */,
/* 6C */  0x006C /*                          LATIN SMALL LETTER L */,
/* 6D */  0x006D /*                          LATIN SMALL LETTER M */,
/* 6E */  0x006E /*                          LATIN SMALL LETTER N */,
/* 6F */  0x006F /*                          LATIN SMALL LETTER O */,
/* 70 */  0x0070 /*                          LATIN SMALL LETTER P */,
/* 71 */  0x0071 /*                          LATIN SMALL LETTER Q */,
/* 72 */  0x0072 /*                          LATIN SMALL LETTER R */,
/* 73 */  0x0073 /*                          LATIN SMALL LETTER S */,
/* 74 */  0x0074 /*                          LATIN SMALL LETTER T */,
/* 75 */  0x0075 /*                          LATIN SMALL LETTER U */,
/* 76 */  0x0076 /*                          LATIN SMALL LETTER V */,
/* 77 */  0x0077 /*                          LATIN SMALL LETTER W */,
/* 78 */  0x0078 /*                          LATIN SMALL LETTER X */,
/* 79 */  0x0079 /*                          LATIN SMALL LETTER Y */,
/* 7A */  0x007A /*                          LATIN SMALL LETTER Z */,
/* 7B */  0x007B /*                            LEFT CURLY BRACKET */,
/* 7C */  0x007C /*                                 VERTICAL LINE */,
/* 7D */  0x007D /*                           RIGHT CURLY BRACKET */,
/* 7E */  0x007E /*                                         TILDE */,
/* 7F */  0x007F /*                                        DELETE */,
/* 80 */  0x0080 /*                                               */,
/* 81 */  0x0081 /*                                               */,
/* 82 */  0x0082 /*                          BREAK PERMITTED HERE */,
/* 83 */  0x0083 /*                                 NO BREAK HERE */,
/* 84 */  0x0084 /*                                               */,
/* 85 */  0x0085 /*                               NEXT LINE (NEL) */,
/* 86 */  0x0086 /*                        START OF SELECTED AREA */,
/* 87 */  0x0087 /*                          END OF SELECTED AREA */,
/* 88 */  0x0088 /*                      CHARACTER TABULATION SET */,
/* 89 */  0x0089 /*       CHARACTER TABULATION WITH JUSTIFICATION */,
/* 8A */  0x008A /*                           LINE TABULATION SET */,
/* 8B */  0x008B /*                          PARTIAL LINE FORWARD */,
/* 8C */  0x008C /*                         PARTIAL LINE BACKWARD */,
/* 8D */  0x008D /*                             REVERSE LINE FEED */,
/* 8E */  0x008E /*                              SINGLE SHIFT TWO */,
/* 8F */  0x008F /*                            SINGLE SHIFT THREE */,
/* 90 */  0x0090 /*                         DEVICE CONTROL STRING */,
/* 91 */  0x0091 /*                               PRIVATE USE ONE */,
/* 92 */  0x0092 /*                               PRIVATE USE TWO */,
/* 93 */  0x0093 /*                            SET TRANSMIT STATE */,
/* 94 */  0x0094 /*                              CANCEL CHARACTER */,
/* 95 */  0x0095 /*                               MESSAGE WAITING */,
/* 96 */  0x0096 /*                         START OF GUARDED AREA */,
/* 97 */  0x0097 /*                           END OF GUARDED AREA */,
/* 98 */  0x0098 /*                               START OF STRING */,
/* 99 */  0x0099 /*                                               */,
/* 9A */  0x009A /*                   SINGLE CHARACTER INTRODUCER */,
/* 9B */  0x009B /*                   CONTROL SEQUENCE INTRODUCER */,
/* 9C */  0x009C /*                             STRING TERMINATOR */,
/* 9D */  0x009D /*                      OPERATING SYSTEM COMMAND */,
/* 9E */  0x009E /*                               PRIVACY MESSAGE */,
/* 9F */  0x009F /*                   APPLICATION PROGRAM COMMAND */,
/* A0 */  0x00A0 /*                                NO-BREAK SPACE */,
/* A1 */  0x02BD /*                MODIFIER LETTER REVERSED COMMA */,
/* A2 */  0x02BC /*                    MODIFIER LETTER APOSTROPHE */,
/* A3 */  0x00A3 /*                                    POUND SIGN */,
/* A4 */     CANT_MAP_CHARACTER   ,
/* A5 */     CANT_MAP_CHARACTER   ,
/* A6 */  0x00A6 /*                                    BROKEN BAR */,
/* A7 */  0x00A7 /*                                  SECTION SIGN */,
/* A8 */  0x00A8 /*                                     DIAERESIS */,
/* A9 */  0x00A9 /*                                COPYRIGHT SIGN */,
/* AA */     CANT_MAP_CHARACTER   ,
/* AB */  0x00AB /*     LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */,
/* AC */  0x00AC /*                                      NOT SIGN */,
/* AD */  0x00AD /*                                   SOFT HYPHEN */,
/* AE */     CANT_MAP_CHARACTER   ,
/* AF */  0x2015 /*                                HORIZONTAL BAR */,
/* B0 */  0x00B0 /*                                   DEGREE SIGN */,
/* B1 */  0x00B1 /*                               PLUS-MINUS SIGN */,
/* B2 */  0x00B2 /*                               SUPERSCRIPT TWO */,
/* B3 */  0x00B3 /*                             SUPERSCRIPT THREE */,
/* B4 */  0x0384 /*                                   GREEK TONOS */,
/* B5 */  0x0385 /*                         GREEK DIALYTIKA TONOS */,
/* B6 */  0x0386 /*         GREEK CAPITAL LETTER ALPHA WITH TONOS */,
/* B7 */  0x00B7 /*                                    MIDDLE DOT */,
/* B8 */  0x0388 /*       GREEK CAPITAL LETTER EPSILON WITH TONOS */,
/* B9 */  0x0389 /*           GREEK CAPITAL LETTER ETA WITH TONOS */,
/* BA */  0x038A /*          GREEK CAPITAL LETTER IOTA WITH TONOS */,
/* BB */  0x00BB /*    RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK */,
/* BC */  0x038C /*       GREEK CAPITAL LETTER OMICRON WITH TONOS */,
/* BD */  0x00BD /*                      VULGAR FRACTION ONE HALF */,
/* BE */  0x038E /*       GREEK CAPITAL LETTER UPSILON WITH TONOS */,
/* BF */  0x038F /*         GREEK CAPITAL LETTER OMEGA WITH TONOS */,
/* C0 */  0x0390 /* GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS */,
/* C1 */  0x0391 /*                    GREEK CAPITAL LETTER ALPHA */,
/* C2 */  0x0392 /*                     GREEK CAPITAL LETTER BETA */,
/* C3 */  0x0393 /*                    GREEK CAPITAL LETTER GAMMA */,
/* C4 */  0x0394 /*                    GREEK CAPITAL LETTER DELTA */,
/* C5 */  0x0395 /*                  GREEK CAPITAL LETTER EPSILON */,
/* C6 */  0x0396 /*                     GREEK CAPITAL LETTER ZETA */,
/* C7 */  0x0397 /*                      GREEK CAPITAL LETTER ETA */,
/* C8 */  0x0398 /*                    GREEK CAPITAL LETTER THETA */,
/* C9 */  0x0399 /*                     GREEK CAPITAL LETTER IOTA */,
/* CA */  0x039A /*                    GREEK CAPITAL LETTER KAPPA */,
/* CB */  0x039B /*                    GREEK CAPITAL LETTER LAMDA */,
/* CC */  0x039C /*                       GREEK CAPITAL LETTER MU */,
/* CD */  0x039D /*                       GREEK CAPITAL LETTER NU */,
/* CE */  0x039E /*                       GREEK CAPITAL LETTER XI */,
/* CF */  0x039F /*                  GREEK CAPITAL LETTER OMICRON */,
/* D0 */  0x03A0 /*                       GREEK CAPITAL LETTER PI */,
/* D1 */  0x03A1 /*                      GREEK CAPITAL LETTER RHO */,
/* D2 */     CANT_MAP_CHARACTER   ,
/* D3 */  0x03A3 /*                    GREEK CAPITAL LETTER SIGMA */,
/* D4 */  0x03A4 /*                      GREEK CAPITAL LETTER TAU */,
/* D5 */  0x03A5 /*                  GREEK CAPITAL LETTER UPSILON */,
/* D6 */  0x03A6 /*                      GREEK CAPITAL LETTER PHI */,
/* D7 */  0x03A7 /*                      GREEK CAPITAL LETTER CHI */,
/* D8 */  0x03A8 /*                      GREEK CAPITAL LETTER PSI */,
/* D9 */  0x03A9 /*                    GREEK CAPITAL LETTER OMEGA */,
/* DA */  0x03AA /*      GREEK CAPITAL LETTER IOTA WITH DIALYTIKA */,
/* DB */  0x03AB /*   GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA */,
/* DC */  0x03AC /*           GREEK SMALL LETTER ALPHA WITH TONOS */,
/* DD */  0x03AD /*         GREEK SMALL LETTER EPSILON WITH TONOS */,
/* DE */  0x03AE /*             GREEK SMALL LETTER ETA WITH TONOS */,
/* DF */  0x03AF /*            GREEK SMALL LETTER IOTA WITH TONOS */,
/* E0 */  0x03B0 /* GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS */,
/* E1 */  0x03B1 /*                      GREEK SMALL LETTER ALPHA */,
/* E2 */  0x03B2 /*                       GREEK SMALL LETTER BETA */,
/* E3 */  0x03B3 /*                      GREEK SMALL LETTER GAMMA */,
/* E4 */  0x03B4 /*                      GREEK SMALL LETTER DELTA */,
/* E5 */  0x03B5 /*                    GREEK SMALL LETTER EPSILON */,
/* E6 */  0x03B6 /*                       GREEK SMALL LETTER ZETA */,
/* E7 */  0x03B7 /*                        GREEK SMALL LETTER ETA */,
/* E8 */  0x03B8 /*                      GREEK SMALL LETTER THETA */,
/* E9 */  0x03B9 /*                       GREEK SMALL LETTER IOTA */,
/* EA */  0x03BA /*                      GREEK SMALL LETTER KAPPA */,
/* EB */  0x03BB /*                      GREEK SMALL LETTER LAMDA */,
/* EC */  0x03BC /*                         GREEK SMALL LETTER MU */,
/* ED */  0x03BD /*                         GREEK SMALL LETTER NU */,
/* EE */  0x03BE /*                         GREEK SMALL LETTER XI */,
/* EF */  0x03BF /*                    GREEK SMALL LETTER OMICRON */,
/* F0 */  0x03C0 /*                         GREEK SMALL LETTER PI */,
/* F1 */  0x03C1 /*                        GREEK SMALL LETTER RHO */,
/* F2 */  0x03C2 /*                GREEK SMALL LETTER FINAL SIGMA */,
/* F3 */  0x03C3 /*                      GREEK SMALL LETTER SIGMA */,
/* F4 */  0x03C4 /*                        GREEK SMALL LETTER TAU */,
/* F5 */  0x03C5 /*                    GREEK SMALL LETTER UPSILON */,
/* F6 */  0x03C6 /*                        GREEK SMALL LETTER PHI */,
/* F7 */  0x03C7 /*                        GREEK SMALL LETTER CHI */,
/* F8 */  0x03C8 /*                        GREEK SMALL LETTER PSI */,
/* F9 */  0x03C9 /*                      GREEK SMALL LETTER OMEGA */,
/* FA */  0x03CA /*        GREEK SMALL LETTER IOTA WITH DIALYTIKA */,
/* FB */  0x03CB /*     GREEK SMALL LETTER UPSILON WITH DIALYTIKA */,
/* FC */  0x03CC /*         GREEK SMALL LETTER OMICRON WITH TONOS */,
/* FD */  0x03CD /*         GREEK SMALL LETTER UPSILON WITH TONOS */,
/* FE */  0x03CE /*           GREEK SMALL LETTER OMEGA WITH TONOS */,
/* FF */     CANT_MAP_CHARACTER   ,
};


static const UCHAR from_unicode_mapping_array[] = {
/* U+XX00 */	CANT_MAP_CHARACTER,	/* 0 */
/* U+XX01 */	CANT_MAP_CHARACTER,	/* 1 */
/* U+XX02 */	CANT_MAP_CHARACTER,	/* 2 */
/* U+XX03 */	CANT_MAP_CHARACTER,	/* 3 */
/* U+XX04 */	CANT_MAP_CHARACTER,	/* 4 */
/* U+XX05 */	CANT_MAP_CHARACTER,	/* 5 */
/* U+XX06 */	CANT_MAP_CHARACTER,	/* 6 */
/* U+XX07 */	CANT_MAP_CHARACTER,	/* 7 */
/* U+XX08 */	CANT_MAP_CHARACTER,	/* 8 */
/* U+XX09 */	CANT_MAP_CHARACTER,	/* 9 */
/* U+XX0A */	CANT_MAP_CHARACTER,	/* 10 */
/* U+XX0B */	CANT_MAP_CHARACTER,	/* 11 */
/* U+XX0C */	CANT_MAP_CHARACTER,	/* 12 */
/* U+XX0D */	CANT_MAP_CHARACTER,	/* 13 */
/* U+XX0E */	CANT_MAP_CHARACTER,	/* 14 */
/* U+XX0F */	CANT_MAP_CHARACTER,	/* 15 */
/* U+XX10 */	CANT_MAP_CHARACTER,	/* 16 */
/* U+XX11 */	CANT_MAP_CHARACTER,	/* 17 */
/* U+XX12 */	CANT_MAP_CHARACTER,	/* 18 */
/* U+XX13 */	CANT_MAP_CHARACTER,	/* 19 */
/* U+XX14 */	CANT_MAP_CHARACTER,	/* 20 */
/* U+XX15 */	CANT_MAP_CHARACTER,	/* 21 */
/* U+XX16 */	CANT_MAP_CHARACTER,	/* 22 */
/* U+XX17 */	CANT_MAP_CHARACTER,	/* 23 */
/* U+XX18 */	CANT_MAP_CHARACTER,	/* 24 */
/* U+XX19 */	CANT_MAP_CHARACTER,	/* 25 */
/* U+XX1A */	CANT_MAP_CHARACTER,	/* 26 */
/* U+XX1B */	CANT_MAP_CHARACTER,	/* 27 */
/* U+XX1C */	CANT_MAP_CHARACTER,	/* 28 */
/* U+XX1D */	CANT_MAP_CHARACTER,	/* 29 */
/* U+XX1E */	CANT_MAP_CHARACTER,	/* 30 */
/* U+XX1F */	CANT_MAP_CHARACTER,	/* 31 */
/* U+XX20 */	CANT_MAP_CHARACTER,	/* 32 */
/* U+XX21 */	CANT_MAP_CHARACTER,	/* 33 */
/* U+XX22 */	CANT_MAP_CHARACTER,	/* 34 */
/* U+XX23 */	CANT_MAP_CHARACTER,	/* 35 */
/* U+XX24 */	CANT_MAP_CHARACTER,	/* 36 */
/* U+XX25 */	CANT_MAP_CHARACTER,	/* 37 */
/* U+XX26 */	CANT_MAP_CHARACTER,	/* 38 */
/* U+XX27 */	CANT_MAP_CHARACTER,	/* 39 */
/* U+XX28 */	CANT_MAP_CHARACTER,	/* 40 */
/* U+XX29 */	CANT_MAP_CHARACTER,	/* 41 */
/* U+XX2A */	CANT_MAP_CHARACTER,	/* 42 */
/* U+XX2B */	CANT_MAP_CHARACTER,	/* 43 */
/* U+XX2C */	CANT_MAP_CHARACTER,	/* 44 */
/* U+XX2D */	CANT_MAP_CHARACTER,	/* 45 */
/* U+XX2E */	CANT_MAP_CHARACTER,	/* 46 */
/* U+XX2F */	CANT_MAP_CHARACTER,	/* 47 */
/* U+XX30 */	CANT_MAP_CHARACTER,	/* 48 */
/* U+XX31 */	CANT_MAP_CHARACTER,	/* 49 */
/* U+XX32 */	CANT_MAP_CHARACTER,	/* 50 */
/* U+XX33 */	CANT_MAP_CHARACTER,	/* 51 */
/* U+XX34 */	CANT_MAP_CHARACTER,	/* 52 */
/* U+XX35 */	CANT_MAP_CHARACTER,	/* 53 */
/* U+XX36 */	CANT_MAP_CHARACTER,	/* 54 */
/* U+XX37 */	CANT_MAP_CHARACTER,	/* 55 */
/* U+XX38 */	CANT_MAP_CHARACTER,	/* 56 */
/* U+XX39 */	CANT_MAP_CHARACTER,	/* 57 */
/* U+XX3A */	CANT_MAP_CHARACTER,	/* 58 */
/* U+XX3B */	CANT_MAP_CHARACTER,	/* 59 */
/* U+XX3C */	CANT_MAP_CHARACTER,	/* 60 */
/* U+XX3D */	CANT_MAP_CHARACTER,	/* 61 */
/* U+XX3E */	CANT_MAP_CHARACTER,	/* 62 */
/* U+XX3F */	CANT_MAP_CHARACTER,	/* 63 */
/* U+XX40 */	CANT_MAP_CHARACTER,	/* 64 */
/* U+XX41 */	CANT_MAP_CHARACTER,	/* 65 */
/* U+XX42 */	CANT_MAP_CHARACTER,	/* 66 */
/* U+XX43 */	CANT_MAP_CHARACTER,	/* 67 */
/* U+XX44 */	CANT_MAP_CHARACTER,	/* 68 */
/* U+XX45 */	CANT_MAP_CHARACTER,	/* 69 */
/* U+XX46 */	CANT_MAP_CHARACTER,	/* 70 */
/* U+XX47 */	CANT_MAP_CHARACTER,	/* 71 */
/* U+XX48 */	CANT_MAP_CHARACTER,	/* 72 */
/* U+XX49 */	CANT_MAP_CHARACTER,	/* 73 */
/* U+XX4A */	CANT_MAP_CHARACTER,	/* 74 */
/* U+XX4B */	CANT_MAP_CHARACTER,	/* 75 */
/* U+XX4C */	CANT_MAP_CHARACTER,	/* 76 */
/* U+XX4D */	CANT_MAP_CHARACTER,	/* 77 */
/* U+XX4E */	CANT_MAP_CHARACTER,	/* 78 */
/* U+XX4F */	CANT_MAP_CHARACTER,	/* 79 */
/* U+XX50 */	CANT_MAP_CHARACTER,	/* 80 */
/* U+XX51 */	CANT_MAP_CHARACTER,	/* 81 */
/* U+XX52 */	CANT_MAP_CHARACTER,	/* 82 */
/* U+XX53 */	CANT_MAP_CHARACTER,	/* 83 */
/* U+XX54 */	CANT_MAP_CHARACTER,	/* 84 */
/* U+XX55 */	CANT_MAP_CHARACTER,	/* 85 */
/* U+XX56 */	CANT_MAP_CHARACTER,	/* 86 */
/* U+XX57 */	CANT_MAP_CHARACTER,	/* 87 */
/* U+XX58 */	CANT_MAP_CHARACTER,	/* 88 */
/* U+XX59 */	CANT_MAP_CHARACTER,	/* 89 */
/* U+XX5A */	CANT_MAP_CHARACTER,	/* 90 */
/* U+XX5B */	CANT_MAP_CHARACTER,	/* 91 */
/* U+XX5C */	CANT_MAP_CHARACTER,	/* 92 */
/* U+XX5D */	CANT_MAP_CHARACTER,	/* 93 */
/* U+XX5E */	CANT_MAP_CHARACTER,	/* 94 */
/* U+XX5F */	CANT_MAP_CHARACTER,	/* 95 */
/* U+XX60 */	CANT_MAP_CHARACTER,	/* 96 */
/* U+XX61 */	CANT_MAP_CHARACTER,	/* 97 */
/* U+XX62 */	CANT_MAP_CHARACTER,	/* 98 */
/* U+XX63 */	CANT_MAP_CHARACTER,	/* 99 */
/* U+XX64 */	CANT_MAP_CHARACTER,	/* 100 */
/* U+XX65 */	CANT_MAP_CHARACTER,	/* 101 */
/* U+XX66 */	CANT_MAP_CHARACTER,	/* 102 */
/* U+XX67 */	CANT_MAP_CHARACTER,	/* 103 */
/* U+XX68 */	CANT_MAP_CHARACTER,	/* 104 */
/* U+XX69 */	CANT_MAP_CHARACTER,	/* 105 */
/* U+XX6A */	CANT_MAP_CHARACTER,	/* 106 */
/* U+XX6B */	CANT_MAP_CHARACTER,	/* 107 */
/* U+XX6C */	CANT_MAP_CHARACTER,	/* 108 */
/* U+XX6D */	CANT_MAP_CHARACTER,	/* 109 */
/* U+XX6E */	CANT_MAP_CHARACTER,	/* 110 */
/* U+XX6F */	CANT_MAP_CHARACTER,	/* 111 */
/* U+XX70 */	CANT_MAP_CHARACTER,	/* 112 */
/* U+XX71 */	CANT_MAP_CHARACTER,	/* 113 */
/* U+XX72 */	CANT_MAP_CHARACTER,	/* 114 */
/* U+XX73 */	CANT_MAP_CHARACTER,	/* 115 */
/* U+XX74 */	CANT_MAP_CHARACTER,	/* 116 */
/* U+XX75 */	CANT_MAP_CHARACTER,	/* 117 */
/* U+XX76 */	CANT_MAP_CHARACTER,	/* 118 */
/* U+XX77 */	CANT_MAP_CHARACTER,	/* 119 */
/* U+XX78 */	CANT_MAP_CHARACTER,	/* 120 */
/* U+XX79 */	CANT_MAP_CHARACTER,	/* 121 */
/* U+XX7A */	CANT_MAP_CHARACTER,	/* 122 */
/* U+XX7B */	CANT_MAP_CHARACTER,	/* 123 */
/* U+XX7C */	CANT_MAP_CHARACTER,	/* 124 */
/* U+XX7D */	CANT_MAP_CHARACTER,	/* 125 */
/* U+XX7E */	CANT_MAP_CHARACTER,	/* 126 */
/* U+XX7F */	CANT_MAP_CHARACTER,	/* 127 */
/* U+XX80 */	CANT_MAP_CHARACTER,	/* 128 */
/* U+XX81 */	CANT_MAP_CHARACTER,	/* 129 */
/* U+XX82 */	CANT_MAP_CHARACTER,	/* 130 */
/* U+XX83 */	CANT_MAP_CHARACTER,	/* 131 */
/* U+XX84 */	CANT_MAP_CHARACTER,	/* 132 */
/* U+XX85 */	CANT_MAP_CHARACTER,	/* 133 */
/* U+XX86 */	CANT_MAP_CHARACTER,	/* 134 */
/* U+XX87 */	CANT_MAP_CHARACTER,	/* 135 */
/* U+XX88 */	CANT_MAP_CHARACTER,	/* 136 */
/* U+XX89 */	CANT_MAP_CHARACTER,	/* 137 */
/* U+XX8A */	CANT_MAP_CHARACTER,	/* 138 */
/* U+XX8B */	CANT_MAP_CHARACTER,	/* 139 */
/* U+XX8C */	CANT_MAP_CHARACTER,	/* 140 */
/* U+XX8D */	CANT_MAP_CHARACTER,	/* 141 */
/* U+XX8E */	CANT_MAP_CHARACTER,	/* 142 */
/* U+XX8F */	CANT_MAP_CHARACTER,	/* 143 */
/* U+XX90 */	CANT_MAP_CHARACTER,	/* 144 */
/* U+XX91 */	CANT_MAP_CHARACTER,	/* 145 */
/* U+XX92 */	CANT_MAP_CHARACTER,	/* 146 */
/* U+XX93 */	CANT_MAP_CHARACTER,	/* 147 */
/* U+XX94 */	CANT_MAP_CHARACTER,	/* 148 */
/* U+XX95 */	CANT_MAP_CHARACTER,	/* 149 */
/* U+XX96 */	CANT_MAP_CHARACTER,	/* 150 */
/* U+XX97 */	CANT_MAP_CHARACTER,	/* 151 */
/* U+XX98 */	CANT_MAP_CHARACTER,	/* 152 */
/* U+XX99 */	CANT_MAP_CHARACTER,	/* 153 */
/* U+XX9A */	CANT_MAP_CHARACTER,	/* 154 */
/* U+XX9B */	CANT_MAP_CHARACTER,	/* 155 */
/* U+XX9C */	CANT_MAP_CHARACTER,	/* 156 */
/* U+XX9D */	CANT_MAP_CHARACTER,	/* 157 */
/* U+XX9E */	CANT_MAP_CHARACTER,	/* 158 */
/* U+XX9F */	CANT_MAP_CHARACTER,	/* 159 */
/* U+XXA0 */	CANT_MAP_CHARACTER,	/* 160 */
/* U+XXA1 */	CANT_MAP_CHARACTER,	/* 161 */
/* U+XXA2 */	CANT_MAP_CHARACTER,	/* 162 */
/* U+XXA3 */	CANT_MAP_CHARACTER,	/* 163 */
/* U+XXA4 */	CANT_MAP_CHARACTER,	/* 164 */
/* U+XXA5 */	CANT_MAP_CHARACTER,	/* 165 */
/* U+XXA6 */	CANT_MAP_CHARACTER,	/* 166 */
/* U+XXA7 */	CANT_MAP_CHARACTER,	/* 167 */
/* U+XXA8 */	CANT_MAP_CHARACTER,	/* 168 */
/* U+XXA9 */	CANT_MAP_CHARACTER,	/* 169 */
/* U+XXAA */	CANT_MAP_CHARACTER,	/* 170 */
/* U+XXAB */	CANT_MAP_CHARACTER,	/* 171 */
/* U+XXAC */	CANT_MAP_CHARACTER,	/* 172 */
/* U+XXAD */	CANT_MAP_CHARACTER,	/* 173 */
/* U+XXAE */	CANT_MAP_CHARACTER,	/* 174 */
/* U+XXAF */	CANT_MAP_CHARACTER,	/* 175 */
/* U+XXB0 */	CANT_MAP_CHARACTER,	/* 176 */
/* U+XXB1 */	CANT_MAP_CHARACTER,	/* 177 */
/* U+XXB2 */	CANT_MAP_CHARACTER,	/* 178 */
/* U+XXB3 */	CANT_MAP_CHARACTER,	/* 179 */
/* U+XXB4 */	CANT_MAP_CHARACTER,	/* 180 */
/* U+XXB5 */	CANT_MAP_CHARACTER,	/* 181 */
/* U+XXB6 */	CANT_MAP_CHARACTER,	/* 182 */
/* U+XXB7 */	CANT_MAP_CHARACTER,	/* 183 */
/* U+XXB8 */	CANT_MAP_CHARACTER,	/* 184 */
/* U+XXB9 */	CANT_MAP_CHARACTER,	/* 185 */
/* U+XXBA */	CANT_MAP_CHARACTER,	/* 186 */
/* U+XXBB */	CANT_MAP_CHARACTER,	/* 187 */
/* U+XXBC */	CANT_MAP_CHARACTER,	/* 188 */
/* U+XXBD */	CANT_MAP_CHARACTER,	/* 189 */
/* U+XXBE */	CANT_MAP_CHARACTER,	/* 190 */
/* U+XXBF */	CANT_MAP_CHARACTER,	/* 191 */
/* U+XXC0 */	CANT_MAP_CHARACTER,	/* 192 */
/* U+XXC1 */	CANT_MAP_CHARACTER,	/* 193 */
/* U+XXC2 */	CANT_MAP_CHARACTER,	/* 194 */
/* U+XXC3 */	CANT_MAP_CHARACTER,	/* 195 */
/* U+XXC4 */	CANT_MAP_CHARACTER,	/* 196 */
/* U+XXC5 */	CANT_MAP_CHARACTER,	/* 197 */
/* U+XXC6 */	CANT_MAP_CHARACTER,	/* 198 */
/* U+XXC7 */	CANT_MAP_CHARACTER,	/* 199 */
/* U+XXC8 */	CANT_MAP_CHARACTER,	/* 200 */
/* U+XXC9 */	CANT_MAP_CHARACTER,	/* 201 */
/* U+XXCA */	CANT_MAP_CHARACTER,	/* 202 */
/* U+XXCB */	CANT_MAP_CHARACTER,	/* 203 */
/* U+XXCC */	CANT_MAP_CHARACTER,	/* 204 */
/* U+XXCD */	CANT_MAP_CHARACTER,	/* 205 */
/* U+XXCE */	CANT_MAP_CHARACTER,	/* 206 */
/* U+XXCF */	CANT_MAP_CHARACTER,	/* 207 */
/* U+XXD0 */	CANT_MAP_CHARACTER,	/* 208 */
/* U+XXD1 */	CANT_MAP_CHARACTER,	/* 209 */
/* U+XXD2 */	CANT_MAP_CHARACTER,	/* 210 */
/* U+XXD3 */	CANT_MAP_CHARACTER,	/* 211 */
/* U+XXD4 */	CANT_MAP_CHARACTER,	/* 212 */
/* U+XXD5 */	CANT_MAP_CHARACTER,	/* 213 */
/* U+XXD6 */	CANT_MAP_CHARACTER,	/* 214 */
/* U+XXD7 */	CANT_MAP_CHARACTER,	/* 215 */
/* U+XXD8 */	CANT_MAP_CHARACTER,	/* 216 */
/* U+XXD9 */	CANT_MAP_CHARACTER,	/* 217 */
/* U+XXDA */	CANT_MAP_CHARACTER,	/* 218 */
/* U+XXDB */	CANT_MAP_CHARACTER,	/* 219 */
/* U+XXDC */	CANT_MAP_CHARACTER,	/* 220 */
/* U+XXDD */	CANT_MAP_CHARACTER,	/* 221 */
/* U+XXDE */	CANT_MAP_CHARACTER,	/* 222 */
/* U+XXDF */	CANT_MAP_CHARACTER,	/* 223 */
/* U+XXE0 */	CANT_MAP_CHARACTER,	/* 224 */
/* U+XXE1 */	CANT_MAP_CHARACTER,	/* 225 */
/* U+XXE2 */	CANT_MAP_CHARACTER,	/* 226 */
/* U+XXE3 */	CANT_MAP_CHARACTER,	/* 227 */
/* U+XXE4 */	CANT_MAP_CHARACTER,	/* 228 */
/* U+XXE5 */	CANT_MAP_CHARACTER,	/* 229 */
/* U+XXE6 */	CANT_MAP_CHARACTER,	/* 230 */
/* U+XXE7 */	CANT_MAP_CHARACTER,	/* 231 */
/* U+XXE8 */	CANT_MAP_CHARACTER,	/* 232 */
/* U+XXE9 */	CANT_MAP_CHARACTER,	/* 233 */
/* U+XXEA */	CANT_MAP_CHARACTER,	/* 234 */
/* U+XXEB */	CANT_MAP_CHARACTER,	/* 235 */
/* U+XXEC */	CANT_MAP_CHARACTER,	/* 236 */
/* U+XXED */	CANT_MAP_CHARACTER,	/* 237 */
/* U+XXEE */	CANT_MAP_CHARACTER,	/* 238 */
/* U+XXEF */	CANT_MAP_CHARACTER,	/* 239 */
/* U+XXF0 */	CANT_MAP_CHARACTER,	/* 240 */
/* U+XXF1 */	CANT_MAP_CHARACTER,	/* 241 */
/* U+XXF2 */	CANT_MAP_CHARACTER,	/* 242 */
/* U+XXF3 */	CANT_MAP_CHARACTER,	/* 243 */
/* U+XXF4 */	CANT_MAP_CHARACTER,	/* 244 */
/* U+XXF5 */	CANT_MAP_CHARACTER,	/* 245 */
/* U+XXF6 */	CANT_MAP_CHARACTER,	/* 246 */
/* U+XXF7 */	CANT_MAP_CHARACTER,	/* 247 */
/* U+XXF8 */	CANT_MAP_CHARACTER,	/* 248 */
/* U+XXF9 */	CANT_MAP_CHARACTER,	/* 249 */
/* U+XXFA */	CANT_MAP_CHARACTER,	/* 250 */
/* U+XXFB */	CANT_MAP_CHARACTER,	/* 251 */
/* U+XXFC */	CANT_MAP_CHARACTER,	/* 252 */
/* U+XXFD */	CANT_MAP_CHARACTER,	/* 253 */
/* U+XXFE */	CANT_MAP_CHARACTER,	/* 254 */
/* U+XXFF */	CANT_MAP_CHARACTER,	/* 255 */
/* U+0000 */	0x00	/*                                          NULL */,/* 256 */
/* U+0001 */	0x01	/*                              START OF HEADING */,/* 257 */
/* U+0002 */	0x02	/*                                 START OF TEXT */,/* 258 */
/* U+0003 */	0x03	/*                                   END OF TEXT */,/* 259 */
/* U+0004 */	0x04	/*                           END OF TRANSMISSION */,/* 260 */
/* U+0005 */	0x05	/*                                       ENQUIRY */,/* 261 */
/* U+0006 */	0x06	/*                                   ACKNOWLEDGE */,/* 262 */
/* U+0007 */	0x07	/*                                          BELL */,/* 263 */
/* U+0008 */	0x08	/*                                     BACKSPACE */,/* 264 */
/* U+0009 */	0x09	/*                          CHARACTER TABULATION */,/* 265 */
/* U+000A */	0x0A	/*                                LINE FEED (LF) */,/* 266 */
/* U+000B */	0x0B	/*                               LINE TABULATION */,/* 267 */
/* U+000C */	0x0C	/*                                FORM FEED (FF) */,/* 268 */
/* U+000D */	0x0D	/*                          CARRIAGE RETURN (CR) */,/* 269 */
/* U+000E */	0x0E	/*                                     SHIFT OUT */,/* 270 */
/* U+000F */	0x0F	/*                                      SHIFT IN */,/* 271 */
/* U+0010 */	0x10	/*                              DATA LINK ESCAPE */,/* 272 */
/* U+0011 */	0x11	/*                            DEVICE CONTROL ONE */,/* 273 */
/* U+0012 */	0x12	/*                            DEVICE CONTROL TWO */,/* 274 */
/* U+0013 */	0x13	/*                          DEVICE CONTROL THREE */,/* 275 */
/* U+0014 */	0x14	/*                           DEVICE CONTROL FOUR */,/* 276 */
/* U+0015 */	0x15	/*                          NEGATIVE ACKNOWLEDGE */,/* 277 */
/* U+0016 */	0x16	/*                              SYNCHRONOUS IDLE */,/* 278 */
/* U+0017 */	0x17	/*                     END OF TRANSMISSION BLOCK */,/* 279 */
/* U+0018 */	0x18	/*                                        CANCEL */,/* 280 */
/* U+0019 */	0x19	/*                                 END OF MEDIUM */,/* 281 */
/* U+001A */	0x1A	/*                                    SUBSTITUTE */,/* 282 */
/* U+001B */	0x1B	/*                                        ESCAPE */,/* 283 */
/* U+001C */	0x1C	/*                    INFORMATION SEPARATOR FOUR */,/* 284 */
/* U+001D */	0x1D	/*                   INFORMATION SEPARATOR THREE */,/* 285 */
/* U+001E */	0x1E	/*                     INFORMATION SEPARATOR TWO */,/* 286 */
/* U+001F */	0x1F	/*                     INFORMATION SEPARATOR ONE */,/* 287 */
/* U+0020 */	0x20	/*                                         SPACE */,/* 288 */
/* U+0021 */	0x21	/*                              EXCLAMATION MARK */,/* 289 */
/* U+0022 */	0x22	/*                                QUOTATION MARK */,/* 290 */
/* U+0023 */	0x23	/*                                   NUMBER SIGN */,/* 291 */
/* U+0024 */	0x24	/*                                   DOLLAR SIGN */,/* 292 */
/* U+0025 */	0x25	/*                                  PERCENT SIGN */,/* 293 */
/* U+0026 */	0x26	/*                                     AMPERSAND */,/* 294 */
/* U+0027 */	0x27	/*                                    APOSTROPHE */,/* 295 */
/* U+0028 */	0x28	/*                              LEFT PARENTHESIS */,/* 296 */
/* U+0029 */	0x29	/*                             RIGHT PARENTHESIS */,/* 297 */
/* U+002A */	0x2A	/*                                      ASTERISK */,/* 298 */
/* U+002B */	0x2B	/*                                     PLUS SIGN */,/* 299 */
/* U+002C */	0x2C	/*                                         COMMA */,/* 300 */
/* U+002D */	0x2D	/*                                  HYPHEN-MINUS */,/* 301 */
/* U+002E */	0x2E	/*                                     FULL STOP */,/* 302 */
/* U+002F */	0x2F	/*                                       SOLIDUS */,/* 303 */
/* U+0030 */	0x30	/*                                    DIGIT ZERO */,/* 304 */
/* U+0031 */	0x31	/*                                     DIGIT ONE */,/* 305 */
/* U+0032 */	0x32	/*                                     DIGIT TWO */,/* 306 */
/* U+0033 */	0x33	/*                                   DIGIT THREE */,/* 307 */
/* U+0034 */	0x34	/*                                    DIGIT FOUR */,/* 308 */
/* U+0035 */	0x35	/*                                    DIGIT FIVE */,/* 309 */
/* U+0036 */	0x36	/*                                     DIGIT SIX */,/* 310 */
/* U+0037 */	0x37	/*                                   DIGIT SEVEN */,/* 311 */
/* U+0038 */	0x38	/*                                   DIGIT EIGHT */,/* 312 */
/* U+0039 */	0x39	/*                                    DIGIT NINE */,/* 313 */
/* U+003A */	0x3A	/*                                         COLON */,/* 314 */
/* U+003B */	0x3B	/*                                     SEMICOLON */,/* 315 */
/* U+003C */	0x3C	/*                                LESS-THAN SIGN */,/* 316 */
/* U+003D */	0x3D	/*                                   EQUALS SIGN */,/* 317 */
/* U+003E */	0x3E	/*                             GREATER-THAN SIGN */,/* 318 */
/* U+003F */	0x3F	/*                                 QUESTION MARK */,/* 319 */
/* U+0040 */	0x40	/*                                 COMMERCIAL AT */,/* 320 */
/* U+0041 */	0x41	/*                        LATIN CAPITAL LETTER A */,/* 321 */
/* U+0042 */	0x42	/*                        LATIN CAPITAL LETTER B */,/* 322 */
/* U+0043 */	0x43	/*                        LATIN CAPITAL LETTER C */,/* 323 */
/* U+0044 */	0x44	/*                        LATIN CAPITAL LETTER D */,/* 324 */
/* U+0045 */	0x45	/*                        LATIN CAPITAL LETTER E */,/* 325 */
/* U+0046 */	0x46	/*                        LATIN CAPITAL LETTER F */,/* 326 */
/* U+0047 */	0x47	/*                        LATIN CAPITAL LETTER G */,/* 327 */
/* U+0048 */	0x48	/*                        LATIN CAPITAL LETTER H */,/* 328 */
/* U+0049 */	0x49	/*                        LATIN CAPITAL LETTER I */,/* 329 */
/* U+004A */	0x4A	/*                        LATIN CAPITAL LETTER J */,/* 330 */
/* U+004B */	0x4B	/*                        LATIN CAPITAL LETTER K */,/* 331 */
/* U+004C */	0x4C	/*                        LATIN CAPITAL LETTER L */,/* 332 */
/* U+004D */	0x4D	/*                        LATIN CAPITAL LETTER M */,/* 333 */
/* U+004E */	0x4E	/*                        LATIN CAPITAL LETTER N */,/* 334 */
/* U+004F */	0x4F	/*                        LATIN CAPITAL LETTER O */,/* 335 */
/* U+0050 */	0x50	/*                        LATIN CAPITAL LETTER P */,/* 336 */
/* U+0051 */	0x51	/*                        LATIN CAPITAL LETTER Q */,/* 337 */
/* U+0052 */	0x52	/*                        LATIN CAPITAL LETTER R */,/* 338 */
/* U+0053 */	0x53	/*                        LATIN CAPITAL LETTER S */,/* 339 */
/* U+0054 */	0x54	/*                        LATIN CAPITAL LETTER T */,/* 340 */
/* U+0055 */	0x55	/*                        LATIN CAPITAL LETTER U */,/* 341 */
/* U+0056 */	0x56	/*                        LATIN CAPITAL LETTER V */,/* 342 */
/* U+0057 */	0x57	/*                        LATIN CAPITAL LETTER W */,/* 343 */
/* U+0058 */	0x58	/*                        LATIN CAPITAL LETTER X */,/* 344 */
/* U+0059 */	0x59	/*                        LATIN CAPITAL LETTER Y */,/* 345 */
/* U+005A */	0x5A	/*                        LATIN CAPITAL LETTER Z */,/* 346 */
/* U+005B */	0x5B	/*                           LEFT SQUARE BRACKET */,/* 347 */
/* U+005C */	0x5C	/*                               REVERSE SOLIDUS */,/* 348 */
/* U+005D */	0x5D	/*                          RIGHT SQUARE BRACKET */,/* 349 */
/* U+005E */	0x5E	/*                             CIRCUMFLEX ACCENT */,/* 350 */
/* U+005F */	0x5F	/*                                      LOW LINE */,/* 351 */
/* U+0060 */	0x60	/*                                  GRAVE ACCENT */,/* 352 */
/* U+0061 */	0x61	/*                          LATIN SMALL LETTER A */,/* 353 */
/* U+0062 */	0x62	/*                          LATIN SMALL LETTER B */,/* 354 */
/* U+0063 */	0x63	/*                          LATIN SMALL LETTER C */,/* 355 */
/* U+0064 */	0x64	/*                          LATIN SMALL LETTER D */,/* 356 */
/* U+0065 */	0x65	/*                          LATIN SMALL LETTER E */,/* 357 */
/* U+0066 */	0x66	/*                          LATIN SMALL LETTER F */,/* 358 */
/* U+0067 */	0x67	/*                          LATIN SMALL LETTER G */,/* 359 */
/* U+0068 */	0x68	/*                          LATIN SMALL LETTER H */,/* 360 */
/* U+0069 */	0x69	/*                          LATIN SMALL LETTER I */,/* 361 */
/* U+006A */	0x6A	/*                          LATIN SMALL LETTER J */,/* 362 */
/* U+006B */	0x6B	/*                          LATIN SMALL LETTER K */,/* 363 */
/* U+006C */	0x6C	/*                          LATIN SMALL LETTER L */,/* 364 */
/* U+006D */	0x6D	/*                          LATIN SMALL LETTER M */,/* 365 */
/* U+006E */	0x6E	/*                          LATIN SMALL LETTER N */,/* 366 */
/* U+006F */	0x6F	/*                          LATIN SMALL LETTER O */,/* 367 */
/* U+0070 */	0x70	/*                          LATIN SMALL LETTER P */,/* 368 */
/* U+0071 */	0x71	/*                          LATIN SMALL LETTER Q */,/* 369 */
/* U+0072 */	0x72	/*                          LATIN SMALL LETTER R */,/* 370 */
/* U+0073 */	0x73	/*                          LATIN SMALL LETTER S */,/* 371 */
/* U+0074 */	0x74	/*                          LATIN SMALL LETTER T */,/* 372 */
/* U+0075 */	0x75	/*                          LATIN SMALL LETTER U */,/* 373 */
/* U+0076 */	0x76	/*                          LATIN SMALL LETTER V */,/* 374 */
/* U+0077 */	0x77	/*                          LATIN SMALL LETTER W */,/* 375 */
/* U+0078 */	0x78	/*                          LATIN SMALL LETTER X */,/* 376 */
/* U+0079 */	0x79	/*                          LATIN SMALL LETTER Y */,/* 377 */
/* U+007A */	0x7A	/*                          LATIN SMALL LETTER Z */,/* 378 */
/* U+007B */	0x7B	/*                            LEFT CURLY BRACKET */,/* 379 */
/* U+007C */	0x7C	/*                                 VERTICAL LINE */,/* 380 */
/* U+007D */	0x7D	/*                           RIGHT CURLY BRACKET */,/* 381 */
/* U+007E */	0x7E	/*                                         TILDE */,/* 382 */
/* U+007F */	0x7F	/*                                        DELETE */,/* 383 */
/* U+0080 */	0x80	/*                                               */,/* 384 */
/* U+0081 */	0x81	/*                                               */,/* 385 */
/* U+0082 */	0x82	/*                          BREAK PERMITTED HERE */,/* 386 */
/* U+0083 */	0x83	/*                                 NO BREAK HERE */,/* 387 */
/* U+0084 */	0x84	/*                                               */,/* 388 */
/* U+0085 */	0x85	/*                               NEXT LINE (NEL) */,/* 389 */
/* U+0086 */	0x86	/*                        START OF SELECTED AREA */,/* 390 */
/* U+0087 */	0x87	/*                          END OF SELECTED AREA */,/* 391 */
/* U+0088 */	0x88	/*                      CHARACTER TABULATION SET */,/* 392 */
/* U+0089 */	0x89	/*       CHARACTER TABULATION WITH JUSTIFICATION */,/* 393 */
/* U+008A */	0x8A	/*                           LINE TABULATION SET */,/* 394 */
/* U+008B */	0x8B	/*                          PARTIAL LINE FORWARD */,/* 395 */
/* U+008C */	0x8C	/*                         PARTIAL LINE BACKWARD */,/* 396 */
/* U+008D */	0x8D	/*                             REVERSE LINE FEED */,/* 397 */
/* U+008E */	0x8E	/*                              SINGLE SHIFT TWO */,/* 398 */
/* U+008F */	0x8F	/*                            SINGLE SHIFT THREE */,/* 399 */
/* U+0090 */	0x90	/*                         DEVICE CONTROL STRING */,/* 400 */
/* U+0091 */	0x91	/*                               PRIVATE USE ONE */,/* 401 */
/* U+0092 */	0x92	/*                               PRIVATE USE TWO */,/* 402 */
/* U+0093 */	0x93	/*                            SET TRANSMIT STATE */,/* 403 */
/* U+0094 */	0x94	/*                              CANCEL CHARACTER */,/* 404 */
/* U+0095 */	0x95	/*                               MESSAGE WAITING */,/* 405 */
/* U+0096 */	0x96	/*                         START OF GUARDED AREA */,/* 406 */
/* U+0097 */	0x97	/*                           END OF GUARDED AREA */,/* 407 */
/* U+0098 */	0x98	/*                               START OF STRING */,/* 408 */
/* U+0099 */	0x99	/*                                               */,/* 409 */
/* U+009A */	0x9A	/*                   SINGLE CHARACTER INTRODUCER */,/* 410 */
/* U+009B */	0x9B	/*                   CONTROL SEQUENCE INTRODUCER */,/* 411 */
/* U+009C */	0x9C	/*                             STRING TERMINATOR */,/* 412 */
/* U+009D */	0x9D	/*                      OPERATING SYSTEM COMMAND */,/* 413 */
/* U+009E */	0x9E	/*                               PRIVACY MESSAGE */,/* 414 */
/* U+009F */	0x9F	/*                   APPLICATION PROGRAM COMMAND */,/* 415 */
/* U+00A0 */	0xA0	/*                                NO-BREAK SPACE */,/* 416 */
/* U+00A1 */	CANT_MAP_CHARACTER,	/* 417 */
/* U+00A2 */	CANT_MAP_CHARACTER,	/* 418 */
/* U+00A3 */	0xA3	/*                                    POUND SIGN */,/* 419 */
/* U+00A4 */	CANT_MAP_CHARACTER,	/* 420 */
/* U+00A5 */	CANT_MAP_CHARACTER,	/* 421 */
/* U+00A6 */	0xA6	/*                                    BROKEN BAR */,/* 422 */
/* U+00A7 */	0xA7	/*                                  SECTION SIGN */,/* 423 */
/* U+00A8 */	0xA8	/*                                     DIAERESIS */,/* 424 */
/* U+00A9 */	0xA9	/*                                COPYRIGHT SIGN */,/* 425 */
/* U+00AA */	CANT_MAP_CHARACTER,	/* 426 */
/* U+00AB */	0xAB	/*     LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */,/* 427 */
/* U+00AC */	0xAC	/*                                      NOT SIGN */,/* 428 */
/* U+00AD */	0xAD	/*                                   SOFT HYPHEN */,/* 429 */
/* U+00AE */	CANT_MAP_CHARACTER,	/* 430 */
/* U+00AF */	CANT_MAP_CHARACTER,	/* 431 */
/* U+00B0 */	0xB0	/*                                   DEGREE SIGN */,/* 432 */
/* U+00B1 */	0xB1	/*                               PLUS-MINUS SIGN */,/* 433 */
/* U+00B2 */	0xB2	/*                               SUPERSCRIPT TWO */,/* 434 */
/* U+00B3 */	0xB3	/*                             SUPERSCRIPT THREE */,/* 435 */
/* U+00B4 */	CANT_MAP_CHARACTER,	/* 436 */
/* U+00B5 */	CANT_MAP_CHARACTER,	/* 437 */
/* U+00B6 */	CANT_MAP_CHARACTER,	/* 438 */
/* U+00B7 */	0xB7	/*                                    MIDDLE DOT */,/* 439 */
/* U+00B8 */	CANT_MAP_CHARACTER,	/* 440 */
/* U+00B9 */	CANT_MAP_CHARACTER,	/* 441 */
/* U+00BA */	CANT_MAP_CHARACTER,	/* 442 */
/* U+00BB */	0xBB	/*    RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK */,/* 443 */
/* U+00BC */	CANT_MAP_CHARACTER,	/* 444 */
/* U+00BD */	0xBD	/*                      VULGAR FRACTION ONE HALF */,/* 445 */
/* U+00BE */	CANT_MAP_CHARACTER,	/* 446 */
/* U+00BF */	CANT_MAP_CHARACTER,	/* 447 */
/* U+00C0 */	CANT_MAP_CHARACTER,	/* 448 */
/* U+00C1 */	CANT_MAP_CHARACTER,	/* 449 */
/* U+00C2 */	CANT_MAP_CHARACTER,	/* 450 */
/* U+00C3 */	CANT_MAP_CHARACTER,	/* 451 */
/* U+00C4 */	CANT_MAP_CHARACTER,	/* 452 */
/* U+00C5 */	CANT_MAP_CHARACTER,	/* 453 */
/* U+00C6 */	CANT_MAP_CHARACTER,	/* 454 */
/* U+00C7 */	CANT_MAP_CHARACTER,	/* 455 */
/* U+00C8 */	CANT_MAP_CHARACTER,	/* 456 */
/* U+00C9 */	CANT_MAP_CHARACTER,	/* 457 */
/* U+00CA */	CANT_MAP_CHARACTER,	/* 458 */
/* U+00CB */	CANT_MAP_CHARACTER,	/* 459 */
/* U+00CC */	CANT_MAP_CHARACTER,	/* 460 */
/* U+00CD */	CANT_MAP_CHARACTER,	/* 461 */
/* U+00CE */	CANT_MAP_CHARACTER,	/* 462 */
/* U+00CF */	CANT_MAP_CHARACTER,	/* 463 */
/* U+00D0 */	CANT_MAP_CHARACTER,	/* 464 */
/* U+00D1 */	CANT_MAP_CHARACTER,	/* 465 */
/* U+00D2 */	CANT_MAP_CHARACTER,	/* 466 */
/* U+00D3 */	CANT_MAP_CHARACTER,	/* 467 */
/* U+00D4 */	CANT_MAP_CHARACTER,	/* 468 */
/* U+00D5 */	CANT_MAP_CHARACTER,	/* 469 */
/* U+00D6 */	CANT_MAP_CHARACTER,	/* 470 */
/* U+00D7 */	CANT_MAP_CHARACTER,	/* 471 */
/* U+00D8 */	CANT_MAP_CHARACTER,	/* 472 */
/* U+00D9 */	CANT_MAP_CHARACTER,	/* 473 */
/* U+00DA */	CANT_MAP_CHARACTER,	/* 474 */
/* U+00DB */	CANT_MAP_CHARACTER,	/* 475 */
/* U+00DC */	CANT_MAP_CHARACTER,	/* 476 */
/* U+00DD */	CANT_MAP_CHARACTER,	/* 477 */
/* U+00DE */	CANT_MAP_CHARACTER,	/* 478 */
/* U+00DF */	CANT_MAP_CHARACTER,	/* 479 */
/* U+00E0 */	CANT_MAP_CHARACTER,	/* 480 */
/* U+00E1 */	CANT_MAP_CHARACTER,	/* 481 */
/* U+00E2 */	CANT_MAP_CHARACTER,	/* 482 */
/* U+00E3 */	CANT_MAP_CHARACTER,	/* 483 */
/* U+00E4 */	CANT_MAP_CHARACTER,	/* 484 */
/* U+00E5 */	CANT_MAP_CHARACTER,	/* 485 */
/* U+00E6 */	CANT_MAP_CHARACTER,	/* 486 */
/* U+00E7 */	CANT_MAP_CHARACTER,	/* 487 */
/* U+00E8 */	CANT_MAP_CHARACTER,	/* 488 */
/* U+00E9 */	CANT_MAP_CHARACTER,	/* 489 */
/* U+00EA */	CANT_MAP_CHARACTER,	/* 490 */
/* U+00EB */	CANT_MAP_CHARACTER,	/* 491 */
/* U+00EC */	CANT_MAP_CHARACTER,	/* 492 */
/* U+00ED */	CANT_MAP_CHARACTER,	/* 493 */
/* U+00EE */	CANT_MAP_CHARACTER,	/* 494 */
/* U+00EF */	CANT_MAP_CHARACTER,	/* 495 */
/* U+00F0 */	CANT_MAP_CHARACTER,	/* 496 */
/* U+00F1 */	CANT_MAP_CHARACTER,	/* 497 */
/* U+00F2 */	CANT_MAP_CHARACTER,	/* 498 */
/* U+00F3 */	CANT_MAP_CHARACTER,	/* 499 */
/* U+00F4 */	CANT_MAP_CHARACTER,	/* 500 */
/* U+00F5 */	CANT_MAP_CHARACTER,	/* 501 */
/* U+00F6 */	CANT_MAP_CHARACTER,	/* 502 */
/* U+00F7 */	CANT_MAP_CHARACTER,	/* 503 */
/* U+00F8 */	CANT_MAP_CHARACTER,	/* 504 */
/* U+00F9 */	CANT_MAP_CHARACTER,	/* 505 */
/* U+00FA */	CANT_MAP_CHARACTER,	/* 506 */
/* U+00FB */	CANT_MAP_CHARACTER,	/* 507 */
/* U+00FC */	CANT_MAP_CHARACTER,	/* 508 */
/* U+00FD */	CANT_MAP_CHARACTER,	/* 509 */
/* U+00FE */	CANT_MAP_CHARACTER,	/* 510 */
/* U+00FF */	CANT_MAP_CHARACTER,	/* 511 */
/* U+0200 */	CANT_MAP_CHARACTER,	/* 512 */
/* U+0201 */	CANT_MAP_CHARACTER,	/* 513 */
/* U+0202 */	CANT_MAP_CHARACTER,	/* 514 */
/* U+0203 */	CANT_MAP_CHARACTER,	/* 515 */
/* U+0204 */	CANT_MAP_CHARACTER,	/* 516 */
/* U+0205 */	CANT_MAP_CHARACTER,	/* 517 */
/* U+0206 */	CANT_MAP_CHARACTER,	/* 518 */
/* U+0207 */	CANT_MAP_CHARACTER,	/* 519 */
/* U+0208 */	CANT_MAP_CHARACTER,	/* 520 */
/* U+0209 */	CANT_MAP_CHARACTER,	/* 521 */
/* U+020A */	CANT_MAP_CHARACTER,	/* 522 */
/* U+020B */	CANT_MAP_CHARACTER,	/* 523 */
/* U+020C */	CANT_MAP_CHARACTER,	/* 524 */
/* U+020D */	CANT_MAP_CHARACTER,	/* 525 */
/* U+020E */	CANT_MAP_CHARACTER,	/* 526 */
/* U+020F */	CANT_MAP_CHARACTER,	/* 527 */
/* U+0210 */	CANT_MAP_CHARACTER,	/* 528 */
/* U+0211 */	CANT_MAP_CHARACTER,	/* 529 */
/* U+0212 */	CANT_MAP_CHARACTER,	/* 530 */
/* U+0213 */	CANT_MAP_CHARACTER,	/* 531 */
/* U+0214 */	CANT_MAP_CHARACTER,	/* 532 */
/* U+0215 */	CANT_MAP_CHARACTER,	/* 533 */
/* U+0216 */	CANT_MAP_CHARACTER,	/* 534 */
/* U+0217 */	CANT_MAP_CHARACTER,	/* 535 */
/* U+0218 */	CANT_MAP_CHARACTER,	/* 536 */
/* U+0219 */	CANT_MAP_CHARACTER,	/* 537 */
/* U+021A */	CANT_MAP_CHARACTER,	/* 538 */
/* U+021B */	CANT_MAP_CHARACTER,	/* 539 */
/* U+021C */	CANT_MAP_CHARACTER,	/* 540 */
/* U+021D */	CANT_MAP_CHARACTER,	/* 541 */
/* U+021E */	CANT_MAP_CHARACTER,	/* 542 */
/* U+021F */	CANT_MAP_CHARACTER,	/* 543 */
/* U+0220 */	CANT_MAP_CHARACTER,	/* 544 */
/* U+0221 */	CANT_MAP_CHARACTER,	/* 545 */
/* U+0222 */	CANT_MAP_CHARACTER,	/* 546 */
/* U+0223 */	CANT_MAP_CHARACTER,	/* 547 */
/* U+0224 */	CANT_MAP_CHARACTER,	/* 548 */
/* U+0225 */	CANT_MAP_CHARACTER,	/* 549 */
/* U+0226 */	CANT_MAP_CHARACTER,	/* 550 */
/* U+0227 */	CANT_MAP_CHARACTER,	/* 551 */
/* U+0228 */	CANT_MAP_CHARACTER,	/* 552 */
/* U+0229 */	CANT_MAP_CHARACTER,	/* 553 */
/* U+022A */	CANT_MAP_CHARACTER,	/* 554 */
/* U+022B */	CANT_MAP_CHARACTER,	/* 555 */
/* U+022C */	CANT_MAP_CHARACTER,	/* 556 */
/* U+022D */	CANT_MAP_CHARACTER,	/* 557 */
/* U+022E */	CANT_MAP_CHARACTER,	/* 558 */
/* U+022F */	CANT_MAP_CHARACTER,	/* 559 */
/* U+0230 */	CANT_MAP_CHARACTER,	/* 560 */
/* U+0231 */	CANT_MAP_CHARACTER,	/* 561 */
/* U+0232 */	CANT_MAP_CHARACTER,	/* 562 */
/* U+0233 */	CANT_MAP_CHARACTER,	/* 563 */
/* U+0234 */	CANT_MAP_CHARACTER,	/* 564 */
/* U+0235 */	CANT_MAP_CHARACTER,	/* 565 */
/* U+0236 */	CANT_MAP_CHARACTER,	/* 566 */
/* U+0237 */	CANT_MAP_CHARACTER,	/* 567 */
/* U+0238 */	CANT_MAP_CHARACTER,	/* 568 */
/* U+0239 */	CANT_MAP_CHARACTER,	/* 569 */
/* U+023A */	CANT_MAP_CHARACTER,	/* 570 */
/* U+023B */	CANT_MAP_CHARACTER,	/* 571 */
/* U+023C */	CANT_MAP_CHARACTER,	/* 572 */
/* U+023D */	CANT_MAP_CHARACTER,	/* 573 */
/* U+023E */	CANT_MAP_CHARACTER,	/* 574 */
/* U+023F */	CANT_MAP_CHARACTER,	/* 575 */
/* U+0240 */	CANT_MAP_CHARACTER,	/* 576 */
/* U+0241 */	CANT_MAP_CHARACTER,	/* 577 */
/* U+0242 */	CANT_MAP_CHARACTER,	/* 578 */
/* U+0243 */	CANT_MAP_CHARACTER,	/* 579 */
/* U+0244 */	CANT_MAP_CHARACTER,	/* 580 */
/* U+0245 */	CANT_MAP_CHARACTER,	/* 581 */
/* U+0246 */	CANT_MAP_CHARACTER,	/* 582 */
/* U+0247 */	CANT_MAP_CHARACTER,	/* 583 */
/* U+0248 */	CANT_MAP_CHARACTER,	/* 584 */
/* U+0249 */	CANT_MAP_CHARACTER,	/* 585 */
/* U+024A */	CANT_MAP_CHARACTER,	/* 586 */
/* U+024B */	CANT_MAP_CHARACTER,	/* 587 */
/* U+024C */	CANT_MAP_CHARACTER,	/* 588 */
/* U+024D */	CANT_MAP_CHARACTER,	/* 589 */
/* U+024E */	CANT_MAP_CHARACTER,	/* 590 */
/* U+024F */	CANT_MAP_CHARACTER,	/* 591 */
/* U+0250 */	CANT_MAP_CHARACTER,	/* 592 */
/* U+0251 */	CANT_MAP_CHARACTER,	/* 593 */
/* U+0252 */	CANT_MAP_CHARACTER,	/* 594 */
/* U+0253 */	CANT_MAP_CHARACTER,	/* 595 */
/* U+0254 */	CANT_MAP_CHARACTER,	/* 596 */
/* U+0255 */	CANT_MAP_CHARACTER,	/* 597 */
/* U+0256 */	CANT_MAP_CHARACTER,	/* 598 */
/* U+0257 */	CANT_MAP_CHARACTER,	/* 599 */
/* U+0258 */	CANT_MAP_CHARACTER,	/* 600 */
/* U+0259 */	CANT_MAP_CHARACTER,	/* 601 */
/* U+025A */	CANT_MAP_CHARACTER,	/* 602 */
/* U+025B */	CANT_MAP_CHARACTER,	/* 603 */
/* U+025C */	CANT_MAP_CHARACTER,	/* 604 */
/* U+025D */	CANT_MAP_CHARACTER,	/* 605 */
/* U+025E */	CANT_MAP_CHARACTER,	/* 606 */
/* U+025F */	CANT_MAP_CHARACTER,	/* 607 */
/* U+0260 */	CANT_MAP_CHARACTER,	/* 608 */
/* U+0261 */	CANT_MAP_CHARACTER,	/* 609 */
/* U+0262 */	CANT_MAP_CHARACTER,	/* 610 */
/* U+0263 */	CANT_MAP_CHARACTER,	/* 611 */
/* U+0264 */	CANT_MAP_CHARACTER,	/* 612 */
/* U+0265 */	CANT_MAP_CHARACTER,	/* 613 */
/* U+0266 */	CANT_MAP_CHARACTER,	/* 614 */
/* U+0267 */	CANT_MAP_CHARACTER,	/* 615 */
/* U+0268 */	CANT_MAP_CHARACTER,	/* 616 */
/* U+0269 */	CANT_MAP_CHARACTER,	/* 617 */
/* U+026A */	CANT_MAP_CHARACTER,	/* 618 */
/* U+026B */	CANT_MAP_CHARACTER,	/* 619 */
/* U+026C */	CANT_MAP_CHARACTER,	/* 620 */
/* U+026D */	CANT_MAP_CHARACTER,	/* 621 */
/* U+026E */	CANT_MAP_CHARACTER,	/* 622 */
/* U+026F */	CANT_MAP_CHARACTER,	/* 623 */
/* U+0270 */	CANT_MAP_CHARACTER,	/* 624 */
/* U+0271 */	CANT_MAP_CHARACTER,	/* 625 */
/* U+0272 */	CANT_MAP_CHARACTER,	/* 626 */
/* U+0273 */	CANT_MAP_CHARACTER,	/* 627 */
/* U+0274 */	CANT_MAP_CHARACTER,	/* 628 */
/* U+0275 */	CANT_MAP_CHARACTER,	/* 629 */
/* U+0276 */	CANT_MAP_CHARACTER,	/* 630 */
/* U+0277 */	CANT_MAP_CHARACTER,	/* 631 */
/* U+0278 */	CANT_MAP_CHARACTER,	/* 632 */
/* U+0279 */	CANT_MAP_CHARACTER,	/* 633 */
/* U+027A */	CANT_MAP_CHARACTER,	/* 634 */
/* U+027B */	CANT_MAP_CHARACTER,	/* 635 */
/* U+027C */	CANT_MAP_CHARACTER,	/* 636 */
/* U+027D */	CANT_MAP_CHARACTER,	/* 637 */
/* U+027E */	CANT_MAP_CHARACTER,	/* 638 */
/* U+027F */	CANT_MAP_CHARACTER,	/* 639 */
/* U+0280 */	CANT_MAP_CHARACTER,	/* 640 */
/* U+0281 */	CANT_MAP_CHARACTER,	/* 641 */
/* U+0282 */	CANT_MAP_CHARACTER,	/* 642 */
/* U+0283 */	CANT_MAP_CHARACTER,	/* 643 */
/* U+0284 */	CANT_MAP_CHARACTER,	/* 644 */
/* U+0285 */	CANT_MAP_CHARACTER,	/* 645 */
/* U+0286 */	CANT_MAP_CHARACTER,	/* 646 */
/* U+0287 */	CANT_MAP_CHARACTER,	/* 647 */
/* U+0288 */	CANT_MAP_CHARACTER,	/* 648 */
/* U+0289 */	CANT_MAP_CHARACTER,	/* 649 */
/* U+028A */	CANT_MAP_CHARACTER,	/* 650 */
/* U+028B */	CANT_MAP_CHARACTER,	/* 651 */
/* U+028C */	CANT_MAP_CHARACTER,	/* 652 */
/* U+028D */	CANT_MAP_CHARACTER,	/* 653 */
/* U+028E */	CANT_MAP_CHARACTER,	/* 654 */
/* U+028F */	CANT_MAP_CHARACTER,	/* 655 */
/* U+0290 */	CANT_MAP_CHARACTER,	/* 656 */
/* U+0291 */	CANT_MAP_CHARACTER,	/* 657 */
/* U+0292 */	CANT_MAP_CHARACTER,	/* 658 */
/* U+0293 */	CANT_MAP_CHARACTER,	/* 659 */
/* U+0294 */	CANT_MAP_CHARACTER,	/* 660 */
/* U+0295 */	CANT_MAP_CHARACTER,	/* 661 */
/* U+0296 */	CANT_MAP_CHARACTER,	/* 662 */
/* U+0297 */	CANT_MAP_CHARACTER,	/* 663 */
/* U+0298 */	CANT_MAP_CHARACTER,	/* 664 */
/* U+0299 */	CANT_MAP_CHARACTER,	/* 665 */
/* U+029A */	CANT_MAP_CHARACTER,	/* 666 */
/* U+029B */	CANT_MAP_CHARACTER,	/* 667 */
/* U+029C */	CANT_MAP_CHARACTER,	/* 668 */
/* U+029D */	CANT_MAP_CHARACTER,	/* 669 */
/* U+029E */	CANT_MAP_CHARACTER,	/* 670 */
/* U+029F */	CANT_MAP_CHARACTER,	/* 671 */
/* U+02A0 */	CANT_MAP_CHARACTER,	/* 672 */
/* U+02A1 */	CANT_MAP_CHARACTER,	/* 673 */
/* U+02A2 */	CANT_MAP_CHARACTER,	/* 674 */
/* U+02A3 */	CANT_MAP_CHARACTER,	/* 675 */
/* U+02A4 */	CANT_MAP_CHARACTER,	/* 676 */
/* U+02A5 */	CANT_MAP_CHARACTER,	/* 677 */
/* U+02A6 */	CANT_MAP_CHARACTER,	/* 678 */
/* U+02A7 */	CANT_MAP_CHARACTER,	/* 679 */
/* U+02A8 */	CANT_MAP_CHARACTER,	/* 680 */
/* U+02A9 */	CANT_MAP_CHARACTER,	/* 681 */
/* U+02AA */	CANT_MAP_CHARACTER,	/* 682 */
/* U+02AB */	CANT_MAP_CHARACTER,	/* 683 */
/* U+02AC */	CANT_MAP_CHARACTER,	/* 684 */
/* U+02AD */	CANT_MAP_CHARACTER,	/* 685 */
/* U+02AE */	CANT_MAP_CHARACTER,	/* 686 */
/* U+02AF */	CANT_MAP_CHARACTER,	/* 687 */
/* U+02B0 */	CANT_MAP_CHARACTER,	/* 688 */
/* U+02B1 */	CANT_MAP_CHARACTER,	/* 689 */
/* U+02B2 */	CANT_MAP_CHARACTER,	/* 690 */
/* U+02B3 */	CANT_MAP_CHARACTER,	/* 691 */
/* U+02B4 */	CANT_MAP_CHARACTER,	/* 692 */
/* U+02B5 */	CANT_MAP_CHARACTER,	/* 693 */
/* U+02B6 */	CANT_MAP_CHARACTER,	/* 694 */
/* U+02B7 */	CANT_MAP_CHARACTER,	/* 695 */
/* U+02B8 */	CANT_MAP_CHARACTER,	/* 696 */
/* U+02B9 */	CANT_MAP_CHARACTER,	/* 697 */
/* U+02BA */	CANT_MAP_CHARACTER,	/* 698 */
/* U+02BB */	CANT_MAP_CHARACTER,	/* 699 */
/* U+02BC */	0xA2	/*                    MODIFIER LETTER APOSTROPHE */,/* 700 */
/* U+02BD */	0xA1	/*                MODIFIER LETTER REVERSED COMMA */,/* 701 */
/* U+02BE */	CANT_MAP_CHARACTER,	/* 702 */
/* U+02BF */	CANT_MAP_CHARACTER,	/* 703 */
/* U+02C0 */	CANT_MAP_CHARACTER,	/* 704 */
/* U+02C1 */	CANT_MAP_CHARACTER,	/* 705 */
/* U+02C2 */	CANT_MAP_CHARACTER,	/* 706 */
/* U+02C3 */	CANT_MAP_CHARACTER,	/* 707 */
/* U+02C4 */	CANT_MAP_CHARACTER,	/* 708 */
/* U+02C5 */	CANT_MAP_CHARACTER,	/* 709 */
/* U+02C6 */	CANT_MAP_CHARACTER,	/* 710 */
/* U+02C7 */	CANT_MAP_CHARACTER,	/* 711 */
/* U+02C8 */	CANT_MAP_CHARACTER,	/* 712 */
/* U+02C9 */	CANT_MAP_CHARACTER,	/* 713 */
/* U+02CA */	CANT_MAP_CHARACTER,	/* 714 */
/* U+02CB */	CANT_MAP_CHARACTER,	/* 715 */
/* U+02CC */	CANT_MAP_CHARACTER,	/* 716 */
/* U+02CD */	CANT_MAP_CHARACTER,	/* 717 */
/* U+02CE */	CANT_MAP_CHARACTER,	/* 718 */
/* U+02CF */	CANT_MAP_CHARACTER,	/* 719 */
/* U+02D0 */	CANT_MAP_CHARACTER,	/* 720 */
/* U+02D1 */	CANT_MAP_CHARACTER,	/* 721 */
/* U+02D2 */	CANT_MAP_CHARACTER,	/* 722 */
/* U+02D3 */	CANT_MAP_CHARACTER,	/* 723 */
/* U+02D4 */	CANT_MAP_CHARACTER,	/* 724 */
/* U+02D5 */	CANT_MAP_CHARACTER,	/* 725 */
/* U+02D6 */	CANT_MAP_CHARACTER,	/* 726 */
/* U+02D7 */	CANT_MAP_CHARACTER,	/* 727 */
/* U+02D8 */	CANT_MAP_CHARACTER,	/* 728 */
/* U+02D9 */	CANT_MAP_CHARACTER,	/* 729 */
/* U+02DA */	CANT_MAP_CHARACTER,	/* 730 */
/* U+02DB */	CANT_MAP_CHARACTER,	/* 731 */
/* U+02DC */	CANT_MAP_CHARACTER,	/* 732 */
/* U+02DD */	CANT_MAP_CHARACTER,	/* 733 */
/* U+02DE */	CANT_MAP_CHARACTER,	/* 734 */
/* U+02DF */	CANT_MAP_CHARACTER,	/* 735 */
/* U+02E0 */	CANT_MAP_CHARACTER,	/* 736 */
/* U+02E1 */	CANT_MAP_CHARACTER,	/* 737 */
/* U+02E2 */	CANT_MAP_CHARACTER,	/* 738 */
/* U+02E3 */	CANT_MAP_CHARACTER,	/* 739 */
/* U+02E4 */	CANT_MAP_CHARACTER,	/* 740 */
/* U+02E5 */	CANT_MAP_CHARACTER,	/* 741 */
/* U+02E6 */	CANT_MAP_CHARACTER,	/* 742 */
/* U+02E7 */	CANT_MAP_CHARACTER,	/* 743 */
/* U+02E8 */	CANT_MAP_CHARACTER,	/* 744 */
/* U+02E9 */	CANT_MAP_CHARACTER,	/* 745 */
/* U+02EA */	CANT_MAP_CHARACTER,	/* 746 */
/* U+02EB */	CANT_MAP_CHARACTER,	/* 747 */
/* U+02EC */	CANT_MAP_CHARACTER,	/* 748 */
/* U+02ED */	CANT_MAP_CHARACTER,	/* 749 */
/* U+02EE */	CANT_MAP_CHARACTER,	/* 750 */
/* U+02EF */	CANT_MAP_CHARACTER,	/* 751 */
/* U+02F0 */	CANT_MAP_CHARACTER,	/* 752 */
/* U+02F1 */	CANT_MAP_CHARACTER,	/* 753 */
/* U+02F2 */	CANT_MAP_CHARACTER,	/* 754 */
/* U+02F3 */	CANT_MAP_CHARACTER,	/* 755 */
/* U+02F4 */	CANT_MAP_CHARACTER,	/* 756 */
/* U+02F5 */	CANT_MAP_CHARACTER,	/* 757 */
/* U+02F6 */	CANT_MAP_CHARACTER,	/* 758 */
/* U+02F7 */	CANT_MAP_CHARACTER,	/* 759 */
/* U+02F8 */	CANT_MAP_CHARACTER,	/* 760 */
/* U+02F9 */	CANT_MAP_CHARACTER,	/* 761 */
/* U+02FA */	CANT_MAP_CHARACTER,	/* 762 */
/* U+02FB */	CANT_MAP_CHARACTER,	/* 763 */
/* U+02FC */	CANT_MAP_CHARACTER,	/* 764 */
/* U+02FD */	CANT_MAP_CHARACTER,	/* 765 */
/* U+02FE */	CANT_MAP_CHARACTER,	/* 766 */
/* U+02FF */	CANT_MAP_CHARACTER,	/* 767 */
/* U+0300 */	CANT_MAP_CHARACTER,	/* 768 */
/* U+0301 */	CANT_MAP_CHARACTER,	/* 769 */
/* U+0302 */	CANT_MAP_CHARACTER,	/* 770 */
/* U+0303 */	CANT_MAP_CHARACTER,	/* 771 */
/* U+0304 */	CANT_MAP_CHARACTER,	/* 772 */
/* U+0305 */	CANT_MAP_CHARACTER,	/* 773 */
/* U+0306 */	CANT_MAP_CHARACTER,	/* 774 */
/* U+0307 */	CANT_MAP_CHARACTER,	/* 775 */
/* U+0308 */	CANT_MAP_CHARACTER,	/* 776 */
/* U+0309 */	CANT_MAP_CHARACTER,	/* 777 */
/* U+030A */	CANT_MAP_CHARACTER,	/* 778 */
/* U+030B */	CANT_MAP_CHARACTER,	/* 779 */
/* U+030C */	CANT_MAP_CHARACTER,	/* 780 */
/* U+030D */	CANT_MAP_CHARACTER,	/* 781 */
/* U+030E */	CANT_MAP_CHARACTER,	/* 782 */
/* U+030F */	CANT_MAP_CHARACTER,	/* 783 */
/* U+0310 */	CANT_MAP_CHARACTER,	/* 784 */
/* U+0311 */	CANT_MAP_CHARACTER,	/* 785 */
/* U+0312 */	CANT_MAP_CHARACTER,	/* 786 */
/* U+0313 */	CANT_MAP_CHARACTER,	/* 787 */
/* U+0314 */	CANT_MAP_CHARACTER,	/* 788 */
/* U+0315 */	CANT_MAP_CHARACTER,	/* 789 */
/* U+0316 */	CANT_MAP_CHARACTER,	/* 790 */
/* U+0317 */	CANT_MAP_CHARACTER,	/* 791 */
/* U+0318 */	CANT_MAP_CHARACTER,	/* 792 */
/* U+0319 */	CANT_MAP_CHARACTER,	/* 793 */
/* U+031A */	CANT_MAP_CHARACTER,	/* 794 */
/* U+031B */	CANT_MAP_CHARACTER,	/* 795 */
/* U+031C */	CANT_MAP_CHARACTER,	/* 796 */
/* U+031D */	CANT_MAP_CHARACTER,	/* 797 */
/* U+031E */	CANT_MAP_CHARACTER,	/* 798 */
/* U+031F */	CANT_MAP_CHARACTER,	/* 799 */
/* U+0320 */	CANT_MAP_CHARACTER,	/* 800 */
/* U+0321 */	CANT_MAP_CHARACTER,	/* 801 */
/* U+0322 */	CANT_MAP_CHARACTER,	/* 802 */
/* U+0323 */	CANT_MAP_CHARACTER,	/* 803 */
/* U+0324 */	CANT_MAP_CHARACTER,	/* 804 */
/* U+0325 */	CANT_MAP_CHARACTER,	/* 805 */
/* U+0326 */	CANT_MAP_CHARACTER,	/* 806 */
/* U+0327 */	CANT_MAP_CHARACTER,	/* 807 */
/* U+0328 */	CANT_MAP_CHARACTER,	/* 808 */
/* U+0329 */	CANT_MAP_CHARACTER,	/* 809 */
/* U+032A */	CANT_MAP_CHARACTER,	/* 810 */
/* U+032B */	CANT_MAP_CHARACTER,	/* 811 */
/* U+032C */	CANT_MAP_CHARACTER,	/* 812 */
/* U+032D */	CANT_MAP_CHARACTER,	/* 813 */
/* U+032E */	CANT_MAP_CHARACTER,	/* 814 */
/* U+032F */	CANT_MAP_CHARACTER,	/* 815 */
/* U+0330 */	CANT_MAP_CHARACTER,	/* 816 */
/* U+0331 */	CANT_MAP_CHARACTER,	/* 817 */
/* U+0332 */	CANT_MAP_CHARACTER,	/* 818 */
/* U+0333 */	CANT_MAP_CHARACTER,	/* 819 */
/* U+0334 */	CANT_MAP_CHARACTER,	/* 820 */
/* U+0335 */	CANT_MAP_CHARACTER,	/* 821 */
/* U+0336 */	CANT_MAP_CHARACTER,	/* 822 */
/* U+0337 */	CANT_MAP_CHARACTER,	/* 823 */
/* U+0338 */	CANT_MAP_CHARACTER,	/* 824 */
/* U+0339 */	CANT_MAP_CHARACTER,	/* 825 */
/* U+033A */	CANT_MAP_CHARACTER,	/* 826 */
/* U+033B */	CANT_MAP_CHARACTER,	/* 827 */
/* U+033C */	CANT_MAP_CHARACTER,	/* 828 */
/* U+033D */	CANT_MAP_CHARACTER,	/* 829 */
/* U+033E */	CANT_MAP_CHARACTER,	/* 830 */
/* U+033F */	CANT_MAP_CHARACTER,	/* 831 */
/* U+0340 */	CANT_MAP_CHARACTER,	/* 832 */
/* U+0341 */	CANT_MAP_CHARACTER,	/* 833 */
/* U+0342 */	CANT_MAP_CHARACTER,	/* 834 */
/* U+0343 */	CANT_MAP_CHARACTER,	/* 835 */
/* U+0344 */	CANT_MAP_CHARACTER,	/* 836 */
/* U+0345 */	CANT_MAP_CHARACTER,	/* 837 */
/* U+0346 */	CANT_MAP_CHARACTER,	/* 838 */
/* U+0347 */	CANT_MAP_CHARACTER,	/* 839 */
/* U+0348 */	CANT_MAP_CHARACTER,	/* 840 */
/* U+0349 */	CANT_MAP_CHARACTER,	/* 841 */
/* U+034A */	CANT_MAP_CHARACTER,	/* 842 */
/* U+034B */	CANT_MAP_CHARACTER,	/* 843 */
/* U+034C */	CANT_MAP_CHARACTER,	/* 844 */
/* U+034D */	CANT_MAP_CHARACTER,	/* 845 */
/* U+034E */	CANT_MAP_CHARACTER,	/* 846 */
/* U+034F */	CANT_MAP_CHARACTER,	/* 847 */
/* U+0350 */	CANT_MAP_CHARACTER,	/* 848 */
/* U+0351 */	CANT_MAP_CHARACTER,	/* 849 */
/* U+0352 */	CANT_MAP_CHARACTER,	/* 850 */
/* U+0353 */	CANT_MAP_CHARACTER,	/* 851 */
/* U+0354 */	CANT_MAP_CHARACTER,	/* 852 */
/* U+0355 */	CANT_MAP_CHARACTER,	/* 853 */
/* U+0356 */	CANT_MAP_CHARACTER,	/* 854 */
/* U+0357 */	CANT_MAP_CHARACTER,	/* 855 */
/* U+0358 */	CANT_MAP_CHARACTER,	/* 856 */
/* U+0359 */	CANT_MAP_CHARACTER,	/* 857 */
/* U+035A */	CANT_MAP_CHARACTER,	/* 858 */
/* U+035B */	CANT_MAP_CHARACTER,	/* 859 */
/* U+035C */	CANT_MAP_CHARACTER,	/* 860 */
/* U+035D */	CANT_MAP_CHARACTER,	/* 861 */
/* U+035E */	CANT_MAP_CHARACTER,	/* 862 */
/* U+035F */	CANT_MAP_CHARACTER,	/* 863 */
/* U+0360 */	CANT_MAP_CHARACTER,	/* 864 */
/* U+0361 */	CANT_MAP_CHARACTER,	/* 865 */
/* U+0362 */	CANT_MAP_CHARACTER,	/* 866 */
/* U+0363 */	CANT_MAP_CHARACTER,	/* 867 */
/* U+0364 */	CANT_MAP_CHARACTER,	/* 868 */
/* U+0365 */	CANT_MAP_CHARACTER,	/* 869 */
/* U+0366 */	CANT_MAP_CHARACTER,	/* 870 */
/* U+0367 */	CANT_MAP_CHARACTER,	/* 871 */
/* U+0368 */	CANT_MAP_CHARACTER,	/* 872 */
/* U+0369 */	CANT_MAP_CHARACTER,	/* 873 */
/* U+036A */	CANT_MAP_CHARACTER,	/* 874 */
/* U+036B */	CANT_MAP_CHARACTER,	/* 875 */
/* U+036C */	CANT_MAP_CHARACTER,	/* 876 */
/* U+036D */	CANT_MAP_CHARACTER,	/* 877 */
/* U+036E */	CANT_MAP_CHARACTER,	/* 878 */
/* U+036F */	CANT_MAP_CHARACTER,	/* 879 */
/* U+0370 */	CANT_MAP_CHARACTER,	/* 880 */
/* U+0371 */	CANT_MAP_CHARACTER,	/* 881 */
/* U+0372 */	CANT_MAP_CHARACTER,	/* 882 */
/* U+0373 */	CANT_MAP_CHARACTER,	/* 883 */
/* U+0374 */	CANT_MAP_CHARACTER,	/* 884 */
/* U+0375 */	CANT_MAP_CHARACTER,	/* 885 */
/* U+0376 */	CANT_MAP_CHARACTER,	/* 886 */
/* U+0377 */	CANT_MAP_CHARACTER,	/* 887 */
/* U+0378 */	CANT_MAP_CHARACTER,	/* 888 */
/* U+0379 */	CANT_MAP_CHARACTER,	/* 889 */
/* U+037A */	CANT_MAP_CHARACTER,	/* 890 */
/* U+037B */	CANT_MAP_CHARACTER,	/* 891 */
/* U+037C */	CANT_MAP_CHARACTER,	/* 892 */
/* U+037D */	CANT_MAP_CHARACTER,	/* 893 */
/* U+037E */	CANT_MAP_CHARACTER,	/* 894 */
/* U+037F */	CANT_MAP_CHARACTER,	/* 895 */
/* U+0380 */	CANT_MAP_CHARACTER,	/* 896 */
/* U+0381 */	CANT_MAP_CHARACTER,	/* 897 */
/* U+0382 */	CANT_MAP_CHARACTER,	/* 898 */
/* U+0383 */	CANT_MAP_CHARACTER,	/* 899 */
/* U+0384 */	0xB4	/*                                   GREEK TONOS */,/* 900 */
/* U+0385 */	0xB5	/*                         GREEK DIALYTIKA TONOS */,/* 901 */
/* U+0386 */	0xB6	/*         GREEK CAPITAL LETTER ALPHA WITH TONOS */,/* 902 */
/* U+0387 */	CANT_MAP_CHARACTER,	/* 903 */
/* U+0388 */	0xB8	/*       GREEK CAPITAL LETTER EPSILON WITH TONOS */,/* 904 */
/* U+0389 */	0xB9	/*           GREEK CAPITAL LETTER ETA WITH TONOS */,/* 905 */
/* U+038A */	0xBA	/*          GREEK CAPITAL LETTER IOTA WITH TONOS */,/* 906 */
/* U+038B */	CANT_MAP_CHARACTER,	/* 907 */
/* U+038C */	0xBC	/*       GREEK CAPITAL LETTER OMICRON WITH TONOS */,/* 908 */
/* U+038D */	CANT_MAP_CHARACTER,	/* 909 */
/* U+038E */	0xBE	/*       GREEK CAPITAL LETTER UPSILON WITH TONOS */,/* 910 */
/* U+038F */	0xBF	/*         GREEK CAPITAL LETTER OMEGA WITH TONOS */,/* 911 */
/* U+0390 */	0xC0	/* GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS */,/* 912 */
/* U+0391 */	0xC1	/*                    GREEK CAPITAL LETTER ALPHA */,/* 913 */
/* U+0392 */	0xC2	/*                     GREEK CAPITAL LETTER BETA */,/* 914 */
/* U+0393 */	0xC3	/*                    GREEK CAPITAL LETTER GAMMA */,/* 915 */
/* U+0394 */	0xC4	/*                    GREEK CAPITAL LETTER DELTA */,/* 916 */
/* U+0395 */	0xC5	/*                  GREEK CAPITAL LETTER EPSILON */,/* 917 */
/* U+0396 */	0xC6	/*                     GREEK CAPITAL LETTER ZETA */,/* 918 */
/* U+0397 */	0xC7	/*                      GREEK CAPITAL LETTER ETA */,/* 919 */
/* U+0398 */	0xC8	/*                    GREEK CAPITAL LETTER THETA */,/* 920 */
/* U+0399 */	0xC9	/*                     GREEK CAPITAL LETTER IOTA */,/* 921 */
/* U+039A */	0xCA	/*                    GREEK CAPITAL LETTER KAPPA */,/* 922 */
/* U+039B */	0xCB	/*                    GREEK CAPITAL LETTER LAMDA */,/* 923 */
/* U+039C */	0xCC	/*                       GREEK CAPITAL LETTER MU */,/* 924 */
/* U+039D */	0xCD	/*                       GREEK CAPITAL LETTER NU */,/* 925 */
/* U+039E */	0xCE	/*                       GREEK CAPITAL LETTER XI */,/* 926 */
/* U+039F */	0xCF	/*                  GREEK CAPITAL LETTER OMICRON */,/* 927 */
/* U+03A0 */	0xD0	/*                       GREEK CAPITAL LETTER PI */,/* 928 */
/* U+03A1 */	0xD1	/*                      GREEK CAPITAL LETTER RHO */,/* 929 */
/* U+03A2 */	CANT_MAP_CHARACTER,	/* 930 */
/* U+03A3 */	0xD3	/*                    GREEK CAPITAL LETTER SIGMA */,/* 931 */
/* U+03A4 */	0xD4	/*                      GREEK CAPITAL LETTER TAU */,/* 932 */
/* U+03A5 */	0xD5	/*                  GREEK CAPITAL LETTER UPSILON */,/* 933 */
/* U+03A6 */	0xD6	/*                      GREEK CAPITAL LETTER PHI */,/* 934 */
/* U+03A7 */	0xD7	/*                      GREEK CAPITAL LETTER CHI */,/* 935 */
/* U+03A8 */	0xD8	/*                      GREEK CAPITAL LETTER PSI */,/* 936 */
/* U+03A9 */	0xD9	/*                    GREEK CAPITAL LETTER OMEGA */,/* 937 */
/* U+03AA */	0xDA	/*      GREEK CAPITAL LETTER IOTA WITH DIALYTIKA */,/* 938 */
/* U+03AB */	0xDB	/*   GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA */,/* 939 */
/* U+03AC */	0xDC	/*           GREEK SMALL LETTER ALPHA WITH TONOS */,/* 940 */
/* U+03AD */	0xDD	/*         GREEK SMALL LETTER EPSILON WITH TONOS */,/* 941 */
/* U+03AE */	0xDE	/*             GREEK SMALL LETTER ETA WITH TONOS */,/* 942 */
/* U+03AF */	0xDF	/*            GREEK SMALL LETTER IOTA WITH TONOS */,/* 943 */
/* U+03B0 */	0xE0	/* GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS */,/* 944 */
/* U+03B1 */	0xE1	/*                      GREEK SMALL LETTER ALPHA */,/* 945 */
/* U+03B2 */	0xE2	/*                       GREEK SMALL LETTER BETA */,/* 946 */
/* U+03B3 */	0xE3	/*                      GREEK SMALL LETTER GAMMA */,/* 947 */
/* U+03B4 */	0xE4	/*                      GREEK SMALL LETTER DELTA */,/* 948 */
/* U+03B5 */	0xE5	/*                    GREEK SMALL LETTER EPSILON */,/* 949 */
/* U+03B6 */	0xE6	/*                       GREEK SMALL LETTER ZETA */,/* 950 */
/* U+03B7 */	0xE7	/*                        GREEK SMALL LETTER ETA */,/* 951 */
/* U+03B8 */	0xE8	/*                      GREEK SMALL LETTER THETA */,/* 952 */
/* U+03B9 */	0xE9	/*                       GREEK SMALL LETTER IOTA */,/* 953 */
/* U+03BA */	0xEA	/*                      GREEK SMALL LETTER KAPPA */,/* 954 */
/* U+03BB */	0xEB	/*                      GREEK SMALL LETTER LAMDA */,/* 955 */
/* U+03BC */	0xEC	/*                         GREEK SMALL LETTER MU */,/* 956 */
/* U+03BD */	0xED	/*                         GREEK SMALL LETTER NU */,/* 957 */
/* U+03BE */	0xEE	/*                         GREEK SMALL LETTER XI */,/* 958 */
/* U+03BF */	0xEF	/*                    GREEK SMALL LETTER OMICRON */,/* 959 */
/* U+03C0 */	0xF0	/*                         GREEK SMALL LETTER PI */,/* 960 */
/* U+03C1 */	0xF1	/*                        GREEK SMALL LETTER RHO */,/* 961 */
/* U+03C2 */	0xF2	/*                GREEK SMALL LETTER FINAL SIGMA */,/* 962 */
/* U+03C3 */	0xF3	/*                      GREEK SMALL LETTER SIGMA */,/* 963 */
/* U+03C4 */	0xF4	/*                        GREEK SMALL LETTER TAU */,/* 964 */
/* U+03C5 */	0xF5	/*                    GREEK SMALL LETTER UPSILON */,/* 965 */
/* U+03C6 */	0xF6	/*                        GREEK SMALL LETTER PHI */,/* 966 */
/* U+03C7 */	0xF7	/*                        GREEK SMALL LETTER CHI */,/* 967 */
/* U+03C8 */	0xF8	/*                        GREEK SMALL LETTER PSI */,/* 968 */
/* U+03C9 */	0xF9	/*                      GREEK SMALL LETTER OMEGA */,/* 969 */
/* U+03CA */	0xFA	/*        GREEK SMALL LETTER IOTA WITH DIALYTIKA */,/* 970 */
/* U+03CB */	0xFB	/*     GREEK SMALL LETTER UPSILON WITH DIALYTIKA */,/* 971 */
/* U+03CC */	0xFC	/*         GREEK SMALL LETTER OMICRON WITH TONOS */,/* 972 */
/* U+03CD */	0xFD	/*         GREEK SMALL LETTER UPSILON WITH TONOS */,/* 973 */
/* U+03CE */	0xFE	/*           GREEK SMALL LETTER OMEGA WITH TONOS */,/* 974 */
/* U+03CF */	CANT_MAP_CHARACTER,	/* 975 */
/* U+03D0 */	CANT_MAP_CHARACTER,	/* 976 */
/* U+03D1 */	CANT_MAP_CHARACTER,	/* 977 */
/* U+03D2 */	CANT_MAP_CHARACTER,	/* 978 */
/* U+03D3 */	CANT_MAP_CHARACTER,	/* 979 */
/* U+03D4 */	CANT_MAP_CHARACTER,	/* 980 */
/* U+03D5 */	CANT_MAP_CHARACTER,	/* 981 */
/* U+03D6 */	CANT_MAP_CHARACTER,	/* 982 */
/* U+03D7 */	CANT_MAP_CHARACTER,	/* 983 */
/* U+03D8 */	CANT_MAP_CHARACTER,	/* 984 */
/* U+03D9 */	CANT_MAP_CHARACTER,	/* 985 */
/* U+03DA */	CANT_MAP_CHARACTER,	/* 986 */
/* U+03DB */	CANT_MAP_CHARACTER,	/* 987 */
/* U+03DC */	CANT_MAP_CHARACTER,	/* 988 */
/* U+03DD */	CANT_MAP_CHARACTER,	/* 989 */
/* U+03DE */	CANT_MAP_CHARACTER,	/* 990 */
/* U+03DF */	CANT_MAP_CHARACTER,	/* 991 */
/* U+03E0 */	CANT_MAP_CHARACTER,	/* 992 */
/* U+03E1 */	CANT_MAP_CHARACTER,	/* 993 */
/* U+03E2 */	CANT_MAP_CHARACTER,	/* 994 */
/* U+03E3 */	CANT_MAP_CHARACTER,	/* 995 */
/* U+03E4 */	CANT_MAP_CHARACTER,	/* 996 */
/* U+03E5 */	CANT_MAP_CHARACTER,	/* 997 */
/* U+03E6 */	CANT_MAP_CHARACTER,	/* 998 */
/* U+03E7 */	CANT_MAP_CHARACTER,	/* 999 */
/* U+03E8 */	CANT_MAP_CHARACTER,	/* 1000 */
/* U+03E9 */	CANT_MAP_CHARACTER,	/* 1001 */
/* U+03EA */	CANT_MAP_CHARACTER,	/* 1002 */
/* U+03EB */	CANT_MAP_CHARACTER,	/* 1003 */
/* U+03EC */	CANT_MAP_CHARACTER,	/* 1004 */
/* U+03ED */	CANT_MAP_CHARACTER,	/* 1005 */
/* U+03EE */	CANT_MAP_CHARACTER,	/* 1006 */
/* U+03EF */	CANT_MAP_CHARACTER,	/* 1007 */
/* U+03F0 */	CANT_MAP_CHARACTER,	/* 1008 */
/* U+03F1 */	CANT_MAP_CHARACTER,	/* 1009 */
/* U+03F2 */	CANT_MAP_CHARACTER,	/* 1010 */
/* U+03F3 */	CANT_MAP_CHARACTER,	/* 1011 */
/* U+03F4 */	CANT_MAP_CHARACTER,	/* 1012 */
/* U+03F5 */	CANT_MAP_CHARACTER,	/* 1013 */
/* U+03F6 */	CANT_MAP_CHARACTER,	/* 1014 */
/* U+03F7 */	CANT_MAP_CHARACTER,	/* 1015 */
/* U+03F8 */	CANT_MAP_CHARACTER,	/* 1016 */
/* U+03F9 */	CANT_MAP_CHARACTER,	/* 1017 */
/* U+03FA */	CANT_MAP_CHARACTER,	/* 1018 */
/* U+03FB */	CANT_MAP_CHARACTER,	/* 1019 */
/* U+03FC */	CANT_MAP_CHARACTER,	/* 1020 */
/* U+03FD */	CANT_MAP_CHARACTER,	/* 1021 */
/* U+03FE */	CANT_MAP_CHARACTER,	/* 1022 */
/* U+03FF */	CANT_MAP_CHARACTER,	/* 1023 */
/* U+2000 */	CANT_MAP_CHARACTER,	/* 1024 */
/* U+2001 */	CANT_MAP_CHARACTER,	/* 1025 */
/* U+2002 */	CANT_MAP_CHARACTER,	/* 1026 */
/* U+2003 */	CANT_MAP_CHARACTER,	/* 1027 */
/* U+2004 */	CANT_MAP_CHARACTER,	/* 1028 */
/* U+2005 */	CANT_MAP_CHARACTER,	/* 1029 */
/* U+2006 */	CANT_MAP_CHARACTER,	/* 1030 */
/* U+2007 */	CANT_MAP_CHARACTER,	/* 1031 */
/* U+2008 */	CANT_MAP_CHARACTER,	/* 1032 */
/* U+2009 */	CANT_MAP_CHARACTER,	/* 1033 */
/* U+200A */	CANT_MAP_CHARACTER,	/* 1034 */
/* U+200B */	CANT_MAP_CHARACTER,	/* 1035 */
/* U+200C */	CANT_MAP_CHARACTER,	/* 1036 */
/* U+200D */	CANT_MAP_CHARACTER,	/* 1037 */
/* U+200E */	CANT_MAP_CHARACTER,	/* 1038 */
/* U+200F */	CANT_MAP_CHARACTER,	/* 1039 */
/* U+2010 */	CANT_MAP_CHARACTER,	/* 1040 */
/* U+2011 */	CANT_MAP_CHARACTER,	/* 1041 */
/* U+2012 */	CANT_MAP_CHARACTER,	/* 1042 */
/* U+2013 */	CANT_MAP_CHARACTER,	/* 1043 */
/* U+2014 */	CANT_MAP_CHARACTER,	/* 1044 */
/* U+2015 */	0xAF	/*                                HORIZONTAL BAR */,/* 1045 */
/* U+2016 */	CANT_MAP_CHARACTER,	/* 1046 */
/* U+2017 */	CANT_MAP_CHARACTER,	/* 1047 */
/* U+2018 */	CANT_MAP_CHARACTER,	/* 1048 */
/* U+2019 */	CANT_MAP_CHARACTER,	/* 1049 */
/* U+201A */	CANT_MAP_CHARACTER,	/* 1050 */
/* U+201B */	CANT_MAP_CHARACTER,	/* 1051 */
/* U+201C */	CANT_MAP_CHARACTER,	/* 1052 */
/* U+201D */	CANT_MAP_CHARACTER,	/* 1053 */
/* U+201E */	CANT_MAP_CHARACTER,	/* 1054 */
/* U+201F */	CANT_MAP_CHARACTER,	/* 1055 */
/* U+2020 */	CANT_MAP_CHARACTER,	/* 1056 */
/* U+2021 */	CANT_MAP_CHARACTER,	/* 1057 */
/* U+2022 */	CANT_MAP_CHARACTER,	/* 1058 */
/* U+2023 */	CANT_MAP_CHARACTER,	/* 1059 */
/* U+2024 */	CANT_MAP_CHARACTER,	/* 1060 */
/* U+2025 */	CANT_MAP_CHARACTER,	/* 1061 */
/* U+2026 */	CANT_MAP_CHARACTER,	/* 1062 */
/* U+2027 */	CANT_MAP_CHARACTER,	/* 1063 */
/* U+2028 */	CANT_MAP_CHARACTER,	/* 1064 */
/* U+2029 */	CANT_MAP_CHARACTER,	/* 1065 */
/* U+202A */	CANT_MAP_CHARACTER,	/* 1066 */
/* U+202B */	CANT_MAP_CHARACTER,	/* 1067 */
/* U+202C */	CANT_MAP_CHARACTER,	/* 1068 */
/* U+202D */	CANT_MAP_CHARACTER,	/* 1069 */
/* U+202E */	CANT_MAP_CHARACTER,	/* 1070 */
/* U+202F */	CANT_MAP_CHARACTER,	/* 1071 */
/* U+2030 */	CANT_MAP_CHARACTER,	/* 1072 */
/* U+2031 */	CANT_MAP_CHARACTER,	/* 1073 */
/* U+2032 */	CANT_MAP_CHARACTER,	/* 1074 */
/* U+2033 */	CANT_MAP_CHARACTER,	/* 1075 */
/* U+2034 */	CANT_MAP_CHARACTER,	/* 1076 */
/* U+2035 */	CANT_MAP_CHARACTER,	/* 1077 */
/* U+2036 */	CANT_MAP_CHARACTER,	/* 1078 */
/* U+2037 */	CANT_MAP_CHARACTER,	/* 1079 */
/* U+2038 */	CANT_MAP_CHARACTER,	/* 1080 */
/* U+2039 */	CANT_MAP_CHARACTER,	/* 1081 */
/* U+203A */	CANT_MAP_CHARACTER,	/* 1082 */
/* U+203B */	CANT_MAP_CHARACTER,	/* 1083 */
/* U+203C */	CANT_MAP_CHARACTER,	/* 1084 */
/* U+203D */	CANT_MAP_CHARACTER,	/* 1085 */
/* U+203E */	CANT_MAP_CHARACTER,	/* 1086 */
/* U+203F */	CANT_MAP_CHARACTER,	/* 1087 */
/* U+2040 */	CANT_MAP_CHARACTER,	/* 1088 */
/* U+2041 */	CANT_MAP_CHARACTER,	/* 1089 */
/* U+2042 */	CANT_MAP_CHARACTER,	/* 1090 */
/* U+2043 */	CANT_MAP_CHARACTER,	/* 1091 */
/* U+2044 */	CANT_MAP_CHARACTER,	/* 1092 */
/* U+2045 */	CANT_MAP_CHARACTER,	/* 1093 */
/* U+2046 */	CANT_MAP_CHARACTER,	/* 1094 */
/* U+2047 */	CANT_MAP_CHARACTER,	/* 1095 */
/* U+2048 */	CANT_MAP_CHARACTER,	/* 1096 */
/* U+2049 */	CANT_MAP_CHARACTER,	/* 1097 */
/* U+204A */	CANT_MAP_CHARACTER,	/* 1098 */
/* U+204B */	CANT_MAP_CHARACTER,	/* 1099 */
/* U+204C */	CANT_MAP_CHARACTER,	/* 1100 */
/* U+204D */	CANT_MAP_CHARACTER,	/* 1101 */
/* U+204E */	CANT_MAP_CHARACTER,	/* 1102 */
/* U+204F */	CANT_MAP_CHARACTER,	/* 1103 */
/* U+2050 */	CANT_MAP_CHARACTER,	/* 1104 */
/* U+2051 */	CANT_MAP_CHARACTER,	/* 1105 */
/* U+2052 */	CANT_MAP_CHARACTER,	/* 1106 */
/* U+2053 */	CANT_MAP_CHARACTER,	/* 1107 */
/* U+2054 */	CANT_MAP_CHARACTER,	/* 1108 */
/* U+2055 */	CANT_MAP_CHARACTER,	/* 1109 */
/* U+2056 */	CANT_MAP_CHARACTER,	/* 1110 */
/* U+2057 */	CANT_MAP_CHARACTER,	/* 1111 */
/* U+2058 */	CANT_MAP_CHARACTER,	/* 1112 */
/* U+2059 */	CANT_MAP_CHARACTER,	/* 1113 */
/* U+205A */	CANT_MAP_CHARACTER,	/* 1114 */
/* U+205B */	CANT_MAP_CHARACTER,	/* 1115 */
/* U+205C */	CANT_MAP_CHARACTER,	/* 1116 */
/* U+205D */	CANT_MAP_CHARACTER,	/* 1117 */
/* U+205E */	CANT_MAP_CHARACTER,	/* 1118 */
/* U+205F */	CANT_MAP_CHARACTER,	/* 1119 */
/* U+2060 */	CANT_MAP_CHARACTER,	/* 1120 */
/* U+2061 */	CANT_MAP_CHARACTER,	/* 1121 */
/* U+2062 */	CANT_MAP_CHARACTER,	/* 1122 */
/* U+2063 */	CANT_MAP_CHARACTER,	/* 1123 */
/* U+2064 */	CANT_MAP_CHARACTER,	/* 1124 */
/* U+2065 */	CANT_MAP_CHARACTER,	/* 1125 */
/* U+2066 */	CANT_MAP_CHARACTER,	/* 1126 */
/* U+2067 */	CANT_MAP_CHARACTER,	/* 1127 */
/* U+2068 */	CANT_MAP_CHARACTER,	/* 1128 */
/* U+2069 */	CANT_MAP_CHARACTER,	/* 1129 */
/* U+206A */	CANT_MAP_CHARACTER,	/* 1130 */
/* U+206B */	CANT_MAP_CHARACTER,	/* 1131 */
/* U+206C */	CANT_MAP_CHARACTER,	/* 1132 */
/* U+206D */	CANT_MAP_CHARACTER,	/* 1133 */
/* U+206E */	CANT_MAP_CHARACTER,	/* 1134 */
/* U+206F */	CANT_MAP_CHARACTER,	/* 1135 */
/* U+2070 */	CANT_MAP_CHARACTER,	/* 1136 */
/* U+2071 */	CANT_MAP_CHARACTER,	/* 1137 */
/* U+2072 */	CANT_MAP_CHARACTER,	/* 1138 */
/* U+2073 */	CANT_MAP_CHARACTER,	/* 1139 */
/* U+2074 */	CANT_MAP_CHARACTER,	/* 1140 */
/* U+2075 */	CANT_MAP_CHARACTER,	/* 1141 */
/* U+2076 */	CANT_MAP_CHARACTER,	/* 1142 */
/* U+2077 */	CANT_MAP_CHARACTER,	/* 1143 */
/* U+2078 */	CANT_MAP_CHARACTER,	/* 1144 */
/* U+2079 */	CANT_MAP_CHARACTER,	/* 1145 */
/* U+207A */	CANT_MAP_CHARACTER,	/* 1146 */
/* U+207B */	CANT_MAP_CHARACTER,	/* 1147 */
/* U+207C */	CANT_MAP_CHARACTER,	/* 1148 */
/* U+207D */	CANT_MAP_CHARACTER,	/* 1149 */
/* U+207E */	CANT_MAP_CHARACTER,	/* 1150 */
/* U+207F */	CANT_MAP_CHARACTER,	/* 1151 */
/* U+2080 */	CANT_MAP_CHARACTER,	/* 1152 */
/* U+2081 */	CANT_MAP_CHARACTER,	/* 1153 */
/* U+2082 */	CANT_MAP_CHARACTER,	/* 1154 */
/* U+2083 */	CANT_MAP_CHARACTER,	/* 1155 */
/* U+2084 */	CANT_MAP_CHARACTER,	/* 1156 */
/* U+2085 */	CANT_MAP_CHARACTER,	/* 1157 */
/* U+2086 */	CANT_MAP_CHARACTER,	/* 1158 */
/* U+2087 */	CANT_MAP_CHARACTER,	/* 1159 */
/* U+2088 */	CANT_MAP_CHARACTER,	/* 1160 */
/* U+2089 */	CANT_MAP_CHARACTER,	/* 1161 */
/* U+208A */	CANT_MAP_CHARACTER,	/* 1162 */
/* U+208B */	CANT_MAP_CHARACTER,	/* 1163 */
/* U+208C */	CANT_MAP_CHARACTER,	/* 1164 */
/* U+208D */	CANT_MAP_CHARACTER,	/* 1165 */
/* U+208E */	CANT_MAP_CHARACTER,	/* 1166 */
/* U+208F */	CANT_MAP_CHARACTER,	/* 1167 */
/* U+2090 */	CANT_MAP_CHARACTER,	/* 1168 */
/* U+2091 */	CANT_MAP_CHARACTER,	/* 1169 */
/* U+2092 */	CANT_MAP_CHARACTER,	/* 1170 */
/* U+2093 */	CANT_MAP_CHARACTER,	/* 1171 */
/* U+2094 */	CANT_MAP_CHARACTER,	/* 1172 */
/* U+2095 */	CANT_MAP_CHARACTER,	/* 1173 */
/* U+2096 */	CANT_MAP_CHARACTER,	/* 1174 */
/* U+2097 */	CANT_MAP_CHARACTER,	/* 1175 */
/* U+2098 */	CANT_MAP_CHARACTER,	/* 1176 */
/* U+2099 */	CANT_MAP_CHARACTER,	/* 1177 */
/* U+209A */	CANT_MAP_CHARACTER,	/* 1178 */
/* U+209B */	CANT_MAP_CHARACTER,	/* 1179 */
/* U+209C */	CANT_MAP_CHARACTER,	/* 1180 */
/* U+209D */	CANT_MAP_CHARACTER,	/* 1181 */
/* U+209E */	CANT_MAP_CHARACTER,	/* 1182 */
/* U+209F */	CANT_MAP_CHARACTER,	/* 1183 */
/* U+20A0 */	CANT_MAP_CHARACTER,	/* 1184 */
/* U+20A1 */	CANT_MAP_CHARACTER,	/* 1185 */
/* U+20A2 */	CANT_MAP_CHARACTER,	/* 1186 */
/* U+20A3 */	CANT_MAP_CHARACTER,	/* 1187 */
/* U+20A4 */	CANT_MAP_CHARACTER,	/* 1188 */
/* U+20A5 */	CANT_MAP_CHARACTER,	/* 1189 */
/* U+20A6 */	CANT_MAP_CHARACTER,	/* 1190 */
/* U+20A7 */	CANT_MAP_CHARACTER,	/* 1191 */
/* U+20A8 */	CANT_MAP_CHARACTER,	/* 1192 */
/* U+20A9 */	CANT_MAP_CHARACTER,	/* 1193 */
/* U+20AA */	CANT_MAP_CHARACTER,	/* 1194 */
/* U+20AB */	CANT_MAP_CHARACTER,	/* 1195 */
/* U+20AC */	CANT_MAP_CHARACTER,	/* 1196 */
/* U+20AD */	CANT_MAP_CHARACTER,	/* 1197 */
/* U+20AE */	CANT_MAP_CHARACTER,	/* 1198 */
/* U+20AF */	CANT_MAP_CHARACTER,	/* 1199 */
/* U+20B0 */	CANT_MAP_CHARACTER,	/* 1200 */
/* U+20B1 */	CANT_MAP_CHARACTER,	/* 1201 */
/* U+20B2 */	CANT_MAP_CHARACTER,	/* 1202 */
/* U+20B3 */	CANT_MAP_CHARACTER,	/* 1203 */
/* U+20B4 */	CANT_MAP_CHARACTER,	/* 1204 */
/* U+20B5 */	CANT_MAP_CHARACTER,	/* 1205 */
/* U+20B6 */	CANT_MAP_CHARACTER,	/* 1206 */
/* U+20B7 */	CANT_MAP_CHARACTER,	/* 1207 */
/* U+20B8 */	CANT_MAP_CHARACTER,	/* 1208 */
/* U+20B9 */	CANT_MAP_CHARACTER,	/* 1209 */
/* U+20BA */	CANT_MAP_CHARACTER,	/* 1210 */
/* U+20BB */	CANT_MAP_CHARACTER,	/* 1211 */
/* U+20BC */	CANT_MAP_CHARACTER,	/* 1212 */
/* U+20BD */	CANT_MAP_CHARACTER,	/* 1213 */
/* U+20BE */	CANT_MAP_CHARACTER,	/* 1214 */
/* U+20BF */	CANT_MAP_CHARACTER,	/* 1215 */
/* U+20C0 */	CANT_MAP_CHARACTER,	/* 1216 */
/* U+20C1 */	CANT_MAP_CHARACTER,	/* 1217 */
/* U+20C2 */	CANT_MAP_CHARACTER,	/* 1218 */
/* U+20C3 */	CANT_MAP_CHARACTER,	/* 1219 */
/* U+20C4 */	CANT_MAP_CHARACTER,	/* 1220 */
/* U+20C5 */	CANT_MAP_CHARACTER,	/* 1221 */
/* U+20C6 */	CANT_MAP_CHARACTER,	/* 1222 */
/* U+20C7 */	CANT_MAP_CHARACTER,	/* 1223 */
/* U+20C8 */	CANT_MAP_CHARACTER,	/* 1224 */
/* U+20C9 */	CANT_MAP_CHARACTER,	/* 1225 */
/* U+20CA */	CANT_MAP_CHARACTER,	/* 1226 */
/* U+20CB */	CANT_MAP_CHARACTER,	/* 1227 */
/* U+20CC */	CANT_MAP_CHARACTER,	/* 1228 */
/* U+20CD */	CANT_MAP_CHARACTER,	/* 1229 */
/* U+20CE */	CANT_MAP_CHARACTER,	/* 1230 */
/* U+20CF */	CANT_MAP_CHARACTER,	/* 1231 */
/* U+20D0 */	CANT_MAP_CHARACTER,	/* 1232 */
/* U+20D1 */	CANT_MAP_CHARACTER,	/* 1233 */
/* U+20D2 */	CANT_MAP_CHARACTER,	/* 1234 */
/* U+20D3 */	CANT_MAP_CHARACTER,	/* 1235 */
/* U+20D4 */	CANT_MAP_CHARACTER,	/* 1236 */
/* U+20D5 */	CANT_MAP_CHARACTER,	/* 1237 */
/* U+20D6 */	CANT_MAP_CHARACTER,	/* 1238 */
/* U+20D7 */	CANT_MAP_CHARACTER,	/* 1239 */
/* U+20D8 */	CANT_MAP_CHARACTER,	/* 1240 */
/* U+20D9 */	CANT_MAP_CHARACTER,	/* 1241 */
/* U+20DA */	CANT_MAP_CHARACTER,	/* 1242 */
/* U+20DB */	CANT_MAP_CHARACTER,	/* 1243 */
/* U+20DC */	CANT_MAP_CHARACTER,	/* 1244 */
/* U+20DD */	CANT_MAP_CHARACTER,	/* 1245 */
/* U+20DE */	CANT_MAP_CHARACTER,	/* 1246 */
/* U+20DF */	CANT_MAP_CHARACTER,	/* 1247 */
/* U+20E0 */	CANT_MAP_CHARACTER,	/* 1248 */
/* U+20E1 */	CANT_MAP_CHARACTER,	/* 1249 */
/* U+20E2 */	CANT_MAP_CHARACTER,	/* 1250 */
/* U+20E3 */	CANT_MAP_CHARACTER,	/* 1251 */
/* U+20E4 */	CANT_MAP_CHARACTER,	/* 1252 */
/* U+20E5 */	CANT_MAP_CHARACTER,	/* 1253 */
/* U+20E6 */	CANT_MAP_CHARACTER,	/* 1254 */
/* U+20E7 */	CANT_MAP_CHARACTER,	/* 1255 */
/* U+20E8 */	CANT_MAP_CHARACTER,	/* 1256 */
/* U+20E9 */	CANT_MAP_CHARACTER,	/* 1257 */
/* U+20EA */	CANT_MAP_CHARACTER,	/* 1258 */
/* U+20EB */	CANT_MAP_CHARACTER,	/* 1259 */
/* U+20EC */	CANT_MAP_CHARACTER,	/* 1260 */
/* U+20ED */	CANT_MAP_CHARACTER,	/* 1261 */
/* U+20EE */	CANT_MAP_CHARACTER,	/* 1262 */
/* U+20EF */	CANT_MAP_CHARACTER,	/* 1263 */
/* U+20F0 */	CANT_MAP_CHARACTER,	/* 1264 */
/* U+20F1 */	CANT_MAP_CHARACTER,	/* 1265 */
/* U+20F2 */	CANT_MAP_CHARACTER,	/* 1266 */
/* U+20F3 */	CANT_MAP_CHARACTER,	/* 1267 */
/* U+20F4 */	CANT_MAP_CHARACTER,	/* 1268 */
/* U+20F5 */	CANT_MAP_CHARACTER,	/* 1269 */
/* U+20F6 */	CANT_MAP_CHARACTER,	/* 1270 */
/* U+20F7 */	CANT_MAP_CHARACTER,	/* 1271 */
/* U+20F8 */	CANT_MAP_CHARACTER,	/* 1272 */
/* U+20F9 */	CANT_MAP_CHARACTER,	/* 1273 */
/* U+20FA */	CANT_MAP_CHARACTER,	/* 1274 */
/* U+20FB */	CANT_MAP_CHARACTER,	/* 1275 */
/* U+20FC */	CANT_MAP_CHARACTER,	/* 1276 */
/* U+20FD */	CANT_MAP_CHARACTER,	/* 1277 */
/* U+20FE */	CANT_MAP_CHARACTER,	/* 1278 */
/* U+20FF */	CANT_MAP_CHARACTER,	/* 1279 */
	0 /* END OF MAP TABLE */
};
static const USHORT from_unicode_map[256] = {
/* U+00-- */	256,
/* U+01-- */	0,
/* U+02-- */	512,
/* U+03-- */	768,
/* U+04-- */	0,
/* U+05-- */	0,
/* U+06-- */	0,
/* U+07-- */	0,
/* U+08-- */	0,
/* U+09-- */	0,
/* U+0A-- */	0,
/* U+0B-- */	0,
/* U+0C-- */	0,
/* U+0D-- */	0,
/* U+0E-- */	0,
/* U+0F-- */	0,
/* U+10-- */	0,
/* U+11-- */	0,
/* U+12-- */	0,
/* U+13-- */	0,
/* U+14-- */	0,
/* U+15-- */	0,
/* U+16-- */	0,
/* U+17-- */	0,
/* U+18-- */	0,
/* U+19-- */	0,
/* U+1A-- */	0,
/* U+1B-- */	0,
/* U+1C-- */	0,
/* U+1D-- */	0,
/* U+1E-- */	0,
/* U+1F-- */	0,
/* U+20-- */	1024,
/* U+21-- */	0,
/* U+22-- */	0,
/* U+23-- */	0,
/* U+24-- */	0,
/* U+25-- */	0,
/* U+26-- */	0,
/* U+27-- */	0,
/* U+28-- */	0,
/* U+29-- */	0,
/* U+2A-- */	0,
/* U+2B-- */	0,
/* U+2C-- */	0,
/* U+2D-- */	0,
/* U+2E-- */	0,
/* U+2F-- */	0,
/* U+30-- */	0,
/* U+31-- */	0,
/* U+32-- */	0,
/* U+33-- */	0,
/* U+34-- */	0,
/* U+35-- */	0,
/* U+36-- */	0,
/* U+37-- */	0,
/* U+38-- */	0,
/* U+39-- */	0,
/* U+3A-- */	0,
/* U+3B-- */	0,
/* U+3C-- */	0,
/* U+3D-- */	0,
/* U+3E-- */	0,
/* U+3F-- */	0,
/* U+40-- */	0,
/* U+41-- */	0,
/* U+42-- */	0,
/* U+43-- */	0,
/* U+44-- */	0,
/* U+45-- */	0,
/* U+46-- */	0,
/* U+47-- */	0,
/* U+48-- */	0,
/* U+49-- */	0,
/* U+4A-- */	0,
/* U+4B-- */	0,
/* U+4C-- */	0,
/* U+4D-- */	0,
/* U+4E-- */	0,
/* U+4F-- */	0,
/* U+50-- */	0,
/* U+51-- */	0,
/* U+52-- */	0,
/* U+53-- */	0,
/* U+54-- */	0,
/* U+55-- */	0,
/* U+56-- */	0,
/* U+57-- */	0,
/* U+58-- */	0,
/* U+59-- */	0,
/* U+5A-- */	0,
/* U+5B-- */	0,
/* U+5C-- */	0,
/* U+5D-- */	0,
/* U+5E-- */	0,
/* U+5F-- */	0,
/* U+60-- */	0,
/* U+61-- */	0,
/* U+62-- */	0,
/* U+63-- */	0,
/* U+64-- */	0,
/* U+65-- */	0,
/* U+66-- */	0,
/* U+67-- */	0,
/* U+68-- */	0,
/* U+69-- */	0,
/* U+6A-- */	0,
/* U+6B-- */	0,
/* U+6C-- */	0,
/* U+6D-- */	0,
/* U+6E-- */	0,
/* U+6F-- */	0,
/* U+70-- */	0,
/* U+71-- */	0,
/* U+72-- */	0,
/* U+73-- */	0,
/* U+74-- */	0,
/* U+75-- */	0,
/* U+76-- */	0,
/* U+77-- */	0,
/* U+78-- */	0,
/* U+79-- */	0,
/* U+7A-- */	0,
/* U+7B-- */	0,
/* U+7C-- */	0,
/* U+7D-- */	0,
/* U+7E-- */	0,
/* U+7F-- */	0,
/* U+80-- */	0,
/* U+81-- */	0,
/* U+82-- */	0,
/* U+83-- */	0,
/* U+84-- */	0,
/* U+85-- */	0,
/* U+86-- */	0,
/* U+87-- */	0,
/* U+88-- */	0,
/* U+89-- */	0,
/* U+8A-- */	0,
/* U+8B-- */	0,
/* U+8C-- */	0,
/* U+8D-- */	0,
/* U+8E-- */	0,
/* U+8F-- */	0,
/* U+90-- */	0,
/* U+91-- */	0,
/* U+92-- */	0,
/* U+93-- */	0,
/* U+94-- */	0,
/* U+95-- */	0,
/* U+96-- */	0,
/* U+97-- */	0,
/* U+98-- */	0,
/* U+99-- */	0,
/* U+9A-- */	0,
/* U+9B-- */	0,
/* U+9C-- */	0,
/* U+9D-- */	0,
/* U+9E-- */	0,
/* U+9F-- */	0,
/* U+A0-- */	0,
/* U+A1-- */	0,
/* U+A2-- */	0,
/* U+A3-- */	0,
/* U+A4-- */	0,
/* U+A5-- */	0,
/* U+A6-- */	0,
/* U+A7-- */	0,
/* U+A8-- */	0,
/* U+A9-- */	0,
/* U+AA-- */	0,
/* U+AB-- */	0,
/* U+AC-- */	0,
/* U+AD-- */	0,
/* U+AE-- */	0,
/* U+AF-- */	0,
/* U+B0-- */	0,
/* U+B1-- */	0,
/* U+B2-- */	0,
/* U+B3-- */	0,
/* U+B4-- */	0,
/* U+B5-- */	0,
/* U+B6-- */	0,
/* U+B7-- */	0,
/* U+B8-- */	0,
/* U+B9-- */	0,
/* U+BA-- */	0,
/* U+BB-- */	0,
/* U+BC-- */	0,
/* U+BD-- */	0,
/* U+BE-- */	0,
/* U+BF-- */	0,
/* U+C0-- */	0,
/* U+C1-- */	0,
/* U+C2-- */	0,
/* U+C3-- */	0,
/* U+C4-- */	0,
/* U+C5-- */	0,
/* U+C6-- */	0,
/* U+C7-- */	0,
/* U+C8-- */	0,
/* U+C9-- */	0,
/* U+CA-- */	0,
/* U+CB-- */	0,
/* U+CC-- */	0,
/* U+CD-- */	0,
/* U+CE-- */	0,
/* U+CF-- */	0,
/* U+D0-- */	0,
/* U+D1-- */	0,
/* U+D2-- */	0,
/* U+D3-- */	0,
/* U+D4-- */	0,
/* U+D5-- */	0,
/* U+D6-- */	0,
/* U+D7-- */	0,
/* U+D8-- */	0,
/* U+D9-- */	0,
/* U+DA-- */	0,
/* U+DB-- */	0,
/* U+DC-- */	0,
/* U+DD-- */	0,
/* U+DE-- */	0,
/* U+DF-- */	0,
/* U+E0-- */	0,
/* U+E1-- */	0,
/* U+E2-- */	0,
/* U+E3-- */	0,
/* U+E4-- */	0,
/* U+E5-- */	0,
/* U+E6-- */	0,
/* U+E7-- */	0,
/* U+E8-- */	0,
/* U+E9-- */	0,
/* U+EA-- */	0,
/* U+EB-- */	0,
/* U+EC-- */	0,
/* U+ED-- */	0,
/* U+EE-- */	0,
/* U+EF-- */	0,
/* U+F0-- */	0,
/* U+F1-- */	0,
/* U+F2-- */	0,
/* U+F3-- */	0,
/* U+F4-- */	0,
/* U+F5-- */	0,
/* U+F6-- */	0,
/* U+F7-- */	0,
/* U+F8-- */	0,
/* U+F9-- */	0,
/* U+FA-- */	0,
/* U+FB-- */	0,
/* U+FC-- */	0,
/* U+FD-- */	0,
/* U+FE-- */	0,
/* U+FF-- */	0,
};
