#!/bin/bash

# gen-control.sh -- generates a Debian control file based in Sid
#
# This file is part of the forensics-all.
#
# Copyright 2015-2017 Giovani Augusto Ferreira <giovani@debian.org>
# Copyright 2015-2016 Joao Eriberto Mota Filho <eriberto@debian.org>
#
# You can use this program under the BSD-3-Clause conditions.

#################
### Variables ###
#################

# Here is the list of packages in main/Sid.
LIST='/var/lib/apt/lists/*debian.org_debian_dists_sid_main_binary-*_Packages'

# These packages will be excluded.
# Use spaces between names.
# Ex: EXCLUDE='PACKAGE1 PACKAGE2 PACKAGE3'
EXCLUDE='forensics-all forensics-extra forensics-extra-gui forensics-full'

# These type of files are dependencies and will be excluded.
DEPENDS='-common|-dbg|-dkms|-doc|^lib|^python'




####################
### Main program ###
####################

### Initial message

echo " "
echo "gen-control.sh -- generates a Debian control file based in Sid"
echo " "
echo "Remember to run 'apt-get update' before to use this script."
echo " "
echo "You can edit the gen-control.sh file to exclude packages."
echo " "
echo "Press ENTER to continue or Ctrl-C to abort."
echo " "
read NOTHING

### Formating exclusions

[ "$EXCLUDE" ] && EXC1=$(echo $EXCLUDE | tr -s " " | sed 's/ /\|/g')

### Initial list of packages

mkdir build

cat $LIST | grep "Maintainer: Debian Forensics" -B6 | grep Package: | \
cut -d" " -f2 | egrep -v "($DEPENDS)" | \
egrep -v "($EXC1)" | sort | sed 's/$/,/g' > build/PACKAGES.txt

echo " "
echo "The packages to be put in DEPENDS field (debian/control) are listed below."
echo " "
cat build/PACKAGES.txt | xargs | sed 's/,$//'
echo " "
echo "TOTAL: $(cat build/PACKAGES.txt | wc -l) packages."
echo " "
echo "Press ENTER to continue or Ctrl-C to abort."
echo " "
read NOTHING


### Build the final control

cp templates/control.part1 control.NEW

echo "Depends: $(cat build/PACKAGES.txt)" | sed 's/^/         /' | \
sed 's/         Depends:/Depends:/' >> control.NEW

cat templates/control.part2 >> control.NEW

cat build/PACKAGES.txt | xargs | sed 's/,$//' | fold -sw 69 | sed 's/^/   /' | \
sed 's/ $//' >> control.NEW

cat templates/control.part3 >> control.NEW


### Final message

echo " "
echo "The control.NEW file is done. Please, rename to"
echo "control and move to debian/ directory."
echo " "


### Clean the build directory

rm -rf build
