#pragma once
/*
 *  
 *  $Id: itoolcontroller.h $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#ifndef ITOOLBAR_H
#define ITOOLBAR_H

#include <api/api.h>
#include <api/toolsystem/itool.h>
#include <api/ievento.h>
#include <list>

class wxXmlNode;
class wxWindow;
class wxEvtHandler;
class wxMenu;

namespace GNC {
	namespace GCS {
		class IContract;
		class IWidgetTool;

		class IToolController {
		public:
			typedef std::list<long> TIdList;

			IToolController();
			virtual ~IToolController();

//region "Tool Bar interface"
			
			virtual void AddTool(long idTool, GNC::GCS::IContract* pContract) = 0;
			virtual void RemoveTool(long idTool) = 0;

			virtual GNC::GCS::ITool* GetTool(long idTool) = 0;

			virtual void Enable(long idTool, bool enabled) = 0;

			virtual void InitializeToolController() = 0;
			virtual void ReconnectToolController() = 0;
			virtual void FinalizeToolController() = 0;

			virtual wxWindow* CreateNewToolBar(wxWindow* pParent, bool alignLeft = true) = 0;
			virtual wxWindow* CreateNewToolBar(wxWindow* pParent, GNC::GCS::ITool::TToolFamily family, bool alignLeft = true) = 0;
			virtual wxWindow* CreateNewToolBar(wxWindow* pParent, const TIdList& toolsToInclude, bool alignLeft = true) = 0;
			virtual void AppendsToolInMenu(wxEvtHandler* pParent, wxMenu* pMenu, GNC::GCS::ITool::TToolFamily family) = 0;

			virtual void OnKeyAccelerator(GNC::GCS::Events::EventoTeclado& evento, wxWindow* pWindow) = 0;

			virtual void ActivateTool(long idTool, const TriggerButton& buttonmask, wxWindow* pParent) = 0;
			virtual void AppendDropDownMenu(long idTool, wxEvtHandler* pParent, wxMenu* pMenu) = 0;
			
			virtual GNC::GCS::IWidgetTool* GetLeftTool() = 0;
			virtual GNC::GCS::IWidgetTool* GetRightTool() = 0;

			static GNC::GCS::IToolController* New();
//endregion

		};
	}
}
#endif